/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.CountResponseAffiliate;
import travel.wink.sdk.affiliate.model.NotificationViewAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;

public class NotificationApi {
    private ApiClient apiClient;

    public NotificationApi() {
        this(new ApiClient());
    }

    @Autowired
    public NotificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec markAsReadRequestCreation(String companyIdentifier, String messageIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        Object postBody = body;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling markAsRead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling markAsRead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling markAsRead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/message/{messageIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<NotificationViewAffiliate> markAsRead(String companyIdentifier, String messageIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>(this){};
        return this.markAsReadRequestCreation(companyIdentifier, messageIdentifier, body, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<NotificationViewAffiliate>> markAsReadWithHttpInfo(String companyIdentifier, String messageIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>(this){};
        return this.markAsReadRequestCreation(companyIdentifier, messageIdentifier, body, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec markAsReadWithResponseSpec(String companyIdentifier, String messageIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        return this.markAsReadRequestCreation(companyIdentifier, messageIdentifier, body, winkVersion);
    }

    private WebClient.ResponseSpec removeNotificationRequestCreation(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/message/{messageIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeNotification(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeNotificationWithHttpInfo(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeNotificationWithResponseSpec(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeNotificationRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showNotificationsRequestCreation(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showNotifications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling showNotifications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/message/{messageIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<NotificationViewAffiliate> showNotifications(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>(this){};
        return this.showNotificationsRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<NotificationViewAffiliate>> showNotificationsWithHttpInfo(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>(this){};
        return this.showNotificationsRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showNotificationsWithResponseSpec(String companyIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showNotificationsRequestCreation(companyIdentifier, messageIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showNotifications1RequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showNotifications1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/message/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<NotificationViewAffiliate> showNotifications1(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>(this){};
        return this.showNotifications1RequestCreation(companyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<NotificationViewAffiliate>>> showNotifications1WithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>(this){};
        return this.showNotifications1RequestCreation(companyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showNotifications1WithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showNotifications1RequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showUnreadMessageCountRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUnreadMessageCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/message/count", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CountResponseAffiliate> showUnreadMessageCount(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>(this){};
        return this.showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CountResponseAffiliate>> showUnreadMessageCountWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>(this){};
        return this.showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showUnreadMessageCountWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion, accept);
    }
}

