/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.affiliate.model.ChildAgent;

@JsonPropertyOrder(value={"adults", "children"})
@JsonTypeName(value="RoomConfiguration_Agent")
public class RoomConfigurationAgent {
    public static final String JSON_PROPERTY_ADULTS = "adults";
    private Integer adults = 1;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private List<ChildAgent> children;

    public RoomConfigurationAgent adults(Integer adults) {
        this.adults = adults;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getAdults() {
        return this.adults;
    }

    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdults(Integer adults) {
        this.adults = adults;
    }

    public RoomConfigurationAgent children(List<ChildAgent> children) {
        this.children = children;
        return this;
    }

    public RoomConfigurationAgent addChildrenItem(ChildAgent childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<ChildAgent>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ChildAgent> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(List<ChildAgent> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomConfigurationAgent roomConfigurationAgent = (RoomConfigurationAgent)o;
        return Objects.equals(this.adults, roomConfigurationAgent.adults) && Objects.equals(this.children, roomConfigurationAgent.children);
    }

    public int hashCode() {
        return Objects.hash(this.adults, this.children);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomConfigurationAgent {\n");
        sb.append("    adults: ").append(this.toIndentedString(this.adults)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

