/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Affiliate API The Affiliate API exposes endpoints to manage affiliate accounts. This API lets you:  1. Create affiliates. 2. Create account managers  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.4.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertCompanyRequestAffiliate
 */
@JsonPropertyOrder({
  UpsertCompanyRequestAffiliate.JSON_PROPERTY_NAME,
  UpsertCompanyRequestAffiliate.JSON_PROPERTY_LEGAL_NAME,
  UpsertCompanyRequestAffiliate.JSON_PROPERTY_COMPANY_TYPE,
  UpsertCompanyRequestAffiliate.JSON_PROPERTY_TYPE,
  UpsertCompanyRequestAffiliate.JSON_PROPERTY_VAT_I_D,
  UpsertCompanyRequestAffiliate.JSON_PROPERTY_DESCRIPTION,
  UpsertCompanyRequestAffiliate.JSON_PROPERTY_URL,
  UpsertCompanyRequestAffiliate.JSON_PROPERTY_URLS
})
@JsonTypeName("UpsertCompanyRequest_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T22:08:14.547771993+07:00[Asia/Bangkok]")
public class UpsertCompanyRequestAffiliate {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  /**
   * Type of company
   */
  public enum CompanyTypeEnum {
    COMPANY("COMPANY"),
    
    INDIVIDUAL("INDIVIDUAL");

    private String value;

    CompanyTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CompanyTypeEnum fromValue(String value) {
      for (CompanyTypeEnum b : CompanyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_COMPANY_TYPE = "companyType";
  private CompanyTypeEnum companyType;

  /**
   * Type of company
   */
  public enum TypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM"),
    
    GOOGLE_HOTEL_API("GOOGLE_HOTEL_API"),
    
    MANAGEMENT_COMPANY("MANAGEMENT_COMPANY"),
    
    CHAIN("CHAIN"),
    
    BRAND("BRAND"),
    
    EVENT_ORGANIZER("EVENT_ORGANIZER");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VAT_I_D = "vatID";
  private String vatID;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_URLS = "urls";
  private List<String> urls;

  public UpsertCompanyRequestAffiliate() {
  }

  public UpsertCompanyRequestAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of company
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public UpsertCompanyRequestAffiliate legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of entity if other than name
   * @return legalName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public UpsertCompanyRequestAffiliate companyType(CompanyTypeEnum companyType) {
    
    this.companyType = companyType;
    return this;
  }

   /**
   * Type of company
   * @return companyType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CompanyTypeEnum getCompanyType() {
    return companyType;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCompanyType(CompanyTypeEnum companyType) {
    this.companyType = companyType;
  }


  public UpsertCompanyRequestAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of company
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public UpsertCompanyRequestAffiliate vatID(String vatID) {
    
    this.vatID = vatID;
    return this;
  }

   /**
   * A VAT id if required
   * @return vatID
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VAT_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVatID() {
    return vatID;
  }


  @JsonProperty(JSON_PROPERTY_VAT_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVatID(String vatID) {
    this.vatID = vatID;
  }


  public UpsertCompanyRequestAffiliate description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A personal message from the company.
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public UpsertCompanyRequestAffiliate url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * Company&#39;s main website
   * @return url
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  public UpsertCompanyRequestAffiliate urls(List<String> urls) {
    
    this.urls = urls;
    return this;
  }

  public UpsertCompanyRequestAffiliate addUrlsItem(String urlsItem) {
    if (this.urls == null) {
      this.urls = new ArrayList<>();
    }
    this.urls.add(urlsItem);
    return this;
  }

   /**
   * List of all active accounts that could be used for selling or seeing a company&#39;s reach.
   * @return urls
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getUrls() {
    return urls;
  }


  @JsonProperty(JSON_PROPERTY_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrls(List<String> urls) {
    this.urls = urls;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate = (UpsertCompanyRequestAffiliate) o;
    return Objects.equals(this.name, upsertCompanyRequestAffiliate.name) &&
        Objects.equals(this.legalName, upsertCompanyRequestAffiliate.legalName) &&
        Objects.equals(this.companyType, upsertCompanyRequestAffiliate.companyType) &&
        Objects.equals(this.type, upsertCompanyRequestAffiliate.type) &&
        Objects.equals(this.vatID, upsertCompanyRequestAffiliate.vatID) &&
        Objects.equals(this.description, upsertCompanyRequestAffiliate.description) &&
        Objects.equals(this.url, upsertCompanyRequestAffiliate.url) &&
        Objects.equals(this.urls, upsertCompanyRequestAffiliate.urls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, legalName, companyType, type, vatID, description, url, urls);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertCompanyRequestAffiliate {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    companyType: ").append(toIndentedString(companyType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    vatID: ").append(toIndentedString(vatID)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    urls: ").append(toIndentedString(urls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

