package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.CompanyViewAffiliate;
import travel.wink.sdk.affiliate.model.CreateCompany400Response;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.InviteManagerRequestAffiliate;
import travel.wink.sdk.affiliate.model.ManagerInviteAcceptedSupplier;
import travel.wink.sdk.affiliate.model.ManagerInviteAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-28T11:50:31.122650324+07:00[Asia/Bangkok]")
public class AccountManagerApi {
    private ApiClient apiClient;

    public AccountManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Accept Invite
     * Accepts the invite to manager a property or account.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier for which to accept invite to
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ManagerInviteAcceptedSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec acceptManagerInviteRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling acceptManagerInvite", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>() {};
        return apiClient.invokeAPI("/api/manager/invite/{companyIdentifier}/accept", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Accept Invite
     * Accepts the invite to manager a property or account.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier for which to accept invite to
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ManagerInviteAcceptedSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ManagerInviteAcceptedSupplier> acceptManagerInvite(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>() {};
        return acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Accept Invite
     * Accepts the invite to manager a property or account.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier for which to accept invite to
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ManagerInviteAcceptedSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ManagerInviteAcceptedSupplier>> acceptManagerInviteWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>() {};
        return acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Accept Invite
     * Accepts the invite to manager a property or account.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier for which to accept invite to
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec acceptManagerInviteWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept);
    }
    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Invite user to manage company with given identifier
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec inviteManagerRequestCreation(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = inviteManagerRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling inviteManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inviteManagerRequestAffiliate' is set
        if (inviteManagerRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'inviteManagerRequestAffiliate' when calling inviteManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/manager/invite", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Invite user to manage company with given identifier
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAffiliate> inviteManager(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Invite user to manage company with given identifier
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAffiliate>> inviteManagerWithHttpInfo(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Invite user to manage company with given identifier
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec inviteManagerWithResponseSpec(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion);
    }
    /**
     * Reject Invite
     * Remove manager by specified identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec rejectInviteRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling rejectInvite", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/manager/invite/{companyIdentifier}/reject", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Reject Invite
     * Remove manager by specified identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> rejectInvite(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return rejectInviteRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Reject Invite
     * Remove manager by specified identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> rejectInviteWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return rejectInviteRequestCreation(companyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Reject Invite
     * Remove manager by specified identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec rejectInviteWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return rejectInviteRequestCreation(companyIdentifier, winkVersion, accept);
    }
    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from company with given identifier
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCompanyUserRequestCreation(String companyIdentifier, String email, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'email' is set
        if (email == null) {
            throw new WebClientResponseException("Missing the required parameter 'email' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("email", email);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/manager/{email}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from company with given identifier
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAffiliate> removeCompanyUser(String companyIdentifier, String email, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from company with given identifier
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAffiliate>> removeCompanyUserWithHttpInfo(String companyIdentifier, String email, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from company with given identifier
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeCompanyUserWithResponseSpec(String companyIdentifier, String email, String winkVersion, String accept) throws WebClientResponseException {
        return removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion, accept);
    }
    /**
     * Show Invites
     * Retrieve list of invites for user
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ManagerInviteAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showManagerInviteListRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>() {};
        return apiClient.invokeAPI("/api/manager/invite/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Invites
     * Retrieve list of invites for user
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ManagerInviteAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ManagerInviteAffiliate> showManagerInviteList(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>() {};
        return showManagerInviteListRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Invites
     * Retrieve list of invites for user
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;ManagerInviteAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ManagerInviteAffiliate>>> showManagerInviteListWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>() {};
        return showManagerInviteListRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Invites
     * Retrieve list of invites for user
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showManagerInviteListWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showManagerInviteListRequestCreation(winkVersion, accept);
    }
}
