/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.BookingAnalyticsSupplier;
import travel.wink.sdk.affiliate.model.BookingOverviewRequestSupplier;
import travel.wink.sdk.affiliate.model.CompanyViewAffiliate;
import travel.wink.sdk.affiliate.model.CreateCompanyRequestAffiliate;
import travel.wink.sdk.affiliate.model.GroupedBookingSalesMetricsSupplierDetails;
import travel.wink.sdk.affiliate.model.PageCompanyViewSupplier;
import travel.wink.sdk.affiliate.model.StateSupplier;
import travel.wink.sdk.affiliate.model.UniqueRequestAffiliate;
import travel.wink.sdk.affiliate.model.UniqueResultAffiliate;
import travel.wink.sdk.affiliate.model.UpsertAddressRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyLogoRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyStatusRequestAffiliate;

public class AffiliateApi {
    private ApiClient apiClient;

    public AffiliateApi() {
        this(new ApiClient());
    }

    @Autowired
    public AffiliateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createCompanyRequestCreation(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateCompanyRequestAffiliate postBody = createCompanyRequestAffiliate;
        if (createCompanyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createCompanyRequestAffiliate' when calling createCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> createCompany(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> createCompanyWithHttpInfo(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCompanyWithResponseSpec(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec isCompanyNameUniqueRequestCreation(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UniqueRequestAffiliate postBody = uniqueRequestAffiliate;
        if (uniqueRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'uniqueRequestAffiliate' when calling isCompanyNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/unique", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResultAffiliate> isCompanyNameUnique(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>(this){};
        return this.isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResultAffiliate>> isCompanyNameUniqueWithHttpInfo(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>(this){};
        return this.isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isCompanyNameUniqueWithResponseSpec(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeCompanyRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> removeCompany(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> removeCompanyWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCompanyWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec searchAffiliatesRequestCreation(StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling searchAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageCompanyViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageCompanyViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageCompanyViewSupplier> searchAffiliates(StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageCompanyViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageCompanyViewSupplier>(this){};
        return this.searchAffiliatesRequestCreation(stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageCompanyViewSupplier>> searchAffiliatesWithHttpInfo(StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageCompanyViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageCompanyViewSupplier>(this){};
        return this.searchAffiliatesRequestCreation(stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchAffiliatesWithResponseSpec(StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return this.searchAffiliatesRequestCreation(stateSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showBookingAnalyticsRequestCreation(String companyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        BookingOverviewRequestSupplier postBody = bookingOverviewRequestSupplier;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingOverviewRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingOverviewRequestSupplier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/analytics", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingAnalyticsSupplier> showBookingAnalytics(String companyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>(this){};
        return this.showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingAnalyticsSupplier>> showBookingAnalyticsWithHttpInfo(String companyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>(this){};
        return this.showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingAnalyticsWithResponseSpec(String companyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showBookingOverviewRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingOverview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/overview", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GroupedBookingSalesMetricsSupplierDetails> showBookingOverview(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>(this){};
        return this.showBookingOverviewRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GroupedBookingSalesMetricsSupplierDetails>> showBookingOverviewWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>(this){};
        return this.showBookingOverviewRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingOverviewWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showBookingOverviewRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCompaniesRequestCreation(String type, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CompanyViewAffiliate> showCompanies(String type, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.showCompaniesRequestCreation(type, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CompanyViewAffiliate>>> showCompaniesWithHttpInfo(String type, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.showCompaniesRequestCreation(type, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCompaniesWithResponseSpec(String type, String winkVersion, String accept) throws WebClientResponseException {
        return this.showCompaniesRequestCreation(type, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCompanyRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> showCompany(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> showCompanyWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCompanyWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateCompanyRequestCreation(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertCompanyRequestAffiliate postBody = upsertCompanyRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyRequestAffiliate' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> updateCompany(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> updateCompanyWithHttpInfo(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompanyWithResponseSpec(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCompany1RequestCreation(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertCompanyStatusRequestAffiliate postBody = upsertCompanyStatusRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyStatusRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyStatusRequestAffiliate' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/status", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> updateCompany1(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> updateCompany1WithHttpInfo(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompany1WithResponseSpec(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCompanyAddressRequestCreation(String companyIdentifier, UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertAddressRequestAffiliate postBody = upsertAddressRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompanyAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAddressRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddressRequestAffiliate' when calling updateCompanyAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/address", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> updateCompanyAddress(String companyIdentifier, UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> updateCompanyAddressWithHttpInfo(String companyIdentifier, UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompanyAddressWithResponseSpec(String companyIdentifier, UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCompanyPhotoRequestCreation(String companyIdentifier, UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertCompanyLogoRequestAffiliate postBody = upsertCompanyLogoRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompanyPhoto", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyLogoRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyLogoRequestAffiliate' when calling updateCompanyPhoto", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/logo", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> updateCompanyPhoto(String companyIdentifier, UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompanyPhotoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> updateCompanyPhotoWithHttpInfo(String companyIdentifier, UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompanyPhotoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompanyPhotoWithResponseSpec(String companyIdentifier, UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateCompanyPhotoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion);
    }
}

