/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Affiliate API The Affiliate API exposes endpoints to manage affiliate accounts. This API lets you:  1. Create affiliates. 2. Create account managers  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.12.6
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.ImageAttributionAffiliate;
import travel.wink.sdk.affiliate.model.SimpleDescriptionAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Multimedia that contains less information than Multimedia object
 */
@JsonPropertyOrder({
  SimpleMultimediaAffiliate.JSON_PROPERTY_MULTIMEDIA_IDENTIFIER,
  SimpleMultimediaAffiliate.JSON_PROPERTY_IDENTIFIER,
  SimpleMultimediaAffiliate.JSON_PROPERTY_TYPE,
  SimpleMultimediaAffiliate.JSON_PROPERTY_SOURCE,
  SimpleMultimediaAffiliate.JSON_PROPERTY_SORT,
  SimpleMultimediaAffiliate.JSON_PROPERTY_ANGLE,
  SimpleMultimediaAffiliate.JSON_PROPERTY_WIDTH,
  SimpleMultimediaAffiliate.JSON_PROPERTY_HEIGHT,
  SimpleMultimediaAffiliate.JSON_PROPERTY_PUBLISHED,
  SimpleMultimediaAffiliate.JSON_PROPERTY_CATEGORY,
  SimpleMultimediaAffiliate.JSON_PROPERTY_DESCRIPTIONS,
  SimpleMultimediaAffiliate.JSON_PROPERTY_LIFESTYLE_TYPE,
  SimpleMultimediaAffiliate.JSON_PROPERTY_ATTRIBUTION,
  SimpleMultimediaAffiliate.JSON_PROPERTY_IS_LANDSCAPE
})
@JsonTypeName("SimpleMultimedia_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-24T16:06:55.282619945+07:00[Asia/Bangkok]")
public class SimpleMultimediaAffiliate {
  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
  private UUID multimediaIdentifier;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  /**
   * Whether Cloudinary media is a VIDEO or IMAGE.
   */
  public enum TypeEnum {
    IMAGE("IMAGE"),
    
    VIDEO("VIDEO"),
    
    AUDIO("AUDIO"),
    
    RAW("RAW");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Currently ONLY using Cloudinary to store all image / video assets.
   */
  public enum SourceEnum {
    YOUTUBE("YOUTUBE"),
    
    CLOUDINARY("CLOUDINARY");

    private String value;

    SourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SourceEnum fromValue(String value) {
      for (SourceEnum b : SourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOURCE = "source";
  private SourceEnum source = SourceEnum.CLOUDINARY;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort = 999;

  public static final String JSON_PROPERTY_ANGLE = "angle";
  private String angle;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Integer width;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Integer height;

  public static final String JSON_PROPERTY_PUBLISHED = "published";
  private Boolean published = false;

  public static final String JSON_PROPERTY_CATEGORY = "category";
  private String category;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionAffiliate> descriptions;

  /**
   * Associate this media with a specific lifestyle type. A user searching and filtering inventory based on lifestyles can be shown relevant media first.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_ATTRIBUTION = "attribution";
  private List<ImageAttributionAffiliate> attribution;

  public static final String JSON_PROPERTY_IS_LANDSCAPE = "isLandscape";
  private Boolean isLandscape;

  public SimpleMultimediaAffiliate() {
  }

  public SimpleMultimediaAffiliate multimediaIdentifier(UUID multimediaIdentifier) {
    
    this.multimediaIdentifier = multimediaIdentifier;
    return this;
  }

   /**
   * Document identifier
   * @return multimediaIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getMultimediaIdentifier() {
    return multimediaIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimediaIdentifier(UUID multimediaIdentifier) {
    this.multimediaIdentifier = multimediaIdentifier;
  }


  public SimpleMultimediaAffiliate identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Use this identifier to communicate with Cloudinary.
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public SimpleMultimediaAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Whether Cloudinary media is a VIDEO or IMAGE.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public SimpleMultimediaAffiliate source(SourceEnum source) {
    
    this.source = source;
    return this;
  }

   /**
   * Currently ONLY using Cloudinary to store all image / video assets.
   * @return source
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SourceEnum getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSource(SourceEnum source) {
    this.source = source;
  }


  public SimpleMultimediaAffiliate sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort allows you to control how you want to sort this record in a list of media records.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public SimpleMultimediaAffiliate angle(String angle) {
    
    this.angle = angle;
    return this;
  }

   /**
   * Media angle
   * @return angle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAngle() {
    return angle;
  }


  @JsonProperty(JSON_PROPERTY_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAngle(String angle) {
    this.angle = angle;
  }


  public SimpleMultimediaAffiliate width(Integer width) {
    
    this.width = width;
    return this;
  }

   /**
   * Media width in pixels.
   * @return width
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWidth(Integer width) {
    this.width = width;
  }


  public SimpleMultimediaAffiliate height(Integer height) {
    
    this.height = height;
    return this;
  }

   /**
   * Media height in pixels.
   * @return height
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHeight(Integer height) {
    this.height = height;
  }


  public SimpleMultimediaAffiliate published(Boolean published) {
    
    this.published = published;
    return this;
  }

   /**
   * Instead of deleting the media, choose to un-publish it instead for later re-use. Could be you keep seasonal images of the property.
   * @return published
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PUBLISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPublished() {
    return published;
  }


  @JsonProperty(JSON_PROPERTY_PUBLISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPublished(Boolean published) {
    this.published = published;
  }


  public SimpleMultimediaAffiliate category(String category) {
    
    this.category = category;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PIC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return category
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCategory() {
    return category;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategory(String category) {
    this.category = category;
  }


  public SimpleMultimediaAffiliate descriptions(List<SimpleDescriptionAffiliate> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public SimpleMultimediaAffiliate addDescriptionsItem(SimpleDescriptionAffiliate descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized media captions to give user some context about where this media was taken.
   * @return descriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescriptionAffiliate> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescriptions(List<SimpleDescriptionAffiliate> descriptions) {
    this.descriptions = descriptions;
  }


  public SimpleMultimediaAffiliate lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Associate this media with a specific lifestyle type. A user searching and filtering inventory based on lifestyles can be shown relevant media first.
   * @return lifestyleType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public SimpleMultimediaAffiliate attribution(List<ImageAttributionAffiliate> attribution) {
    
    this.attribution = attribution;
    return this;
  }

  public SimpleMultimediaAffiliate addAttributionItem(ImageAttributionAffiliate attributionItem) {
    if (this.attribution == null) {
      this.attribution = new ArrayList<>();
    }
    this.attribution.add(attributionItem);
    return this;
  }

   /**
   * Whether image has attribution properties
   * @return attribution
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ATTRIBUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ImageAttributionAffiliate> getAttribution() {
    return attribution;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttribution(List<ImageAttributionAffiliate> attribution) {
    this.attribution = attribution;
  }


  public SimpleMultimediaAffiliate isLandscape(Boolean isLandscape) {
    
    this.isLandscape = isLandscape;
    return this;
  }

   /**
   * True if media width is greater or equal to height
   * @return isLandscape
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_LANDSCAPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsLandscape() {
    return isLandscape;
  }


  @JsonProperty(JSON_PROPERTY_IS_LANDSCAPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsLandscape(Boolean isLandscape) {
    this.isLandscape = isLandscape;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SimpleMultimediaAffiliate simpleMultimediaAffiliate = (SimpleMultimediaAffiliate) o;
    return Objects.equals(this.multimediaIdentifier, simpleMultimediaAffiliate.multimediaIdentifier) &&
        Objects.equals(this.identifier, simpleMultimediaAffiliate.identifier) &&
        Objects.equals(this.type, simpleMultimediaAffiliate.type) &&
        Objects.equals(this.source, simpleMultimediaAffiliate.source) &&
        Objects.equals(this.sort, simpleMultimediaAffiliate.sort) &&
        Objects.equals(this.angle, simpleMultimediaAffiliate.angle) &&
        Objects.equals(this.width, simpleMultimediaAffiliate.width) &&
        Objects.equals(this.height, simpleMultimediaAffiliate.height) &&
        Objects.equals(this.published, simpleMultimediaAffiliate.published) &&
        Objects.equals(this.category, simpleMultimediaAffiliate.category) &&
        Objects.equals(this.descriptions, simpleMultimediaAffiliate.descriptions) &&
        Objects.equals(this.lifestyleType, simpleMultimediaAffiliate.lifestyleType) &&
        Objects.equals(this.attribution, simpleMultimediaAffiliate.attribution) &&
        Objects.equals(this.isLandscape, simpleMultimediaAffiliate.isLandscape);
  }

  @Override
  public int hashCode() {
    return Objects.hash(multimediaIdentifier, identifier, type, source, sort, angle, width, height, published, category, descriptions, lifestyleType, attribution, isLandscape);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SimpleMultimediaAffiliate {\n");
    sb.append("    multimediaIdentifier: ").append(toIndentedString(multimediaIdentifier)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    angle: ").append(toIndentedString(angle)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    published: ").append(toIndentedString(published)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    isLandscape: ").append(toIndentedString(isLandscape)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

