/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.CompanyViewAffiliate;
import travel.wink.sdk.affiliate.model.InviteManagerRequestAffiliate;
import travel.wink.sdk.affiliate.model.ManagerInviteAcceptedSupplier;
import travel.wink.sdk.affiliate.model.ManagerInviteAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseSupplier;

public class AccountManagerApi {
    private ApiClient apiClient;

    public AccountManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec acceptManagerInviteRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling acceptManagerInvite", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>(this){};
        return this.apiClient.invokeAPI("/api/manager/invite/{companyIdentifier}/accept", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ManagerInviteAcceptedSupplier> acceptManagerInvite(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>(this){};
        return this.acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ManagerInviteAcceptedSupplier>> acceptManagerInviteWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>(this){};
        return this.acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec acceptManagerInviteWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec inviteManagerRequestCreation(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        InviteManagerRequestAffiliate postBody = inviteManagerRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling inviteManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inviteManagerRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'inviteManagerRequestAffiliate' when calling inviteManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/manager/invite", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> inviteManager(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> inviteManagerWithHttpInfo(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec inviteManagerWithResponseSpec(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec rejectInviteRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling rejectInvite", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/manager/invite/{companyIdentifier}/reject", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> rejectInvite(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.rejectInviteRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> rejectInviteWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.rejectInviteRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec rejectInviteWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.rejectInviteRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeCompanyUserRequestCreation(String companyIdentifier, String email, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (email == null) {
            throw new WebClientResponseException("Missing the required parameter 'email' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("email", email);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/manager/{email}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> removeCompanyUser(String companyIdentifier, String email, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> removeCompanyUserWithHttpInfo(String companyIdentifier, String email, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCompanyUserWithResponseSpec(String companyIdentifier, String email, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion, accept);
    }

    private WebClient.ResponseSpec showManagerInviteListRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/manager/invite/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ManagerInviteAffiliate> showManagerInviteList(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>(this){};
        return this.showManagerInviteListRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ManagerInviteAffiliate>>> showManagerInviteListWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>(this){};
        return this.showManagerInviteListRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showManagerInviteListWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showManagerInviteListRequestCreation(winkVersion, accept);
    }
}

