/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Affiliate API The Affiliate API exposes endpoints to manage affiliate accounts. This API lets you:  1. Create affiliates. 2. Create account managers  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.14.5
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Online presence of account.
 */
@JsonPropertyOrder({
  OnlinePresenceAffiliate.JSON_PROPERTY_TYPE,
  OnlinePresenceAffiliate.JSON_PROPERTY_IDENTIFIER,
  OnlinePresenceAffiliate.JSON_PROPERTY_AUDIENCES,
  OnlinePresenceAffiliate.JSON_PROPERTY_AUDIENCE_SIZE
})
@JsonTypeName("OnlinePresence_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:44:47.458177582+07:00[Asia/Bangkok]")
public class OnlinePresenceAffiliate {
  /**
   * List of all active accounts that could be used for selling or seeing a company&#39;s reach.
   */
  public enum TypeEnum {
    WINK("WINK"),
    
    WEB_SITE("WEB_SITE"),
    
    PERSONAL_WEB_SITE("PERSONAL_WEB_SITE"),
    
    CORPORATE_WEB_SITE("CORPORATE_WEB_SITE"),
    
    FACEBOOK("FACEBOOK"),
    
    INSTAGRAM("INSTAGRAM"),
    
    TWITTER_X("TWITTER_X"),
    
    LINKEDIN("LINKEDIN"),
    
    TIKTOK("TIKTOK"),
    
    SNAPCHAT("SNAPCHAT"),
    
    MASTODON("MASTODON"),
    
    THREADS("THREADS"),
    
    HIVE_SOCIAL("HIVE_SOCIAL"),
    
    MEWE("MEWE"),
    
    ELLO("ELLO"),
    
    WHATSAPP("WHATSAPP"),
    
    TELEGRAM("TELEGRAM"),
    
    SIGNAL("SIGNAL"),
    
    WECHAT("WECHAT"),
    
    LINE("LINE"),
    
    KAKAOTALK("KAKAOTALK"),
    
    VIBER("VIBER"),
    
    DISCORD("DISCORD"),
    
    SKYPE("SKYPE"),
    
    FACEBOOK_MESSENGER("FACEBOOK_MESSENGER"),
    
    YOUTUBE("YOUTUBE"),
    
    TWITCH("TWITCH"),
    
    BILIBILI("BILIBILI"),
    
    VIMEO("VIMEO"),
    
    DAILYMOTION("DAILYMOTION"),
    
    KICK("KICK"),
    
    UPLIVE("UPLIVE"),
    
    PINTEREST("PINTEREST"),
    
    BEREAL("BEREAL"),
    
    VSCO("VSCO"),
    
    IMGUR("IMGUR"),
    
    FLICKR("FLICKR"),
    
    FIVE_HUNDRED_PX("FIVE_HUNDRED_PX"),
    
    REDDIT("REDDIT"),
    
    QUORA("QUORA"),
    
    TUMBLR("TUMBLR"),
    
    PLURK("PLURK"),
    
    MEDIUM("MEDIUM"),
    
    BLUESKY("BLUESKY"),
    
    MINDS("MINDS"),
    
    STEEMIT("STEEMIT"),
    
    DIASPORA("DIASPORA"),
    
    WHISPER("WHISPER"),
    
    YIK_YAK("YIK_YAK"),
    
    TELLONYM("TELLONYM"),
    
    GOOGLE("GOOGLE"),
    
    GITHUB("GITHUB"),
    
    SPOTIFY("SPOTIFY"),
    
    UPWORK("UPWORK"),
    
    SHOPIFY("SHOPIFY"),
    
    AMAZON("AMAZON");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  /**
   * The url, account name or phone number that identifies this user with the specified network.
   */
  public enum AudiencesEnum {
    EVERYONE("EVERYONE"),
    
    ADVENTURE("ADVENTURE"),
    
    BEACH("BEACH"),
    
    BUSINESS("BUSINESS"),
    
    CULTURAL_EXPERIENCE("CULTURAL_EXPERIENCE"),
    
    EDUCATION("EDUCATION"),
    
    FAMILY("FAMILY"),
    
    FOOD_AND_CULINARY("FOOD_AND_CULINARY"),
    
    HIKING("HIKING"),
    
    HISTORICAL_SITES("HISTORICAL_SITES"),
    
    HONEYMOON("HONEYMOON"),
    
    LUXURY("LUXURY"),
    
    MEDICAL_TOURISM("MEDICAL_TOURISM"),
    
    MUSIC_AND_FESTIVALS("MUSIC_AND_FESTIVALS"),
    
    NATURE_AND_WILDLIFE("NATURE_AND_WILDLIFE"),
    
    PHOTOGRAPHY("PHOTOGRAPHY"),
    
    PILGRIMAGE("PILGRIMAGE"),
    
    RELAXATION("RELAXATION"),
    
    ROAD_TRIP("ROAD_TRIP"),
    
    ROMANCE("ROMANCE"),
    
    SHOPPING("SHOPPING"),
    
    SKIING("SKIING"),
    
    SOLO_TRAVEL("SOLO_TRAVEL"),
    
    SPORTS_EVENTS("SPORTS_EVENTS"),
    
    VOLUNTEERING("VOLUNTEERING"),
    
    WELLNESS_AND_SPA("WELLNESS_AND_SPA"),
    
    CITY("CITY"),
    
    WILDLIFE("WILDLIFE");

    private String value;

    AudiencesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AudiencesEnum fromValue(String value) {
      for (AudiencesEnum b : AudiencesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AUDIENCES = "audiences";
  private List<AudiencesEnum> audiences;

  public static final String JSON_PROPERTY_AUDIENCE_SIZE = "audienceSize";
  private Long audienceSize;

  public OnlinePresenceAffiliate() {
  }

  public OnlinePresenceAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * List of all active accounts that could be used for selling or seeing a company&#39;s reach.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public OnlinePresenceAffiliate identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * The url, account name or phone number that identifies this user with the specified network.
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public OnlinePresenceAffiliate audiences(List<AudiencesEnum> audiences) {
    
    this.audiences = audiences;
    return this;
  }

  public OnlinePresenceAffiliate addAudiencesItem(AudiencesEnum audiencesItem) {
    if (this.audiences == null) {
      this.audiences = new ArrayList<>();
    }
    this.audiences.add(audiencesItem);
    return this;
  }

   /**
   * The url, account name or phone number that identifies this user with the specified network.
   * @return audiences
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AUDIENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AudiencesEnum> getAudiences() {
    return audiences;
  }


  @JsonProperty(JSON_PROPERTY_AUDIENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAudiences(List<AudiencesEnum> audiences) {
    this.audiences = audiences;
  }


  public OnlinePresenceAffiliate audienceSize(Long audienceSize) {
    
    this.audienceSize = audienceSize;
    return this;
  }

   /**
   * The url, account name or phone number that identifies this user with the specified network.
   * @return audienceSize
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_AUDIENCE_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getAudienceSize() {
    return audienceSize;
  }


  @JsonProperty(JSON_PROPERTY_AUDIENCE_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAudienceSize(Long audienceSize) {
    this.audienceSize = audienceSize;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OnlinePresenceAffiliate onlinePresenceAffiliate = (OnlinePresenceAffiliate) o;
    return Objects.equals(this.type, onlinePresenceAffiliate.type) &&
        Objects.equals(this.identifier, onlinePresenceAffiliate.identifier) &&
        Objects.equals(this.audiences, onlinePresenceAffiliate.audiences) &&
        Objects.equals(this.audienceSize, onlinePresenceAffiliate.audienceSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, identifier, audiences, audienceSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OnlinePresenceAffiliate {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    audiences: ").append(toIndentedString(audiences)).append("\n");
    sb.append("    audienceSize: ").append(toIndentedString(audienceSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

