/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.AddressSupplier;
import travel.wink.sdk.affiliate.model.CompanyUserSupplier;
import travel.wink.sdk.affiliate.model.CustomMonetaryAmount;
import travel.wink.sdk.affiliate.model.ManagedByEntitySupplier;
import travel.wink.sdk.affiliate.model.OnlinePresenceSupplier;
import travel.wink.sdk.affiliate.model.SimpleMultimediaSupplier;
import travel.wink.sdk.affiliate.model.TravelAgentSupplier;

@JsonPropertyOrder(value={"identifier", "userIdentifier", "owner", "name", "urlName", "legalName", "enabled", "approved", "companyType", "type", "description", "address", "managers", "logo", "travelAgent", "managedBy", "onlinePresence", "annualTravelSpendInDollars"})
@JsonTypeName(value="Company_Supplier")
public class CompanySupplier {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private CompanyUserSupplier owner;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_URL_NAME = "urlName";
    private String urlName;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    private String legalName;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_APPROVED = "approved";
    private Boolean approved = false;
    public static final String JSON_PROPERTY_COMPANY_TYPE = "companyType";
    private CompanyTypeEnum companyType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressSupplier address;
    public static final String JSON_PROPERTY_MANAGERS = "managers";
    private List<CompanyUserSupplier> managers;
    public static final String JSON_PROPERTY_LOGO = "logo";
    private SimpleMultimediaSupplier logo;
    public static final String JSON_PROPERTY_TRAVEL_AGENT = "travelAgent";
    private TravelAgentSupplier travelAgent;
    public static final String JSON_PROPERTY_MANAGED_BY = "managedBy";
    private ManagedByEntitySupplier managedBy;
    public static final String JSON_PROPERTY_ONLINE_PRESENCE = "onlinePresence";
    private List<OnlinePresenceSupplier> onlinePresence;
    public static final String JSON_PROPERTY_ANNUAL_TRAVEL_SPEND_IN_DOLLARS = "annualTravelSpendInDollars";
    private CustomMonetaryAmount annualTravelSpendInDollars;

    public CompanySupplier identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public CompanySupplier userIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public CompanySupplier owner(CompanyUserSupplier owner) {
        this.owner = owner;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CompanyUserSupplier getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwner(CompanyUserSupplier owner) {
        this.owner = owner;
    }

    public CompanySupplier name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CompanySupplier urlName(String urlName) {
        this.urlName = urlName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrlName() {
        return this.urlName;
    }

    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrlName(String urlName) {
        this.urlName = urlName;
    }

    public CompanySupplier legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nullable
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public CompanySupplier enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CompanySupplier approved(Boolean approved) {
        this.approved = approved;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="approved")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getApproved() {
        return this.approved;
    }

    @JsonProperty(value="approved")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    public CompanySupplier companyType(CompanyTypeEnum companyType) {
        this.companyType = companyType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="companyType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CompanyTypeEnum getCompanyType() {
        return this.companyType;
    }

    @JsonProperty(value="companyType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompanyType(CompanyTypeEnum companyType) {
        this.companyType = companyType;
    }

    public CompanySupplier type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CompanySupplier description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CompanySupplier address(AddressSupplier address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressSupplier getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(AddressSupplier address) {
        this.address = address;
    }

    public CompanySupplier managers(List<CompanyUserSupplier> managers) {
        this.managers = managers;
        return this;
    }

    public CompanySupplier addManagersItem(CompanyUserSupplier managersItem) {
        if (this.managers == null) {
            this.managers = new ArrayList<CompanyUserSupplier>();
        }
        this.managers.add(managersItem);
        return this;
    }

    @Nullable
    @Valid
    @Size(min=0, max=30)
    @JsonProperty(value="managers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @Size(min=0, max=30) List<CompanyUserSupplier> getManagers() {
        return this.managers;
    }

    @JsonProperty(value="managers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setManagers(List<CompanyUserSupplier> managers) {
        this.managers = managers;
    }

    public CompanySupplier logo(SimpleMultimediaSupplier logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SimpleMultimediaSupplier getLogo() {
        return this.logo;
    }

    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(SimpleMultimediaSupplier logo) {
        this.logo = logo;
    }

    public CompanySupplier travelAgent(TravelAgentSupplier travelAgent) {
        this.travelAgent = travelAgent;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="travelAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TravelAgentSupplier getTravelAgent() {
        return this.travelAgent;
    }

    @JsonProperty(value="travelAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTravelAgent(TravelAgentSupplier travelAgent) {
        this.travelAgent = travelAgent;
    }

    public CompanySupplier managedBy(ManagedByEntitySupplier managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="managedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ManagedByEntitySupplier getManagedBy() {
        return this.managedBy;
    }

    @JsonProperty(value="managedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setManagedBy(ManagedByEntitySupplier managedBy) {
        this.managedBy = managedBy;
    }

    public CompanySupplier onlinePresence(List<OnlinePresenceSupplier> onlinePresence) {
        this.onlinePresence = onlinePresence;
        return this;
    }

    public CompanySupplier addOnlinePresenceItem(OnlinePresenceSupplier onlinePresenceItem) {
        if (this.onlinePresence == null) {
            this.onlinePresence = new ArrayList<OnlinePresenceSupplier>();
        }
        this.onlinePresence.add(onlinePresenceItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="onlinePresence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OnlinePresenceSupplier> getOnlinePresence() {
        return this.onlinePresence;
    }

    @JsonProperty(value="onlinePresence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOnlinePresence(List<OnlinePresenceSupplier> onlinePresence) {
        this.onlinePresence = onlinePresence;
    }

    public CompanySupplier annualTravelSpendInDollars(CustomMonetaryAmount annualTravelSpendInDollars) {
        this.annualTravelSpendInDollars = annualTravelSpendInDollars;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="annualTravelSpendInDollars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getAnnualTravelSpendInDollars() {
        return this.annualTravelSpendInDollars;
    }

    @JsonProperty(value="annualTravelSpendInDollars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnnualTravelSpendInDollars(CustomMonetaryAmount annualTravelSpendInDollars) {
        this.annualTravelSpendInDollars = annualTravelSpendInDollars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompanySupplier companySupplier = (CompanySupplier)o;
        return Objects.equals(this.identifier, companySupplier.identifier) && Objects.equals(this.userIdentifier, companySupplier.userIdentifier) && Objects.equals(this.owner, companySupplier.owner) && Objects.equals(this.name, companySupplier.name) && Objects.equals(this.urlName, companySupplier.urlName) && Objects.equals(this.legalName, companySupplier.legalName) && Objects.equals(this.enabled, companySupplier.enabled) && Objects.equals(this.approved, companySupplier.approved) && Objects.equals((Object)this.companyType, (Object)companySupplier.companyType) && Objects.equals((Object)this.type, (Object)companySupplier.type) && Objects.equals(this.description, companySupplier.description) && Objects.equals(this.address, companySupplier.address) && Objects.equals(this.managers, companySupplier.managers) && Objects.equals(this.logo, companySupplier.logo) && Objects.equals(this.travelAgent, companySupplier.travelAgent) && Objects.equals(this.managedBy, companySupplier.managedBy) && Objects.equals(this.onlinePresence, companySupplier.onlinePresence) && Objects.equals(this.annualTravelSpendInDollars, companySupplier.annualTravelSpendInDollars);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.userIdentifier, this.owner, this.name, this.urlName, this.legalName, this.enabled, this.approved, this.companyType, this.type, this.description, this.address, this.managers, this.logo, this.travelAgent, this.managedBy, this.onlinePresence, this.annualTravelSpendInDollars});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompanySupplier {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    urlName: ").append(this.toIndentedString(this.urlName)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    approved: ").append(this.toIndentedString(this.approved)).append("\n");
        sb.append("    companyType: ").append(this.toIndentedString((Object)this.companyType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    managers: ").append(this.toIndentedString(this.managers)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    travelAgent: ").append(this.toIndentedString(this.travelAgent)).append("\n");
        sb.append("    managedBy: ").append(this.toIndentedString(this.managedBy)).append("\n");
        sb.append("    onlinePresence: ").append(this.toIndentedString(this.onlinePresence)).append("\n");
        sb.append("    annualTravelSpendInDollars: ").append(this.toIndentedString(this.annualTravelSpendInDollars)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CompanyTypeEnum {
        COMPANY("COMPANY"),
        INDIVIDUAL("INDIVIDUAL");

        private String value;

        private CompanyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CompanyTypeEnum fromValue(String value) {
            for (CompanyTypeEnum b : CompanyTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        DIRECT("DIRECT"),
        APPLICATION("APPLICATION"),
        HOTEL("HOTEL"),
        TRAVELIKO("TRAVELIKO"),
        CORPORATE("CORPORATE"),
        TRAVEL_AGENT("TRAVEL_AGENT"),
        INFLUENCER("INFLUENCER"),
        BLOGGER("BLOGGER"),
        DESTINATION("DESTINATION"),
        CHANNEL_MANAGER("CHANNEL_MANAGER"),
        PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
        CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM"),
        GOOGLE_HOTEL_API("GOOGLE_HOTEL_API"),
        MANAGEMENT_COMPANY("MANAGEMENT_COMPANY"),
        CHAIN("CHAIN"),
        BRAND("BRAND"),
        EVENT_ORGANIZER("EVENT_ORGANIZER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

