package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.AffiliateAccountAffiliate;
import travel.wink.sdk.affiliate.model.AffiliateAccountSupplier;
import travel.wink.sdk.affiliate.model.CreateCompany400Response;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.InviteManagerRequestAffiliate;
import travel.wink.sdk.affiliate.model.ManagerInviteAcceptedSupplier;
import travel.wink.sdk.affiliate.model.ManagerInviteAffiliate;
import travel.wink.sdk.affiliate.model.UpsertManagedByAgencyRequestAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:15:21.456735702+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class AccountManagerApi {
    private ApiClient apiClient;

    public AccountManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Accept Invite
     * Accepts the invite to manager a property or account.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier AffiliateAccountLightweight identifier for which to accept invite to
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ManagerInviteAcceptedSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec acceptManagerInviteRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling acceptManagerInvite", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>() {};
        return apiClient.invokeAPI("/api/manager/invite/{companyIdentifier}/accept", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Accept Invite
     * Accepts the invite to manager a property or account.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier AffiliateAccountLightweight identifier for which to accept invite to
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ManagerInviteAcceptedSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ManagerInviteAcceptedSupplier> acceptManagerInvite(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>() {};
        return acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Accept Invite
     * Accepts the invite to manager a property or account.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier AffiliateAccountLightweight identifier for which to accept invite to
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ManagerInviteAcceptedSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ManagerInviteAcceptedSupplier>> acceptManagerInviteWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>() {};
        return acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Accept Invite
     * Accepts the invite to manager a property or account.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier AffiliateAccountLightweight identifier for which to accept invite to
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec acceptManagerInviteWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept);
    }

    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec inviteManagerRequestCreation(@jakarta.annotation.Nonnull InviteManagerRequestAffiliate inviteManagerRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = inviteManagerRequestAffiliate;
        // verify the required parameter 'inviteManagerRequestAffiliate' is set
        if (inviteManagerRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'inviteManagerRequestAffiliate' when calling inviteManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/manager/invite", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> inviteManager(@jakarta.annotation.Nonnull InviteManagerRequestAffiliate inviteManagerRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return inviteManagerRequestCreation(inviteManagerRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> inviteManagerWithHttpInfo(@jakarta.annotation.Nonnull InviteManagerRequestAffiliate inviteManagerRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return inviteManagerRequestCreation(inviteManagerRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec inviteManagerWithResponseSpec(@jakarta.annotation.Nonnull InviteManagerRequestAffiliate inviteManagerRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return inviteManagerRequestCreation(inviteManagerRequestAffiliate, winkVersion);
    }

    /**
     * Reject Invite
     * Remove manager by specified identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec rejectInviteRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling rejectInvite", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountSupplier>() {};
        return apiClient.invokeAPI("/api/manager/invite/{companyIdentifier}/reject", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Reject Invite
     * Remove manager by specified identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountSupplier> rejectInvite(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountSupplier>() {};
        return rejectInviteRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Reject Invite
     * Remove manager by specified identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AffiliateAccountSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountSupplier>> rejectInviteWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountSupplier>() {};
        return rejectInviteRequestCreation(companyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Reject Invite
     * Remove manager by specified identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove manager from this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec rejectInviteWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return rejectInviteRequestCreation(companyIdentifier, winkVersion, accept);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCompanyUserRequestCreation(@jakarta.annotation.Nonnull String email, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'email' is set
        if (email == null) {
            throw new WebClientResponseException("Missing the required parameter 'email' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("email", email);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/manager/{email}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> removeCompanyUser(@jakarta.annotation.Nonnull String email, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return removeCompanyUserRequestCreation(email, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> removeCompanyUserWithHttpInfo(@jakarta.annotation.Nonnull String email, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return removeCompanyUserRequestCreation(email, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeCompanyUserWithResponseSpec(@jakarta.annotation.Nonnull String email, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeCompanyUserRequestCreation(email, winkVersion, accept);
    }

    /**
     * Remove Managing Agency
     * Unset managing agency.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeManagerAgencyRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/manager/agency", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Managing Agency
     * Unset managing agency.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> removeManagerAgency(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return removeManagerAgencyRequestCreation(winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Managing Agency
     * Unset managing agency.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> removeManagerAgencyWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return removeManagerAgencyRequestCreation(winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Managing Agency
     * Unset managing agency.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeManagerAgencyWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeManagerAgencyRequestCreation(winkVersion, accept);
    }

    /**
     * Show Invites
     * Retrieve list of invites for user
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ManagerInviteAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showManagerInviteListRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>() {};
        return apiClient.invokeAPI("/api/manager/invite/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Invites
     * Retrieve list of invites for user
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ManagerInviteAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ManagerInviteAffiliate> showManagerInviteList(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>() {};
        return showManagerInviteListRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Invites
     * Retrieve list of invites for user
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;ManagerInviteAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ManagerInviteAffiliate>>> showManagerInviteListWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>() {};
        return showManagerInviteListRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Invites
     * Retrieve list of invites for user
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showManagerInviteListWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showManagerInviteListRequestCreation(winkVersion, accept);
    }

    /**
     * Set Managing Agency
     * Indicates that the entity is managed by an another entity on the platform. This does not give privileges to manage the account but entitles the agency to a commission.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertManagedByAgencyRequestAffiliate The upsertManagedByAgencyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateManagerAgencyRequestCreation(@jakarta.annotation.Nonnull UpsertManagedByAgencyRequestAffiliate upsertManagedByAgencyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertManagedByAgencyRequestAffiliate;
        // verify the required parameter 'upsertManagedByAgencyRequestAffiliate' is set
        if (upsertManagedByAgencyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertManagedByAgencyRequestAffiliate' when calling updateManagerAgency", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/manager/agency", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Set Managing Agency
     * Indicates that the entity is managed by an another entity on the platform. This does not give privileges to manage the account but entitles the agency to a commission.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertManagedByAgencyRequestAffiliate The upsertManagedByAgencyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> updateManagerAgency(@jakarta.annotation.Nonnull UpsertManagedByAgencyRequestAffiliate upsertManagedByAgencyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateManagerAgencyRequestCreation(upsertManagedByAgencyRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Set Managing Agency
     * Indicates that the entity is managed by an another entity on the platform. This does not give privileges to manage the account but entitles the agency to a commission.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertManagedByAgencyRequestAffiliate The upsertManagedByAgencyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateManagerAgencyWithHttpInfo(@jakarta.annotation.Nonnull UpsertManagedByAgencyRequestAffiliate upsertManagedByAgencyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateManagerAgencyRequestCreation(upsertManagedByAgencyRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Set Managing Agency
     * Indicates that the entity is managed by an another entity on the platform. This does not give privileges to manage the account but entitles the agency to a commission.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertManagedByAgencyRequestAffiliate The upsertManagedByAgencyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateManagerAgencyWithResponseSpec(@jakarta.annotation.Nonnull UpsertManagedByAgencyRequestAffiliate upsertManagedByAgencyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateManagerAgencyRequestCreation(upsertManagedByAgencyRequestAffiliate, winkVersion);
    }
}
