package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.AffiliateAccountAffiliate;
import travel.wink.sdk.affiliate.model.BookingAnalyticsSupplier;
import travel.wink.sdk.affiliate.model.BookingOverviewRequestSupplier;
import travel.wink.sdk.affiliate.model.CreateCompany400Response;
import travel.wink.sdk.affiliate.model.CreateCompanyRequestAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.GroupedBookingSalesMetricsSupplierDetails;
import travel.wink.sdk.affiliate.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.model.PageAffiliateAccountSupplier;
import travel.wink.sdk.affiliate.model.StateSupplier;
import travel.wink.sdk.affiliate.model.UniqueRequestAffiliate;
import travel.wink.sdk.affiliate.model.UniqueResultAffiliate;
import travel.wink.sdk.affiliate.model.UpsertAddressRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyLogoRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyOnlinePresenceRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyStatusRequestAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:15:21.456735702+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class AffiliateApi {
    private ApiClient apiClient;

    public AffiliateApi() {
        this(new ApiClient());
    }

    @Autowired
    public AffiliateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Create Affiliate
     * Create a new affiliate
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createCompanyRequestAffiliate The createCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCompanyRequestCreation(@jakarta.annotation.Nonnull CreateCompanyRequestAffiliate createCompanyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = createCompanyRequestAffiliate;
        // verify the required parameter 'createCompanyRequestAffiliate' is set
        if (createCompanyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createCompanyRequestAffiliate' when calling createCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Affiliate
     * Create a new affiliate
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createCompanyRequestAffiliate The createCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> createCompany(@jakarta.annotation.Nonnull CreateCompanyRequestAffiliate createCompanyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Affiliate
     * Create a new affiliate
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createCompanyRequestAffiliate The createCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> createCompanyWithHttpInfo(@jakarta.annotation.Nonnull CreateCompanyRequestAffiliate createCompanyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Affiliate
     * Create a new affiliate
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createCompanyRequestAffiliate The createCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCompanyWithResponseSpec(@jakarta.annotation.Nonnull CreateCompanyRequestAffiliate createCompanyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion);
    }

    /**
     * Verify Affiliate Name
     * Check if company name is unique
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param uniqueRequestAffiliate The uniqueRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return UniqueResultAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isCompanyNameUniqueRequestCreation(@jakarta.annotation.Nonnull UniqueRequestAffiliate uniqueRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = uniqueRequestAffiliate;
        // verify the required parameter 'uniqueRequestAffiliate' is set
        if (uniqueRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'uniqueRequestAffiliate' when calling isCompanyNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/unique", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Affiliate Name
     * Check if company name is unique
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param uniqueRequestAffiliate The uniqueRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return UniqueResultAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UniqueResultAffiliate> isCompanyNameUnique(@jakarta.annotation.Nonnull UniqueRequestAffiliate uniqueRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>() {};
        return isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Verify Affiliate Name
     * Check if company name is unique
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param uniqueRequestAffiliate The uniqueRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UniqueResultAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UniqueResultAffiliate>> isCompanyNameUniqueWithHttpInfo(@jakarta.annotation.Nonnull UniqueRequestAffiliate uniqueRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>() {};
        return isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Verify Affiliate Name
     * Check if company name is unique
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param uniqueRequestAffiliate The uniqueRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isCompanyNameUniqueWithResponseSpec(@jakarta.annotation.Nonnull UniqueRequestAffiliate uniqueRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion);
    }

    /**
     * Delete Affiliate
     * Delete a company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Delete company with given identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCompanyRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Affiliate
     * Delete a company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Delete company with given identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> removeCompany(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return removeCompanyRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Affiliate
     * Delete a company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Delete company with given identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> removeCompanyWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return removeCompanyRequestCreation(companyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Affiliate
     * Delete a company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Delete company with given identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeCompanyWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeCompanyRequestCreation(companyIdentifier, winkVersion, accept);
    }

    /**
     * Delete Affiliate
     * Delete a company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMyAccountRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/my-account", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Affiliate
     * Delete a company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> removeMyAccount(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return removeMyAccountRequestCreation(winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Affiliate
     * Delete a company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> removeMyAccountWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return removeMyAccountRequestCreation(winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Affiliate
     * Delete a company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMyAccountWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeMyAccountRequestCreation(winkVersion, accept);
    }

    /**
     * Affiliate Search
     * Retrieve a paginated list of affiliates that you manage.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateSupplier Filter grid by state request body
     * @param winkVersion The winkVersion parameter
     * @return PageAffiliateAccountSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec searchAffiliatesRequestCreation(@jakarta.annotation.Nonnull StateSupplier stateSupplier, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = stateSupplier;
        // verify the required parameter 'stateSupplier' is set
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling searchAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageAffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<PageAffiliateAccountSupplier>() {};
        return apiClient.invokeAPI("/api/affiliate/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Affiliate Search
     * Retrieve a paginated list of affiliates that you manage.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateSupplier Filter grid by state request body
     * @param winkVersion The winkVersion parameter
     * @return PageAffiliateAccountSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageAffiliateAccountSupplier> searchAffiliates(@jakarta.annotation.Nonnull StateSupplier stateSupplier, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageAffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<PageAffiliateAccountSupplier>() {};
        return searchAffiliatesRequestCreation(stateSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Affiliate Search
     * Retrieve a paginated list of affiliates that you manage.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateSupplier Filter grid by state request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageAffiliateAccountSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageAffiliateAccountSupplier>> searchAffiliatesWithHttpInfo(@jakarta.annotation.Nonnull StateSupplier stateSupplier, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageAffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<PageAffiliateAccountSupplier>() {};
        return searchAffiliatesRequestCreation(stateSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Affiliate Search
     * Retrieve a paginated list of affiliates that you manage.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateSupplier Filter grid by state request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec searchAffiliatesWithResponseSpec(@jakarta.annotation.Nonnull StateSupplier stateSupplier, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return searchAffiliatesRequestCreation(stateSupplier, winkVersion);
    }

    /**
     * Affiliate Booking Analytics
     * Retrieve the number of upcoming bookings that arrive today for the specific company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show active booking count for company with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return BookingAnalyticsSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingAnalyticsRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull BookingOverviewRequestSupplier bookingOverviewRequestSupplier, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = bookingOverviewRequestSupplier;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingOverviewRequestSupplier' is set
        if (bookingOverviewRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingOverviewRequestSupplier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/analytics", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Affiliate Booking Analytics
     * Retrieve the number of upcoming bookings that arrive today for the specific company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show active booking count for company with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return BookingAnalyticsSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingAnalyticsSupplier> showBookingAnalytics(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull BookingOverviewRequestSupplier bookingOverviewRequestSupplier, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>() {};
        return showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Affiliate Booking Analytics
     * Retrieve the number of upcoming bookings that arrive today for the specific company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show active booking count for company with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingAnalyticsSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingAnalyticsSupplier>> showBookingAnalyticsWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull BookingOverviewRequestSupplier bookingOverviewRequestSupplier, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>() {};
        return showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Affiliate Booking Analytics
     * Retrieve the number of upcoming bookings that arrive today for the specific company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show active booking count for company with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingAnalyticsWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull BookingOverviewRequestSupplier bookingOverviewRequestSupplier, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion);
    }

    /**
     * Affiliate Booking Overview
     * Basic booking overview data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking owned by this company
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return GroupedBookingSalesMetricsSupplierDetails
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingOverviewRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingOverview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/overview", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Affiliate Booking Overview
     * Basic booking overview data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking owned by this company
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return GroupedBookingSalesMetricsSupplierDetails
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GroupedBookingSalesMetricsSupplierDetails> showBookingOverview(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>() {};
        return showBookingOverviewRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Affiliate Booking Overview
     * Basic booking overview data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking owned by this company
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;GroupedBookingSalesMetricsSupplierDetails&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GroupedBookingSalesMetricsSupplierDetails>> showBookingOverviewWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>() {};
        return showBookingOverviewRequestCreation(companyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Affiliate Booking Overview
     * Basic booking overview data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking owned by this company
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingOverviewWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showBookingOverviewRequestCreation(companyIdentifier, winkVersion, accept);
    }

    /**
     * Show Affiliates
     * List all companies owned by caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type Filter on companies of a specific type
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCompaniesRequestCreation(@jakarta.annotation.Nullable String type, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Affiliates
     * List all companies owned by caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type Filter on companies of a specific type
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AffiliateAccountAffiliate> showCompanies(@jakarta.annotation.Nullable String type, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return showCompaniesRequestCreation(type, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Affiliates
     * List all companies owned by caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type Filter on companies of a specific type
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;AffiliateAccountAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<AffiliateAccountAffiliate>>> showCompaniesWithHttpInfo(@jakarta.annotation.Nullable String type, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return showCompaniesRequestCreation(type, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Affiliates
     * List all companies owned by caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type Filter on companies of a specific type
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCompaniesWithResponseSpec(@jakarta.annotation.Nullable String type, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showCompaniesRequestCreation(type, winkVersion, accept);
    }

    /**
     * Show Affiliate
     * Retrieve company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Select company with given identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCompanyRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Affiliate
     * Retrieve company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Select company with given identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> showCompany(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return showCompanyRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Affiliate
     * Retrieve company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Select company with given identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> showCompanyWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return showCompanyRequestCreation(companyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Affiliate
     * Retrieve company by identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Select company with given identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCompanyWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showCompanyRequestCreation(companyIdentifier, winkVersion, accept);
    }

    /**
     * Show My Account
     * Retrieve my own account on Wink
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMyAccountRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/my-account", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show My Account
     * Retrieve my own account on Wink
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> showMyAccount(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return showMyAccountRequestCreation(winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show My Account
     * Retrieve my own account on Wink
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> showMyAccountWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return showMyAccountRequestCreation(winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show My Account
     * Retrieve my own account on Wink
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMyAccountWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showMyAccountRequestCreation(winkVersion, accept);
    }

    /**
     * Sales Channel Search
     * Search for sales channels by name
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param name Search for sales channel with name
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSalesChannelsRequestCreation(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling showSalesChannels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "name", name));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/sales-channel/search", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Sales Channel Search
     * Search for sales channels by name
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param name Search for sales channel with name
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showSalesChannels(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showSalesChannelsRequestCreation(name, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Sales Channel Search
     * Search for sales channels by name
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param name Search for sales channel with name
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showSalesChannelsWithHttpInfo(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showSalesChannelsRequestCreation(name, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Sales Channel Search
     * Search for sales channels by name
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param name Search for sales channel with name
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSalesChannelsWithResponseSpec(@jakarta.annotation.Nonnull String name, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showSalesChannelsRequestCreation(name, winkVersion, accept);
    }

    /**
     * Update Affiliate
     * Update an existing company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update company with given identifier
     * @param upsertCompanyRequestAffiliate The upsertCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompanyRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCompanyRequestAffiliate' is set
        if (upsertCompanyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyRequestAffiliate' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Affiliate
     * Update an existing company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update company with given identifier
     * @param upsertCompanyRequestAffiliate The upsertCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> updateCompany(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Affiliate
     * Update an existing company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update company with given identifier
     * @param upsertCompanyRequestAffiliate The upsertCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateCompanyWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Affiliate
     * Update an existing company
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update company with given identifier
     * @param upsertCompanyRequestAffiliate The upsertCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCompanyWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion);
    }

    /**
     * Toggle Affiliate Status
     * Update company status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update status of company with given identifier
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompany1RequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyStatusRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCompanyStatusRequestAffiliate' is set
        if (upsertCompanyStatusRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyStatusRequestAffiliate' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/status", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Toggle Affiliate Status
     * Update company status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update status of company with given identifier
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> updateCompany1(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Toggle Affiliate Status
     * Update company status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update status of company with given identifier
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateCompany1WithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Toggle Affiliate Status
     * Update company status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update status of company with given identifier
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCompany1WithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion);
    }

    /**
     * Update Affiliate Address
     * Updates company address.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update address of company with given identifier
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompanyAddressRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAddressRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompanyAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAddressRequestAffiliate' is set
        if (upsertAddressRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddressRequestAffiliate' when calling updateCompanyAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/address", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Affiliate Address
     * Updates company address.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update address of company with given identifier
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> updateCompanyAddress(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Affiliate Address
     * Updates company address.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update address of company with given identifier
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateCompanyAddressWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Affiliate Address
     * Updates company address.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update address of company with given identifier
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCompanyAddressWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion);
    }

    /**
     * Update Affiliate Logo
     * Updates company logo.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update logo of company with given identifier
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompanyLogoRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyLogoRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompanyLogo", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCompanyLogoRequestAffiliate' is set
        if (upsertCompanyLogoRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyLogoRequestAffiliate' when calling updateCompanyLogo", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/logo", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Affiliate Logo
     * Updates company logo.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update logo of company with given identifier
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> updateCompanyLogo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateCompanyLogoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Affiliate Logo
     * Updates company logo.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update logo of company with given identifier
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateCompanyLogoWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateCompanyLogoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Affiliate Logo
     * Updates company logo.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update logo of company with given identifier
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCompanyLogoWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateCompanyLogoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion);
    }

    /**
     * Update Affiliate Online Presence
     * Updates company online presence.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update logo of company with given identifier
     * @param upsertCompanyOnlinePresenceRequestAffiliate The upsertCompanyOnlinePresenceRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompanyOnlinePresenceRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyOnlinePresenceRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompanyOnlinePresence", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCompanyOnlinePresenceRequestAffiliate' is set
        if (upsertCompanyOnlinePresenceRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyOnlinePresenceRequestAffiliate' when calling updateCompanyOnlinePresence", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/online-presence", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Affiliate Online Presence
     * Updates company online presence.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update logo of company with given identifier
     * @param upsertCompanyOnlinePresenceRequestAffiliate The upsertCompanyOnlinePresenceRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> updateCompanyOnlinePresence(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateCompanyOnlinePresenceRequestCreation(companyIdentifier, upsertCompanyOnlinePresenceRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Affiliate Online Presence
     * Updates company online presence.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update logo of company with given identifier
     * @param upsertCompanyOnlinePresenceRequestAffiliate The upsertCompanyOnlinePresenceRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateCompanyOnlinePresenceWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateCompanyOnlinePresenceRequestCreation(companyIdentifier, upsertCompanyOnlinePresenceRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Affiliate Online Presence
     * Updates company online presence.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update logo of company with given identifier
     * @param upsertCompanyOnlinePresenceRequestAffiliate The upsertCompanyOnlinePresenceRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCompanyOnlinePresenceWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateCompanyOnlinePresenceRequestCreation(companyIdentifier, upsertCompanyOnlinePresenceRequestAffiliate, winkVersion);
    }

    /**
     * Toggle My Account Status
     * Update company status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMyAccountRequestCreation(@jakarta.annotation.Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyStatusRequestAffiliate;
        // verify the required parameter 'upsertCompanyStatusRequestAffiliate' is set
        if (upsertCompanyStatusRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyStatusRequestAffiliate' when calling updateMyAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/my-account/status", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Toggle My Account Status
     * Update company status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> updateMyAccount(@jakarta.annotation.Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateMyAccountRequestCreation(upsertCompanyStatusRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Toggle My Account Status
     * Update company status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateMyAccountWithHttpInfo(@jakarta.annotation.Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateMyAccountRequestCreation(upsertCompanyStatusRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Toggle My Account Status
     * Update company status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateMyAccountWithResponseSpec(@jakarta.annotation.Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateMyAccountRequestCreation(upsertCompanyStatusRequestAffiliate, winkVersion);
    }

    /**
     * Update My Account Address
     * Updates company address.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMyAccountAddressRequestCreation(@jakarta.annotation.Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAddressRequestAffiliate;
        // verify the required parameter 'upsertAddressRequestAffiliate' is set
        if (upsertAddressRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddressRequestAffiliate' when calling updateMyAccountAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/my-account/address", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update My Account Address
     * Updates company address.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> updateMyAccountAddress(@jakarta.annotation.Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateMyAccountAddressRequestCreation(upsertAddressRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update My Account Address
     * Updates company address.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateMyAccountAddressWithHttpInfo(@jakarta.annotation.Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateMyAccountAddressRequestCreation(upsertAddressRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update My Account Address
     * Updates company address.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateMyAccountAddressWithResponseSpec(@jakarta.annotation.Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateMyAccountAddressRequestCreation(upsertAddressRequestAffiliate, winkVersion);
    }

    /**
     * Update My Account Logo
     * Updates company logo.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMyAccountLogoRequestCreation(@jakarta.annotation.Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyLogoRequestAffiliate;
        // verify the required parameter 'upsertCompanyLogoRequestAffiliate' is set
        if (upsertCompanyLogoRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyLogoRequestAffiliate' when calling updateMyAccountLogo", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/my-account/logo", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update My Account Logo
     * Updates company logo.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> updateMyAccountLogo(@jakarta.annotation.Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateMyAccountLogoRequestCreation(upsertCompanyLogoRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update My Account Logo
     * Updates company logo.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateMyAccountLogoWithHttpInfo(@jakarta.annotation.Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateMyAccountLogoRequestCreation(upsertCompanyLogoRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update My Account Logo
     * Updates company logo.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateMyAccountLogoWithResponseSpec(@jakarta.annotation.Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateMyAccountLogoRequestCreation(upsertCompanyLogoRequestAffiliate, winkVersion);
    }

    /**
     * Update My Account Online Presence
     * Updates company online presence.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyOnlinePresenceRequestAffiliate The upsertCompanyOnlinePresenceRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMyAccountOnlinePresenceRequestCreation(@jakarta.annotation.Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyOnlinePresenceRequestAffiliate;
        // verify the required parameter 'upsertCompanyOnlinePresenceRequestAffiliate' is set
        if (upsertCompanyOnlinePresenceRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyOnlinePresenceRequestAffiliate' when calling updateMyAccountOnlinePresence", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return apiClient.invokeAPI("/api/my-account/online-presence", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update My Account Online Presence
     * Updates company online presence.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyOnlinePresenceRequestAffiliate The upsertCompanyOnlinePresenceRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAffiliate> updateMyAccountOnlinePresence(@jakarta.annotation.Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateMyAccountOnlinePresenceRequestCreation(upsertCompanyOnlinePresenceRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update My Account Online Presence
     * Updates company online presence.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyOnlinePresenceRequestAffiliate The upsertCompanyOnlinePresenceRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateMyAccountOnlinePresenceWithHttpInfo(@jakarta.annotation.Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>() {};
        return updateMyAccountOnlinePresenceRequestCreation(upsertCompanyOnlinePresenceRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update My Account Online Presence
     * Updates company online presence.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertCompanyOnlinePresenceRequestAffiliate The upsertCompanyOnlinePresenceRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateMyAccountOnlinePresenceWithResponseSpec(@jakarta.annotation.Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateMyAccountOnlinePresenceRequestCreation(upsertCompanyOnlinePresenceRequestAffiliate, winkVersion);
    }
}
