/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.AffiliateAccountAffiliate;
import travel.wink.sdk.affiliate.model.AffiliateAccountSupplier;
import travel.wink.sdk.affiliate.model.InviteManagerRequestAffiliate;
import travel.wink.sdk.affiliate.model.ManagerInviteAcceptedSupplier;
import travel.wink.sdk.affiliate.model.ManagerInviteAffiliate;
import travel.wink.sdk.affiliate.model.UpsertManagedByAgencyRequestAffiliate;

public class AccountManagerApi {
    private ApiClient apiClient;

    public AccountManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec acceptManagerInviteRequestCreation(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling acceptManagerInvite", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>(this){};
        return this.apiClient.invokeAPI("/api/manager/invite/{companyIdentifier}/accept", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ManagerInviteAcceptedSupplier> acceptManagerInvite(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>(this){};
        return this.acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ManagerInviteAcceptedSupplier>> acceptManagerInviteWithHttpInfo(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAcceptedSupplier> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAcceptedSupplier>(this){};
        return this.acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec acceptManagerInviteWithResponseSpec(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.acceptManagerInviteRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec inviteManagerRequestCreation(@Nonnull InviteManagerRequestAffiliate inviteManagerRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        InviteManagerRequestAffiliate postBody = inviteManagerRequestAffiliate;
        if (inviteManagerRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'inviteManagerRequestAffiliate' when calling inviteManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/manager/invite", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> inviteManager(@Nonnull InviteManagerRequestAffiliate inviteManagerRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.inviteManagerRequestCreation(inviteManagerRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> inviteManagerWithHttpInfo(@Nonnull InviteManagerRequestAffiliate inviteManagerRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.inviteManagerRequestCreation(inviteManagerRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec inviteManagerWithResponseSpec(@Nonnull InviteManagerRequestAffiliate inviteManagerRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.inviteManagerRequestCreation(inviteManagerRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec rejectInviteRequestCreation(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling rejectInvite", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountSupplier>(this){};
        return this.apiClient.invokeAPI("/api/manager/invite/{companyIdentifier}/reject", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountSupplier> rejectInvite(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountSupplier>(this){};
        return this.rejectInviteRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountSupplier>> rejectInviteWithHttpInfo(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountSupplier>(this){};
        return this.rejectInviteRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec rejectInviteWithResponseSpec(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.rejectInviteRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeCompanyUserRequestCreation(@Nonnull String email, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (email == null) {
            throw new WebClientResponseException("Missing the required parameter 'email' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("email", email);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/manager/{email}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> removeCompanyUser(@Nonnull String email, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.removeCompanyUserRequestCreation(email, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> removeCompanyUserWithHttpInfo(@Nonnull String email, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.removeCompanyUserRequestCreation(email, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCompanyUserWithResponseSpec(@Nonnull String email, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeCompanyUserRequestCreation(email, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeManagerAgencyRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/manager/agency", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> removeManagerAgency(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.removeManagerAgencyRequestCreation(winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> removeManagerAgencyWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.removeManagerAgencyRequestCreation(winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeManagerAgencyWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeManagerAgencyRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showManagerInviteListRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/manager/invite/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ManagerInviteAffiliate> showManagerInviteList(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>(this){};
        return this.showManagerInviteListRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ManagerInviteAffiliate>>> showManagerInviteListWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagerInviteAffiliate> localVarReturnType = new ParameterizedTypeReference<ManagerInviteAffiliate>(this){};
        return this.showManagerInviteListRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showManagerInviteListWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showManagerInviteListRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateManagerAgencyRequestCreation(@Nonnull UpsertManagedByAgencyRequestAffiliate upsertManagedByAgencyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertManagedByAgencyRequestAffiliate postBody = upsertManagedByAgencyRequestAffiliate;
        if (upsertManagedByAgencyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertManagedByAgencyRequestAffiliate' when calling updateManagerAgency", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/manager/agency", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> updateManagerAgency(@Nonnull UpsertManagedByAgencyRequestAffiliate upsertManagedByAgencyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateManagerAgencyRequestCreation(upsertManagedByAgencyRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateManagerAgencyWithHttpInfo(@Nonnull UpsertManagedByAgencyRequestAffiliate upsertManagedByAgencyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateManagerAgencyRequestCreation(upsertManagedByAgencyRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateManagerAgencyWithResponseSpec(@Nonnull UpsertManagedByAgencyRequestAffiliate upsertManagedByAgencyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateManagerAgencyRequestCreation(upsertManagedByAgencyRequestAffiliate, winkVersion);
    }
}

