/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.AffiliateAccountAffiliate;
import travel.wink.sdk.affiliate.model.BookingAnalyticsSupplier;
import travel.wink.sdk.affiliate.model.BookingOverviewRequestSupplier;
import travel.wink.sdk.affiliate.model.CreateCompanyRequestAffiliate;
import travel.wink.sdk.affiliate.model.GroupedBookingSalesMetricsSupplierDetails;
import travel.wink.sdk.affiliate.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.model.PageAffiliateAccountSupplier;
import travel.wink.sdk.affiliate.model.StateSupplier;
import travel.wink.sdk.affiliate.model.UniqueRequestAffiliate;
import travel.wink.sdk.affiliate.model.UniqueResultAffiliate;
import travel.wink.sdk.affiliate.model.UpsertAddressRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyLogoRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyOnlinePresenceRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyStatusRequestAffiliate;

public class AffiliateApi {
    private ApiClient apiClient;

    public AffiliateApi() {
        this(new ApiClient());
    }

    @Autowired
    public AffiliateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createCompanyRequestCreation(@Nonnull CreateCompanyRequestAffiliate createCompanyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CreateCompanyRequestAffiliate postBody = createCompanyRequestAffiliate;
        if (createCompanyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createCompanyRequestAffiliate' when calling createCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> createCompany(@Nonnull CreateCompanyRequestAffiliate createCompanyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> createCompanyWithHttpInfo(@Nonnull CreateCompanyRequestAffiliate createCompanyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCompanyWithResponseSpec(@Nonnull CreateCompanyRequestAffiliate createCompanyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec isCompanyNameUniqueRequestCreation(@Nonnull UniqueRequestAffiliate uniqueRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UniqueRequestAffiliate postBody = uniqueRequestAffiliate;
        if (uniqueRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'uniqueRequestAffiliate' when calling isCompanyNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/unique", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResultAffiliate> isCompanyNameUnique(@Nonnull UniqueRequestAffiliate uniqueRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>(this){};
        return this.isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResultAffiliate>> isCompanyNameUniqueWithHttpInfo(@Nonnull UniqueRequestAffiliate uniqueRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>(this){};
        return this.isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isCompanyNameUniqueWithResponseSpec(@Nonnull UniqueRequestAffiliate uniqueRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeCompanyRequestCreation(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> removeCompany(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> removeCompanyWithHttpInfo(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCompanyWithResponseSpec(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeMyAccountRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/my-account", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> removeMyAccount(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.removeMyAccountRequestCreation(winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> removeMyAccountWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.removeMyAccountRequestCreation(winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMyAccountWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeMyAccountRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec searchAffiliatesRequestCreation(@Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling searchAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageAffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<PageAffiliateAccountSupplier>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageAffiliateAccountSupplier> searchAffiliates(@Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageAffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<PageAffiliateAccountSupplier>(this){};
        return this.searchAffiliatesRequestCreation(stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageAffiliateAccountSupplier>> searchAffiliatesWithHttpInfo(@Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageAffiliateAccountSupplier> localVarReturnType = new ParameterizedTypeReference<PageAffiliateAccountSupplier>(this){};
        return this.searchAffiliatesRequestCreation(stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchAffiliatesWithResponseSpec(@Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.searchAffiliatesRequestCreation(stateSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showBookingAnalyticsRequestCreation(@Nonnull String companyIdentifier, @Nonnull BookingOverviewRequestSupplier bookingOverviewRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        BookingOverviewRequestSupplier postBody = bookingOverviewRequestSupplier;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingOverviewRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingOverviewRequestSupplier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/analytics", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingAnalyticsSupplier> showBookingAnalytics(@Nonnull String companyIdentifier, @Nonnull BookingOverviewRequestSupplier bookingOverviewRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>(this){};
        return this.showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingAnalyticsSupplier>> showBookingAnalyticsWithHttpInfo(@Nonnull String companyIdentifier, @Nonnull BookingOverviewRequestSupplier bookingOverviewRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>(this){};
        return this.showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingAnalyticsWithResponseSpec(@Nonnull String companyIdentifier, @Nonnull BookingOverviewRequestSupplier bookingOverviewRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showBookingOverviewRequestCreation(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingOverview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/overview", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GroupedBookingSalesMetricsSupplierDetails> showBookingOverview(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>(this){};
        return this.showBookingOverviewRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GroupedBookingSalesMetricsSupplierDetails>> showBookingOverviewWithHttpInfo(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>(this){};
        return this.showBookingOverviewRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingOverviewWithResponseSpec(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showBookingOverviewRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCompaniesRequestCreation(@Nullable String type, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<AffiliateAccountAffiliate> showCompanies(@Nullable String type, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.showCompaniesRequestCreation(type, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<AffiliateAccountAffiliate>>> showCompaniesWithHttpInfo(@Nullable String type, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.showCompaniesRequestCreation(type, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCompaniesWithResponseSpec(@Nullable String type, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showCompaniesRequestCreation(type, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCompanyRequestCreation(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> showCompany(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> showCompanyWithHttpInfo(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCompanyWithResponseSpec(@Nonnull String companyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showMyAccountRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/my-account", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> showMyAccount(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.showMyAccountRequestCreation(winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> showMyAccountWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.showMyAccountRequestCreation(winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMyAccountWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showMyAccountRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelsRequestCreation(@Nonnull String name, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling showSalesChannels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "name", name));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/search", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showSalesChannels(@Nonnull String name, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showSalesChannelsRequestCreation(name, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showSalesChannelsWithHttpInfo(@Nonnull String name, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showSalesChannelsRequestCreation(name, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelsWithResponseSpec(@Nonnull String name, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSalesChannelsRequestCreation(name, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateCompanyRequestCreation(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertCompanyRequestAffiliate postBody = upsertCompanyRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyRequestAffiliate' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> updateCompany(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateCompanyWithHttpInfo(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompanyWithResponseSpec(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCompany1RequestCreation(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertCompanyStatusRequestAffiliate postBody = upsertCompanyStatusRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyStatusRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyStatusRequestAffiliate' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/status", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> updateCompany1(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateCompany1WithHttpInfo(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompany1WithResponseSpec(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCompanyAddressRequestCreation(@Nonnull String companyIdentifier, @Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertAddressRequestAffiliate postBody = upsertAddressRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompanyAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAddressRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddressRequestAffiliate' when calling updateCompanyAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/address", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> updateCompanyAddress(@Nonnull String companyIdentifier, @Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateCompanyAddressWithHttpInfo(@Nonnull String companyIdentifier, @Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompanyAddressWithResponseSpec(@Nonnull String companyIdentifier, @Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCompanyLogoRequestCreation(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertCompanyLogoRequestAffiliate postBody = upsertCompanyLogoRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompanyLogo", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyLogoRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyLogoRequestAffiliate' when calling updateCompanyLogo", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/logo", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> updateCompanyLogo(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateCompanyLogoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateCompanyLogoWithHttpInfo(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateCompanyLogoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompanyLogoWithResponseSpec(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateCompanyLogoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCompanyOnlinePresenceRequestCreation(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertCompanyOnlinePresenceRequestAffiliate postBody = upsertCompanyOnlinePresenceRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompanyOnlinePresence", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyOnlinePresenceRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyOnlinePresenceRequestAffiliate' when calling updateCompanyOnlinePresence", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/online-presence", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> updateCompanyOnlinePresence(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateCompanyOnlinePresenceRequestCreation(companyIdentifier, upsertCompanyOnlinePresenceRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateCompanyOnlinePresenceWithHttpInfo(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateCompanyOnlinePresenceRequestCreation(companyIdentifier, upsertCompanyOnlinePresenceRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompanyOnlinePresenceWithResponseSpec(@Nonnull String companyIdentifier, @Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateCompanyOnlinePresenceRequestCreation(companyIdentifier, upsertCompanyOnlinePresenceRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateMyAccountRequestCreation(@Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertCompanyStatusRequestAffiliate postBody = upsertCompanyStatusRequestAffiliate;
        if (upsertCompanyStatusRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyStatusRequestAffiliate' when calling updateMyAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/my-account/status", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> updateMyAccount(@Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateMyAccountRequestCreation(upsertCompanyStatusRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateMyAccountWithHttpInfo(@Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateMyAccountRequestCreation(upsertCompanyStatusRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMyAccountWithResponseSpec(@Nonnull UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateMyAccountRequestCreation(upsertCompanyStatusRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateMyAccountAddressRequestCreation(@Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertAddressRequestAffiliate postBody = upsertAddressRequestAffiliate;
        if (upsertAddressRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddressRequestAffiliate' when calling updateMyAccountAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/my-account/address", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> updateMyAccountAddress(@Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateMyAccountAddressRequestCreation(upsertAddressRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateMyAccountAddressWithHttpInfo(@Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateMyAccountAddressRequestCreation(upsertAddressRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMyAccountAddressWithResponseSpec(@Nonnull UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateMyAccountAddressRequestCreation(upsertAddressRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateMyAccountLogoRequestCreation(@Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertCompanyLogoRequestAffiliate postBody = upsertCompanyLogoRequestAffiliate;
        if (upsertCompanyLogoRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyLogoRequestAffiliate' when calling updateMyAccountLogo", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/my-account/logo", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> updateMyAccountLogo(@Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateMyAccountLogoRequestCreation(upsertCompanyLogoRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateMyAccountLogoWithHttpInfo(@Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateMyAccountLogoRequestCreation(upsertCompanyLogoRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMyAccountLogoWithResponseSpec(@Nonnull UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateMyAccountLogoRequestCreation(upsertCompanyLogoRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateMyAccountOnlinePresenceRequestCreation(@Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertCompanyOnlinePresenceRequestAffiliate postBody = upsertCompanyOnlinePresenceRequestAffiliate;
        if (upsertCompanyOnlinePresenceRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyOnlinePresenceRequestAffiliate' when calling updateMyAccountOnlinePresence", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/my-account/online-presence", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAffiliate> updateMyAccountOnlinePresence(@Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateMyAccountOnlinePresenceRequestCreation(upsertCompanyOnlinePresenceRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAffiliate>> updateMyAccountOnlinePresenceWithHttpInfo(@Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAffiliate> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAffiliate>(this){};
        return this.updateMyAccountOnlinePresenceRequestCreation(upsertCompanyOnlinePresenceRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMyAccountOnlinePresenceWithResponseSpec(@Nonnull UpsertCompanyOnlinePresenceRequestAffiliate upsertCompanyOnlinePresenceRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateMyAccountOnlinePresenceRequestCreation(upsertCompanyOnlinePresenceRequestAffiliate, winkVersion);
    }
}

