/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.AddressSupplier;
import travel.wink.sdk.affiliate.model.AffiliateAccountUserSupplier;
import travel.wink.sdk.affiliate.model.CustomMonetaryAmount;
import travel.wink.sdk.affiliate.model.ManagedByEntitySupplier;
import travel.wink.sdk.affiliate.model.SimpleMultimediaSupplier;
import travel.wink.sdk.affiliate.model.TravelAgentSupplier;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "userIdentifier", "owner", "name", "urlName", "legalName", "enabled", "approved", "companyType", "type", "description", "address", "managers", "logo", "travelAgent", "managedBy", "onlinePresence", "annualTravelSpendInDollars", "plans", "previousUrlNameList"})
@JsonTypeName(value="AffiliateAccount_Supplier")
public class AffiliateAccountSupplier {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    @Nullable
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    @Nullable
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    @Nonnull
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_OWNER = "owner";
    @Nonnull
    private AffiliateAccountUserSupplier owner;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_URL_NAME = "urlName";
    @Nonnull
    private String urlName;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    @Nullable
    private String legalName;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    @Nonnull
    private Boolean enabled;
    public static final String JSON_PROPERTY_APPROVED = "approved";
    @Nonnull
    private Boolean approved = false;
    public static final String JSON_PROPERTY_COMPANY_TYPE = "companyType";
    @Nonnull
    private CompanyTypeEnum companyType;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @Nonnull
    private AddressSupplier address;
    public static final String JSON_PROPERTY_MANAGERS = "managers";
    @Nullable
    private List<@Valid AffiliateAccountUserSupplier> managers = new ArrayList<AffiliateAccountUserSupplier>();
    public static final String JSON_PROPERTY_LOGO = "logo";
    @Nullable
    private SimpleMultimediaSupplier logo;
    public static final String JSON_PROPERTY_TRAVEL_AGENT = "travelAgent";
    @Nullable
    private TravelAgentSupplier travelAgent;
    public static final String JSON_PROPERTY_MANAGED_BY = "managedBy";
    @Nullable
    private ManagedByEntitySupplier managedBy;
    public static final String JSON_PROPERTY_ONLINE_PRESENCE = "onlinePresence";
    @Nullable
    private List<Object> onlinePresence = new ArrayList<Object>();
    public static final String JSON_PROPERTY_ANNUAL_TRAVEL_SPEND_IN_DOLLARS = "annualTravelSpendInDollars";
    @Nullable
    private CustomMonetaryAmount annualTravelSpendInDollars;
    public static final String JSON_PROPERTY_PLANS = "plans";
    @Nullable
    private List<Object> plans = new ArrayList<Object>();
    public static final String JSON_PROPERTY_PREVIOUS_URL_NAME_LIST = "previousUrlNameList";
    @Nullable
    private List<Object> previousUrlNameList = new ArrayList<Object>();

    public AffiliateAccountSupplier id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public AffiliateAccountSupplier createdDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public AffiliateAccountSupplier lastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public AffiliateAccountSupplier version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public AffiliateAccountSupplier userIdentifier(@Nonnull UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserIdentifier(@Nonnull UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public AffiliateAccountSupplier owner(@Nonnull AffiliateAccountUserSupplier owner) {
        this.owner = owner;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AffiliateAccountUserSupplier getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwner(@Nonnull AffiliateAccountUserSupplier owner) {
        this.owner = owner;
    }

    public AffiliateAccountSupplier name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public AffiliateAccountSupplier urlName(@Nonnull String urlName) {
        this.urlName = urlName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getUrlName() {
        return this.urlName;
    }

    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrlName(@Nonnull String urlName) {
        this.urlName = urlName;
    }

    public AffiliateAccountSupplier legalName(@Nullable String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nullable
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalName(@Nullable String legalName) {
        this.legalName = legalName;
    }

    public AffiliateAccountSupplier enabled(@Nonnull Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(@Nonnull Boolean enabled) {
        this.enabled = enabled;
    }

    public AffiliateAccountSupplier approved(@Nonnull Boolean approved) {
        this.approved = approved;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="approved")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getApproved() {
        return this.approved;
    }

    @JsonProperty(value="approved")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApproved(@Nonnull Boolean approved) {
        this.approved = approved;
    }

    public AffiliateAccountSupplier companyType(@Nonnull CompanyTypeEnum companyType) {
        this.companyType = companyType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="companyType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CompanyTypeEnum getCompanyType() {
        return this.companyType;
    }

    @JsonProperty(value="companyType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompanyType(@Nonnull CompanyTypeEnum companyType) {
        this.companyType = companyType;
    }

    public AffiliateAccountSupplier type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public AffiliateAccountSupplier description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public AffiliateAccountSupplier address(@Nonnull AddressSupplier address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressSupplier getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(@Nonnull AddressSupplier address) {
        this.address = address;
    }

    public AffiliateAccountSupplier managers(@Nullable List<@Valid AffiliateAccountUserSupplier> managers) {
        this.managers = managers;
        return this;
    }

    public AffiliateAccountSupplier addManagersItem(AffiliateAccountUserSupplier managersItem) {
        if (this.managers == null) {
            this.managers = new ArrayList<AffiliateAccountUserSupplier>();
        }
        this.managers.add(managersItem);
        return this;
    }

    @Nullable
    @Valid
    @Size(min=0, max=30)
    @JsonProperty(value="managers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @Size(min=0, max=30) List<@Valid AffiliateAccountUserSupplier> getManagers() {
        return this.managers;
    }

    @JsonProperty(value="managers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setManagers(@Nullable List<@Valid AffiliateAccountUserSupplier> managers) {
        this.managers = managers;
    }

    public AffiliateAccountSupplier logo(@Nullable SimpleMultimediaSupplier logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SimpleMultimediaSupplier getLogo() {
        return this.logo;
    }

    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(@Nullable SimpleMultimediaSupplier logo) {
        this.logo = logo;
    }

    public AffiliateAccountSupplier travelAgent(@Nullable TravelAgentSupplier travelAgent) {
        this.travelAgent = travelAgent;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="travelAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TravelAgentSupplier getTravelAgent() {
        return this.travelAgent;
    }

    @JsonProperty(value="travelAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTravelAgent(@Nullable TravelAgentSupplier travelAgent) {
        this.travelAgent = travelAgent;
    }

    public AffiliateAccountSupplier managedBy(@Nullable ManagedByEntitySupplier managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="managedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ManagedByEntitySupplier getManagedBy() {
        return this.managedBy;
    }

    @JsonProperty(value="managedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setManagedBy(@Nullable ManagedByEntitySupplier managedBy) {
        this.managedBy = managedBy;
    }

    public AffiliateAccountSupplier onlinePresence(@Nullable List<Object> onlinePresence) {
        this.onlinePresence = onlinePresence;
        return this;
    }

    public AffiliateAccountSupplier addOnlinePresenceItem(Object onlinePresenceItem) {
        if (this.onlinePresence == null) {
            this.onlinePresence = new ArrayList<Object>();
        }
        this.onlinePresence.add(onlinePresenceItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="onlinePresence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getOnlinePresence() {
        return this.onlinePresence;
    }

    @JsonProperty(value="onlinePresence")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOnlinePresence(@Nullable List<Object> onlinePresence) {
        this.onlinePresence = onlinePresence;
    }

    public AffiliateAccountSupplier annualTravelSpendInDollars(@Nullable CustomMonetaryAmount annualTravelSpendInDollars) {
        this.annualTravelSpendInDollars = annualTravelSpendInDollars;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="annualTravelSpendInDollars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getAnnualTravelSpendInDollars() {
        return this.annualTravelSpendInDollars;
    }

    @JsonProperty(value="annualTravelSpendInDollars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnnualTravelSpendInDollars(@Nullable CustomMonetaryAmount annualTravelSpendInDollars) {
        this.annualTravelSpendInDollars = annualTravelSpendInDollars;
    }

    public AffiliateAccountSupplier plans(@Nullable List<Object> plans) {
        this.plans = plans;
        return this;
    }

    public AffiliateAccountSupplier addPlansItem(Object plansItem) {
        if (this.plans == null) {
            this.plans = new ArrayList<Object>();
        }
        this.plans.add(plansItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="plans")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getPlans() {
        return this.plans;
    }

    @JsonProperty(value="plans")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlans(@Nullable List<Object> plans) {
        this.plans = plans;
    }

    public AffiliateAccountSupplier previousUrlNameList(@Nullable List<Object> previousUrlNameList) {
        this.previousUrlNameList = previousUrlNameList;
        return this;
    }

    public AffiliateAccountSupplier addPreviousUrlNameListItem(Object previousUrlNameListItem) {
        if (this.previousUrlNameList == null) {
            this.previousUrlNameList = new ArrayList<Object>();
        }
        this.previousUrlNameList.add(previousUrlNameListItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="previousUrlNameList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getPreviousUrlNameList() {
        return this.previousUrlNameList;
    }

    @JsonProperty(value="previousUrlNameList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreviousUrlNameList(@Nullable List<Object> previousUrlNameList) {
        this.previousUrlNameList = previousUrlNameList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffiliateAccountSupplier affiliateAccountSupplier = (AffiliateAccountSupplier)o;
        return Objects.equals(this.id, affiliateAccountSupplier.id) && Objects.equals(this.createdDate, affiliateAccountSupplier.createdDate) && Objects.equals(this.lastUpdate, affiliateAccountSupplier.lastUpdate) && Objects.equals(this.version, affiliateAccountSupplier.version) && Objects.equals(this.userIdentifier, affiliateAccountSupplier.userIdentifier) && Objects.equals(this.owner, affiliateAccountSupplier.owner) && Objects.equals(this.name, affiliateAccountSupplier.name) && Objects.equals(this.urlName, affiliateAccountSupplier.urlName) && Objects.equals(this.legalName, affiliateAccountSupplier.legalName) && Objects.equals(this.enabled, affiliateAccountSupplier.enabled) && Objects.equals(this.approved, affiliateAccountSupplier.approved) && Objects.equals((Object)this.companyType, (Object)affiliateAccountSupplier.companyType) && Objects.equals((Object)this.type, (Object)affiliateAccountSupplier.type) && Objects.equals(this.description, affiliateAccountSupplier.description) && Objects.equals(this.address, affiliateAccountSupplier.address) && Objects.equals(this.managers, affiliateAccountSupplier.managers) && Objects.equals(this.logo, affiliateAccountSupplier.logo) && Objects.equals(this.travelAgent, affiliateAccountSupplier.travelAgent) && Objects.equals(this.managedBy, affiliateAccountSupplier.managedBy) && Objects.equals(this.onlinePresence, affiliateAccountSupplier.onlinePresence) && Objects.equals(this.annualTravelSpendInDollars, affiliateAccountSupplier.annualTravelSpendInDollars) && Objects.equals(this.plans, affiliateAccountSupplier.plans) && Objects.equals(this.previousUrlNameList, affiliateAccountSupplier.previousUrlNameList);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.userIdentifier, this.owner, this.name, this.urlName, this.legalName, this.enabled, this.approved, this.companyType, this.type, this.description, this.address, this.managers, this.logo, this.travelAgent, this.managedBy, this.onlinePresence, this.annualTravelSpendInDollars, this.plans, this.previousUrlNameList});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AffiliateAccountSupplier {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    urlName: ").append(this.toIndentedString(this.urlName)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    approved: ").append(this.toIndentedString(this.approved)).append("\n");
        sb.append("    companyType: ").append(this.toIndentedString((Object)this.companyType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    managers: ").append(this.toIndentedString(this.managers)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    travelAgent: ").append(this.toIndentedString(this.travelAgent)).append("\n");
        sb.append("    managedBy: ").append(this.toIndentedString(this.managedBy)).append("\n");
        sb.append("    onlinePresence: ").append(this.toIndentedString(this.onlinePresence)).append("\n");
        sb.append("    annualTravelSpendInDollars: ").append(this.toIndentedString(this.annualTravelSpendInDollars)).append("\n");
        sb.append("    plans: ").append(this.toIndentedString(this.plans)).append("\n");
        sb.append("    previousUrlNameList: ").append(this.toIndentedString(this.previousUrlNameList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CompanyTypeEnum {
        COMPANY(String.valueOf("COMPANY")),
        INDIVIDUAL(String.valueOf("INDIVIDUAL"));

        private String value;

        private CompanyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CompanyTypeEnum fromValue(String value) {
            for (CompanyTypeEnum b : CompanyTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        DIRECT(String.valueOf("DIRECT")),
        APPLICATION(String.valueOf("APPLICATION")),
        HOTEL(String.valueOf("HOTEL")),
        TRAVELIKO(String.valueOf("TRAVELIKO")),
        CORPORATE(String.valueOf("CORPORATE")),
        TRAVEL_AGENT(String.valueOf("TRAVEL_AGENT")),
        INFLUENCER(String.valueOf("INFLUENCER")),
        BLOGGER(String.valueOf("BLOGGER")),
        DESTINATION(String.valueOf("DESTINATION")),
        CHANNEL_MANAGER(String.valueOf("CHANNEL_MANAGER")),
        PROPERTY_MANAGEMENT_SYSTEM(String.valueOf("PROPERTY_MANAGEMENT_SYSTEM")),
        CENTRAL_RESERVATION_SYSTEM(String.valueOf("CENTRAL_RESERVATION_SYSTEM")),
        GOOGLE_HOTEL_API(String.valueOf("GOOGLE_HOTEL_API")),
        MANAGEMENT_COMPANY(String.valueOf("MANAGEMENT_COMPANY")),
        CHAIN(String.valueOf("CHAIN")),
        BRAND(String.valueOf("BRAND")),
        EVENT_ORGANIZER(String.valueOf("EVENT_ORGANIZER"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

