/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.syndication.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.syndication.invoker.ApiClient;
import travel.wink.sdk.affiliate.syndication.model.ConsumeExternalUrlRequestAffiliate;
import travel.wink.sdk.affiliate.syndication.model.SortedAffiliate;
import travel.wink.sdk.affiliate.syndication.model.SyndicationCategoryAffiliate;
import travel.wink.sdk.affiliate.syndication.model.SyndicationEntryAffiliate;
import travel.wink.sdk.affiliate.syndication.model.SyndicationSettingsAffiliate;
import travel.wink.sdk.affiliate.syndication.model.UpsertSyndicationCategoryAffiliate;
import travel.wink.sdk.affiliate.syndication.model.UpsertSyndicationEntryAffiliate;
import travel.wink.sdk.affiliate.syndication.model.UpsertSyndicationSettingsAffiliate;

public class SyndicationPublisherApi {
    private ApiClient apiClient;

    public SyndicationPublisherApi() {
        this(new ApiClient());
    }

    @Autowired
    public SyndicationPublisherApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec consumeExternalUrlForSyndicationEntryRequestCreation(ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ConsumeExternalUrlRequestAffiliate postBody = consumeExternalUrlRequestAffiliate;
        if (consumeExternalUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'consumeExternalUrlRequestAffiliate' when calling consumeExternalUrlForSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UpsertSyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<UpsertSyndicationEntryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/entry/consume-url", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UpsertSyndicationEntryAffiliate> consumeExternalUrlForSyndicationEntry(ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpsertSyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<UpsertSyndicationEntryAffiliate>(this){};
        return this.consumeExternalUrlForSyndicationEntryRequestCreation(consumeExternalUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UpsertSyndicationEntryAffiliate>> consumeExternalUrlForSyndicationEntryWithHttpInfo(ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpsertSyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<UpsertSyndicationEntryAffiliate>(this){};
        return this.consumeExternalUrlForSyndicationEntryRequestCreation(consumeExternalUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec consumeExternalUrlForSyndicationEntryWithResponseSpec(ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.consumeExternalUrlForSyndicationEntryRequestCreation(consumeExternalUrlRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSyndicationCategoryRequestCreation(UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSyndicationCategoryAffiliate postBody = upsertSyndicationCategoryAffiliate;
        if (upsertSyndicationCategoryAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSyndicationCategoryAffiliate' when calling createSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/category", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationCategoryAffiliate> createSyndicationCategory(UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.createSyndicationCategoryRequestCreation(upsertSyndicationCategoryAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationCategoryAffiliate>> createSyndicationCategoryWithHttpInfo(UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.createSyndicationCategoryRequestCreation(upsertSyndicationCategoryAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSyndicationCategoryWithResponseSpec(UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSyndicationCategoryRequestCreation(upsertSyndicationCategoryAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSyndicationEntryRequestCreation(UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSyndicationEntryAffiliate postBody = upsertSyndicationEntryAffiliate;
        if (upsertSyndicationEntryAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSyndicationEntryAffiliate' when calling createSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationEntryAffiliate> createSyndicationEntry(UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.createSyndicationEntryRequestCreation(upsertSyndicationEntryAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationEntryAffiliate>> createSyndicationEntryWithHttpInfo(UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.createSyndicationEntryRequestCreation(upsertSyndicationEntryAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSyndicationEntryWithResponseSpec(UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSyndicationEntryRequestCreation(upsertSyndicationEntryAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSyndicationCategoryRequestCreation(String syndicationCategoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (syndicationCategoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationCategoryIdentifier' when calling removeSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("syndicationCategoryIdentifier", syndicationCategoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/category/{syndicationCategoryIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationCategoryAffiliate> removeSyndicationCategory(String syndicationCategoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.removeSyndicationCategoryRequestCreation(syndicationCategoryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationCategoryAffiliate>> removeSyndicationCategoryWithHttpInfo(String syndicationCategoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.removeSyndicationCategoryRequestCreation(syndicationCategoryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSyndicationCategoryWithResponseSpec(String syndicationCategoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeSyndicationCategoryRequestCreation(syndicationCategoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeSyndicationEntryRequestCreation(String syndicationEntryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (syndicationEntryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationEntryIdentifier' when calling removeSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("syndicationEntryIdentifier", syndicationEntryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/entry/{syndicationEntryIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationEntryAffiliate> removeSyndicationEntry(String syndicationEntryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.removeSyndicationEntryRequestCreation(syndicationEntryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationEntryAffiliate>> removeSyndicationEntryWithHttpInfo(String syndicationEntryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.removeSyndicationEntryRequestCreation(syndicationEntryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSyndicationEntryWithResponseSpec(String syndicationEntryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeSyndicationEntryRequestCreation(syndicationEntryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSyndicationCategoryRequestCreation(String syndicationCategoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (syndicationCategoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationCategoryIdentifier' when calling showSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("syndicationCategoryIdentifier", syndicationCategoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/category/{syndicationCategoryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationCategoryAffiliate> showSyndicationCategory(String syndicationCategoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.showSyndicationCategoryRequestCreation(syndicationCategoryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationCategoryAffiliate>> showSyndicationCategoryWithHttpInfo(String syndicationCategoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.showSyndicationCategoryRequestCreation(syndicationCategoryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSyndicationCategoryWithResponseSpec(String syndicationCategoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSyndicationCategoryRequestCreation(syndicationCategoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSyndicationCategoryListRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/category/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SyndicationCategoryAffiliate> showSyndicationCategoryList(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.showSyndicationCategoryListRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SyndicationCategoryAffiliate>>> showSyndicationCategoryListWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.showSyndicationCategoryListRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSyndicationCategoryListWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showSyndicationCategoryListRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showSyndicationEntryRequestCreation(String syndicationEntryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (syndicationEntryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationEntryIdentifier' when calling showSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("syndicationEntryIdentifier", syndicationEntryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/entry/{syndicationEntryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationEntryAffiliate> showSyndicationEntry(String syndicationEntryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.showSyndicationEntryRequestCreation(syndicationEntryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationEntryAffiliate>> showSyndicationEntryWithHttpInfo(String syndicationEntryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.showSyndicationEntryRequestCreation(syndicationEntryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSyndicationEntryWithResponseSpec(String syndicationEntryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSyndicationEntryRequestCreation(syndicationEntryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSyndicationEntryListRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/entry/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SyndicationEntryAffiliate> showSyndicationEntryList(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.showSyndicationEntryListRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SyndicationEntryAffiliate>>> showSyndicationEntryListWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.showSyndicationEntryListRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSyndicationEntryListWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showSyndicationEntryListRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showSyndicationSettingsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/settings", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationSettingsAffiliate> showSyndicationSettings(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>(this){};
        return this.showSyndicationSettingsRequestCreation(winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationSettingsAffiliate>> showSyndicationSettingsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>(this){};
        return this.showSyndicationSettingsRequestCreation(winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSyndicationSettingsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showSyndicationSettingsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec sortSyndicationEntryListRequestCreation(List<SortedAffiliate> sortedAffiliate, String winkVersion) throws WebClientResponseException {
        List<SortedAffiliate> postBody = sortedAffiliate;
        if (sortedAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sortedAffiliate' when calling sortSyndicationEntryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/entry/list/sort", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SyndicationEntryAffiliate> sortSyndicationEntryList(List<SortedAffiliate> sortedAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.sortSyndicationEntryListRequestCreation(sortedAffiliate, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SyndicationEntryAffiliate>>> sortSyndicationEntryListWithHttpInfo(List<SortedAffiliate> sortedAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.sortSyndicationEntryListRequestCreation(sortedAffiliate, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec sortSyndicationEntryListWithResponseSpec(List<SortedAffiliate> sortedAffiliate, String winkVersion) throws WebClientResponseException {
        return this.sortSyndicationEntryListRequestCreation(sortedAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateSyndicationCategoryRequestCreation(String syndicationCategoryIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSyndicationCategoryAffiliate postBody = upsertSyndicationCategoryAffiliate;
        if (syndicationCategoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationCategoryIdentifier' when calling updateSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSyndicationCategoryAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSyndicationCategoryAffiliate' when calling updateSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("syndicationCategoryIdentifier", syndicationCategoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/category/{syndicationCategoryIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationCategoryAffiliate> updateSyndicationCategory(String syndicationCategoryIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.updateSyndicationCategoryRequestCreation(syndicationCategoryIdentifier, upsertSyndicationCategoryAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationCategoryAffiliate>> updateSyndicationCategoryWithHttpInfo(String syndicationCategoryIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>(this){};
        return this.updateSyndicationCategoryRequestCreation(syndicationCategoryIdentifier, upsertSyndicationCategoryAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSyndicationCategoryWithResponseSpec(String syndicationCategoryIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateSyndicationCategoryRequestCreation(syndicationCategoryIdentifier, upsertSyndicationCategoryAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateSyndicationEntryRequestCreation(String syndicationEntryIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSyndicationEntryAffiliate postBody = upsertSyndicationEntryAffiliate;
        if (syndicationEntryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationEntryIdentifier' when calling updateSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSyndicationEntryAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSyndicationEntryAffiliate' when calling updateSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("syndicationEntryIdentifier", syndicationEntryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/entry/{syndicationEntryIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationEntryAffiliate> updateSyndicationEntry(String syndicationEntryIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.updateSyndicationEntryRequestCreation(syndicationEntryIdentifier, upsertSyndicationEntryAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationEntryAffiliate>> updateSyndicationEntryWithHttpInfo(String syndicationEntryIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.updateSyndicationEntryRequestCreation(syndicationEntryIdentifier, upsertSyndicationEntryAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSyndicationEntryWithResponseSpec(String syndicationEntryIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateSyndicationEntryRequestCreation(syndicationEntryIdentifier, upsertSyndicationEntryAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec upsertSyndicationSettingsRequestCreation(UpsertSyndicationSettingsAffiliate upsertSyndicationSettingsAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSyndicationSettingsAffiliate postBody = upsertSyndicationSettingsAffiliate;
        if (upsertSyndicationSettingsAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSyndicationSettingsAffiliate' when calling upsertSyndicationSettings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/syndication/settings", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationSettingsAffiliate> upsertSyndicationSettings(UpsertSyndicationSettingsAffiliate upsertSyndicationSettingsAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>(this){};
        return this.upsertSyndicationSettingsRequestCreation(upsertSyndicationSettingsAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationSettingsAffiliate>> upsertSyndicationSettingsWithHttpInfo(UpsertSyndicationSettingsAffiliate upsertSyndicationSettingsAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>(this){};
        return this.upsertSyndicationSettingsRequestCreation(upsertSyndicationSettingsAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec upsertSyndicationSettingsWithResponseSpec(UpsertSyndicationSettingsAffiliate upsertSyndicationSettingsAffiliate, String winkVersion) throws WebClientResponseException {
        return this.upsertSyndicationSettingsRequestCreation(upsertSyndicationSettingsAffiliate, winkVersion);
    }
}

