/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.syndication.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.syndication.invoker.ApiClient;
import travel.wink.sdk.affiliate.syndication.model.BooleanResponseNonAuthenticatedEntity;
import travel.wink.sdk.affiliate.syndication.model.FacebookEmbedNonAuthenticatedEntity;
import travel.wink.sdk.affiliate.syndication.model.InstagramEmbedNonAuthenticatedEntity;
import travel.wink.sdk.affiliate.syndication.model.KeyValuePairNonAuthenticatedEntity;
import travel.wink.sdk.affiliate.syndication.model.PageConsumableSyndicationEntryNonAuthenticatedEntity;
import travel.wink.sdk.affiliate.syndication.model.RedirectViewNonAuthenticatedEntity;
import travel.wink.sdk.affiliate.syndication.model.SpotifyEmbedNonAuthenticatedEntity;
import travel.wink.sdk.affiliate.syndication.model.StateNonAuthenticatedEntity;
import travel.wink.sdk.affiliate.syndication.model.SyndicationAccountNonAuthenticatedEntity;
import travel.wink.sdk.affiliate.syndication.model.TikTokEmbedNonAuthenticatedEntity;
import travel.wink.sdk.affiliate.syndication.model.TwitterEmbedNonAuthenticatedEntity;

public class SyndicationConsumerApi {
    private ApiClient apiClient;

    public SyndicationConsumerApi() {
        this(new ApiClient());
    }

    @Autowired
    public SyndicationConsumerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec consumeFacebookPageUrlRequestCreation(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling consumeFacebookPageUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (url == null) {
            throw new WebClientResponseException("Missing the required parameter 'url' when calling consumeFacebookPageUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "url", url));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/facebook/page", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FacebookEmbedNonAuthenticatedEntity> consumeFacebookPageUrl(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity>(this){};
        return this.consumeFacebookPageUrlRequestCreation(companyIdentifier, url, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<FacebookEmbedNonAuthenticatedEntity>> consumeFacebookPageUrlWithHttpInfo(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity>(this){};
        return this.consumeFacebookPageUrlRequestCreation(companyIdentifier, url, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec consumeFacebookPageUrlWithResponseSpec(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        return this.consumeFacebookPageUrlRequestCreation(companyIdentifier, url, winkVersion);
    }

    private WebClient.ResponseSpec consumeFacebookPostUrlRequestCreation(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling consumeFacebookPostUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (url == null) {
            throw new WebClientResponseException("Missing the required parameter 'url' when calling consumeFacebookPostUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "url", url));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/facebook/post", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FacebookEmbedNonAuthenticatedEntity> consumeFacebookPostUrl(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity>(this){};
        return this.consumeFacebookPostUrlRequestCreation(companyIdentifier, url, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<FacebookEmbedNonAuthenticatedEntity>> consumeFacebookPostUrlWithHttpInfo(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity>(this){};
        return this.consumeFacebookPostUrlRequestCreation(companyIdentifier, url, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec consumeFacebookPostUrlWithResponseSpec(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        return this.consumeFacebookPostUrlRequestCreation(companyIdentifier, url, winkVersion);
    }

    private WebClient.ResponseSpec consumeFacebookVideoUrlRequestCreation(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling consumeFacebookVideoUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (url == null) {
            throw new WebClientResponseException("Missing the required parameter 'url' when calling consumeFacebookVideoUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "url", url));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/facebook/video", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FacebookEmbedNonAuthenticatedEntity> consumeFacebookVideoUrl(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity>(this){};
        return this.consumeFacebookVideoUrlRequestCreation(companyIdentifier, url, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<FacebookEmbedNonAuthenticatedEntity>> consumeFacebookVideoUrlWithHttpInfo(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<FacebookEmbedNonAuthenticatedEntity>(this){};
        return this.consumeFacebookVideoUrlRequestCreation(companyIdentifier, url, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec consumeFacebookVideoUrlWithResponseSpec(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        return this.consumeFacebookVideoUrlRequestCreation(companyIdentifier, url, winkVersion);
    }

    private WebClient.ResponseSpec consumeInstagramPostUrlRequestCreation(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling consumeInstagramPostUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (url == null) {
            throw new WebClientResponseException("Missing the required parameter 'url' when calling consumeInstagramPostUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "url", url));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InstagramEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InstagramEmbedNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/instagram/post", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InstagramEmbedNonAuthenticatedEntity> consumeInstagramPostUrl(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InstagramEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InstagramEmbedNonAuthenticatedEntity>(this){};
        return this.consumeInstagramPostUrlRequestCreation(companyIdentifier, url, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InstagramEmbedNonAuthenticatedEntity>> consumeInstagramPostUrlWithHttpInfo(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InstagramEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InstagramEmbedNonAuthenticatedEntity>(this){};
        return this.consumeInstagramPostUrlRequestCreation(companyIdentifier, url, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec consumeInstagramPostUrlWithResponseSpec(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        return this.consumeInstagramPostUrlRequestCreation(companyIdentifier, url, winkVersion);
    }

    private WebClient.ResponseSpec consumeSpotifyUrlRequestCreation(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling consumeSpotifyUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (url == null) {
            throw new WebClientResponseException("Missing the required parameter 'url' when calling consumeSpotifyUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "url", url));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpotifyEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SpotifyEmbedNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/spotify", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpotifyEmbedNonAuthenticatedEntity> consumeSpotifyUrl(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpotifyEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SpotifyEmbedNonAuthenticatedEntity>(this){};
        return this.consumeSpotifyUrlRequestCreation(companyIdentifier, url, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpotifyEmbedNonAuthenticatedEntity>> consumeSpotifyUrlWithHttpInfo(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpotifyEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SpotifyEmbedNonAuthenticatedEntity>(this){};
        return this.consumeSpotifyUrlRequestCreation(companyIdentifier, url, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec consumeSpotifyUrlWithResponseSpec(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        return this.consumeSpotifyUrlRequestCreation(companyIdentifier, url, winkVersion);
    }

    private WebClient.ResponseSpec consumeTikTokUrlRequestCreation(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling consumeTikTokUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (url == null) {
            throw new WebClientResponseException("Missing the required parameter 'url' when calling consumeTikTokUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "url", url));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<TikTokEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<TikTokEmbedNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/tiktok", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TikTokEmbedNonAuthenticatedEntity> consumeTikTokUrl(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<TikTokEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<TikTokEmbedNonAuthenticatedEntity>(this){};
        return this.consumeTikTokUrlRequestCreation(companyIdentifier, url, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TikTokEmbedNonAuthenticatedEntity>> consumeTikTokUrlWithHttpInfo(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<TikTokEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<TikTokEmbedNonAuthenticatedEntity>(this){};
        return this.consumeTikTokUrlRequestCreation(companyIdentifier, url, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec consumeTikTokUrlWithResponseSpec(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        return this.consumeTikTokUrlRequestCreation(companyIdentifier, url, winkVersion);
    }

    private WebClient.ResponseSpec consumeTwitterUrlRequestCreation(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling consumeTwitterUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (url == null) {
            throw new WebClientResponseException("Missing the required parameter 'url' when calling consumeTwitterUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "url", url));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<TwitterEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<TwitterEmbedNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/tweet", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TwitterEmbedNonAuthenticatedEntity> consumeTwitterUrl(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<TwitterEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<TwitterEmbedNonAuthenticatedEntity>(this){};
        return this.consumeTwitterUrlRequestCreation(companyIdentifier, url, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TwitterEmbedNonAuthenticatedEntity>> consumeTwitterUrlWithHttpInfo(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<TwitterEmbedNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<TwitterEmbedNonAuthenticatedEntity>(this){};
        return this.consumeTwitterUrlRequestCreation(companyIdentifier, url, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec consumeTwitterUrlWithResponseSpec(String companyIdentifier, String url, String winkVersion) throws WebClientResponseException {
        return this.consumeTwitterUrlRequestCreation(companyIdentifier, url, winkVersion);
    }

    private WebClient.ResponseSpec redirectUrlRequestCreation(String companyIdentifier, String syndicationEntryIdentifier, String userAgent, String host, String referer) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling redirectUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (syndicationEntryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationEntryIdentifier' when calling redirectUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (userAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'userAgent' when calling redirectUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (host == null) {
            throw new WebClientResponseException("Missing the required parameter 'host' when calling redirectUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (referer == null) {
            throw new WebClientResponseException("Missing the required parameter 'referer' when calling redirectUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("syndicationEntryIdentifier", syndicationEntryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (userAgent != null) {
            headerParams.add("User-Agent", this.apiClient.parameterToString(userAgent));
        }
        if (host != null) {
            headerParams.add("Host", this.apiClient.parameterToString(host));
        }
        if (referer != null) {
            headerParams.add("Referer", this.apiClient.parameterToString(referer));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RedirectViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RedirectViewNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/{syndicationEntryIdentifier}/redirect", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RedirectViewNonAuthenticatedEntity> redirectUrl(String companyIdentifier, String syndicationEntryIdentifier, String userAgent, String host, String referer) throws WebClientResponseException {
        ParameterizedTypeReference<RedirectViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RedirectViewNonAuthenticatedEntity>(this){};
        return this.redirectUrlRequestCreation(companyIdentifier, syndicationEntryIdentifier, userAgent, host, referer).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RedirectViewNonAuthenticatedEntity>> redirectUrlWithHttpInfo(String companyIdentifier, String syndicationEntryIdentifier, String userAgent, String host, String referer) throws WebClientResponseException {
        ParameterizedTypeReference<RedirectViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RedirectViewNonAuthenticatedEntity>(this){};
        return this.redirectUrlRequestCreation(companyIdentifier, syndicationEntryIdentifier, userAgent, host, referer).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec redirectUrlWithResponseSpec(String companyIdentifier, String syndicationEntryIdentifier, String userAgent, String host, String referer) throws WebClientResponseException {
        return this.redirectUrlRequestCreation(companyIdentifier, syndicationEntryIdentifier, userAgent, host, referer);
    }

    private WebClient.ResponseSpec showSyndicationAccountRequestCreation(String urlName, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling showSyndicationAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("urlName", urlName);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationAccountNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SyndicationAccountNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/syndication/{urlName}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationAccountNonAuthenticatedEntity> showSyndicationAccount(String urlName, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationAccountNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SyndicationAccountNonAuthenticatedEntity>(this){};
        return this.showSyndicationAccountRequestCreation(urlName, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationAccountNonAuthenticatedEntity>> showSyndicationAccountWithHttpInfo(String urlName, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationAccountNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SyndicationAccountNonAuthenticatedEntity>(this){};
        return this.showSyndicationAccountRequestCreation(urlName, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSyndicationAccountWithResponseSpec(String urlName, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSyndicationAccountRequestCreation(urlName, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSyndicationCategoriesRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSyndicationCategories", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/category/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairNonAuthenticatedEntity> showSyndicationCategories(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>(this){};
        return this.showSyndicationCategoriesRequestCreation(companyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairNonAuthenticatedEntity>>> showSyndicationCategoriesWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<KeyValuePairNonAuthenticatedEntity>(this){};
        return this.showSyndicationCategoriesRequestCreation(companyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSyndicationCategoriesWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSyndicationCategoriesRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSyndicationEntryGridRequestCreation(String companyIdentifier, StateNonAuthenticatedEntity stateNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        StateNonAuthenticatedEntity postBody = stateNonAuthenticatedEntity;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSyndicationEntryGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateNonAuthenticatedEntity' when calling showSyndicationEntryGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageConsumableSyndicationEntryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageConsumableSyndicationEntryNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageConsumableSyndicationEntryNonAuthenticatedEntity> showSyndicationEntryGrid(String companyIdentifier, StateNonAuthenticatedEntity stateNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageConsumableSyndicationEntryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageConsumableSyndicationEntryNonAuthenticatedEntity>(this){};
        return this.showSyndicationEntryGridRequestCreation(companyIdentifier, stateNonAuthenticatedEntity, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageConsumableSyndicationEntryNonAuthenticatedEntity>> showSyndicationEntryGridWithHttpInfo(String companyIdentifier, StateNonAuthenticatedEntity stateNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageConsumableSyndicationEntryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageConsumableSyndicationEntryNonAuthenticatedEntity>(this){};
        return this.showSyndicationEntryGridRequestCreation(companyIdentifier, stateNonAuthenticatedEntity, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSyndicationEntryGridWithResponseSpec(String companyIdentifier, StateNonAuthenticatedEntity stateNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return this.showSyndicationEntryGridRequestCreation(companyIdentifier, stateNonAuthenticatedEntity, winkVersion);
    }

    private WebClient.ResponseSpec trackShareRequestCreation(String companyIdentifier, String syndicationEntryIdentifier, String platform, String userAgent, String host, String referer, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling trackShare", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (syndicationEntryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationEntryIdentifier' when calling trackShare", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (platform == null) {
            throw new WebClientResponseException("Missing the required parameter 'platform' when calling trackShare", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (userAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'userAgent' when calling trackShare", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (host == null) {
            throw new WebClientResponseException("Missing the required parameter 'host' when calling trackShare", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (referer == null) {
            throw new WebClientResponseException("Missing the required parameter 'referer' when calling trackShare", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("syndicationEntryIdentifier", syndicationEntryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "platform", platform));
        if (userAgent != null) {
            headerParams.add("User-Agent", this.apiClient.parameterToString(userAgent));
        }
        if (host != null) {
            headerParams.add("Host", this.apiClient.parameterToString(host));
        }
        if (referer != null) {
            headerParams.add("Referer", this.apiClient.parameterToString(referer));
        }
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BooleanResponseNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/syndication/{syndicationEntryIdentifier}/share", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseNonAuthenticatedEntity> trackShare(String companyIdentifier, String syndicationEntryIdentifier, String platform, String userAgent, String host, String referer, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BooleanResponseNonAuthenticatedEntity>(this){};
        return this.trackShareRequestCreation(companyIdentifier, syndicationEntryIdentifier, platform, userAgent, host, referer, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseNonAuthenticatedEntity>> trackShareWithHttpInfo(String companyIdentifier, String syndicationEntryIdentifier, String platform, String userAgent, String host, String referer, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BooleanResponseNonAuthenticatedEntity>(this){};
        return this.trackShareRequestCreation(companyIdentifier, syndicationEntryIdentifier, platform, userAgent, host, referer, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec trackShareWithResponseSpec(String companyIdentifier, String syndicationEntryIdentifier, String platform, String userAgent, String host, String referer, String winkVersion) throws WebClientResponseException {
        return this.trackShareRequestCreation(companyIdentifier, syndicationEntryIdentifier, platform, userAgent, host, referer, winkVersion);
    }
}

