package travel.wink.sdk.analytics.api;

import travel.wink.sdk.analytics.invoker.ApiClient;

import travel.wink.sdk.analytics.model.ChartRequestViewAuthenticatedEntity;
import travel.wink.sdk.analytics.model.GenericErrorMessage;
import travel.wink.sdk.analytics.model.LineChartNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.RemoveEntryResponseAuthenticatedEntity;
import travel.wink.sdk.analytics.model.ShowChartRequest400Response;
import travel.wink.sdk.analytics.model.UpsertChartRequestWrapperAuthenticatedEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T22:09:22.001384940+07:00[Asia/Bangkok]")
public class AnalyticsApi {
    private ApiClient apiClient;

    public AnalyticsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnalyticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertChartRequestWrapperAuthenticatedEntity The upsertChartRequestWrapperAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartRequestViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createChartRequestRequestCreation(UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertChartRequestWrapperAuthenticatedEntity;
        // verify the required parameter 'upsertChartRequestWrapperAuthenticatedEntity' is set
        if (upsertChartRequestWrapperAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestWrapperAuthenticatedEntity' when calling createChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertChartRequestWrapperAuthenticatedEntity The upsertChartRequestWrapperAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartRequestViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartRequestViewAuthenticatedEntity> createChartRequest(UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return createChartRequestRequestCreation(upsertChartRequestWrapperAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertChartRequestWrapperAuthenticatedEntity The upsertChartRequestWrapperAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ChartRequestViewAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ChartRequestViewAuthenticatedEntity>> createChartRequestWithHttpInfo(UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return createChartRequestRequestCreation(upsertChartRequestWrapperAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertChartRequestWrapperAuthenticatedEntity The upsertChartRequestWrapperAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createChartRequestWithResponseSpec(UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return createChartRequestRequestCreation(upsertChartRequestWrapperAuthenticatedEntity, winkVersion);
    }
    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeChartRequestRequestCreation(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling removeChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAuthenticatedEntity> removeChartRequest(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAuthenticatedEntity>> removeChartRequestWithHttpInfo(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeChartRequestWithResponseSpec(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept);
    }
    /**
     * Show Analytics
     * Show analytics the authenticated entity has previously created
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;LineChartNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnalyticsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Analytics
     * Show analytics the authenticated entity has previously created
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;LineChartNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<LineChartNonAuthenticatedEntity> showAnalytics(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>() {};
        return showAnalyticsRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Analytics
     * Show analytics the authenticated entity has previously created
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;LineChartNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<LineChartNonAuthenticatedEntity>>> showAnalyticsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>() {};
        return showAnalyticsRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Analytics
     * Show analytics the authenticated entity has previously created
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAnalyticsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showAnalyticsRequestCreation(winkVersion, accept);
    }
    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ChartRequestViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChartRequestRequestCreation(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling showChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ChartRequestViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartRequestViewAuthenticatedEntity> showChartRequest(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return showChartRequestRequestCreation(chartIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ChartRequestViewAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ChartRequestViewAuthenticatedEntity>> showChartRequestWithHttpInfo(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return showChartRequestRequestCreation(chartIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showChartRequestWithResponseSpec(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showChartRequestRequestCreation(chartIdentifier, winkVersion, accept);
    }
    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ChartRequestViewAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChartRequestsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ChartRequestViewAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ChartRequestViewAuthenticatedEntity> showChartRequests(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return showChartRequestsRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;ChartRequestViewAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ChartRequestViewAuthenticatedEntity>>> showChartRequestsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return showChartRequestsRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showChartRequestsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showChartRequestsRequestCreation(winkVersion, accept);
    }
    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestWrapperAuthenticatedEntity The upsertChartRequestWrapperAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartRequestViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateChartRequestRequestCreation(String chartIdentifier, UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertChartRequestWrapperAuthenticatedEntity;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertChartRequestWrapperAuthenticatedEntity' is set
        if (upsertChartRequestWrapperAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestWrapperAuthenticatedEntity' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestWrapperAuthenticatedEntity The upsertChartRequestWrapperAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartRequestViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartRequestViewAuthenticatedEntity> updateChartRequest(String chartIdentifier, UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapperAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestWrapperAuthenticatedEntity The upsertChartRequestWrapperAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ChartRequestViewAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ChartRequestViewAuthenticatedEntity>> updateChartRequestWithHttpInfo(String chartIdentifier, UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>() {};
        return updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapperAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestWrapperAuthenticatedEntity The upsertChartRequestWrapperAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateChartRequestWithResponseSpec(String chartIdentifier, UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapperAuthenticatedEntity, winkVersion);
    }
}
