/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.analytics.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.analytics.invoker.ApiClient;
import travel.wink.sdk.analytics.model.ChartRequestViewAuthenticatedEntity;
import travel.wink.sdk.analytics.model.LineChartNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.RemoveEntryResponseAuthenticatedEntity;
import travel.wink.sdk.analytics.model.UpsertChartRequestWrapperAuthenticatedEntity;

public class AnalyticsApi {
    private ApiClient apiClient;

    public AnalyticsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnalyticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createChartRequestRequestCreation(UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        UpsertChartRequestWrapperAuthenticatedEntity postBody = upsertChartRequestWrapperAuthenticatedEntity;
        if (upsertChartRequestWrapperAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestWrapperAuthenticatedEntity' when calling createChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/chart", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ChartRequestViewAuthenticatedEntity> createChartRequest(UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.createChartRequestRequestCreation(upsertChartRequestWrapperAuthenticatedEntity, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ChartRequestViewAuthenticatedEntity>> createChartRequestWithHttpInfo(UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.createChartRequestRequestCreation(upsertChartRequestWrapperAuthenticatedEntity, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createChartRequestWithResponseSpec(UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return this.createChartRequestRequestCreation(upsertChartRequestWrapperAuthenticatedEntity, winkVersion);
    }

    private WebClient.ResponseSpec removeChartRequestRequestCreation(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling removeChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("chartIdentifier", chartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAuthenticatedEntity> removeChartRequest(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>(this){};
        return this.removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAuthenticatedEntity>> removeChartRequestWithHttpInfo(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>(this){};
        return this.removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeChartRequestWithResponseSpec(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAnalyticsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<LineChartNonAuthenticatedEntity> showAnalytics(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>(this){};
        return this.showAnalyticsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<LineChartNonAuthenticatedEntity>>> showAnalyticsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>(this){};
        return this.showAnalyticsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAnalyticsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showAnalyticsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showChartRequestRequestCreation(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling showChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("chartIdentifier", chartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ChartRequestViewAuthenticatedEntity> showChartRequest(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.showChartRequestRequestCreation(chartIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ChartRequestViewAuthenticatedEntity>> showChartRequestWithHttpInfo(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.showChartRequestRequestCreation(chartIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showChartRequestWithResponseSpec(String chartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showChartRequestRequestCreation(chartIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showChartRequestsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/chart/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ChartRequestViewAuthenticatedEntity> showChartRequests(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.showChartRequestsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ChartRequestViewAuthenticatedEntity>>> showChartRequestsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.showChartRequestsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showChartRequestsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showChartRequestsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateChartRequestRequestCreation(String chartIdentifier, UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        UpsertChartRequestWrapperAuthenticatedEntity postBody = upsertChartRequestWrapperAuthenticatedEntity;
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertChartRequestWrapperAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestWrapperAuthenticatedEntity' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("chartIdentifier", chartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ChartRequestViewAuthenticatedEntity> updateChartRequest(String chartIdentifier, UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapperAuthenticatedEntity, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ChartRequestViewAuthenticatedEntity>> updateChartRequestWithHttpInfo(String chartIdentifier, UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewAuthenticatedEntity>(this){};
        return this.updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapperAuthenticatedEntity, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateChartRequestWithResponseSpec(String chartIdentifier, UpsertChartRequestWrapperAuthenticatedEntity upsertChartRequestWrapperAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return this.updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapperAuthenticatedEntity, winkVersion);
    }
}

