package travel.wink.sdk.analytics.api;

import travel.wink.sdk.analytics.invoker.ApiClient;

import travel.wink.sdk.analytics.model.BookingLeaderboardEntryNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.GenericErrorMessage;
import travel.wink.sdk.analytics.model.LeaderboardOwnerRequestNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.LeaderboardRequestNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.PageBookingLeaderboardEntryNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.ShowChartRequest400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T20:21:08.208727904+07:00[Asia/Bangkok]")
public class LeaderboardApi {
    private ApiClient apiClient;

    public LeaderboardApi() {
        this(new ApiClient());
    }

    @Autowired
    public LeaderboardApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Leaderboard by Region
     * Show leaderboard based on location type such as continent.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param leaderboardRequestNonAuthenticatedEntity The leaderboardRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingLeaderboardEntryNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLeaderboardRequestCreation(LeaderboardRequestNonAuthenticatedEntity leaderboardRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = leaderboardRequestNonAuthenticatedEntity;
        // verify the required parameter 'leaderboardRequestNonAuthenticatedEntity' is set
        if (leaderboardRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'leaderboardRequestNonAuthenticatedEntity' when calling showLeaderboard", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingLeaderboardEntryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageBookingLeaderboardEntryNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/leaderboard/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Leaderboard by Region
     * Show leaderboard based on location type such as continent.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param leaderboardRequestNonAuthenticatedEntity The leaderboardRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingLeaderboardEntryNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingLeaderboardEntryNonAuthenticatedEntity> showLeaderboard(LeaderboardRequestNonAuthenticatedEntity leaderboardRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingLeaderboardEntryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageBookingLeaderboardEntryNonAuthenticatedEntity>() {};
        return showLeaderboardRequestCreation(leaderboardRequestNonAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Leaderboard by Region
     * Show leaderboard based on location type such as continent.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param leaderboardRequestNonAuthenticatedEntity The leaderboardRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageBookingLeaderboardEntryNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageBookingLeaderboardEntryNonAuthenticatedEntity>> showLeaderboardWithHttpInfo(LeaderboardRequestNonAuthenticatedEntity leaderboardRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingLeaderboardEntryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageBookingLeaderboardEntryNonAuthenticatedEntity>() {};
        return showLeaderboardRequestCreation(leaderboardRequestNonAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Leaderboard by Region
     * Show leaderboard based on location type such as continent.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param leaderboardRequestNonAuthenticatedEntity The leaderboardRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLeaderboardWithResponseSpec(LeaderboardRequestNonAuthenticatedEntity leaderboardRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return showLeaderboardRequestCreation(leaderboardRequestNonAuthenticatedEntity, winkVersion);
    }
    /**
     * Show Leaderboard by Affiliate 
     * Show leaderboard for a specific affiliate.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param leaderboardOwnerRequestNonAuthenticatedEntity The leaderboardOwnerRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingLeaderboardEntryNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLeaderboardByOwnerRequestCreation(LeaderboardOwnerRequestNonAuthenticatedEntity leaderboardOwnerRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = leaderboardOwnerRequestNonAuthenticatedEntity;
        // verify the required parameter 'leaderboardOwnerRequestNonAuthenticatedEntity' is set
        if (leaderboardOwnerRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'leaderboardOwnerRequestNonAuthenticatedEntity' when calling showLeaderboardByOwner", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingLeaderboardEntryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BookingLeaderboardEntryNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/leaderboard", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Leaderboard by Affiliate 
     * Show leaderboard for a specific affiliate.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param leaderboardOwnerRequestNonAuthenticatedEntity The leaderboardOwnerRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingLeaderboardEntryNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingLeaderboardEntryNonAuthenticatedEntity> showLeaderboardByOwner(LeaderboardOwnerRequestNonAuthenticatedEntity leaderboardOwnerRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingLeaderboardEntryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BookingLeaderboardEntryNonAuthenticatedEntity>() {};
        return showLeaderboardByOwnerRequestCreation(leaderboardOwnerRequestNonAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Leaderboard by Affiliate 
     * Show leaderboard for a specific affiliate.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param leaderboardOwnerRequestNonAuthenticatedEntity The leaderboardOwnerRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingLeaderboardEntryNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingLeaderboardEntryNonAuthenticatedEntity>> showLeaderboardByOwnerWithHttpInfo(LeaderboardOwnerRequestNonAuthenticatedEntity leaderboardOwnerRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingLeaderboardEntryNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BookingLeaderboardEntryNonAuthenticatedEntity>() {};
        return showLeaderboardByOwnerRequestCreation(leaderboardOwnerRequestNonAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Leaderboard by Affiliate 
     * Show leaderboard for a specific affiliate.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param leaderboardOwnerRequestNonAuthenticatedEntity The leaderboardOwnerRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLeaderboardByOwnerWithResponseSpec(LeaderboardOwnerRequestNonAuthenticatedEntity leaderboardOwnerRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return showLeaderboardByOwnerRequestCreation(leaderboardOwnerRequestNonAuthenticatedEntity, winkVersion);
    }
}
