package travel.wink.sdk.analytics.api;

import travel.wink.sdk.analytics.invoker.ApiClient;

import travel.wink.sdk.analytics.model.ChartAuthenticatedEntity;
import travel.wink.sdk.analytics.model.GenericErrorMessage;
import travel.wink.sdk.analytics.model.LineChartNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.PageLineChartNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.RemoveEntryResponseAuthenticatedEntity;
import travel.wink.sdk.analytics.model.ShowChartRequest400Response;
import travel.wink.sdk.analytics.model.StateNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.UpsertChartRequestAuthenticatedEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:16:41.091743638+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class AnalyticsApi {
    private ApiClient apiClient;

    public AnalyticsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnalyticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertChartRequestAuthenticatedEntity The upsertChartRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createChartRequestRequestCreation(@jakarta.annotation.Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertChartRequestAuthenticatedEntity;
        // verify the required parameter 'upsertChartRequestAuthenticatedEntity' is set
        if (upsertChartRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestAuthenticatedEntity' when calling createChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertChartRequestAuthenticatedEntity The upsertChartRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartAuthenticatedEntity> createChartRequest(@jakarta.annotation.Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return createChartRequestRequestCreation(upsertChartRequestAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertChartRequestAuthenticatedEntity The upsertChartRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ChartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ChartAuthenticatedEntity>> createChartRequestWithHttpInfo(@jakarta.annotation.Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return createChartRequestRequestCreation(upsertChartRequestAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertChartRequestAuthenticatedEntity The upsertChartRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createChartRequestWithResponseSpec(@jakarta.annotation.Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createChartRequestRequestCreation(upsertChartRequestAuthenticatedEntity, winkVersion);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeChartRequestRequestCreation(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling removeChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAuthenticatedEntity> removeChartRequest(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAuthenticatedEntity>> removeChartRequestWithHttpInfo(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeChartRequestWithResponseSpec(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept);
    }

    /**
     * Show Analytics Grid
     * Show paginated analytics.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateNonAuthenticatedEntity The stateNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return PageLineChartNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnalyticsGridRequestCreation(@jakarta.annotation.Nonnull StateNonAuthenticatedEntity stateNonAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = stateNonAuthenticatedEntity;
        // verify the required parameter 'stateNonAuthenticatedEntity' is set
        if (stateNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateNonAuthenticatedEntity' when calling showAnalyticsGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Analytics Grid
     * Show paginated analytics.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateNonAuthenticatedEntity The stateNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return PageLineChartNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageLineChartNonAuthenticatedEntity> showAnalyticsGrid(@jakarta.annotation.Nonnull StateNonAuthenticatedEntity stateNonAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity>() {};
        return showAnalyticsGridRequestCreation(stateNonAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Analytics Grid
     * Show paginated analytics.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateNonAuthenticatedEntity The stateNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageLineChartNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageLineChartNonAuthenticatedEntity>> showAnalyticsGridWithHttpInfo(@jakarta.annotation.Nonnull StateNonAuthenticatedEntity stateNonAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity>() {};
        return showAnalyticsGridRequestCreation(stateNonAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Analytics Grid
     * Show paginated analytics.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateNonAuthenticatedEntity The stateNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAnalyticsGridWithResponseSpec(@jakarta.annotation.Nonnull StateNonAuthenticatedEntity stateNonAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return showAnalyticsGridRequestCreation(stateNonAuthenticatedEntity, winkVersion);
    }

    /**
     * Show Analytics
     * Show analytics.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;LineChartNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnalyticsListRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Analytics
     * Show analytics.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;LineChartNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<LineChartNonAuthenticatedEntity> showAnalyticsList(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>() {};
        return showAnalyticsListRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Analytics
     * Show analytics.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;LineChartNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<LineChartNonAuthenticatedEntity>>> showAnalyticsListWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>() {};
        return showAnalyticsListRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Analytics
     * Show analytics.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAnalyticsListWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showAnalyticsListRequestCreation(winkVersion, accept);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ChartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChartRequestRequestCreation(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling showChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ChartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartAuthenticatedEntity> showChartRequest(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return showChartRequestRequestCreation(chartIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ChartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ChartAuthenticatedEntity>> showChartRequestWithHttpInfo(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return showChartRequestRequestCreation(chartIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showChartRequestWithResponseSpec(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showChartRequestRequestCreation(chartIdentifier, winkVersion, accept);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ChartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChartRequestsRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ChartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ChartAuthenticatedEntity> showChartRequests(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return showChartRequestsRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;ChartAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ChartAuthenticatedEntity>>> showChartRequestsWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return showChartRequestsRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showChartRequestsWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showChartRequestsRequestCreation(winkVersion, accept);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestAuthenticatedEntity The upsertChartRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateChartRequestRequestCreation(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertChartRequestAuthenticatedEntity;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertChartRequestAuthenticatedEntity' is set
        if (upsertChartRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestAuthenticatedEntity' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestAuthenticatedEntity The upsertChartRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartAuthenticatedEntity> updateChartRequest(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestAuthenticatedEntity The upsertChartRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ChartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ChartAuthenticatedEntity>> updateChartRequestWithHttpInfo(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>() {};
        return updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestAuthenticatedEntity The upsertChartRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateChartRequestWithResponseSpec(@jakarta.annotation.Nonnull String chartIdentifier, @jakarta.annotation.Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestAuthenticatedEntity, winkVersion);
    }
}
