/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BookingLeaderboardEntryNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_OWNER_IDENTIFIER,
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_OWNER_NAME,
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_CONTINENT,
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_COUNTRY,
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_COUNTRY_GEO_NAME_ID,
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_CITY,
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_CITY_GEO_NAME_ID,
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_BOOKINGS,
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_TOTAL_PRICE_AMOUNT,
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT,
  BookingLeaderboardEntryNonAuthenticatedEntity.JSON_PROPERTY_CURRENCY_CODE
})
@JsonTypeName("BookingLeaderboardEntry_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:16:41.091743638+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class BookingLeaderboardEntryNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  @jakarta.annotation.Nullable
  private String ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  @jakarta.annotation.Nullable
  private String ownerName;

  public static final String JSON_PROPERTY_CONTINENT = "continent";
  @jakarta.annotation.Nullable
  private String continent;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  @jakarta.annotation.Nullable
  private String country;

  public static final String JSON_PROPERTY_COUNTRY_GEO_NAME_ID = "countryGeoNameId";
  @jakarta.annotation.Nullable
  private String countryGeoNameId;

  public static final String JSON_PROPERTY_CITY = "city";
  @jakarta.annotation.Nullable
  private String city;

  public static final String JSON_PROPERTY_CITY_GEO_NAME_ID = "cityGeoNameId";
  @jakarta.annotation.Nullable
  private String cityGeoNameId;

  public static final String JSON_PROPERTY_BOOKINGS = "bookings";
  @jakarta.annotation.Nullable
  private Long bookings;

  public static final String JSON_PROPERTY_TOTAL_PRICE_AMOUNT = "totalPriceAmount";
  @jakarta.annotation.Nullable
  private BigDecimal totalPriceAmount;

  public static final String JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT = "averageBookingAmount";
  @jakarta.annotation.Nullable
  private BigDecimal averageBookingAmount;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  @jakarta.annotation.Nullable
  private String currencyCode;

  public BookingLeaderboardEntryNonAuthenticatedEntity() {
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity ownerIdentifier(@jakarta.annotation.Nullable String ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

  /**
   * Get ownerIdentifier
   * @return ownerIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(@jakarta.annotation.Nullable String ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity ownerName(@jakarta.annotation.Nullable String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

  /**
   * Get ownerName
   * @return ownerName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(@jakarta.annotation.Nullable String ownerName) {
    this.ownerName = ownerName;
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity continent(@jakarta.annotation.Nullable String continent) {
    
    this.continent = continent;
    return this;
  }

  /**
   * Get continent
   * @return continent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinent() {
    return continent;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinent(@jakarta.annotation.Nullable String continent) {
    this.continent = continent;
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity country(@jakarta.annotation.Nullable String country) {
    
    this.country = country;
    return this;
  }

  /**
   * Get country
   * @return country
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(@jakarta.annotation.Nullable String country) {
    this.country = country;
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity countryGeoNameId(@jakarta.annotation.Nullable String countryGeoNameId) {
    
    this.countryGeoNameId = countryGeoNameId;
    return this;
  }

  /**
   * Get countryGeoNameId
   * @return countryGeoNameId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryGeoNameId() {
    return countryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryGeoNameId(@jakarta.annotation.Nullable String countryGeoNameId) {
    this.countryGeoNameId = countryGeoNameId;
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity city(@jakarta.annotation.Nullable String city) {
    
    this.city = city;
    return this;
  }

  /**
   * Get city
   * @return city
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(@jakarta.annotation.Nullable String city) {
    this.city = city;
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity cityGeoNameId(@jakarta.annotation.Nullable String cityGeoNameId) {
    
    this.cityGeoNameId = cityGeoNameId;
    return this;
  }

  /**
   * Get cityGeoNameId
   * @return cityGeoNameId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityGeoNameId() {
    return cityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityGeoNameId(@jakarta.annotation.Nullable String cityGeoNameId) {
    this.cityGeoNameId = cityGeoNameId;
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity bookings(@jakarta.annotation.Nullable Long bookings) {
    
    this.bookings = bookings;
    return this;
  }

  /**
   * Get bookings
   * @return bookings
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBookings() {
    return bookings;
  }


  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookings(@jakarta.annotation.Nullable Long bookings) {
    this.bookings = bookings;
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity totalPriceAmount(@jakarta.annotation.Nullable BigDecimal totalPriceAmount) {
    
    this.totalPriceAmount = totalPriceAmount;
    return this;
  }

  /**
   * Get totalPriceAmount
   * @return totalPriceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getTotalPriceAmount() {
    return totalPriceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalPriceAmount(@jakarta.annotation.Nullable BigDecimal totalPriceAmount) {
    this.totalPriceAmount = totalPriceAmount;
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity averageBookingAmount(@jakarta.annotation.Nullable BigDecimal averageBookingAmount) {
    
    this.averageBookingAmount = averageBookingAmount;
    return this;
  }

  /**
   * Get averageBookingAmount
   * @return averageBookingAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getAverageBookingAmount() {
    return averageBookingAmount;
  }


  @JsonProperty(JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAverageBookingAmount(@jakarta.annotation.Nullable BigDecimal averageBookingAmount) {
    this.averageBookingAmount = averageBookingAmount;
  }

  public BookingLeaderboardEntryNonAuthenticatedEntity currencyCode(@jakarta.annotation.Nullable String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Get currencyCode
   * @return currencyCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(@jakarta.annotation.Nullable String currencyCode) {
    this.currencyCode = currencyCode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingLeaderboardEntryNonAuthenticatedEntity bookingLeaderboardEntryNonAuthenticatedEntity = (BookingLeaderboardEntryNonAuthenticatedEntity) o;
    return Objects.equals(this.ownerIdentifier, bookingLeaderboardEntryNonAuthenticatedEntity.ownerIdentifier) &&
        Objects.equals(this.ownerName, bookingLeaderboardEntryNonAuthenticatedEntity.ownerName) &&
        Objects.equals(this.continent, bookingLeaderboardEntryNonAuthenticatedEntity.continent) &&
        Objects.equals(this.country, bookingLeaderboardEntryNonAuthenticatedEntity.country) &&
        Objects.equals(this.countryGeoNameId, bookingLeaderboardEntryNonAuthenticatedEntity.countryGeoNameId) &&
        Objects.equals(this.city, bookingLeaderboardEntryNonAuthenticatedEntity.city) &&
        Objects.equals(this.cityGeoNameId, bookingLeaderboardEntryNonAuthenticatedEntity.cityGeoNameId) &&
        Objects.equals(this.bookings, bookingLeaderboardEntryNonAuthenticatedEntity.bookings) &&
        Objects.equals(this.totalPriceAmount, bookingLeaderboardEntryNonAuthenticatedEntity.totalPriceAmount) &&
        Objects.equals(this.averageBookingAmount, bookingLeaderboardEntryNonAuthenticatedEntity.averageBookingAmount) &&
        Objects.equals(this.currencyCode, bookingLeaderboardEntryNonAuthenticatedEntity.currencyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ownerIdentifier, ownerName, continent, country, countryGeoNameId, city, cityGeoNameId, bookings, totalPriceAmount, averageBookingAmount, currencyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingLeaderboardEntryNonAuthenticatedEntity {\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    continent: ").append(toIndentedString(continent)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    countryGeoNameId: ").append(toIndentedString(countryGeoNameId)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    cityGeoNameId: ").append(toIndentedString(cityGeoNameId)).append("\n");
    sb.append("    bookings: ").append(toIndentedString(bookings)).append("\n");
    sb.append("    totalPriceAmount: ").append(toIndentedString(totalPriceAmount)).append("\n");
    sb.append("    averageBookingAmount: ").append(toIndentedString(averageBookingAmount)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

