/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import travel.wink.sdk.analytics.model.KeyValuePairAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Chart properties allow you to choose how to visualize available data points. Choose how you want to:   - filter your data  - sort your data  - group your data  - include data in your data sets  - display currency amounts
 */
@JsonPropertyOrder({
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SERIES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_TIME_SERIES_UNITS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_START_DATE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_END_DATE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_CONTINENT_CODE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_PAGE_VISITS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CARD_VISITS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_BOOKINGS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLATIONS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ROOM_NIGHTS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_MEETING_ROOMS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_RESTAURANTS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_SPAS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_SPAS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ACTIVITIES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ATTRACTIONS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_PLACES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_PLACES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ADD_ONS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ADDONS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_SPAS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_PLACES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_PAGE_VISITS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CARD_VISITS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_BOOKINGS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLATIONS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ROOM_NIGHTS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_MEETING_ROOMS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_RESTAURANTS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_SPAS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_SPAS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ACTIVITIES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ATTRACTIONS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_PLACES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_PLACES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ADD_ONS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_SPAS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_PLACES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_CONTINENT_CODE,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER,
  ChartDetailsAuthenticatedEntity.JSON_PROPERTY_CURRENCY_CODE
})
@JsonTypeName("ChartDetails_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:16:41.091743638+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class ChartDetailsAuthenticatedEntity {
  /**
   * The time series to visualize
   */
  public enum SeriesEnum {
    HOUR(String.valueOf("HOUR")),
    
    DAY(String.valueOf("DAY")),
    
    MONTH(String.valueOf("MONTH")),
    
    YEAR(String.valueOf("YEAR"));

    private String value;

    SeriesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SeriesEnum fromValue(String value) {
      for (SeriesEnum b : SeriesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SERIES = "series";
  @jakarta.annotation.Nonnull
  private SeriesEnum series;

  public static final String JSON_PROPERTY_TIME_SERIES_UNITS = "timeSeriesUnits";
  @jakarta.annotation.Nullable
  private Long timeSeriesUnits;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime endDate;

  public static final String JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER = "filterOnHotelIdentifier";
  @jakarta.annotation.Nullable
  private KeyValuePairAuthenticatedEntity filterOnHotelIdentifier;

  /**
   * Filter on channel sub type. What channel sub-type helped make the booking.
   */
  public enum FilterOnChannelSubTypeEnum {
    DIRECT(String.valueOf("DIRECT")),
    
    APPLICATION(String.valueOf("APPLICATION")),
    
    HOTEL(String.valueOf("HOTEL")),
    
    TRAVELIKO(String.valueOf("TRAVELIKO")),
    
    CORPORATE(String.valueOf("CORPORATE")),
    
    TRAVEL_AGENT(String.valueOf("TRAVEL_AGENT")),
    
    INFLUENCER(String.valueOf("INFLUENCER")),
    
    BLOGGER(String.valueOf("BLOGGER")),
    
    DESTINATION(String.valueOf("DESTINATION")),
    
    CHANNEL_MANAGER(String.valueOf("CHANNEL_MANAGER")),
    
    PROPERTY_MANAGEMENT_SYSTEM(String.valueOf("PROPERTY_MANAGEMENT_SYSTEM")),
    
    CENTRAL_RESERVATION_SYSTEM(String.valueOf("CENTRAL_RESERVATION_SYSTEM")),
    
    GOOGLE_HOTEL_API(String.valueOf("GOOGLE_HOTEL_API")),
    
    MANAGEMENT_COMPANY(String.valueOf("MANAGEMENT_COMPANY")),
    
    CHAIN(String.valueOf("CHAIN")),
    
    BRAND(String.valueOf("BRAND")),
    
    EVENT_ORGANIZER(String.valueOf("EVENT_ORGANIZER"));

    private String value;

    FilterOnChannelSubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FilterOnChannelSubTypeEnum fromValue(String value) {
      for (FilterOnChannelSubTypeEnum b : FilterOnChannelSubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE = "filterOnChannelSubType";
  @jakarta.annotation.Nullable
  private FilterOnChannelSubTypeEnum filterOnChannelSubType;

  public static final String JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER = "filterOnOwnerIdentifier";
  @jakarta.annotation.Nullable
  private KeyValuePairAuthenticatedEntity filterOnOwnerIdentifier;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID = "filterOnEngineCountryGeoNameId";
  @jakarta.annotation.Nullable
  private KeyValuePairAuthenticatedEntity filterOnEngineCountryGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID = "filterOnEngineCityGeoNameId";
  @jakarta.annotation.Nullable
  private KeyValuePairAuthenticatedEntity filterOnEngineCityGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE = "filterOnEngineContinentCode";
  @jakarta.annotation.Nullable
  private KeyValuePairAuthenticatedEntity filterOnEngineContinentCode;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER = "filterOnEngineConfigurationIdentifier";
  @jakarta.annotation.Nullable
  private KeyValuePairAuthenticatedEntity filterOnEngineConfigurationIdentifier;

  public static final String JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID = "filterOnCountryGeoNameId";
  @jakarta.annotation.Nullable
  private KeyValuePairAuthenticatedEntity filterOnCountryGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID = "filterOnCityGeoNameId";
  @jakarta.annotation.Nullable
  private KeyValuePairAuthenticatedEntity filterOnCityGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_CONTINENT_CODE = "filterOnContinentCode";
  @jakarta.annotation.Nullable
  private KeyValuePairAuthenticatedEntity filterOnContinentCode;

  public static final String JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER = "filterOnUserIdentifier";
  @jakarta.annotation.Nullable
  private KeyValuePairAuthenticatedEntity filterOnUserIdentifier;

  public static final String JSON_PROPERTY_SORT_ON_PAGE_VISITS = "sortOnPageVisits";
  @jakarta.annotation.Nullable
  private Boolean sortOnPageVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS = "sortOnMapMarkerVisits";
  @jakarta.annotation.Nullable
  private Boolean sortOnMapMarkerVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_CARD_VISITS = "sortOnCardVisits";
  @jakarta.annotation.Nullable
  private Boolean sortOnCardVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_BOOKINGS = "sortOnBookings";
  @jakarta.annotation.Nullable
  private Boolean sortOnBookings = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLATIONS = "sortOnCancellations";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancellations = false;

  public static final String JSON_PROPERTY_SORT_ON_ROOM_NIGHTS = "sortOnRoomNights";
  @jakarta.annotation.Nullable
  private Boolean sortOnRoomNights = false;

  public static final String JSON_PROPERTY_SORT_ON_MEETING_ROOMS = "sortOnMeetingRooms";
  @jakarta.annotation.Nullable
  private Boolean sortOnMeetingRooms = false;

  public static final String JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE = "sortOnMeetingRoomsRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_RESTAURANTS = "sortOnRestaurants";
  @jakarta.annotation.Nullable
  private Boolean sortOnRestaurants = false;

  public static final String JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE = "sortOnRestaurantsRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_SPAS = "sortOnSpas";
  @jakarta.annotation.Nullable
  private Boolean sortOnSpas = false;

  public static final String JSON_PROPERTY_SORT_ON_SPAS_REVENUE = "sortOnSpasRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnSpasRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ACTIVITIES = "sortOnActivities";
  @jakarta.annotation.Nullable
  private Boolean sortOnActivities = false;

  public static final String JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE = "sortOnActivitiesRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnActivitiesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ATTRACTIONS = "sortOnAttractions";
  @jakarta.annotation.Nullable
  private Boolean sortOnAttractions = false;

  public static final String JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE = "sortOnAttractionsRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnAttractionsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_PLACES = "sortOnPlaces";
  @jakarta.annotation.Nullable
  private Boolean sortOnPlaces = false;

  public static final String JSON_PROPERTY_SORT_ON_PLACES_REVENUE = "sortOnPlacesRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnPlacesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES = "sortOnRoomTypeAncillaries";
  @jakarta.annotation.Nullable
  private Boolean sortOnRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE = "sortOnRoomTypeAncillariesRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ADD_ONS = "sortOnAddOns";
  @jakarta.annotation.Nullable
  private Boolean sortOnAddOns = false;

  public static final String JSON_PROPERTY_SORT_ON_ADDONS_REVENUE = "sortOnAddonsRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnAddonsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE = "sortOnTotalRoomRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE = "sortOnTotalAncillariesRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE = "sortOnTotalNetRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnTotalNetRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS = "sortOnCancelledRoomNights";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledRoomNights = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS = "sortOnCancelledMeetingRooms";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledMeetingRooms = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE = "sortOnCancelledMeetingRoomsRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS = "sortOnCancelledRestaurants";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledRestaurants = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE = "sortOnCancelledRestaurantsRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_SPAS = "sortOnCancelledSpas";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledSpas = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE = "sortOnCancelledSpasRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledSpasRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES = "sortOnCancelledActivities";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledActivities = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE = "sortOnCancelledActivitiesRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledActivitiesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS = "sortOnCancelledAttractions";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledAttractions = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE = "sortOnCancelledAttractionsRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledAttractionsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PLACES = "sortOnCancelledPlaces";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledPlaces = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE = "sortOnCancelledPlacesRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledPlacesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE = "sortOnCancelledTotalRoomRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE = "sortOnCancelledTotalAncillariesRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES = "sortOnCancelledRoomTypeAncillaries";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE = "sortOnCancelledRoomTypeAncillariesRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS = "sortOnCancelledAddOns";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledAddOns = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE = "sortOnCancelledAddonsRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledAddonsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE = "sortOnCancelledTotalNetRevenue";
  @jakarta.annotation.Nullable
  private Boolean sortOnCancelledTotalNetRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_PAGE_VISITS = "includePageVisits";
  @jakarta.annotation.Nullable
  private Boolean includePageVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS = "includeMapMarkerVisits";
  @jakarta.annotation.Nullable
  private Boolean includeMapMarkerVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_CARD_VISITS = "includeCardVisits";
  @jakarta.annotation.Nullable
  private Boolean includeCardVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_BOOKINGS = "includeBookings";
  @jakarta.annotation.Nullable
  private Boolean includeBookings = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLATIONS = "includeCancellations";
  @jakarta.annotation.Nullable
  private Boolean includeCancellations = false;

  public static final String JSON_PROPERTY_INCLUDE_ROOM_NIGHTS = "includeRoomNights";
  @jakarta.annotation.Nullable
  private Boolean includeRoomNights = false;

  public static final String JSON_PROPERTY_INCLUDE_MEETING_ROOMS = "includeMeetingRooms";
  @jakarta.annotation.Nullable
  private Boolean includeMeetingRooms = false;

  public static final String JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE = "includeMeetingRoomsRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_RESTAURANTS = "includeRestaurants";
  @jakarta.annotation.Nullable
  private Boolean includeRestaurants = false;

  public static final String JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE = "includeRestaurantsRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_SPAS = "includeSpas";
  @jakarta.annotation.Nullable
  private Boolean includeSpas = false;

  public static final String JSON_PROPERTY_INCLUDE_SPAS_REVENUE = "includeSpasRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeSpasRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ACTIVITIES = "includeActivities";
  @jakarta.annotation.Nullable
  private Boolean includeActivities = false;

  public static final String JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE = "includeActivitiesRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeActivitiesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ATTRACTIONS = "includeAttractions";
  @jakarta.annotation.Nullable
  private Boolean includeAttractions = false;

  public static final String JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE = "includeAttractionsRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeAttractionsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_PLACES = "includePlaces";
  @jakarta.annotation.Nullable
  private Boolean includePlaces = false;

  public static final String JSON_PROPERTY_INCLUDE_PLACES_REVENUE = "includePlacesRevenue";
  @jakarta.annotation.Nullable
  private Boolean includePlacesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES = "includeRoomTypeAncillaries";
  @jakarta.annotation.Nullable
  private Boolean includeRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE = "includeRoomTypeAncillariesRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ADD_ONS = "includeAddOns";
  @jakarta.annotation.Nullable
  private Boolean includeAddOns = false;

  public static final String JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE = "includeAddOnsRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeAddOnsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE = "includeTotalRoomRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE = "includeAverageRoomRate";
  @jakarta.annotation.Nullable
  private Boolean includeAverageRoomRate = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE = "includeTotalAncillariesRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE = "includeTotalNetRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeTotalNetRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS = "includeCancelledRoomNights";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledRoomNights = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS = "includeCancelledMeetingRooms";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledMeetingRooms = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE = "includeCancelledMeetingRoomsRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS = "includeCancelledRestaurants";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledRestaurants = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE = "includeCancelledRestaurantsRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_SPAS = "includeCancelledSpas";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledSpas = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE = "includeCancelledSpasRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledSpasRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES = "includeCancelledActivities";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledActivities = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE = "includeCancelledActivitiesRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledActivitiesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS = "includeCancelledAttractions";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledAttractions = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE = "includeCancelledAttractionsRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledAttractionsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PLACES = "includeCancelledPlaces";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledPlaces = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE = "includeCancelledPlacesRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledPlacesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES = "includeCancelledRoomTypeAncillaries";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE = "includeCancelledRoomTypeAncillariesRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS = "includeCancelledAddOns";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledAddOns = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE = "includeCancelledAddOnsRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledAddOnsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE = "includeCancelledTotalRoomRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE = "includeCancelledTotalAncillariesRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE = "includeCancelledTotalNetRevenue";
  @jakarta.annotation.Nullable
  private Boolean includeCancelledTotalNetRevenue = false;

  public static final String JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE = "groupOnChannelSubType";
  @jakarta.annotation.Nullable
  private Boolean groupOnChannelSubType = false;

  public static final String JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER = "groupOnOwnerIdentifier";
  @jakarta.annotation.Nullable
  private Boolean groupOnOwnerIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID = "groupOnEngineCountryGeoNameId";
  @jakarta.annotation.Nullable
  private Boolean groupOnEngineCountryGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID = "groupOnEngineCityGeoNameId";
  @jakarta.annotation.Nullable
  private Boolean groupOnEngineCityGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE = "groupOnEngineContinentCode";
  @jakarta.annotation.Nullable
  private Boolean groupOnEngineContinentCode = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER = "groupOnEngineConfigurationIdentifier";
  @jakarta.annotation.Nullable
  private Boolean groupOnEngineConfigurationIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID = "groupOnCountryGeoNameId";
  @jakarta.annotation.Nullable
  private Boolean groupOnCountryGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID = "groupOnCityGeoNameId";
  @jakarta.annotation.Nullable
  private Boolean groupOnCityGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_CONTINENT_CODE = "groupOnContinentCode";
  @jakarta.annotation.Nullable
  private Boolean groupOnContinentCode = false;

  public static final String JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER = "groupOnHotelIdentifier";
  @jakarta.annotation.Nullable
  private Boolean groupOnHotelIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER = "groupOnUserIdentifier";
  @jakarta.annotation.Nullable
  private Boolean groupOnUserIdentifier = false;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  @jakarta.annotation.Nullable
  private String currencyCode = "USD";

  public ChartDetailsAuthenticatedEntity() {
  }

  public ChartDetailsAuthenticatedEntity series(@jakarta.annotation.Nonnull SeriesEnum series) {
    
    this.series = series;
    return this;
  }

  /**
   * The time series to visualize
   * @return series
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SeriesEnum getSeries() {
    return series;
  }


  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSeries(@jakarta.annotation.Nonnull SeriesEnum series) {
    this.series = series;
  }

  public ChartDetailsAuthenticatedEntity timeSeriesUnits(@jakarta.annotation.Nullable Long timeSeriesUnits) {
    
    this.timeSeriesUnits = timeSeriesUnits;
    return this;
  }

  /**
   * How many units of the time series type to visualize. Only required if start / end date not populated.
   * @return timeSeriesUnits
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIME_SERIES_UNITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimeSeriesUnits() {
    return timeSeriesUnits;
  }


  @JsonProperty(JSON_PROPERTY_TIME_SERIES_UNITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeSeriesUnits(@jakarta.annotation.Nullable Long timeSeriesUnits) {
    this.timeSeriesUnits = timeSeriesUnits;
  }

  public ChartDetailsAuthenticatedEntity startDate(@jakarta.annotation.Nullable java.time.LocalDateTime startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Fixed date to start visualizations on
   * @return startDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@jakarta.annotation.Nullable java.time.LocalDateTime startDate) {
    this.startDate = startDate;
  }

  public ChartDetailsAuthenticatedEntity endDate(@jakarta.annotation.Nullable java.time.LocalDateTime endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * Fixed date to end visualizations on
   * @return endDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@jakarta.annotation.Nullable java.time.LocalDateTime endDate) {
    this.endDate = endDate;
  }

  public ChartDetailsAuthenticatedEntity filterOnHotelIdentifier(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnHotelIdentifier) {
    
    this.filterOnHotelIdentifier = filterOnHotelIdentifier;
    return this;
  }

  /**
   * Filter on hotel identifier
   * @return filterOnHotelIdentifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnHotelIdentifier() {
    return filterOnHotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnHotelIdentifier(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnHotelIdentifier) {
    this.filterOnHotelIdentifier = filterOnHotelIdentifier;
  }

  public ChartDetailsAuthenticatedEntity filterOnChannelSubType(@jakarta.annotation.Nullable FilterOnChannelSubTypeEnum filterOnChannelSubType) {
    
    this.filterOnChannelSubType = filterOnChannelSubType;
    return this;
  }

  /**
   * Filter on channel sub type. What channel sub-type helped make the booking.
   * @return filterOnChannelSubType
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FilterOnChannelSubTypeEnum getFilterOnChannelSubType() {
    return filterOnChannelSubType;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnChannelSubType(@jakarta.annotation.Nullable FilterOnChannelSubTypeEnum filterOnChannelSubType) {
    this.filterOnChannelSubType = filterOnChannelSubType;
  }

  public ChartDetailsAuthenticatedEntity filterOnOwnerIdentifier(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnOwnerIdentifier) {
    
    this.filterOnOwnerIdentifier = filterOnOwnerIdentifier;
    return this;
  }

  /**
   * Filter on seller identifier. What affiliate helped make this booking.
   * @return filterOnOwnerIdentifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnOwnerIdentifier() {
    return filterOnOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnOwnerIdentifier(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnOwnerIdentifier) {
    this.filterOnOwnerIdentifier = filterOnOwnerIdentifier;
  }

  public ChartDetailsAuthenticatedEntity filterOnEngineCountryGeoNameId(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnEngineCountryGeoNameId) {
    
    this.filterOnEngineCountryGeoNameId = filterOnEngineCountryGeoNameId;
    return this;
  }

  /**
   * Filter on customization country geoNameId. Which country is this application from.
   * @return filterOnEngineCountryGeoNameId
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnEngineCountryGeoNameId() {
    return filterOnEngineCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineCountryGeoNameId(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnEngineCountryGeoNameId) {
    this.filterOnEngineCountryGeoNameId = filterOnEngineCountryGeoNameId;
  }

  public ChartDetailsAuthenticatedEntity filterOnEngineCityGeoNameId(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnEngineCityGeoNameId) {
    
    this.filterOnEngineCityGeoNameId = filterOnEngineCityGeoNameId;
    return this;
  }

  /**
   * Filter on city geoNameId. Which city is this application from.
   * @return filterOnEngineCityGeoNameId
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnEngineCityGeoNameId() {
    return filterOnEngineCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineCityGeoNameId(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnEngineCityGeoNameId) {
    this.filterOnEngineCityGeoNameId = filterOnEngineCityGeoNameId;
  }

  public ChartDetailsAuthenticatedEntity filterOnEngineContinentCode(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnEngineContinentCode) {
    
    this.filterOnEngineContinentCode = filterOnEngineContinentCode;
    return this;
  }

  /**
   * Filter on continent. Which city is this application from.
   * @return filterOnEngineContinentCode
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnEngineContinentCode() {
    return filterOnEngineContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineContinentCode(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnEngineContinentCode) {
    this.filterOnEngineContinentCode = filterOnEngineContinentCode;
  }

  public ChartDetailsAuthenticatedEntity filterOnEngineConfigurationIdentifier(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnEngineConfigurationIdentifier) {
    
    this.filterOnEngineConfigurationIdentifier = filterOnEngineConfigurationIdentifier;
    return this;
  }

  /**
   * Filter on customization. Which customization made this booking.
   * @return filterOnEngineConfigurationIdentifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnEngineConfigurationIdentifier() {
    return filterOnEngineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineConfigurationIdentifier(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnEngineConfigurationIdentifier) {
    this.filterOnEngineConfigurationIdentifier = filterOnEngineConfigurationIdentifier;
  }

  public ChartDetailsAuthenticatedEntity filterOnCountryGeoNameId(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnCountryGeoNameId) {
    
    this.filterOnCountryGeoNameId = filterOnCountryGeoNameId;
    return this;
  }

  /**
   * Filter on country geoNameId. Which country is the traveler from.
   * @return filterOnCountryGeoNameId
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnCountryGeoNameId() {
    return filterOnCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnCountryGeoNameId(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnCountryGeoNameId) {
    this.filterOnCountryGeoNameId = filterOnCountryGeoNameId;
  }

  public ChartDetailsAuthenticatedEntity filterOnCityGeoNameId(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnCityGeoNameId) {
    
    this.filterOnCityGeoNameId = filterOnCityGeoNameId;
    return this;
  }

  /**
   * Filter on city geoNameId. Which city is the traveler from.
   * @return filterOnCityGeoNameId
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnCityGeoNameId() {
    return filterOnCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnCityGeoNameId(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnCityGeoNameId) {
    this.filterOnCityGeoNameId = filterOnCityGeoNameId;
  }

  public ChartDetailsAuthenticatedEntity filterOnContinentCode(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnContinentCode) {
    
    this.filterOnContinentCode = filterOnContinentCode;
    return this;
  }

  /**
   * Filter on continent. Which continent is the traveler from.
   * @return filterOnContinentCode
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnContinentCode() {
    return filterOnContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnContinentCode(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnContinentCode) {
    this.filterOnContinentCode = filterOnContinentCode;
  }

  public ChartDetailsAuthenticatedEntity filterOnUserIdentifier(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnUserIdentifier) {
    
    this.filterOnUserIdentifier = filterOnUserIdentifier;
    return this;
  }

  /**
   * Filter on user identifier. Which authenticated user made the booking.
   * @return filterOnUserIdentifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnUserIdentifier() {
    return filterOnUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnUserIdentifier(@jakarta.annotation.Nullable KeyValuePairAuthenticatedEntity filterOnUserIdentifier) {
    this.filterOnUserIdentifier = filterOnUserIdentifier;
  }

  public ChartDetailsAuthenticatedEntity sortOnPageVisits(@jakarta.annotation.Nullable Boolean sortOnPageVisits) {
    
    this.sortOnPageVisits = sortOnPageVisits;
    return this;
  }

  /**
   * Sort on page visits
   * @return sortOnPageVisits
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPageVisits() {
    return sortOnPageVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPageVisits(@jakarta.annotation.Nullable Boolean sortOnPageVisits) {
    this.sortOnPageVisits = sortOnPageVisits;
  }

  public ChartDetailsAuthenticatedEntity sortOnMapMarkerVisits(@jakarta.annotation.Nullable Boolean sortOnMapMarkerVisits) {
    
    this.sortOnMapMarkerVisits = sortOnMapMarkerVisits;
    return this;
  }

  /**
   * Sort on map marker visits
   * @return sortOnMapMarkerVisits
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMapMarkerVisits() {
    return sortOnMapMarkerVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMapMarkerVisits(@jakarta.annotation.Nullable Boolean sortOnMapMarkerVisits) {
    this.sortOnMapMarkerVisits = sortOnMapMarkerVisits;
  }

  public ChartDetailsAuthenticatedEntity sortOnCardVisits(@jakarta.annotation.Nullable Boolean sortOnCardVisits) {
    
    this.sortOnCardVisits = sortOnCardVisits;
    return this;
  }

  /**
   * Sort on card visits
   * @return sortOnCardVisits
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCardVisits() {
    return sortOnCardVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCardVisits(@jakarta.annotation.Nullable Boolean sortOnCardVisits) {
    this.sortOnCardVisits = sortOnCardVisits;
  }

  public ChartDetailsAuthenticatedEntity sortOnBookings(@jakarta.annotation.Nullable Boolean sortOnBookings) {
    
    this.sortOnBookings = sortOnBookings;
    return this;
  }

  /**
   * Sort on bookings
   * @return sortOnBookings
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnBookings() {
    return sortOnBookings;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnBookings(@jakarta.annotation.Nullable Boolean sortOnBookings) {
    this.sortOnBookings = sortOnBookings;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancellations(@jakarta.annotation.Nullable Boolean sortOnCancellations) {
    
    this.sortOnCancellations = sortOnCancellations;
    return this;
  }

  /**
   * Sort on cancellations
   * @return sortOnCancellations
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancellations() {
    return sortOnCancellations;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancellations(@jakarta.annotation.Nullable Boolean sortOnCancellations) {
    this.sortOnCancellations = sortOnCancellations;
  }

  public ChartDetailsAuthenticatedEntity sortOnRoomNights(@jakarta.annotation.Nullable Boolean sortOnRoomNights) {
    
    this.sortOnRoomNights = sortOnRoomNights;
    return this;
  }

  /**
   * Sort on room nights
   * @return sortOnRoomNights
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRoomNights() {
    return sortOnRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRoomNights(@jakarta.annotation.Nullable Boolean sortOnRoomNights) {
    this.sortOnRoomNights = sortOnRoomNights;
  }

  public ChartDetailsAuthenticatedEntity sortOnMeetingRooms(@jakarta.annotation.Nullable Boolean sortOnMeetingRooms) {
    
    this.sortOnMeetingRooms = sortOnMeetingRooms;
    return this;
  }

  /**
   * Sort on meeting rooms
   * @return sortOnMeetingRooms
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMeetingRooms() {
    return sortOnMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMeetingRooms(@jakarta.annotation.Nullable Boolean sortOnMeetingRooms) {
    this.sortOnMeetingRooms = sortOnMeetingRooms;
  }

  public ChartDetailsAuthenticatedEntity sortOnMeetingRoomsRevenue(@jakarta.annotation.Nullable Boolean sortOnMeetingRoomsRevenue) {
    
    this.sortOnMeetingRoomsRevenue = sortOnMeetingRoomsRevenue;
    return this;
  }

  /**
   * Sort on meeting rooms revenue
   * @return sortOnMeetingRoomsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMeetingRoomsRevenue() {
    return sortOnMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMeetingRoomsRevenue(@jakarta.annotation.Nullable Boolean sortOnMeetingRoomsRevenue) {
    this.sortOnMeetingRoomsRevenue = sortOnMeetingRoomsRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnRestaurants(@jakarta.annotation.Nullable Boolean sortOnRestaurants) {
    
    this.sortOnRestaurants = sortOnRestaurants;
    return this;
  }

  /**
   * Sort on restaurants
   * @return sortOnRestaurants
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRestaurants() {
    return sortOnRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRestaurants(@jakarta.annotation.Nullable Boolean sortOnRestaurants) {
    this.sortOnRestaurants = sortOnRestaurants;
  }

  public ChartDetailsAuthenticatedEntity sortOnRestaurantsRevenue(@jakarta.annotation.Nullable Boolean sortOnRestaurantsRevenue) {
    
    this.sortOnRestaurantsRevenue = sortOnRestaurantsRevenue;
    return this;
  }

  /**
   * Sort on restaurants revenue
   * @return sortOnRestaurantsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRestaurantsRevenue() {
    return sortOnRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRestaurantsRevenue(@jakarta.annotation.Nullable Boolean sortOnRestaurantsRevenue) {
    this.sortOnRestaurantsRevenue = sortOnRestaurantsRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnSpas(@jakarta.annotation.Nullable Boolean sortOnSpas) {
    
    this.sortOnSpas = sortOnSpas;
    return this;
  }

  /**
   * Sort on spas
   * @return sortOnSpas
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnSpas() {
    return sortOnSpas;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnSpas(@jakarta.annotation.Nullable Boolean sortOnSpas) {
    this.sortOnSpas = sortOnSpas;
  }

  public ChartDetailsAuthenticatedEntity sortOnSpasRevenue(@jakarta.annotation.Nullable Boolean sortOnSpasRevenue) {
    
    this.sortOnSpasRevenue = sortOnSpasRevenue;
    return this;
  }

  /**
   * Sort on spas revenue
   * @return sortOnSpasRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnSpasRevenue() {
    return sortOnSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnSpasRevenue(@jakarta.annotation.Nullable Boolean sortOnSpasRevenue) {
    this.sortOnSpasRevenue = sortOnSpasRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnActivities(@jakarta.annotation.Nullable Boolean sortOnActivities) {
    
    this.sortOnActivities = sortOnActivities;
    return this;
  }

  /**
   * Sort on activities
   * @return sortOnActivities
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnActivities() {
    return sortOnActivities;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnActivities(@jakarta.annotation.Nullable Boolean sortOnActivities) {
    this.sortOnActivities = sortOnActivities;
  }

  public ChartDetailsAuthenticatedEntity sortOnActivitiesRevenue(@jakarta.annotation.Nullable Boolean sortOnActivitiesRevenue) {
    
    this.sortOnActivitiesRevenue = sortOnActivitiesRevenue;
    return this;
  }

  /**
   * Sort on activities revenue
   * @return sortOnActivitiesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnActivitiesRevenue() {
    return sortOnActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnActivitiesRevenue(@jakarta.annotation.Nullable Boolean sortOnActivitiesRevenue) {
    this.sortOnActivitiesRevenue = sortOnActivitiesRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnAttractions(@jakarta.annotation.Nullable Boolean sortOnAttractions) {
    
    this.sortOnAttractions = sortOnAttractions;
    return this;
  }

  /**
   * Sort on attractions
   * @return sortOnAttractions
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAttractions() {
    return sortOnAttractions;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAttractions(@jakarta.annotation.Nullable Boolean sortOnAttractions) {
    this.sortOnAttractions = sortOnAttractions;
  }

  public ChartDetailsAuthenticatedEntity sortOnAttractionsRevenue(@jakarta.annotation.Nullable Boolean sortOnAttractionsRevenue) {
    
    this.sortOnAttractionsRevenue = sortOnAttractionsRevenue;
    return this;
  }

  /**
   * Sort on attractions revenue
   * @return sortOnAttractionsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAttractionsRevenue() {
    return sortOnAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAttractionsRevenue(@jakarta.annotation.Nullable Boolean sortOnAttractionsRevenue) {
    this.sortOnAttractionsRevenue = sortOnAttractionsRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnPlaces(@jakarta.annotation.Nullable Boolean sortOnPlaces) {
    
    this.sortOnPlaces = sortOnPlaces;
    return this;
  }

  /**
   * Sort on places
   * @return sortOnPlaces
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPlaces() {
    return sortOnPlaces;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPlaces(@jakarta.annotation.Nullable Boolean sortOnPlaces) {
    this.sortOnPlaces = sortOnPlaces;
  }

  public ChartDetailsAuthenticatedEntity sortOnPlacesRevenue(@jakarta.annotation.Nullable Boolean sortOnPlacesRevenue) {
    
    this.sortOnPlacesRevenue = sortOnPlacesRevenue;
    return this;
  }

  /**
   * Sort on places revenue
   * @return sortOnPlacesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPlacesRevenue() {
    return sortOnPlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPlacesRevenue(@jakarta.annotation.Nullable Boolean sortOnPlacesRevenue) {
    this.sortOnPlacesRevenue = sortOnPlacesRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnRoomTypeAncillaries(@jakarta.annotation.Nullable Boolean sortOnRoomTypeAncillaries) {
    
    this.sortOnRoomTypeAncillaries = sortOnRoomTypeAncillaries;
    return this;
  }

  /**
   * Sort on room type ancillaries
   * @return sortOnRoomTypeAncillaries
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRoomTypeAncillaries() {
    return sortOnRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRoomTypeAncillaries(@jakarta.annotation.Nullable Boolean sortOnRoomTypeAncillaries) {
    this.sortOnRoomTypeAncillaries = sortOnRoomTypeAncillaries;
  }

  public ChartDetailsAuthenticatedEntity sortOnRoomTypeAncillariesRevenue(@jakarta.annotation.Nullable Boolean sortOnRoomTypeAncillariesRevenue) {
    
    this.sortOnRoomTypeAncillariesRevenue = sortOnRoomTypeAncillariesRevenue;
    return this;
  }

  /**
   * Sort on room type ancillaries revenue
   * @return sortOnRoomTypeAncillariesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRoomTypeAncillariesRevenue() {
    return sortOnRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRoomTypeAncillariesRevenue(@jakarta.annotation.Nullable Boolean sortOnRoomTypeAncillariesRevenue) {
    this.sortOnRoomTypeAncillariesRevenue = sortOnRoomTypeAncillariesRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnAddOns(@jakarta.annotation.Nullable Boolean sortOnAddOns) {
    
    this.sortOnAddOns = sortOnAddOns;
    return this;
  }

  /**
   * Sort on add-ons
   * @return sortOnAddOns
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAddOns() {
    return sortOnAddOns;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAddOns(@jakarta.annotation.Nullable Boolean sortOnAddOns) {
    this.sortOnAddOns = sortOnAddOns;
  }

  public ChartDetailsAuthenticatedEntity sortOnAddonsRevenue(@jakarta.annotation.Nullable Boolean sortOnAddonsRevenue) {
    
    this.sortOnAddonsRevenue = sortOnAddonsRevenue;
    return this;
  }

  /**
   * Sort on add-on revenue
   * @return sortOnAddonsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAddonsRevenue() {
    return sortOnAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAddonsRevenue(@jakarta.annotation.Nullable Boolean sortOnAddonsRevenue) {
    this.sortOnAddonsRevenue = sortOnAddonsRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnTotalRoomRevenue(@jakarta.annotation.Nullable Boolean sortOnTotalRoomRevenue) {
    
    this.sortOnTotalRoomRevenue = sortOnTotalRoomRevenue;
    return this;
  }

  /**
   * Sort on total room revenue
   * @return sortOnTotalRoomRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalRoomRevenue() {
    return sortOnTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalRoomRevenue(@jakarta.annotation.Nullable Boolean sortOnTotalRoomRevenue) {
    this.sortOnTotalRoomRevenue = sortOnTotalRoomRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnTotalAncillariesRevenue(@jakarta.annotation.Nullable Boolean sortOnTotalAncillariesRevenue) {
    
    this.sortOnTotalAncillariesRevenue = sortOnTotalAncillariesRevenue;
    return this;
  }

  /**
   * Sort on aggregate ancillaries revenue
   * @return sortOnTotalAncillariesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalAncillariesRevenue() {
    return sortOnTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalAncillariesRevenue(@jakarta.annotation.Nullable Boolean sortOnTotalAncillariesRevenue) {
    this.sortOnTotalAncillariesRevenue = sortOnTotalAncillariesRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnTotalNetRevenue(@jakarta.annotation.Nullable Boolean sortOnTotalNetRevenue) {
    
    this.sortOnTotalNetRevenue = sortOnTotalNetRevenue;
    return this;
  }

  /**
   * Sort on total net revenue
   * @return sortOnTotalNetRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalNetRevenue() {
    return sortOnTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalNetRevenue(@jakarta.annotation.Nullable Boolean sortOnTotalNetRevenue) {
    this.sortOnTotalNetRevenue = sortOnTotalNetRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledRoomNights(@jakarta.annotation.Nullable Boolean sortOnCancelledRoomNights) {
    
    this.sortOnCancelledRoomNights = sortOnCancelledRoomNights;
    return this;
  }

  /**
   * Sort on cancelled room nights
   * @return sortOnCancelledRoomNights
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRoomNights() {
    return sortOnCancelledRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRoomNights(@jakarta.annotation.Nullable Boolean sortOnCancelledRoomNights) {
    this.sortOnCancelledRoomNights = sortOnCancelledRoomNights;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledMeetingRooms(@jakarta.annotation.Nullable Boolean sortOnCancelledMeetingRooms) {
    
    this.sortOnCancelledMeetingRooms = sortOnCancelledMeetingRooms;
    return this;
  }

  /**
   * Sort on cancelled meeting rooms
   * @return sortOnCancelledMeetingRooms
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledMeetingRooms() {
    return sortOnCancelledMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledMeetingRooms(@jakarta.annotation.Nullable Boolean sortOnCancelledMeetingRooms) {
    this.sortOnCancelledMeetingRooms = sortOnCancelledMeetingRooms;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledMeetingRoomsRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledMeetingRoomsRevenue) {
    
    this.sortOnCancelledMeetingRoomsRevenue = sortOnCancelledMeetingRoomsRevenue;
    return this;
  }

  /**
   * Sort on cancelled meeting rooms revenue
   * @return sortOnCancelledMeetingRoomsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledMeetingRoomsRevenue() {
    return sortOnCancelledMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledMeetingRoomsRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledMeetingRoomsRevenue) {
    this.sortOnCancelledMeetingRoomsRevenue = sortOnCancelledMeetingRoomsRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledRestaurants(@jakarta.annotation.Nullable Boolean sortOnCancelledRestaurants) {
    
    this.sortOnCancelledRestaurants = sortOnCancelledRestaurants;
    return this;
  }

  /**
   * Sort on cancelled restaurants
   * @return sortOnCancelledRestaurants
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRestaurants() {
    return sortOnCancelledRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRestaurants(@jakarta.annotation.Nullable Boolean sortOnCancelledRestaurants) {
    this.sortOnCancelledRestaurants = sortOnCancelledRestaurants;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledRestaurantsRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledRestaurantsRevenue) {
    
    this.sortOnCancelledRestaurantsRevenue = sortOnCancelledRestaurantsRevenue;
    return this;
  }

  /**
   * Sort on cancelled restaurants revenue
   * @return sortOnCancelledRestaurantsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRestaurantsRevenue() {
    return sortOnCancelledRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRestaurantsRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledRestaurantsRevenue) {
    this.sortOnCancelledRestaurantsRevenue = sortOnCancelledRestaurantsRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledSpas(@jakarta.annotation.Nullable Boolean sortOnCancelledSpas) {
    
    this.sortOnCancelledSpas = sortOnCancelledSpas;
    return this;
  }

  /**
   * Sort on cancelled spas
   * @return sortOnCancelledSpas
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledSpas() {
    return sortOnCancelledSpas;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledSpas(@jakarta.annotation.Nullable Boolean sortOnCancelledSpas) {
    this.sortOnCancelledSpas = sortOnCancelledSpas;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledSpasRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledSpasRevenue) {
    
    this.sortOnCancelledSpasRevenue = sortOnCancelledSpasRevenue;
    return this;
  }

  /**
   * Sort on cancelled spas revenue
   * @return sortOnCancelledSpasRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledSpasRevenue() {
    return sortOnCancelledSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledSpasRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledSpasRevenue) {
    this.sortOnCancelledSpasRevenue = sortOnCancelledSpasRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledActivities(@jakarta.annotation.Nullable Boolean sortOnCancelledActivities) {
    
    this.sortOnCancelledActivities = sortOnCancelledActivities;
    return this;
  }

  /**
   * Sort on cancelled activities
   * @return sortOnCancelledActivities
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledActivities() {
    return sortOnCancelledActivities;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledActivities(@jakarta.annotation.Nullable Boolean sortOnCancelledActivities) {
    this.sortOnCancelledActivities = sortOnCancelledActivities;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledActivitiesRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledActivitiesRevenue) {
    
    this.sortOnCancelledActivitiesRevenue = sortOnCancelledActivitiesRevenue;
    return this;
  }

  /**
   * Sort on cancelled activities revenue
   * @return sortOnCancelledActivitiesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledActivitiesRevenue() {
    return sortOnCancelledActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledActivitiesRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledActivitiesRevenue) {
    this.sortOnCancelledActivitiesRevenue = sortOnCancelledActivitiesRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledAttractions(@jakarta.annotation.Nullable Boolean sortOnCancelledAttractions) {
    
    this.sortOnCancelledAttractions = sortOnCancelledAttractions;
    return this;
  }

  /**
   * Sort on cancelled attractions
   * @return sortOnCancelledAttractions
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAttractions() {
    return sortOnCancelledAttractions;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAttractions(@jakarta.annotation.Nullable Boolean sortOnCancelledAttractions) {
    this.sortOnCancelledAttractions = sortOnCancelledAttractions;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledAttractionsRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledAttractionsRevenue) {
    
    this.sortOnCancelledAttractionsRevenue = sortOnCancelledAttractionsRevenue;
    return this;
  }

  /**
   * Sort on cancelled attractions revenue
   * @return sortOnCancelledAttractionsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAttractionsRevenue() {
    return sortOnCancelledAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAttractionsRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledAttractionsRevenue) {
    this.sortOnCancelledAttractionsRevenue = sortOnCancelledAttractionsRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledPlaces(@jakarta.annotation.Nullable Boolean sortOnCancelledPlaces) {
    
    this.sortOnCancelledPlaces = sortOnCancelledPlaces;
    return this;
  }

  /**
   * Sort on cancelled places
   * @return sortOnCancelledPlaces
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledPlaces() {
    return sortOnCancelledPlaces;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledPlaces(@jakarta.annotation.Nullable Boolean sortOnCancelledPlaces) {
    this.sortOnCancelledPlaces = sortOnCancelledPlaces;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledPlacesRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledPlacesRevenue) {
    
    this.sortOnCancelledPlacesRevenue = sortOnCancelledPlacesRevenue;
    return this;
  }

  /**
   * Sort on cancelled places revenue
   * @return sortOnCancelledPlacesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledPlacesRevenue() {
    return sortOnCancelledPlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledPlacesRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledPlacesRevenue) {
    this.sortOnCancelledPlacesRevenue = sortOnCancelledPlacesRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledTotalRoomRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledTotalRoomRevenue) {
    
    this.sortOnCancelledTotalRoomRevenue = sortOnCancelledTotalRoomRevenue;
    return this;
  }

  /**
   * Sort on cancelled total room revenue
   * @return sortOnCancelledTotalRoomRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalRoomRevenue() {
    return sortOnCancelledTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalRoomRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledTotalRoomRevenue) {
    this.sortOnCancelledTotalRoomRevenue = sortOnCancelledTotalRoomRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledTotalAncillariesRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledTotalAncillariesRevenue) {
    
    this.sortOnCancelledTotalAncillariesRevenue = sortOnCancelledTotalAncillariesRevenue;
    return this;
  }

  /**
   * Sort on cancelled aggregate total ancillaries revenue
   * @return sortOnCancelledTotalAncillariesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalAncillariesRevenue() {
    return sortOnCancelledTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalAncillariesRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledTotalAncillariesRevenue) {
    this.sortOnCancelledTotalAncillariesRevenue = sortOnCancelledTotalAncillariesRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledRoomTypeAncillaries(@jakarta.annotation.Nullable Boolean sortOnCancelledRoomTypeAncillaries) {
    
    this.sortOnCancelledRoomTypeAncillaries = sortOnCancelledRoomTypeAncillaries;
    return this;
  }

  /**
   * Sort on cancelled room type ancillaries
   * @return sortOnCancelledRoomTypeAncillaries
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRoomTypeAncillaries() {
    return sortOnCancelledRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRoomTypeAncillaries(@jakarta.annotation.Nullable Boolean sortOnCancelledRoomTypeAncillaries) {
    this.sortOnCancelledRoomTypeAncillaries = sortOnCancelledRoomTypeAncillaries;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledRoomTypeAncillariesRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledRoomTypeAncillariesRevenue) {
    
    this.sortOnCancelledRoomTypeAncillariesRevenue = sortOnCancelledRoomTypeAncillariesRevenue;
    return this;
  }

  /**
   * Sort on cancelled room type ancillaries revenue
   * @return sortOnCancelledRoomTypeAncillariesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRoomTypeAncillariesRevenue() {
    return sortOnCancelledRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRoomTypeAncillariesRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledRoomTypeAncillariesRevenue) {
    this.sortOnCancelledRoomTypeAncillariesRevenue = sortOnCancelledRoomTypeAncillariesRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledAddOns(@jakarta.annotation.Nullable Boolean sortOnCancelledAddOns) {
    
    this.sortOnCancelledAddOns = sortOnCancelledAddOns;
    return this;
  }

  /**
   * Sort on cancelled add-ons
   * @return sortOnCancelledAddOns
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAddOns() {
    return sortOnCancelledAddOns;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAddOns(@jakarta.annotation.Nullable Boolean sortOnCancelledAddOns) {
    this.sortOnCancelledAddOns = sortOnCancelledAddOns;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledAddonsRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledAddonsRevenue) {
    
    this.sortOnCancelledAddonsRevenue = sortOnCancelledAddonsRevenue;
    return this;
  }

  /**
   * Sort on cancelled add-o revenue
   * @return sortOnCancelledAddonsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAddonsRevenue() {
    return sortOnCancelledAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAddonsRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledAddonsRevenue) {
    this.sortOnCancelledAddonsRevenue = sortOnCancelledAddonsRevenue;
  }

  public ChartDetailsAuthenticatedEntity sortOnCancelledTotalNetRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledTotalNetRevenue) {
    
    this.sortOnCancelledTotalNetRevenue = sortOnCancelledTotalNetRevenue;
    return this;
  }

  /**
   * Sort on cancelled total net revenue
   * @return sortOnCancelledTotalNetRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalNetRevenue() {
    return sortOnCancelledTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalNetRevenue(@jakarta.annotation.Nullable Boolean sortOnCancelledTotalNetRevenue) {
    this.sortOnCancelledTotalNetRevenue = sortOnCancelledTotalNetRevenue;
  }

  public ChartDetailsAuthenticatedEntity includePageVisits(@jakarta.annotation.Nullable Boolean includePageVisits) {
    
    this.includePageVisits = includePageVisits;
    return this;
  }

  /**
   * Include page visits
   * @return includePageVisits
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePageVisits() {
    return includePageVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePageVisits(@jakarta.annotation.Nullable Boolean includePageVisits) {
    this.includePageVisits = includePageVisits;
  }

  public ChartDetailsAuthenticatedEntity includeMapMarkerVisits(@jakarta.annotation.Nullable Boolean includeMapMarkerVisits) {
    
    this.includeMapMarkerVisits = includeMapMarkerVisits;
    return this;
  }

  /**
   * Include map marker visits
   * @return includeMapMarkerVisits
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMapMarkerVisits() {
    return includeMapMarkerVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMapMarkerVisits(@jakarta.annotation.Nullable Boolean includeMapMarkerVisits) {
    this.includeMapMarkerVisits = includeMapMarkerVisits;
  }

  public ChartDetailsAuthenticatedEntity includeCardVisits(@jakarta.annotation.Nullable Boolean includeCardVisits) {
    
    this.includeCardVisits = includeCardVisits;
    return this;
  }

  /**
   * Include card visits
   * @return includeCardVisits
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCardVisits() {
    return includeCardVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCardVisits(@jakarta.annotation.Nullable Boolean includeCardVisits) {
    this.includeCardVisits = includeCardVisits;
  }

  public ChartDetailsAuthenticatedEntity includeBookings(@jakarta.annotation.Nullable Boolean includeBookings) {
    
    this.includeBookings = includeBookings;
    return this;
  }

  /**
   * Include bookings
   * @return includeBookings
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeBookings() {
    return includeBookings;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeBookings(@jakarta.annotation.Nullable Boolean includeBookings) {
    this.includeBookings = includeBookings;
  }

  public ChartDetailsAuthenticatedEntity includeCancellations(@jakarta.annotation.Nullable Boolean includeCancellations) {
    
    this.includeCancellations = includeCancellations;
    return this;
  }

  /**
   * Include cancellations
   * @return includeCancellations
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancellations() {
    return includeCancellations;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancellations(@jakarta.annotation.Nullable Boolean includeCancellations) {
    this.includeCancellations = includeCancellations;
  }

  public ChartDetailsAuthenticatedEntity includeRoomNights(@jakarta.annotation.Nullable Boolean includeRoomNights) {
    
    this.includeRoomNights = includeRoomNights;
    return this;
  }

  /**
   * Include room nights
   * @return includeRoomNights
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRoomNights() {
    return includeRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRoomNights(@jakarta.annotation.Nullable Boolean includeRoomNights) {
    this.includeRoomNights = includeRoomNights;
  }

  public ChartDetailsAuthenticatedEntity includeMeetingRooms(@jakarta.annotation.Nullable Boolean includeMeetingRooms) {
    
    this.includeMeetingRooms = includeMeetingRooms;
    return this;
  }

  /**
   * Include meeting rooms
   * @return includeMeetingRooms
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMeetingRooms() {
    return includeMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMeetingRooms(@jakarta.annotation.Nullable Boolean includeMeetingRooms) {
    this.includeMeetingRooms = includeMeetingRooms;
  }

  public ChartDetailsAuthenticatedEntity includeMeetingRoomsRevenue(@jakarta.annotation.Nullable Boolean includeMeetingRoomsRevenue) {
    
    this.includeMeetingRoomsRevenue = includeMeetingRoomsRevenue;
    return this;
  }

  /**
   * Include meeting rooms revenue
   * @return includeMeetingRoomsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMeetingRoomsRevenue() {
    return includeMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMeetingRoomsRevenue(@jakarta.annotation.Nullable Boolean includeMeetingRoomsRevenue) {
    this.includeMeetingRoomsRevenue = includeMeetingRoomsRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeRestaurants(@jakarta.annotation.Nullable Boolean includeRestaurants) {
    
    this.includeRestaurants = includeRestaurants;
    return this;
  }

  /**
   * Include restaurants
   * @return includeRestaurants
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRestaurants() {
    return includeRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRestaurants(@jakarta.annotation.Nullable Boolean includeRestaurants) {
    this.includeRestaurants = includeRestaurants;
  }

  public ChartDetailsAuthenticatedEntity includeRestaurantsRevenue(@jakarta.annotation.Nullable Boolean includeRestaurantsRevenue) {
    
    this.includeRestaurantsRevenue = includeRestaurantsRevenue;
    return this;
  }

  /**
   * Include restaurants revenue
   * @return includeRestaurantsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRestaurantsRevenue() {
    return includeRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRestaurantsRevenue(@jakarta.annotation.Nullable Boolean includeRestaurantsRevenue) {
    this.includeRestaurantsRevenue = includeRestaurantsRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeSpas(@jakarta.annotation.Nullable Boolean includeSpas) {
    
    this.includeSpas = includeSpas;
    return this;
  }

  /**
   * Include spas
   * @return includeSpas
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeSpas() {
    return includeSpas;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeSpas(@jakarta.annotation.Nullable Boolean includeSpas) {
    this.includeSpas = includeSpas;
  }

  public ChartDetailsAuthenticatedEntity includeSpasRevenue(@jakarta.annotation.Nullable Boolean includeSpasRevenue) {
    
    this.includeSpasRevenue = includeSpasRevenue;
    return this;
  }

  /**
   * Include spas revenue
   * @return includeSpasRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeSpasRevenue() {
    return includeSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeSpasRevenue(@jakarta.annotation.Nullable Boolean includeSpasRevenue) {
    this.includeSpasRevenue = includeSpasRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeActivities(@jakarta.annotation.Nullable Boolean includeActivities) {
    
    this.includeActivities = includeActivities;
    return this;
  }

  /**
   * Include activities
   * @return includeActivities
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeActivities() {
    return includeActivities;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeActivities(@jakarta.annotation.Nullable Boolean includeActivities) {
    this.includeActivities = includeActivities;
  }

  public ChartDetailsAuthenticatedEntity includeActivitiesRevenue(@jakarta.annotation.Nullable Boolean includeActivitiesRevenue) {
    
    this.includeActivitiesRevenue = includeActivitiesRevenue;
    return this;
  }

  /**
   * Include activities revenue
   * @return includeActivitiesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeActivitiesRevenue() {
    return includeActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeActivitiesRevenue(@jakarta.annotation.Nullable Boolean includeActivitiesRevenue) {
    this.includeActivitiesRevenue = includeActivitiesRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeAttractions(@jakarta.annotation.Nullable Boolean includeAttractions) {
    
    this.includeAttractions = includeAttractions;
    return this;
  }

  /**
   * Include attractions
   * @return includeAttractions
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAttractions() {
    return includeAttractions;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAttractions(@jakarta.annotation.Nullable Boolean includeAttractions) {
    this.includeAttractions = includeAttractions;
  }

  public ChartDetailsAuthenticatedEntity includeAttractionsRevenue(@jakarta.annotation.Nullable Boolean includeAttractionsRevenue) {
    
    this.includeAttractionsRevenue = includeAttractionsRevenue;
    return this;
  }

  /**
   * Include attractions revenue
   * @return includeAttractionsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAttractionsRevenue() {
    return includeAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAttractionsRevenue(@jakarta.annotation.Nullable Boolean includeAttractionsRevenue) {
    this.includeAttractionsRevenue = includeAttractionsRevenue;
  }

  public ChartDetailsAuthenticatedEntity includePlaces(@jakarta.annotation.Nullable Boolean includePlaces) {
    
    this.includePlaces = includePlaces;
    return this;
  }

  /**
   * Include places
   * @return includePlaces
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePlaces() {
    return includePlaces;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePlaces(@jakarta.annotation.Nullable Boolean includePlaces) {
    this.includePlaces = includePlaces;
  }

  public ChartDetailsAuthenticatedEntity includePlacesRevenue(@jakarta.annotation.Nullable Boolean includePlacesRevenue) {
    
    this.includePlacesRevenue = includePlacesRevenue;
    return this;
  }

  /**
   * Include places revenue
   * @return includePlacesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePlacesRevenue() {
    return includePlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePlacesRevenue(@jakarta.annotation.Nullable Boolean includePlacesRevenue) {
    this.includePlacesRevenue = includePlacesRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeRoomTypeAncillaries(@jakarta.annotation.Nullable Boolean includeRoomTypeAncillaries) {
    
    this.includeRoomTypeAncillaries = includeRoomTypeAncillaries;
    return this;
  }

  /**
   * Include room type ancillaries
   * @return includeRoomTypeAncillaries
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRoomTypeAncillaries() {
    return includeRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRoomTypeAncillaries(@jakarta.annotation.Nullable Boolean includeRoomTypeAncillaries) {
    this.includeRoomTypeAncillaries = includeRoomTypeAncillaries;
  }

  public ChartDetailsAuthenticatedEntity includeRoomTypeAncillariesRevenue(@jakarta.annotation.Nullable Boolean includeRoomTypeAncillariesRevenue) {
    
    this.includeRoomTypeAncillariesRevenue = includeRoomTypeAncillariesRevenue;
    return this;
  }

  /**
   * Include packages revenue
   * @return includeRoomTypeAncillariesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRoomTypeAncillariesRevenue() {
    return includeRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRoomTypeAncillariesRevenue(@jakarta.annotation.Nullable Boolean includeRoomTypeAncillariesRevenue) {
    this.includeRoomTypeAncillariesRevenue = includeRoomTypeAncillariesRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeAddOns(@jakarta.annotation.Nullable Boolean includeAddOns) {
    
    this.includeAddOns = includeAddOns;
    return this;
  }

  /**
   * Include add-ons
   * @return includeAddOns
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAddOns() {
    return includeAddOns;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAddOns(@jakarta.annotation.Nullable Boolean includeAddOns) {
    this.includeAddOns = includeAddOns;
  }

  public ChartDetailsAuthenticatedEntity includeAddOnsRevenue(@jakarta.annotation.Nullable Boolean includeAddOnsRevenue) {
    
    this.includeAddOnsRevenue = includeAddOnsRevenue;
    return this;
  }

  /**
   * Include add-ons revenue
   * @return includeAddOnsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAddOnsRevenue() {
    return includeAddOnsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAddOnsRevenue(@jakarta.annotation.Nullable Boolean includeAddOnsRevenue) {
    this.includeAddOnsRevenue = includeAddOnsRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeTotalRoomRevenue(@jakarta.annotation.Nullable Boolean includeTotalRoomRevenue) {
    
    this.includeTotalRoomRevenue = includeTotalRoomRevenue;
    return this;
  }

  /**
   * Include total room revenue
   * @return includeTotalRoomRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalRoomRevenue() {
    return includeTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalRoomRevenue(@jakarta.annotation.Nullable Boolean includeTotalRoomRevenue) {
    this.includeTotalRoomRevenue = includeTotalRoomRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeAverageRoomRate(@jakarta.annotation.Nullable Boolean includeAverageRoomRate) {
    
    this.includeAverageRoomRate = includeAverageRoomRate;
    return this;
  }

  /**
   * Include average room rate
   * @return includeAverageRoomRate
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAverageRoomRate() {
    return includeAverageRoomRate;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAverageRoomRate(@jakarta.annotation.Nullable Boolean includeAverageRoomRate) {
    this.includeAverageRoomRate = includeAverageRoomRate;
  }

  public ChartDetailsAuthenticatedEntity includeTotalAncillariesRevenue(@jakarta.annotation.Nullable Boolean includeTotalAncillariesRevenue) {
    
    this.includeTotalAncillariesRevenue = includeTotalAncillariesRevenue;
    return this;
  }

  /**
   * Include combined packages and add-os revenue
   * @return includeTotalAncillariesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalAncillariesRevenue() {
    return includeTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalAncillariesRevenue(@jakarta.annotation.Nullable Boolean includeTotalAncillariesRevenue) {
    this.includeTotalAncillariesRevenue = includeTotalAncillariesRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeTotalNetRevenue(@jakarta.annotation.Nullable Boolean includeTotalNetRevenue) {
    
    this.includeTotalNetRevenue = includeTotalNetRevenue;
    return this;
  }

  /**
   * Include total net revenue
   * @return includeTotalNetRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalNetRevenue() {
    return includeTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalNetRevenue(@jakarta.annotation.Nullable Boolean includeTotalNetRevenue) {
    this.includeTotalNetRevenue = includeTotalNetRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledRoomNights(@jakarta.annotation.Nullable Boolean includeCancelledRoomNights) {
    
    this.includeCancelledRoomNights = includeCancelledRoomNights;
    return this;
  }

  /**
   * Include cancelled room nights
   * @return includeCancelledRoomNights
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRoomNights() {
    return includeCancelledRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRoomNights(@jakarta.annotation.Nullable Boolean includeCancelledRoomNights) {
    this.includeCancelledRoomNights = includeCancelledRoomNights;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledMeetingRooms(@jakarta.annotation.Nullable Boolean includeCancelledMeetingRooms) {
    
    this.includeCancelledMeetingRooms = includeCancelledMeetingRooms;
    return this;
  }

  /**
   * Include cancelled meeting rooms
   * @return includeCancelledMeetingRooms
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledMeetingRooms() {
    return includeCancelledMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledMeetingRooms(@jakarta.annotation.Nullable Boolean includeCancelledMeetingRooms) {
    this.includeCancelledMeetingRooms = includeCancelledMeetingRooms;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledMeetingRoomsRevenue(@jakarta.annotation.Nullable Boolean includeCancelledMeetingRoomsRevenue) {
    
    this.includeCancelledMeetingRoomsRevenue = includeCancelledMeetingRoomsRevenue;
    return this;
  }

  /**
   * Include cancelled meeting rooms revenue
   * @return includeCancelledMeetingRoomsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledMeetingRoomsRevenue() {
    return includeCancelledMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledMeetingRoomsRevenue(@jakarta.annotation.Nullable Boolean includeCancelledMeetingRoomsRevenue) {
    this.includeCancelledMeetingRoomsRevenue = includeCancelledMeetingRoomsRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledRestaurants(@jakarta.annotation.Nullable Boolean includeCancelledRestaurants) {
    
    this.includeCancelledRestaurants = includeCancelledRestaurants;
    return this;
  }

  /**
   * Include cancelled restaurants
   * @return includeCancelledRestaurants
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRestaurants() {
    return includeCancelledRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRestaurants(@jakarta.annotation.Nullable Boolean includeCancelledRestaurants) {
    this.includeCancelledRestaurants = includeCancelledRestaurants;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledRestaurantsRevenue(@jakarta.annotation.Nullable Boolean includeCancelledRestaurantsRevenue) {
    
    this.includeCancelledRestaurantsRevenue = includeCancelledRestaurantsRevenue;
    return this;
  }

  /**
   * Include cancelled restaurants revenue
   * @return includeCancelledRestaurantsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRestaurantsRevenue() {
    return includeCancelledRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRestaurantsRevenue(@jakarta.annotation.Nullable Boolean includeCancelledRestaurantsRevenue) {
    this.includeCancelledRestaurantsRevenue = includeCancelledRestaurantsRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledSpas(@jakarta.annotation.Nullable Boolean includeCancelledSpas) {
    
    this.includeCancelledSpas = includeCancelledSpas;
    return this;
  }

  /**
   * Include cancelled spas
   * @return includeCancelledSpas
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledSpas() {
    return includeCancelledSpas;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledSpas(@jakarta.annotation.Nullable Boolean includeCancelledSpas) {
    this.includeCancelledSpas = includeCancelledSpas;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledSpasRevenue(@jakarta.annotation.Nullable Boolean includeCancelledSpasRevenue) {
    
    this.includeCancelledSpasRevenue = includeCancelledSpasRevenue;
    return this;
  }

  /**
   * Include cancelled spas revenue
   * @return includeCancelledSpasRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledSpasRevenue() {
    return includeCancelledSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledSpasRevenue(@jakarta.annotation.Nullable Boolean includeCancelledSpasRevenue) {
    this.includeCancelledSpasRevenue = includeCancelledSpasRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledActivities(@jakarta.annotation.Nullable Boolean includeCancelledActivities) {
    
    this.includeCancelledActivities = includeCancelledActivities;
    return this;
  }

  /**
   * Include cancelled activities
   * @return includeCancelledActivities
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledActivities() {
    return includeCancelledActivities;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledActivities(@jakarta.annotation.Nullable Boolean includeCancelledActivities) {
    this.includeCancelledActivities = includeCancelledActivities;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledActivitiesRevenue(@jakarta.annotation.Nullable Boolean includeCancelledActivitiesRevenue) {
    
    this.includeCancelledActivitiesRevenue = includeCancelledActivitiesRevenue;
    return this;
  }

  /**
   * Include cancelled activities revenue
   * @return includeCancelledActivitiesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledActivitiesRevenue() {
    return includeCancelledActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledActivitiesRevenue(@jakarta.annotation.Nullable Boolean includeCancelledActivitiesRevenue) {
    this.includeCancelledActivitiesRevenue = includeCancelledActivitiesRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledAttractions(@jakarta.annotation.Nullable Boolean includeCancelledAttractions) {
    
    this.includeCancelledAttractions = includeCancelledAttractions;
    return this;
  }

  /**
   * Include cancelled attractions
   * @return includeCancelledAttractions
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAttractions() {
    return includeCancelledAttractions;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAttractions(@jakarta.annotation.Nullable Boolean includeCancelledAttractions) {
    this.includeCancelledAttractions = includeCancelledAttractions;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledAttractionsRevenue(@jakarta.annotation.Nullable Boolean includeCancelledAttractionsRevenue) {
    
    this.includeCancelledAttractionsRevenue = includeCancelledAttractionsRevenue;
    return this;
  }

  /**
   * Include cancelled attractions revenue
   * @return includeCancelledAttractionsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAttractionsRevenue() {
    return includeCancelledAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAttractionsRevenue(@jakarta.annotation.Nullable Boolean includeCancelledAttractionsRevenue) {
    this.includeCancelledAttractionsRevenue = includeCancelledAttractionsRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledPlaces(@jakarta.annotation.Nullable Boolean includeCancelledPlaces) {
    
    this.includeCancelledPlaces = includeCancelledPlaces;
    return this;
  }

  /**
   * Include cancelled places
   * @return includeCancelledPlaces
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledPlaces() {
    return includeCancelledPlaces;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledPlaces(@jakarta.annotation.Nullable Boolean includeCancelledPlaces) {
    this.includeCancelledPlaces = includeCancelledPlaces;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledPlacesRevenue(@jakarta.annotation.Nullable Boolean includeCancelledPlacesRevenue) {
    
    this.includeCancelledPlacesRevenue = includeCancelledPlacesRevenue;
    return this;
  }

  /**
   * Include cancelled places revenue
   * @return includeCancelledPlacesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledPlacesRevenue() {
    return includeCancelledPlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledPlacesRevenue(@jakarta.annotation.Nullable Boolean includeCancelledPlacesRevenue) {
    this.includeCancelledPlacesRevenue = includeCancelledPlacesRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledRoomTypeAncillaries(@jakarta.annotation.Nullable Boolean includeCancelledRoomTypeAncillaries) {
    
    this.includeCancelledRoomTypeAncillaries = includeCancelledRoomTypeAncillaries;
    return this;
  }

  /**
   * Include cancelled packages
   * @return includeCancelledRoomTypeAncillaries
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRoomTypeAncillaries() {
    return includeCancelledRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRoomTypeAncillaries(@jakarta.annotation.Nullable Boolean includeCancelledRoomTypeAncillaries) {
    this.includeCancelledRoomTypeAncillaries = includeCancelledRoomTypeAncillaries;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledRoomTypeAncillariesRevenue(@jakarta.annotation.Nullable Boolean includeCancelledRoomTypeAncillariesRevenue) {
    
    this.includeCancelledRoomTypeAncillariesRevenue = includeCancelledRoomTypeAncillariesRevenue;
    return this;
  }

  /**
   * Include cancelled packages revenue
   * @return includeCancelledRoomTypeAncillariesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRoomTypeAncillariesRevenue() {
    return includeCancelledRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRoomTypeAncillariesRevenue(@jakarta.annotation.Nullable Boolean includeCancelledRoomTypeAncillariesRevenue) {
    this.includeCancelledRoomTypeAncillariesRevenue = includeCancelledRoomTypeAncillariesRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledAddOns(@jakarta.annotation.Nullable Boolean includeCancelledAddOns) {
    
    this.includeCancelledAddOns = includeCancelledAddOns;
    return this;
  }

  /**
   * Include cancelled add-ons
   * @return includeCancelledAddOns
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAddOns() {
    return includeCancelledAddOns;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAddOns(@jakarta.annotation.Nullable Boolean includeCancelledAddOns) {
    this.includeCancelledAddOns = includeCancelledAddOns;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledAddOnsRevenue(@jakarta.annotation.Nullable Boolean includeCancelledAddOnsRevenue) {
    
    this.includeCancelledAddOnsRevenue = includeCancelledAddOnsRevenue;
    return this;
  }

  /**
   * Include cancelled add-ons revenue
   * @return includeCancelledAddOnsRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAddOnsRevenue() {
    return includeCancelledAddOnsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAddOnsRevenue(@jakarta.annotation.Nullable Boolean includeCancelledAddOnsRevenue) {
    this.includeCancelledAddOnsRevenue = includeCancelledAddOnsRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledTotalRoomRevenue(@jakarta.annotation.Nullable Boolean includeCancelledTotalRoomRevenue) {
    
    this.includeCancelledTotalRoomRevenue = includeCancelledTotalRoomRevenue;
    return this;
  }

  /**
   * Include cancelled total room revenue
   * @return includeCancelledTotalRoomRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalRoomRevenue() {
    return includeCancelledTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalRoomRevenue(@jakarta.annotation.Nullable Boolean includeCancelledTotalRoomRevenue) {
    this.includeCancelledTotalRoomRevenue = includeCancelledTotalRoomRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledTotalAncillariesRevenue(@jakarta.annotation.Nullable Boolean includeCancelledTotalAncillariesRevenue) {
    
    this.includeCancelledTotalAncillariesRevenue = includeCancelledTotalAncillariesRevenue;
    return this;
  }

  /**
   * Include combined cancelled package and add-on revenue
   * @return includeCancelledTotalAncillariesRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalAncillariesRevenue() {
    return includeCancelledTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalAncillariesRevenue(@jakarta.annotation.Nullable Boolean includeCancelledTotalAncillariesRevenue) {
    this.includeCancelledTotalAncillariesRevenue = includeCancelledTotalAncillariesRevenue;
  }

  public ChartDetailsAuthenticatedEntity includeCancelledTotalNetRevenue(@jakarta.annotation.Nullable Boolean includeCancelledTotalNetRevenue) {
    
    this.includeCancelledTotalNetRevenue = includeCancelledTotalNetRevenue;
    return this;
  }

  /**
   * Include cancelled total net revenue
   * @return includeCancelledTotalNetRevenue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalNetRevenue() {
    return includeCancelledTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalNetRevenue(@jakarta.annotation.Nullable Boolean includeCancelledTotalNetRevenue) {
    this.includeCancelledTotalNetRevenue = includeCancelledTotalNetRevenue;
  }

  public ChartDetailsAuthenticatedEntity groupOnChannelSubType(@jakarta.annotation.Nullable Boolean groupOnChannelSubType) {
    
    this.groupOnChannelSubType = groupOnChannelSubType;
    return this;
  }

  /**
   * Group on  channel sub type
   * @return groupOnChannelSubType
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnChannelSubType() {
    return groupOnChannelSubType;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnChannelSubType(@jakarta.annotation.Nullable Boolean groupOnChannelSubType) {
    this.groupOnChannelSubType = groupOnChannelSubType;
  }

  public ChartDetailsAuthenticatedEntity groupOnOwnerIdentifier(@jakarta.annotation.Nullable Boolean groupOnOwnerIdentifier) {
    
    this.groupOnOwnerIdentifier = groupOnOwnerIdentifier;
    return this;
  }

  /**
   * Group on owner identifier
   * @return groupOnOwnerIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnOwnerIdentifier() {
    return groupOnOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnOwnerIdentifier(@jakarta.annotation.Nullable Boolean groupOnOwnerIdentifier) {
    this.groupOnOwnerIdentifier = groupOnOwnerIdentifier;
  }

  public ChartDetailsAuthenticatedEntity groupOnEngineCountryGeoNameId(@jakarta.annotation.Nullable Boolean groupOnEngineCountryGeoNameId) {
    
    this.groupOnEngineCountryGeoNameId = groupOnEngineCountryGeoNameId;
    return this;
  }

  /**
   * Group on application country geoNameId
   * @return groupOnEngineCountryGeoNameId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineCountryGeoNameId() {
    return groupOnEngineCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineCountryGeoNameId(@jakarta.annotation.Nullable Boolean groupOnEngineCountryGeoNameId) {
    this.groupOnEngineCountryGeoNameId = groupOnEngineCountryGeoNameId;
  }

  public ChartDetailsAuthenticatedEntity groupOnEngineCityGeoNameId(@jakarta.annotation.Nullable Boolean groupOnEngineCityGeoNameId) {
    
    this.groupOnEngineCityGeoNameId = groupOnEngineCityGeoNameId;
    return this;
  }

  /**
   * Group on application city geoNameId
   * @return groupOnEngineCityGeoNameId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineCityGeoNameId() {
    return groupOnEngineCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineCityGeoNameId(@jakarta.annotation.Nullable Boolean groupOnEngineCityGeoNameId) {
    this.groupOnEngineCityGeoNameId = groupOnEngineCityGeoNameId;
  }

  public ChartDetailsAuthenticatedEntity groupOnEngineContinentCode(@jakarta.annotation.Nullable Boolean groupOnEngineContinentCode) {
    
    this.groupOnEngineContinentCode = groupOnEngineContinentCode;
    return this;
  }

  /**
   * Group on application continent code
   * @return groupOnEngineContinentCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineContinentCode() {
    return groupOnEngineContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineContinentCode(@jakarta.annotation.Nullable Boolean groupOnEngineContinentCode) {
    this.groupOnEngineContinentCode = groupOnEngineContinentCode;
  }

  public ChartDetailsAuthenticatedEntity groupOnEngineConfigurationIdentifier(@jakarta.annotation.Nullable Boolean groupOnEngineConfigurationIdentifier) {
    
    this.groupOnEngineConfigurationIdentifier = groupOnEngineConfigurationIdentifier;
    return this;
  }

  /**
   * Group on customization identifier
   * @return groupOnEngineConfigurationIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineConfigurationIdentifier() {
    return groupOnEngineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineConfigurationIdentifier(@jakarta.annotation.Nullable Boolean groupOnEngineConfigurationIdentifier) {
    this.groupOnEngineConfigurationIdentifier = groupOnEngineConfigurationIdentifier;
  }

  public ChartDetailsAuthenticatedEntity groupOnCountryGeoNameId(@jakarta.annotation.Nullable Boolean groupOnCountryGeoNameId) {
    
    this.groupOnCountryGeoNameId = groupOnCountryGeoNameId;
    return this;
  }

  /**
   * Group on country geoNameId
   * @return groupOnCountryGeoNameId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnCountryGeoNameId() {
    return groupOnCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnCountryGeoNameId(@jakarta.annotation.Nullable Boolean groupOnCountryGeoNameId) {
    this.groupOnCountryGeoNameId = groupOnCountryGeoNameId;
  }

  public ChartDetailsAuthenticatedEntity groupOnCityGeoNameId(@jakarta.annotation.Nullable Boolean groupOnCityGeoNameId) {
    
    this.groupOnCityGeoNameId = groupOnCityGeoNameId;
    return this;
  }

  /**
   * Group on city geoNameId
   * @return groupOnCityGeoNameId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnCityGeoNameId() {
    return groupOnCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnCityGeoNameId(@jakarta.annotation.Nullable Boolean groupOnCityGeoNameId) {
    this.groupOnCityGeoNameId = groupOnCityGeoNameId;
  }

  public ChartDetailsAuthenticatedEntity groupOnContinentCode(@jakarta.annotation.Nullable Boolean groupOnContinentCode) {
    
    this.groupOnContinentCode = groupOnContinentCode;
    return this;
  }

  /**
   * Group on continent code
   * @return groupOnContinentCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnContinentCode() {
    return groupOnContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnContinentCode(@jakarta.annotation.Nullable Boolean groupOnContinentCode) {
    this.groupOnContinentCode = groupOnContinentCode;
  }

  public ChartDetailsAuthenticatedEntity groupOnHotelIdentifier(@jakarta.annotation.Nullable Boolean groupOnHotelIdentifier) {
    
    this.groupOnHotelIdentifier = groupOnHotelIdentifier;
    return this;
  }

  /**
   * Group on hotel identifier
   * @return groupOnHotelIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnHotelIdentifier() {
    return groupOnHotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnHotelIdentifier(@jakarta.annotation.Nullable Boolean groupOnHotelIdentifier) {
    this.groupOnHotelIdentifier = groupOnHotelIdentifier;
  }

  public ChartDetailsAuthenticatedEntity groupOnUserIdentifier(@jakarta.annotation.Nullable Boolean groupOnUserIdentifier) {
    
    this.groupOnUserIdentifier = groupOnUserIdentifier;
    return this;
  }

  /**
   * Group on user identifier
   * @return groupOnUserIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnUserIdentifier() {
    return groupOnUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnUserIdentifier(@jakarta.annotation.Nullable Boolean groupOnUserIdentifier) {
    this.groupOnUserIdentifier = groupOnUserIdentifier;
  }

  public ChartDetailsAuthenticatedEntity currencyCode(@jakarta.annotation.Nullable String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Currency code
   * @return currencyCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(@jakarta.annotation.Nullable String currencyCode) {
    this.currencyCode = currencyCode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChartDetailsAuthenticatedEntity chartDetailsAuthenticatedEntity = (ChartDetailsAuthenticatedEntity) o;
    return Objects.equals(this.series, chartDetailsAuthenticatedEntity.series) &&
        Objects.equals(this.timeSeriesUnits, chartDetailsAuthenticatedEntity.timeSeriesUnits) &&
        Objects.equals(this.startDate, chartDetailsAuthenticatedEntity.startDate) &&
        Objects.equals(this.endDate, chartDetailsAuthenticatedEntity.endDate) &&
        Objects.equals(this.filterOnHotelIdentifier, chartDetailsAuthenticatedEntity.filterOnHotelIdentifier) &&
        Objects.equals(this.filterOnChannelSubType, chartDetailsAuthenticatedEntity.filterOnChannelSubType) &&
        Objects.equals(this.filterOnOwnerIdentifier, chartDetailsAuthenticatedEntity.filterOnOwnerIdentifier) &&
        Objects.equals(this.filterOnEngineCountryGeoNameId, chartDetailsAuthenticatedEntity.filterOnEngineCountryGeoNameId) &&
        Objects.equals(this.filterOnEngineCityGeoNameId, chartDetailsAuthenticatedEntity.filterOnEngineCityGeoNameId) &&
        Objects.equals(this.filterOnEngineContinentCode, chartDetailsAuthenticatedEntity.filterOnEngineContinentCode) &&
        Objects.equals(this.filterOnEngineConfigurationIdentifier, chartDetailsAuthenticatedEntity.filterOnEngineConfigurationIdentifier) &&
        Objects.equals(this.filterOnCountryGeoNameId, chartDetailsAuthenticatedEntity.filterOnCountryGeoNameId) &&
        Objects.equals(this.filterOnCityGeoNameId, chartDetailsAuthenticatedEntity.filterOnCityGeoNameId) &&
        Objects.equals(this.filterOnContinentCode, chartDetailsAuthenticatedEntity.filterOnContinentCode) &&
        Objects.equals(this.filterOnUserIdentifier, chartDetailsAuthenticatedEntity.filterOnUserIdentifier) &&
        Objects.equals(this.sortOnPageVisits, chartDetailsAuthenticatedEntity.sortOnPageVisits) &&
        Objects.equals(this.sortOnMapMarkerVisits, chartDetailsAuthenticatedEntity.sortOnMapMarkerVisits) &&
        Objects.equals(this.sortOnCardVisits, chartDetailsAuthenticatedEntity.sortOnCardVisits) &&
        Objects.equals(this.sortOnBookings, chartDetailsAuthenticatedEntity.sortOnBookings) &&
        Objects.equals(this.sortOnCancellations, chartDetailsAuthenticatedEntity.sortOnCancellations) &&
        Objects.equals(this.sortOnRoomNights, chartDetailsAuthenticatedEntity.sortOnRoomNights) &&
        Objects.equals(this.sortOnMeetingRooms, chartDetailsAuthenticatedEntity.sortOnMeetingRooms) &&
        Objects.equals(this.sortOnMeetingRoomsRevenue, chartDetailsAuthenticatedEntity.sortOnMeetingRoomsRevenue) &&
        Objects.equals(this.sortOnRestaurants, chartDetailsAuthenticatedEntity.sortOnRestaurants) &&
        Objects.equals(this.sortOnRestaurantsRevenue, chartDetailsAuthenticatedEntity.sortOnRestaurantsRevenue) &&
        Objects.equals(this.sortOnSpas, chartDetailsAuthenticatedEntity.sortOnSpas) &&
        Objects.equals(this.sortOnSpasRevenue, chartDetailsAuthenticatedEntity.sortOnSpasRevenue) &&
        Objects.equals(this.sortOnActivities, chartDetailsAuthenticatedEntity.sortOnActivities) &&
        Objects.equals(this.sortOnActivitiesRevenue, chartDetailsAuthenticatedEntity.sortOnActivitiesRevenue) &&
        Objects.equals(this.sortOnAttractions, chartDetailsAuthenticatedEntity.sortOnAttractions) &&
        Objects.equals(this.sortOnAttractionsRevenue, chartDetailsAuthenticatedEntity.sortOnAttractionsRevenue) &&
        Objects.equals(this.sortOnPlaces, chartDetailsAuthenticatedEntity.sortOnPlaces) &&
        Objects.equals(this.sortOnPlacesRevenue, chartDetailsAuthenticatedEntity.sortOnPlacesRevenue) &&
        Objects.equals(this.sortOnRoomTypeAncillaries, chartDetailsAuthenticatedEntity.sortOnRoomTypeAncillaries) &&
        Objects.equals(this.sortOnRoomTypeAncillariesRevenue, chartDetailsAuthenticatedEntity.sortOnRoomTypeAncillariesRevenue) &&
        Objects.equals(this.sortOnAddOns, chartDetailsAuthenticatedEntity.sortOnAddOns) &&
        Objects.equals(this.sortOnAddonsRevenue, chartDetailsAuthenticatedEntity.sortOnAddonsRevenue) &&
        Objects.equals(this.sortOnTotalRoomRevenue, chartDetailsAuthenticatedEntity.sortOnTotalRoomRevenue) &&
        Objects.equals(this.sortOnTotalAncillariesRevenue, chartDetailsAuthenticatedEntity.sortOnTotalAncillariesRevenue) &&
        Objects.equals(this.sortOnTotalNetRevenue, chartDetailsAuthenticatedEntity.sortOnTotalNetRevenue) &&
        Objects.equals(this.sortOnCancelledRoomNights, chartDetailsAuthenticatedEntity.sortOnCancelledRoomNights) &&
        Objects.equals(this.sortOnCancelledMeetingRooms, chartDetailsAuthenticatedEntity.sortOnCancelledMeetingRooms) &&
        Objects.equals(this.sortOnCancelledMeetingRoomsRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledMeetingRoomsRevenue) &&
        Objects.equals(this.sortOnCancelledRestaurants, chartDetailsAuthenticatedEntity.sortOnCancelledRestaurants) &&
        Objects.equals(this.sortOnCancelledRestaurantsRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledRestaurantsRevenue) &&
        Objects.equals(this.sortOnCancelledSpas, chartDetailsAuthenticatedEntity.sortOnCancelledSpas) &&
        Objects.equals(this.sortOnCancelledSpasRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledSpasRevenue) &&
        Objects.equals(this.sortOnCancelledActivities, chartDetailsAuthenticatedEntity.sortOnCancelledActivities) &&
        Objects.equals(this.sortOnCancelledActivitiesRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledActivitiesRevenue) &&
        Objects.equals(this.sortOnCancelledAttractions, chartDetailsAuthenticatedEntity.sortOnCancelledAttractions) &&
        Objects.equals(this.sortOnCancelledAttractionsRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledAttractionsRevenue) &&
        Objects.equals(this.sortOnCancelledPlaces, chartDetailsAuthenticatedEntity.sortOnCancelledPlaces) &&
        Objects.equals(this.sortOnCancelledPlacesRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledPlacesRevenue) &&
        Objects.equals(this.sortOnCancelledTotalRoomRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledTotalRoomRevenue) &&
        Objects.equals(this.sortOnCancelledTotalAncillariesRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledTotalAncillariesRevenue) &&
        Objects.equals(this.sortOnCancelledRoomTypeAncillaries, chartDetailsAuthenticatedEntity.sortOnCancelledRoomTypeAncillaries) &&
        Objects.equals(this.sortOnCancelledRoomTypeAncillariesRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledRoomTypeAncillariesRevenue) &&
        Objects.equals(this.sortOnCancelledAddOns, chartDetailsAuthenticatedEntity.sortOnCancelledAddOns) &&
        Objects.equals(this.sortOnCancelledAddonsRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledAddonsRevenue) &&
        Objects.equals(this.sortOnCancelledTotalNetRevenue, chartDetailsAuthenticatedEntity.sortOnCancelledTotalNetRevenue) &&
        Objects.equals(this.includePageVisits, chartDetailsAuthenticatedEntity.includePageVisits) &&
        Objects.equals(this.includeMapMarkerVisits, chartDetailsAuthenticatedEntity.includeMapMarkerVisits) &&
        Objects.equals(this.includeCardVisits, chartDetailsAuthenticatedEntity.includeCardVisits) &&
        Objects.equals(this.includeBookings, chartDetailsAuthenticatedEntity.includeBookings) &&
        Objects.equals(this.includeCancellations, chartDetailsAuthenticatedEntity.includeCancellations) &&
        Objects.equals(this.includeRoomNights, chartDetailsAuthenticatedEntity.includeRoomNights) &&
        Objects.equals(this.includeMeetingRooms, chartDetailsAuthenticatedEntity.includeMeetingRooms) &&
        Objects.equals(this.includeMeetingRoomsRevenue, chartDetailsAuthenticatedEntity.includeMeetingRoomsRevenue) &&
        Objects.equals(this.includeRestaurants, chartDetailsAuthenticatedEntity.includeRestaurants) &&
        Objects.equals(this.includeRestaurantsRevenue, chartDetailsAuthenticatedEntity.includeRestaurantsRevenue) &&
        Objects.equals(this.includeSpas, chartDetailsAuthenticatedEntity.includeSpas) &&
        Objects.equals(this.includeSpasRevenue, chartDetailsAuthenticatedEntity.includeSpasRevenue) &&
        Objects.equals(this.includeActivities, chartDetailsAuthenticatedEntity.includeActivities) &&
        Objects.equals(this.includeActivitiesRevenue, chartDetailsAuthenticatedEntity.includeActivitiesRevenue) &&
        Objects.equals(this.includeAttractions, chartDetailsAuthenticatedEntity.includeAttractions) &&
        Objects.equals(this.includeAttractionsRevenue, chartDetailsAuthenticatedEntity.includeAttractionsRevenue) &&
        Objects.equals(this.includePlaces, chartDetailsAuthenticatedEntity.includePlaces) &&
        Objects.equals(this.includePlacesRevenue, chartDetailsAuthenticatedEntity.includePlacesRevenue) &&
        Objects.equals(this.includeRoomTypeAncillaries, chartDetailsAuthenticatedEntity.includeRoomTypeAncillaries) &&
        Objects.equals(this.includeRoomTypeAncillariesRevenue, chartDetailsAuthenticatedEntity.includeRoomTypeAncillariesRevenue) &&
        Objects.equals(this.includeAddOns, chartDetailsAuthenticatedEntity.includeAddOns) &&
        Objects.equals(this.includeAddOnsRevenue, chartDetailsAuthenticatedEntity.includeAddOnsRevenue) &&
        Objects.equals(this.includeTotalRoomRevenue, chartDetailsAuthenticatedEntity.includeTotalRoomRevenue) &&
        Objects.equals(this.includeAverageRoomRate, chartDetailsAuthenticatedEntity.includeAverageRoomRate) &&
        Objects.equals(this.includeTotalAncillariesRevenue, chartDetailsAuthenticatedEntity.includeTotalAncillariesRevenue) &&
        Objects.equals(this.includeTotalNetRevenue, chartDetailsAuthenticatedEntity.includeTotalNetRevenue) &&
        Objects.equals(this.includeCancelledRoomNights, chartDetailsAuthenticatedEntity.includeCancelledRoomNights) &&
        Objects.equals(this.includeCancelledMeetingRooms, chartDetailsAuthenticatedEntity.includeCancelledMeetingRooms) &&
        Objects.equals(this.includeCancelledMeetingRoomsRevenue, chartDetailsAuthenticatedEntity.includeCancelledMeetingRoomsRevenue) &&
        Objects.equals(this.includeCancelledRestaurants, chartDetailsAuthenticatedEntity.includeCancelledRestaurants) &&
        Objects.equals(this.includeCancelledRestaurantsRevenue, chartDetailsAuthenticatedEntity.includeCancelledRestaurantsRevenue) &&
        Objects.equals(this.includeCancelledSpas, chartDetailsAuthenticatedEntity.includeCancelledSpas) &&
        Objects.equals(this.includeCancelledSpasRevenue, chartDetailsAuthenticatedEntity.includeCancelledSpasRevenue) &&
        Objects.equals(this.includeCancelledActivities, chartDetailsAuthenticatedEntity.includeCancelledActivities) &&
        Objects.equals(this.includeCancelledActivitiesRevenue, chartDetailsAuthenticatedEntity.includeCancelledActivitiesRevenue) &&
        Objects.equals(this.includeCancelledAttractions, chartDetailsAuthenticatedEntity.includeCancelledAttractions) &&
        Objects.equals(this.includeCancelledAttractionsRevenue, chartDetailsAuthenticatedEntity.includeCancelledAttractionsRevenue) &&
        Objects.equals(this.includeCancelledPlaces, chartDetailsAuthenticatedEntity.includeCancelledPlaces) &&
        Objects.equals(this.includeCancelledPlacesRevenue, chartDetailsAuthenticatedEntity.includeCancelledPlacesRevenue) &&
        Objects.equals(this.includeCancelledRoomTypeAncillaries, chartDetailsAuthenticatedEntity.includeCancelledRoomTypeAncillaries) &&
        Objects.equals(this.includeCancelledRoomTypeAncillariesRevenue, chartDetailsAuthenticatedEntity.includeCancelledRoomTypeAncillariesRevenue) &&
        Objects.equals(this.includeCancelledAddOns, chartDetailsAuthenticatedEntity.includeCancelledAddOns) &&
        Objects.equals(this.includeCancelledAddOnsRevenue, chartDetailsAuthenticatedEntity.includeCancelledAddOnsRevenue) &&
        Objects.equals(this.includeCancelledTotalRoomRevenue, chartDetailsAuthenticatedEntity.includeCancelledTotalRoomRevenue) &&
        Objects.equals(this.includeCancelledTotalAncillariesRevenue, chartDetailsAuthenticatedEntity.includeCancelledTotalAncillariesRevenue) &&
        Objects.equals(this.includeCancelledTotalNetRevenue, chartDetailsAuthenticatedEntity.includeCancelledTotalNetRevenue) &&
        Objects.equals(this.groupOnChannelSubType, chartDetailsAuthenticatedEntity.groupOnChannelSubType) &&
        Objects.equals(this.groupOnOwnerIdentifier, chartDetailsAuthenticatedEntity.groupOnOwnerIdentifier) &&
        Objects.equals(this.groupOnEngineCountryGeoNameId, chartDetailsAuthenticatedEntity.groupOnEngineCountryGeoNameId) &&
        Objects.equals(this.groupOnEngineCityGeoNameId, chartDetailsAuthenticatedEntity.groupOnEngineCityGeoNameId) &&
        Objects.equals(this.groupOnEngineContinentCode, chartDetailsAuthenticatedEntity.groupOnEngineContinentCode) &&
        Objects.equals(this.groupOnEngineConfigurationIdentifier, chartDetailsAuthenticatedEntity.groupOnEngineConfigurationIdentifier) &&
        Objects.equals(this.groupOnCountryGeoNameId, chartDetailsAuthenticatedEntity.groupOnCountryGeoNameId) &&
        Objects.equals(this.groupOnCityGeoNameId, chartDetailsAuthenticatedEntity.groupOnCityGeoNameId) &&
        Objects.equals(this.groupOnContinentCode, chartDetailsAuthenticatedEntity.groupOnContinentCode) &&
        Objects.equals(this.groupOnHotelIdentifier, chartDetailsAuthenticatedEntity.groupOnHotelIdentifier) &&
        Objects.equals(this.groupOnUserIdentifier, chartDetailsAuthenticatedEntity.groupOnUserIdentifier) &&
        Objects.equals(this.currencyCode, chartDetailsAuthenticatedEntity.currencyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(series, timeSeriesUnits, startDate, endDate, filterOnHotelIdentifier, filterOnChannelSubType, filterOnOwnerIdentifier, filterOnEngineCountryGeoNameId, filterOnEngineCityGeoNameId, filterOnEngineContinentCode, filterOnEngineConfigurationIdentifier, filterOnCountryGeoNameId, filterOnCityGeoNameId, filterOnContinentCode, filterOnUserIdentifier, sortOnPageVisits, sortOnMapMarkerVisits, sortOnCardVisits, sortOnBookings, sortOnCancellations, sortOnRoomNights, sortOnMeetingRooms, sortOnMeetingRoomsRevenue, sortOnRestaurants, sortOnRestaurantsRevenue, sortOnSpas, sortOnSpasRevenue, sortOnActivities, sortOnActivitiesRevenue, sortOnAttractions, sortOnAttractionsRevenue, sortOnPlaces, sortOnPlacesRevenue, sortOnRoomTypeAncillaries, sortOnRoomTypeAncillariesRevenue, sortOnAddOns, sortOnAddonsRevenue, sortOnTotalRoomRevenue, sortOnTotalAncillariesRevenue, sortOnTotalNetRevenue, sortOnCancelledRoomNights, sortOnCancelledMeetingRooms, sortOnCancelledMeetingRoomsRevenue, sortOnCancelledRestaurants, sortOnCancelledRestaurantsRevenue, sortOnCancelledSpas, sortOnCancelledSpasRevenue, sortOnCancelledActivities, sortOnCancelledActivitiesRevenue, sortOnCancelledAttractions, sortOnCancelledAttractionsRevenue, sortOnCancelledPlaces, sortOnCancelledPlacesRevenue, sortOnCancelledTotalRoomRevenue, sortOnCancelledTotalAncillariesRevenue, sortOnCancelledRoomTypeAncillaries, sortOnCancelledRoomTypeAncillariesRevenue, sortOnCancelledAddOns, sortOnCancelledAddonsRevenue, sortOnCancelledTotalNetRevenue, includePageVisits, includeMapMarkerVisits, includeCardVisits, includeBookings, includeCancellations, includeRoomNights, includeMeetingRooms, includeMeetingRoomsRevenue, includeRestaurants, includeRestaurantsRevenue, includeSpas, includeSpasRevenue, includeActivities, includeActivitiesRevenue, includeAttractions, includeAttractionsRevenue, includePlaces, includePlacesRevenue, includeRoomTypeAncillaries, includeRoomTypeAncillariesRevenue, includeAddOns, includeAddOnsRevenue, includeTotalRoomRevenue, includeAverageRoomRate, includeTotalAncillariesRevenue, includeTotalNetRevenue, includeCancelledRoomNights, includeCancelledMeetingRooms, includeCancelledMeetingRoomsRevenue, includeCancelledRestaurants, includeCancelledRestaurantsRevenue, includeCancelledSpas, includeCancelledSpasRevenue, includeCancelledActivities, includeCancelledActivitiesRevenue, includeCancelledAttractions, includeCancelledAttractionsRevenue, includeCancelledPlaces, includeCancelledPlacesRevenue, includeCancelledRoomTypeAncillaries, includeCancelledRoomTypeAncillariesRevenue, includeCancelledAddOns, includeCancelledAddOnsRevenue, includeCancelledTotalRoomRevenue, includeCancelledTotalAncillariesRevenue, includeCancelledTotalNetRevenue, groupOnChannelSubType, groupOnOwnerIdentifier, groupOnEngineCountryGeoNameId, groupOnEngineCityGeoNameId, groupOnEngineContinentCode, groupOnEngineConfigurationIdentifier, groupOnCountryGeoNameId, groupOnCityGeoNameId, groupOnContinentCode, groupOnHotelIdentifier, groupOnUserIdentifier, currencyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChartDetailsAuthenticatedEntity {\n");
    sb.append("    series: ").append(toIndentedString(series)).append("\n");
    sb.append("    timeSeriesUnits: ").append(toIndentedString(timeSeriesUnits)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    filterOnHotelIdentifier: ").append(toIndentedString(filterOnHotelIdentifier)).append("\n");
    sb.append("    filterOnChannelSubType: ").append(toIndentedString(filterOnChannelSubType)).append("\n");
    sb.append("    filterOnOwnerIdentifier: ").append(toIndentedString(filterOnOwnerIdentifier)).append("\n");
    sb.append("    filterOnEngineCountryGeoNameId: ").append(toIndentedString(filterOnEngineCountryGeoNameId)).append("\n");
    sb.append("    filterOnEngineCityGeoNameId: ").append(toIndentedString(filterOnEngineCityGeoNameId)).append("\n");
    sb.append("    filterOnEngineContinentCode: ").append(toIndentedString(filterOnEngineContinentCode)).append("\n");
    sb.append("    filterOnEngineConfigurationIdentifier: ").append(toIndentedString(filterOnEngineConfigurationIdentifier)).append("\n");
    sb.append("    filterOnCountryGeoNameId: ").append(toIndentedString(filterOnCountryGeoNameId)).append("\n");
    sb.append("    filterOnCityGeoNameId: ").append(toIndentedString(filterOnCityGeoNameId)).append("\n");
    sb.append("    filterOnContinentCode: ").append(toIndentedString(filterOnContinentCode)).append("\n");
    sb.append("    filterOnUserIdentifier: ").append(toIndentedString(filterOnUserIdentifier)).append("\n");
    sb.append("    sortOnPageVisits: ").append(toIndentedString(sortOnPageVisits)).append("\n");
    sb.append("    sortOnMapMarkerVisits: ").append(toIndentedString(sortOnMapMarkerVisits)).append("\n");
    sb.append("    sortOnCardVisits: ").append(toIndentedString(sortOnCardVisits)).append("\n");
    sb.append("    sortOnBookings: ").append(toIndentedString(sortOnBookings)).append("\n");
    sb.append("    sortOnCancellations: ").append(toIndentedString(sortOnCancellations)).append("\n");
    sb.append("    sortOnRoomNights: ").append(toIndentedString(sortOnRoomNights)).append("\n");
    sb.append("    sortOnMeetingRooms: ").append(toIndentedString(sortOnMeetingRooms)).append("\n");
    sb.append("    sortOnMeetingRoomsRevenue: ").append(toIndentedString(sortOnMeetingRoomsRevenue)).append("\n");
    sb.append("    sortOnRestaurants: ").append(toIndentedString(sortOnRestaurants)).append("\n");
    sb.append("    sortOnRestaurantsRevenue: ").append(toIndentedString(sortOnRestaurantsRevenue)).append("\n");
    sb.append("    sortOnSpas: ").append(toIndentedString(sortOnSpas)).append("\n");
    sb.append("    sortOnSpasRevenue: ").append(toIndentedString(sortOnSpasRevenue)).append("\n");
    sb.append("    sortOnActivities: ").append(toIndentedString(sortOnActivities)).append("\n");
    sb.append("    sortOnActivitiesRevenue: ").append(toIndentedString(sortOnActivitiesRevenue)).append("\n");
    sb.append("    sortOnAttractions: ").append(toIndentedString(sortOnAttractions)).append("\n");
    sb.append("    sortOnAttractionsRevenue: ").append(toIndentedString(sortOnAttractionsRevenue)).append("\n");
    sb.append("    sortOnPlaces: ").append(toIndentedString(sortOnPlaces)).append("\n");
    sb.append("    sortOnPlacesRevenue: ").append(toIndentedString(sortOnPlacesRevenue)).append("\n");
    sb.append("    sortOnRoomTypeAncillaries: ").append(toIndentedString(sortOnRoomTypeAncillaries)).append("\n");
    sb.append("    sortOnRoomTypeAncillariesRevenue: ").append(toIndentedString(sortOnRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    sortOnAddOns: ").append(toIndentedString(sortOnAddOns)).append("\n");
    sb.append("    sortOnAddonsRevenue: ").append(toIndentedString(sortOnAddonsRevenue)).append("\n");
    sb.append("    sortOnTotalRoomRevenue: ").append(toIndentedString(sortOnTotalRoomRevenue)).append("\n");
    sb.append("    sortOnTotalAncillariesRevenue: ").append(toIndentedString(sortOnTotalAncillariesRevenue)).append("\n");
    sb.append("    sortOnTotalNetRevenue: ").append(toIndentedString(sortOnTotalNetRevenue)).append("\n");
    sb.append("    sortOnCancelledRoomNights: ").append(toIndentedString(sortOnCancelledRoomNights)).append("\n");
    sb.append("    sortOnCancelledMeetingRooms: ").append(toIndentedString(sortOnCancelledMeetingRooms)).append("\n");
    sb.append("    sortOnCancelledMeetingRoomsRevenue: ").append(toIndentedString(sortOnCancelledMeetingRoomsRevenue)).append("\n");
    sb.append("    sortOnCancelledRestaurants: ").append(toIndentedString(sortOnCancelledRestaurants)).append("\n");
    sb.append("    sortOnCancelledRestaurantsRevenue: ").append(toIndentedString(sortOnCancelledRestaurantsRevenue)).append("\n");
    sb.append("    sortOnCancelledSpas: ").append(toIndentedString(sortOnCancelledSpas)).append("\n");
    sb.append("    sortOnCancelledSpasRevenue: ").append(toIndentedString(sortOnCancelledSpasRevenue)).append("\n");
    sb.append("    sortOnCancelledActivities: ").append(toIndentedString(sortOnCancelledActivities)).append("\n");
    sb.append("    sortOnCancelledActivitiesRevenue: ").append(toIndentedString(sortOnCancelledActivitiesRevenue)).append("\n");
    sb.append("    sortOnCancelledAttractions: ").append(toIndentedString(sortOnCancelledAttractions)).append("\n");
    sb.append("    sortOnCancelledAttractionsRevenue: ").append(toIndentedString(sortOnCancelledAttractionsRevenue)).append("\n");
    sb.append("    sortOnCancelledPlaces: ").append(toIndentedString(sortOnCancelledPlaces)).append("\n");
    sb.append("    sortOnCancelledPlacesRevenue: ").append(toIndentedString(sortOnCancelledPlacesRevenue)).append("\n");
    sb.append("    sortOnCancelledTotalRoomRevenue: ").append(toIndentedString(sortOnCancelledTotalRoomRevenue)).append("\n");
    sb.append("    sortOnCancelledTotalAncillariesRevenue: ").append(toIndentedString(sortOnCancelledTotalAncillariesRevenue)).append("\n");
    sb.append("    sortOnCancelledRoomTypeAncillaries: ").append(toIndentedString(sortOnCancelledRoomTypeAncillaries)).append("\n");
    sb.append("    sortOnCancelledRoomTypeAncillariesRevenue: ").append(toIndentedString(sortOnCancelledRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    sortOnCancelledAddOns: ").append(toIndentedString(sortOnCancelledAddOns)).append("\n");
    sb.append("    sortOnCancelledAddonsRevenue: ").append(toIndentedString(sortOnCancelledAddonsRevenue)).append("\n");
    sb.append("    sortOnCancelledTotalNetRevenue: ").append(toIndentedString(sortOnCancelledTotalNetRevenue)).append("\n");
    sb.append("    includePageVisits: ").append(toIndentedString(includePageVisits)).append("\n");
    sb.append("    includeMapMarkerVisits: ").append(toIndentedString(includeMapMarkerVisits)).append("\n");
    sb.append("    includeCardVisits: ").append(toIndentedString(includeCardVisits)).append("\n");
    sb.append("    includeBookings: ").append(toIndentedString(includeBookings)).append("\n");
    sb.append("    includeCancellations: ").append(toIndentedString(includeCancellations)).append("\n");
    sb.append("    includeRoomNights: ").append(toIndentedString(includeRoomNights)).append("\n");
    sb.append("    includeMeetingRooms: ").append(toIndentedString(includeMeetingRooms)).append("\n");
    sb.append("    includeMeetingRoomsRevenue: ").append(toIndentedString(includeMeetingRoomsRevenue)).append("\n");
    sb.append("    includeRestaurants: ").append(toIndentedString(includeRestaurants)).append("\n");
    sb.append("    includeRestaurantsRevenue: ").append(toIndentedString(includeRestaurantsRevenue)).append("\n");
    sb.append("    includeSpas: ").append(toIndentedString(includeSpas)).append("\n");
    sb.append("    includeSpasRevenue: ").append(toIndentedString(includeSpasRevenue)).append("\n");
    sb.append("    includeActivities: ").append(toIndentedString(includeActivities)).append("\n");
    sb.append("    includeActivitiesRevenue: ").append(toIndentedString(includeActivitiesRevenue)).append("\n");
    sb.append("    includeAttractions: ").append(toIndentedString(includeAttractions)).append("\n");
    sb.append("    includeAttractionsRevenue: ").append(toIndentedString(includeAttractionsRevenue)).append("\n");
    sb.append("    includePlaces: ").append(toIndentedString(includePlaces)).append("\n");
    sb.append("    includePlacesRevenue: ").append(toIndentedString(includePlacesRevenue)).append("\n");
    sb.append("    includeRoomTypeAncillaries: ").append(toIndentedString(includeRoomTypeAncillaries)).append("\n");
    sb.append("    includeRoomTypeAncillariesRevenue: ").append(toIndentedString(includeRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    includeAddOns: ").append(toIndentedString(includeAddOns)).append("\n");
    sb.append("    includeAddOnsRevenue: ").append(toIndentedString(includeAddOnsRevenue)).append("\n");
    sb.append("    includeTotalRoomRevenue: ").append(toIndentedString(includeTotalRoomRevenue)).append("\n");
    sb.append("    includeAverageRoomRate: ").append(toIndentedString(includeAverageRoomRate)).append("\n");
    sb.append("    includeTotalAncillariesRevenue: ").append(toIndentedString(includeTotalAncillariesRevenue)).append("\n");
    sb.append("    includeTotalNetRevenue: ").append(toIndentedString(includeTotalNetRevenue)).append("\n");
    sb.append("    includeCancelledRoomNights: ").append(toIndentedString(includeCancelledRoomNights)).append("\n");
    sb.append("    includeCancelledMeetingRooms: ").append(toIndentedString(includeCancelledMeetingRooms)).append("\n");
    sb.append("    includeCancelledMeetingRoomsRevenue: ").append(toIndentedString(includeCancelledMeetingRoomsRevenue)).append("\n");
    sb.append("    includeCancelledRestaurants: ").append(toIndentedString(includeCancelledRestaurants)).append("\n");
    sb.append("    includeCancelledRestaurantsRevenue: ").append(toIndentedString(includeCancelledRestaurantsRevenue)).append("\n");
    sb.append("    includeCancelledSpas: ").append(toIndentedString(includeCancelledSpas)).append("\n");
    sb.append("    includeCancelledSpasRevenue: ").append(toIndentedString(includeCancelledSpasRevenue)).append("\n");
    sb.append("    includeCancelledActivities: ").append(toIndentedString(includeCancelledActivities)).append("\n");
    sb.append("    includeCancelledActivitiesRevenue: ").append(toIndentedString(includeCancelledActivitiesRevenue)).append("\n");
    sb.append("    includeCancelledAttractions: ").append(toIndentedString(includeCancelledAttractions)).append("\n");
    sb.append("    includeCancelledAttractionsRevenue: ").append(toIndentedString(includeCancelledAttractionsRevenue)).append("\n");
    sb.append("    includeCancelledPlaces: ").append(toIndentedString(includeCancelledPlaces)).append("\n");
    sb.append("    includeCancelledPlacesRevenue: ").append(toIndentedString(includeCancelledPlacesRevenue)).append("\n");
    sb.append("    includeCancelledRoomTypeAncillaries: ").append(toIndentedString(includeCancelledRoomTypeAncillaries)).append("\n");
    sb.append("    includeCancelledRoomTypeAncillariesRevenue: ").append(toIndentedString(includeCancelledRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    includeCancelledAddOns: ").append(toIndentedString(includeCancelledAddOns)).append("\n");
    sb.append("    includeCancelledAddOnsRevenue: ").append(toIndentedString(includeCancelledAddOnsRevenue)).append("\n");
    sb.append("    includeCancelledTotalRoomRevenue: ").append(toIndentedString(includeCancelledTotalRoomRevenue)).append("\n");
    sb.append("    includeCancelledTotalAncillariesRevenue: ").append(toIndentedString(includeCancelledTotalAncillariesRevenue)).append("\n");
    sb.append("    includeCancelledTotalNetRevenue: ").append(toIndentedString(includeCancelledTotalNetRevenue)).append("\n");
    sb.append("    groupOnChannelSubType: ").append(toIndentedString(groupOnChannelSubType)).append("\n");
    sb.append("    groupOnOwnerIdentifier: ").append(toIndentedString(groupOnOwnerIdentifier)).append("\n");
    sb.append("    groupOnEngineCountryGeoNameId: ").append(toIndentedString(groupOnEngineCountryGeoNameId)).append("\n");
    sb.append("    groupOnEngineCityGeoNameId: ").append(toIndentedString(groupOnEngineCityGeoNameId)).append("\n");
    sb.append("    groupOnEngineContinentCode: ").append(toIndentedString(groupOnEngineContinentCode)).append("\n");
    sb.append("    groupOnEngineConfigurationIdentifier: ").append(toIndentedString(groupOnEngineConfigurationIdentifier)).append("\n");
    sb.append("    groupOnCountryGeoNameId: ").append(toIndentedString(groupOnCountryGeoNameId)).append("\n");
    sb.append("    groupOnCityGeoNameId: ").append(toIndentedString(groupOnCityGeoNameId)).append("\n");
    sb.append("    groupOnContinentCode: ").append(toIndentedString(groupOnContinentCode)).append("\n");
    sb.append("    groupOnHotelIdentifier: ").append(toIndentedString(groupOnHotelIdentifier)).append("\n");
    sb.append("    groupOnUserIdentifier: ").append(toIndentedString(groupOnUserIdentifier)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

