/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.analytics.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.analytics.invoker.ApiClient;
import travel.wink.sdk.analytics.model.ChartAuthenticatedEntity;
import travel.wink.sdk.analytics.model.LineChartNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.PageLineChartNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.RemoveEntryResponseAuthenticatedEntity;
import travel.wink.sdk.analytics.model.StateNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.UpsertChartRequestAuthenticatedEntity;

public class AnalyticsApi {
    private ApiClient apiClient;

    public AnalyticsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnalyticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createChartRequestRequestCreation(@Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertChartRequestAuthenticatedEntity postBody = upsertChartRequestAuthenticatedEntity;
        if (upsertChartRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestAuthenticatedEntity' when calling createChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/chart", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ChartAuthenticatedEntity> createChartRequest(@Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.createChartRequestRequestCreation(upsertChartRequestAuthenticatedEntity, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ChartAuthenticatedEntity>> createChartRequestWithHttpInfo(@Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.createChartRequestRequestCreation(upsertChartRequestAuthenticatedEntity, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createChartRequestWithResponseSpec(@Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createChartRequestRequestCreation(upsertChartRequestAuthenticatedEntity, winkVersion);
    }

    private WebClient.ResponseSpec removeChartRequestRequestCreation(@Nonnull String chartIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling removeChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("chartIdentifier", chartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAuthenticatedEntity> removeChartRequest(@Nonnull String chartIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>(this){};
        return this.removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAuthenticatedEntity>> removeChartRequestWithHttpInfo(@Nonnull String chartIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>(this){};
        return this.removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeChartRequestWithResponseSpec(@Nonnull String chartIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeChartRequestRequestCreation(chartIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAnalyticsGridRequestCreation(@Nonnull StateNonAuthenticatedEntity stateNonAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        StateNonAuthenticatedEntity postBody = stateNonAuthenticatedEntity;
        if (stateNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateNonAuthenticatedEntity' when calling showAnalyticsGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageLineChartNonAuthenticatedEntity> showAnalyticsGrid(@Nonnull StateNonAuthenticatedEntity stateNonAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity>(this){};
        return this.showAnalyticsGridRequestCreation(stateNonAuthenticatedEntity, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageLineChartNonAuthenticatedEntity>> showAnalyticsGridWithHttpInfo(@Nonnull StateNonAuthenticatedEntity stateNonAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<PageLineChartNonAuthenticatedEntity>(this){};
        return this.showAnalyticsGridRequestCreation(stateNonAuthenticatedEntity, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAnalyticsGridWithResponseSpec(@Nonnull StateNonAuthenticatedEntity stateNonAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        return this.showAnalyticsGridRequestCreation(stateNonAuthenticatedEntity, winkVersion);
    }

    private WebClient.ResponseSpec showAnalyticsListRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<LineChartNonAuthenticatedEntity> showAnalyticsList(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>(this){};
        return this.showAnalyticsListRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<LineChartNonAuthenticatedEntity>>> showAnalyticsListWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>(this){};
        return this.showAnalyticsListRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAnalyticsListWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showAnalyticsListRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showChartRequestRequestCreation(@Nonnull String chartIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling showChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("chartIdentifier", chartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ChartAuthenticatedEntity> showChartRequest(@Nonnull String chartIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.showChartRequestRequestCreation(chartIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ChartAuthenticatedEntity>> showChartRequestWithHttpInfo(@Nonnull String chartIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.showChartRequestRequestCreation(chartIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showChartRequestWithResponseSpec(@Nonnull String chartIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showChartRequestRequestCreation(chartIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showChartRequestsRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/chart/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ChartAuthenticatedEntity> showChartRequests(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.showChartRequestsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ChartAuthenticatedEntity>>> showChartRequestsWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.showChartRequestsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showChartRequestsWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showChartRequestsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateChartRequestRequestCreation(@Nonnull String chartIdentifier, @Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertChartRequestAuthenticatedEntity postBody = upsertChartRequestAuthenticatedEntity;
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertChartRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestAuthenticatedEntity' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("chartIdentifier", chartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ChartAuthenticatedEntity> updateChartRequest(@Nonnull String chartIdentifier, @Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestAuthenticatedEntity, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ChartAuthenticatedEntity>> updateChartRequestWithHttpInfo(@Nonnull String chartIdentifier, @Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartAuthenticatedEntity>(this){};
        return this.updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestAuthenticatedEntity, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateChartRequestWithResponseSpec(@Nonnull String chartIdentifier, @Nonnull UpsertChartRequestAuthenticatedEntity upsertChartRequestAuthenticatedEntity, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestAuthenticatedEntity, winkVersion);
    }
}

