/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 24.7.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.analytics.model.ChartValueAxisLabelsConsumer;
import travel.wink.sdk.analytics.model.ChartValueAxisLineConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The configuration options of the value axis.
 */
@ApiModel(description = "The configuration options of the value axis.")
@JsonPropertyOrder({
  ChartValueAxisConsumer.JSON_PROPERTY_LABELS,
  ChartValueAxisConsumer.JSON_PROPERTY_LINE,
  ChartValueAxisConsumer.JSON_PROPERTY_AXIS_CROSSING_VALUE,
  ChartValueAxisConsumer.JSON_PROPERTY_MAJOR_UNIT
})
@JsonTypeName("ChartValueAxis_Consumer")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-18T08:51:35.234629791+07:00[Asia/Bangkok]")
public class ChartValueAxisConsumer {
  public static final String JSON_PROPERTY_LABELS = "labels";
  private ChartValueAxisLabelsConsumer labels;

  public static final String JSON_PROPERTY_LINE = "line";
  private ChartValueAxisLineConsumer line;

  public static final String JSON_PROPERTY_AXIS_CROSSING_VALUE = "axisCrossingValue";
  private Integer axisCrossingValue;

  public static final String JSON_PROPERTY_MAJOR_UNIT = "majorUnit";
  private Float majorUnit;

  public ChartValueAxisConsumer() { 
  }

  public ChartValueAxisConsumer labels(ChartValueAxisLabelsConsumer labels) {
    
    this.labels = labels;
    return this;
  }

   /**
   * Get labels
   * @return labels
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LABELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartValueAxisLabelsConsumer getLabels() {
    return labels;
  }


  @JsonProperty(JSON_PROPERTY_LABELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLabels(ChartValueAxisLabelsConsumer labels) {
    this.labels = labels;
  }


  public ChartValueAxisConsumer line(ChartValueAxisLineConsumer line) {
    
    this.line = line;
    return this;
  }

   /**
   * Get line
   * @return line
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartValueAxisLineConsumer getLine() {
    return line;
  }


  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLine(ChartValueAxisLineConsumer line) {
    this.line = line;
  }


  public ChartValueAxisConsumer axisCrossingValue(Integer axisCrossingValue) {
    
    this.axisCrossingValue = axisCrossingValue;
    return this;
  }

   /**
   * - (Only for objects) The value at which the category axis crosses this axis. - (Only for arrays) The value indices at which the category axes cross the value axis. - (Only for dates) The date at which the category axis crosses this axis.
   * @return axisCrossingValue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "- (Only for objects) The value at which the category axis crosses this axis. - (Only for arrays) The value indices at which the category axes cross the value axis. - (Only for dates) The date at which the category axis crosses this axis.")
  @JsonProperty(JSON_PROPERTY_AXIS_CROSSING_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAxisCrossingValue() {
    return axisCrossingValue;
  }


  @JsonProperty(JSON_PROPERTY_AXIS_CROSSING_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAxisCrossingValue(Integer axisCrossingValue) {
    this.axisCrossingValue = axisCrossingValue;
  }


  public ChartValueAxisConsumer majorUnit(Float majorUnit) {
    
    this.majorUnit = majorUnit;
    return this;
  }

   /**
   * The interval between major divisions. If &#x60;valueAxis.type&#x60; is set to &#x60;log&#x60;, the majorUnit value is used for the base of the logarithm.
   * @return majorUnit
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The interval between major divisions. If `valueAxis.type` is set to `log`, the majorUnit value is used for the base of the logarithm.")
  @JsonProperty(JSON_PROPERTY_MAJOR_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMajorUnit() {
    return majorUnit;
  }


  @JsonProperty(JSON_PROPERTY_MAJOR_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMajorUnit(Float majorUnit) {
    this.majorUnit = majorUnit;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChartValueAxisConsumer chartValueAxisConsumer = (ChartValueAxisConsumer) o;
    return Objects.equals(this.labels, chartValueAxisConsumer.labels) &&
        Objects.equals(this.line, chartValueAxisConsumer.line) &&
        Objects.equals(this.axisCrossingValue, chartValueAxisConsumer.axisCrossingValue) &&
        Objects.equals(this.majorUnit, chartValueAxisConsumer.majorUnit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(labels, line, axisCrossingValue, majorUnit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChartValueAxisConsumer {\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    line: ").append(toIndentedString(line)).append("\n");
    sb.append("    axisCrossingValue: ").append(toIndentedString(axisCrossingValue)).append("\n");
    sb.append("    majorUnit: ").append(toIndentedString(majorUnit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

