/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 25.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import travel.wink.sdk.analytics.model.KeyValuePair;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Chart properties allow you to choose how to visualize available data points. Choose how you want to:   - filter your data  - sort your data  - group your data  - include data in your data sets  - display currency amounts
 */
@ApiModel(description = "Chart properties allow you to choose how to visualize available data points. Choose how you want to:   - filter your data  - sort your data  - group your data  - include data in your data sets  - display currency amounts")
@JsonPropertyOrder({
  ChartRequest.JSON_PROPERTY_SERIES,
  ChartRequest.JSON_PROPERTY_TIME_SERIES_UNITS,
  ChartRequest.JSON_PROPERTY_START_DATE,
  ChartRequest.JSON_PROPERTY_END_DATE,
  ChartRequest.JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE,
  ChartRequest.JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE,
  ChartRequest.JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_FILTER_ON_CONTINENT_CODE,
  ChartRequest.JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_SORT_ON_PAGE_VISITS,
  ChartRequest.JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CARD_VISITS,
  ChartRequest.JSON_PROPERTY_SORT_ON_BOOKINGS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLATIONS,
  ChartRequest.JSON_PROPERTY_SORT_ON_ROOM_NIGHTS,
  ChartRequest.JSON_PROPERTY_SORT_ON_MEETING_ROOMS,
  ChartRequest.JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_RESTAURANTS,
  ChartRequest.JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_SPAS,
  ChartRequest.JSON_PROPERTY_SORT_ON_SPAS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_ACTIVITIES,
  ChartRequest.JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_ATTRACTIONS,
  ChartRequest.JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_PLACES,
  ChartRequest.JSON_PROPERTY_SORT_ON_PLACES_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES,
  ChartRequest.JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_ADD_ONS,
  ChartRequest.JSON_PROPERTY_SORT_ON_ADDONS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_SPAS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_PLACES,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE,
  ChartRequest.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_PAGE_VISITS,
  ChartRequest.JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CARD_VISITS,
  ChartRequest.JSON_PROPERTY_INCLUDE_BOOKINGS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLATIONS,
  ChartRequest.JSON_PROPERTY_INCLUDE_ROOM_NIGHTS,
  ChartRequest.JSON_PROPERTY_INCLUDE_MEETING_ROOMS,
  ChartRequest.JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_RESTAURANTS,
  ChartRequest.JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_SPAS,
  ChartRequest.JSON_PROPERTY_INCLUDE_SPAS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_ACTIVITIES,
  ChartRequest.JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_ATTRACTIONS,
  ChartRequest.JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_PLACES,
  ChartRequest.JSON_PROPERTY_INCLUDE_PLACES_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES,
  ChartRequest.JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_ADD_ONS,
  ChartRequest.JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE,
  ChartRequest.JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_SPAS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_PLACES,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE,
  ChartRequest.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE,
  ChartRequest.JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE,
  ChartRequest.JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE,
  ChartRequest.JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID,
  ChartRequest.JSON_PROPERTY_GROUP_ON_CONTINENT_CODE,
  ChartRequest.JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER,
  ChartRequest.JSON_PROPERTY_CURRENCY_CODE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-24T11:12:54.995330422+07:00[Asia/Bangkok]")
public class ChartRequest {
  /**
   * The time series to visualize
   */
  public enum SeriesEnum {
    HOUR("HOUR"),
    
    DAY("DAY"),
    
    MONTH("MONTH"),
    
    YEAR("YEAR");

    private String value;

    SeriesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SeriesEnum fromValue(String value) {
      for (SeriesEnum b : SeriesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SERIES = "series";
  private SeriesEnum series;

  public static final String JSON_PROPERTY_TIME_SERIES_UNITS = "timeSeriesUnits";
  private Long timeSeriesUnits;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private java.time.LocalDateTime startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private java.time.LocalDateTime endDate;

  public static final String JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER = "filterOnHotelIdentifier";
  private KeyValuePair filterOnHotelIdentifier;

  /**
   * Filter on channel sub type. What channel sub-type helped make the booking.
   */
  public enum FilterOnChannelSubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM");

    private String value;

    FilterOnChannelSubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FilterOnChannelSubTypeEnum fromValue(String value) {
      for (FilterOnChannelSubTypeEnum b : FilterOnChannelSubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE = "filterOnChannelSubType";
  private FilterOnChannelSubTypeEnum filterOnChannelSubType;

  public static final String JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER = "filterOnOwnerIdentifier";
  private KeyValuePair filterOnOwnerIdentifier;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID = "filterOnEngineCountryGeoNameId";
  private KeyValuePair filterOnEngineCountryGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID = "filterOnEngineCityGeoNameId";
  private KeyValuePair filterOnEngineCityGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE = "filterOnEngineContinentCode";
  private KeyValuePair filterOnEngineContinentCode;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER = "filterOnEngineConfigurationIdentifier";
  private KeyValuePair filterOnEngineConfigurationIdentifier;

  public static final String JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID = "filterOnCountryGeoNameId";
  private KeyValuePair filterOnCountryGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID = "filterOnCityGeoNameId";
  private KeyValuePair filterOnCityGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_CONTINENT_CODE = "filterOnContinentCode";
  private KeyValuePair filterOnContinentCode;

  public static final String JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER = "filterOnUserIdentifier";
  private KeyValuePair filterOnUserIdentifier;

  public static final String JSON_PROPERTY_SORT_ON_PAGE_VISITS = "sortOnPageVisits";
  private Boolean sortOnPageVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS = "sortOnMapMarkerVisits";
  private Boolean sortOnMapMarkerVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_CARD_VISITS = "sortOnCardVisits";
  private Boolean sortOnCardVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_BOOKINGS = "sortOnBookings";
  private Boolean sortOnBookings = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLATIONS = "sortOnCancellations";
  private Boolean sortOnCancellations = false;

  public static final String JSON_PROPERTY_SORT_ON_ROOM_NIGHTS = "sortOnRoomNights";
  private Boolean sortOnRoomNights = false;

  public static final String JSON_PROPERTY_SORT_ON_MEETING_ROOMS = "sortOnMeetingRooms";
  private Boolean sortOnMeetingRooms = false;

  public static final String JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE = "sortOnMeetingRoomsRevenue";
  private Boolean sortOnMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_RESTAURANTS = "sortOnRestaurants";
  private Boolean sortOnRestaurants = false;

  public static final String JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE = "sortOnRestaurantsRevenue";
  private Boolean sortOnRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_SPAS = "sortOnSpas";
  private Boolean sortOnSpas = false;

  public static final String JSON_PROPERTY_SORT_ON_SPAS_REVENUE = "sortOnSpasRevenue";
  private Boolean sortOnSpasRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ACTIVITIES = "sortOnActivities";
  private Boolean sortOnActivities = false;

  public static final String JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE = "sortOnActivitiesRevenue";
  private Boolean sortOnActivitiesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ATTRACTIONS = "sortOnAttractions";
  private Boolean sortOnAttractions = false;

  public static final String JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE = "sortOnAttractionsRevenue";
  private Boolean sortOnAttractionsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_PLACES = "sortOnPlaces";
  private Boolean sortOnPlaces = false;

  public static final String JSON_PROPERTY_SORT_ON_PLACES_REVENUE = "sortOnPlacesRevenue";
  private Boolean sortOnPlacesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES = "sortOnRoomTypeAncillaries";
  private Boolean sortOnRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE = "sortOnRoomTypeAncillariesRevenue";
  private Boolean sortOnRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ADD_ONS = "sortOnAddOns";
  private Boolean sortOnAddOns = false;

  public static final String JSON_PROPERTY_SORT_ON_ADDONS_REVENUE = "sortOnAddonsRevenue";
  private Boolean sortOnAddonsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE = "sortOnTotalRoomRevenue";
  private Boolean sortOnTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE = "sortOnTotalAncillariesRevenue";
  private Boolean sortOnTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE = "sortOnTotalNetRevenue";
  private Boolean sortOnTotalNetRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS = "sortOnCancelledRoomNights";
  private Boolean sortOnCancelledRoomNights = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS = "sortOnCancelledMeetingRooms";
  private Boolean sortOnCancelledMeetingRooms = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE = "sortOnCancelledMeetingRoomsRevenue";
  private Boolean sortOnCancelledMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS = "sortOnCancelledRestaurants";
  private Boolean sortOnCancelledRestaurants = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE = "sortOnCancelledRestaurantsRevenue";
  private Boolean sortOnCancelledRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_SPAS = "sortOnCancelledSpas";
  private Boolean sortOnCancelledSpas = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE = "sortOnCancelledSpasRevenue";
  private Boolean sortOnCancelledSpasRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES = "sortOnCancelledActivities";
  private Boolean sortOnCancelledActivities = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE = "sortOnCancelledActivitiesRevenue";
  private Boolean sortOnCancelledActivitiesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS = "sortOnCancelledAttractions";
  private Boolean sortOnCancelledAttractions = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE = "sortOnCancelledAttractionsRevenue";
  private Boolean sortOnCancelledAttractionsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PLACES = "sortOnCancelledPlaces";
  private Boolean sortOnCancelledPlaces = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE = "sortOnCancelledPlacesRevenue";
  private Boolean sortOnCancelledPlacesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE = "sortOnCancelledTotalRoomRevenue";
  private Boolean sortOnCancelledTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE = "sortOnCancelledTotalAncillariesRevenue";
  private Boolean sortOnCancelledTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES = "sortOnCancelledRoomTypeAncillaries";
  private Boolean sortOnCancelledRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE = "sortOnCancelledRoomTypeAncillariesRevenue";
  private Boolean sortOnCancelledRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS = "sortOnCancelledAddOns";
  private Boolean sortOnCancelledAddOns = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE = "sortOnCancelledAddonsRevenue";
  private Boolean sortOnCancelledAddonsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE = "sortOnCancelledTotalNetRevenue";
  private Boolean sortOnCancelledTotalNetRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_PAGE_VISITS = "includePageVisits";
  private Boolean includePageVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS = "includeMapMarkerVisits";
  private Boolean includeMapMarkerVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_CARD_VISITS = "includeCardVisits";
  private Boolean includeCardVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_BOOKINGS = "includeBookings";
  private Boolean includeBookings = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLATIONS = "includeCancellations";
  private Boolean includeCancellations = false;

  public static final String JSON_PROPERTY_INCLUDE_ROOM_NIGHTS = "includeRoomNights";
  private Boolean includeRoomNights = false;

  public static final String JSON_PROPERTY_INCLUDE_MEETING_ROOMS = "includeMeetingRooms";
  private Boolean includeMeetingRooms = false;

  public static final String JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE = "includeMeetingRoomsRevenue";
  private Boolean includeMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_RESTAURANTS = "includeRestaurants";
  private Boolean includeRestaurants = false;

  public static final String JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE = "includeRestaurantsRevenue";
  private Boolean includeRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_SPAS = "includeSpas";
  private Boolean includeSpas = false;

  public static final String JSON_PROPERTY_INCLUDE_SPAS_REVENUE = "includeSpasRevenue";
  private Boolean includeSpasRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ACTIVITIES = "includeActivities";
  private Boolean includeActivities = false;

  public static final String JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE = "includeActivitiesRevenue";
  private Boolean includeActivitiesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ATTRACTIONS = "includeAttractions";
  private Boolean includeAttractions = false;

  public static final String JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE = "includeAttractionsRevenue";
  private Boolean includeAttractionsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_PLACES = "includePlaces";
  private Boolean includePlaces = false;

  public static final String JSON_PROPERTY_INCLUDE_PLACES_REVENUE = "includePlacesRevenue";
  private Boolean includePlacesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES = "includeRoomTypeAncillaries";
  private Boolean includeRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE = "includeRoomTypeAncillariesRevenue";
  private Boolean includeRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ADD_ONS = "includeAddOns";
  private Boolean includeAddOns = false;

  public static final String JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE = "includeAddOnsRevenue";
  private Boolean includeAddOnsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE = "includeTotalRoomRevenue";
  private Boolean includeTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE = "includeAverageRoomRate";
  private Boolean includeAverageRoomRate = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE = "includeTotalAncillariesRevenue";
  private Boolean includeTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE = "includeTotalNetRevenue";
  private Boolean includeTotalNetRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS = "includeCancelledRoomNights";
  private Boolean includeCancelledRoomNights = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS = "includeCancelledMeetingRooms";
  private Boolean includeCancelledMeetingRooms = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE = "includeCancelledMeetingRoomsRevenue";
  private Boolean includeCancelledMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS = "includeCancelledRestaurants";
  private Boolean includeCancelledRestaurants = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE = "includeCancelledRestaurantsRevenue";
  private Boolean includeCancelledRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_SPAS = "includeCancelledSpas";
  private Boolean includeCancelledSpas = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE = "includeCancelledSpasRevenue";
  private Boolean includeCancelledSpasRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES = "includeCancelledActivities";
  private Boolean includeCancelledActivities = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE = "includeCancelledActivitiesRevenue";
  private Boolean includeCancelledActivitiesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS = "includeCancelledAttractions";
  private Boolean includeCancelledAttractions = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE = "includeCancelledAttractionsRevenue";
  private Boolean includeCancelledAttractionsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PLACES = "includeCancelledPlaces";
  private Boolean includeCancelledPlaces = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE = "includeCancelledPlacesRevenue";
  private Boolean includeCancelledPlacesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES = "includeCancelledRoomTypeAncillaries";
  private Boolean includeCancelledRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE = "includeCancelledRoomTypeAncillariesRevenue";
  private Boolean includeCancelledRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS = "includeCancelledAddOns";
  private Boolean includeCancelledAddOns = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE = "includeCancelledAddOnsRevenue";
  private Boolean includeCancelledAddOnsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE = "includeCancelledTotalRoomRevenue";
  private Boolean includeCancelledTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE = "includeCancelledTotalAncillariesRevenue";
  private Boolean includeCancelledTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE = "includeCancelledTotalNetRevenue";
  private Boolean includeCancelledTotalNetRevenue = false;

  public static final String JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE = "groupOnChannelSubType";
  private Boolean groupOnChannelSubType = false;

  public static final String JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER = "groupOnOwnerIdentifier";
  private Boolean groupOnOwnerIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER = "groupOnEngineIdentifier";
  private Boolean groupOnEngineIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID = "groupOnEngineCountryGeoNameId";
  private Boolean groupOnEngineCountryGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID = "groupOnEngineCityGeoNameId";
  private Boolean groupOnEngineCityGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE = "groupOnEngineContinentCode";
  private Boolean groupOnEngineContinentCode = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER = "groupOnEngineConfigurationIdentifier";
  private Boolean groupOnEngineConfigurationIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID = "groupOnCountryGeoNameId";
  private Boolean groupOnCountryGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID = "groupOnCityGeoNameId";
  private Boolean groupOnCityGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_CONTINENT_CODE = "groupOnContinentCode";
  private Boolean groupOnContinentCode = false;

  public static final String JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER = "groupOnHotelIdentifier";
  private Boolean groupOnHotelIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER = "groupOnUserIdentifier";
  private Boolean groupOnUserIdentifier = false;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode = "USD";

  public ChartRequest() { 
  }

  public ChartRequest series(SeriesEnum series) {
    
    this.series = series;
    return this;
  }

   /**
   * The time series to visualize
   * @return series
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "HOUR", required = true, value = "The time series to visualize")
  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SeriesEnum getSeries() {
    return series;
  }


  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSeries(SeriesEnum series) {
    this.series = series;
  }


  public ChartRequest timeSeriesUnits(Long timeSeriesUnits) {
    
    this.timeSeriesUnits = timeSeriesUnits;
    return this;
  }

   /**
   * How many units of the time series type to visualize. Only required if start / end date not populated.
   * @return timeSeriesUnits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "24", value = "How many units of the time series type to visualize. Only required if start / end date not populated.")
  @JsonProperty(JSON_PROPERTY_TIME_SERIES_UNITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimeSeriesUnits() {
    return timeSeriesUnits;
  }


  @JsonProperty(JSON_PROPERTY_TIME_SERIES_UNITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeSeriesUnits(Long timeSeriesUnits) {
    this.timeSeriesUnits = timeSeriesUnits;
  }


  public ChartRequest startDate(java.time.LocalDateTime startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Fixed date to start visualizations on
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Fixed date to start visualizations on")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(java.time.LocalDateTime startDate) {
    this.startDate = startDate;
  }


  public ChartRequest endDate(java.time.LocalDateTime endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Fixed date to end visualizations on
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Fixed date to end visualizations on")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(java.time.LocalDateTime endDate) {
    this.endDate = endDate;
  }


  public ChartRequest filterOnHotelIdentifier(KeyValuePair filterOnHotelIdentifier) {
    
    this.filterOnHotelIdentifier = filterOnHotelIdentifier;
    return this;
  }

   /**
   * Get filterOnHotelIdentifier
   * @return filterOnHotelIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnHotelIdentifier() {
    return filterOnHotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnHotelIdentifier(KeyValuePair filterOnHotelIdentifier) {
    this.filterOnHotelIdentifier = filterOnHotelIdentifier;
  }


  public ChartRequest filterOnChannelSubType(FilterOnChannelSubTypeEnum filterOnChannelSubType) {
    
    this.filterOnChannelSubType = filterOnChannelSubType;
    return this;
  }

   /**
   * Filter on channel sub type. What channel sub-type helped make the booking.
   * @return filterOnChannelSubType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "APPLICATION", value = "Filter on channel sub type. What channel sub-type helped make the booking.")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FilterOnChannelSubTypeEnum getFilterOnChannelSubType() {
    return filterOnChannelSubType;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnChannelSubType(FilterOnChannelSubTypeEnum filterOnChannelSubType) {
    this.filterOnChannelSubType = filterOnChannelSubType;
  }


  public ChartRequest filterOnOwnerIdentifier(KeyValuePair filterOnOwnerIdentifier) {
    
    this.filterOnOwnerIdentifier = filterOnOwnerIdentifier;
    return this;
  }

   /**
   * Get filterOnOwnerIdentifier
   * @return filterOnOwnerIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnOwnerIdentifier() {
    return filterOnOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnOwnerIdentifier(KeyValuePair filterOnOwnerIdentifier) {
    this.filterOnOwnerIdentifier = filterOnOwnerIdentifier;
  }


  public ChartRequest filterOnEngineCountryGeoNameId(KeyValuePair filterOnEngineCountryGeoNameId) {
    
    this.filterOnEngineCountryGeoNameId = filterOnEngineCountryGeoNameId;
    return this;
  }

   /**
   * Get filterOnEngineCountryGeoNameId
   * @return filterOnEngineCountryGeoNameId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnEngineCountryGeoNameId() {
    return filterOnEngineCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineCountryGeoNameId(KeyValuePair filterOnEngineCountryGeoNameId) {
    this.filterOnEngineCountryGeoNameId = filterOnEngineCountryGeoNameId;
  }


  public ChartRequest filterOnEngineCityGeoNameId(KeyValuePair filterOnEngineCityGeoNameId) {
    
    this.filterOnEngineCityGeoNameId = filterOnEngineCityGeoNameId;
    return this;
  }

   /**
   * Get filterOnEngineCityGeoNameId
   * @return filterOnEngineCityGeoNameId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnEngineCityGeoNameId() {
    return filterOnEngineCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineCityGeoNameId(KeyValuePair filterOnEngineCityGeoNameId) {
    this.filterOnEngineCityGeoNameId = filterOnEngineCityGeoNameId;
  }


  public ChartRequest filterOnEngineContinentCode(KeyValuePair filterOnEngineContinentCode) {
    
    this.filterOnEngineContinentCode = filterOnEngineContinentCode;
    return this;
  }

   /**
   * Get filterOnEngineContinentCode
   * @return filterOnEngineContinentCode
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnEngineContinentCode() {
    return filterOnEngineContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineContinentCode(KeyValuePair filterOnEngineContinentCode) {
    this.filterOnEngineContinentCode = filterOnEngineContinentCode;
  }


  public ChartRequest filterOnEngineConfigurationIdentifier(KeyValuePair filterOnEngineConfigurationIdentifier) {
    
    this.filterOnEngineConfigurationIdentifier = filterOnEngineConfigurationIdentifier;
    return this;
  }

   /**
   * Get filterOnEngineConfigurationIdentifier
   * @return filterOnEngineConfigurationIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnEngineConfigurationIdentifier() {
    return filterOnEngineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineConfigurationIdentifier(KeyValuePair filterOnEngineConfigurationIdentifier) {
    this.filterOnEngineConfigurationIdentifier = filterOnEngineConfigurationIdentifier;
  }


  public ChartRequest filterOnCountryGeoNameId(KeyValuePair filterOnCountryGeoNameId) {
    
    this.filterOnCountryGeoNameId = filterOnCountryGeoNameId;
    return this;
  }

   /**
   * Get filterOnCountryGeoNameId
   * @return filterOnCountryGeoNameId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnCountryGeoNameId() {
    return filterOnCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnCountryGeoNameId(KeyValuePair filterOnCountryGeoNameId) {
    this.filterOnCountryGeoNameId = filterOnCountryGeoNameId;
  }


  public ChartRequest filterOnCityGeoNameId(KeyValuePair filterOnCityGeoNameId) {
    
    this.filterOnCityGeoNameId = filterOnCityGeoNameId;
    return this;
  }

   /**
   * Get filterOnCityGeoNameId
   * @return filterOnCityGeoNameId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnCityGeoNameId() {
    return filterOnCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnCityGeoNameId(KeyValuePair filterOnCityGeoNameId) {
    this.filterOnCityGeoNameId = filterOnCityGeoNameId;
  }


  public ChartRequest filterOnContinentCode(KeyValuePair filterOnContinentCode) {
    
    this.filterOnContinentCode = filterOnContinentCode;
    return this;
  }

   /**
   * Get filterOnContinentCode
   * @return filterOnContinentCode
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnContinentCode() {
    return filterOnContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnContinentCode(KeyValuePair filterOnContinentCode) {
    this.filterOnContinentCode = filterOnContinentCode;
  }


  public ChartRequest filterOnUserIdentifier(KeyValuePair filterOnUserIdentifier) {
    
    this.filterOnUserIdentifier = filterOnUserIdentifier;
    return this;
  }

   /**
   * Get filterOnUserIdentifier
   * @return filterOnUserIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePair getFilterOnUserIdentifier() {
    return filterOnUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnUserIdentifier(KeyValuePair filterOnUserIdentifier) {
    this.filterOnUserIdentifier = filterOnUserIdentifier;
  }


  public ChartRequest sortOnPageVisits(Boolean sortOnPageVisits) {
    
    this.sortOnPageVisits = sortOnPageVisits;
    return this;
  }

   /**
   * Sort on page visits
   * @return sortOnPageVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Sort on page visits")
  @JsonProperty(JSON_PROPERTY_SORT_ON_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPageVisits() {
    return sortOnPageVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPageVisits(Boolean sortOnPageVisits) {
    this.sortOnPageVisits = sortOnPageVisits;
  }


  public ChartRequest sortOnMapMarkerVisits(Boolean sortOnMapMarkerVisits) {
    
    this.sortOnMapMarkerVisits = sortOnMapMarkerVisits;
    return this;
  }

   /**
   * Sort on map marker visits
   * @return sortOnMapMarkerVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on map marker visits")
  @JsonProperty(JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMapMarkerVisits() {
    return sortOnMapMarkerVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMapMarkerVisits(Boolean sortOnMapMarkerVisits) {
    this.sortOnMapMarkerVisits = sortOnMapMarkerVisits;
  }


  public ChartRequest sortOnCardVisits(Boolean sortOnCardVisits) {
    
    this.sortOnCardVisits = sortOnCardVisits;
    return this;
  }

   /**
   * Sort on card visits
   * @return sortOnCardVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on card visits")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCardVisits() {
    return sortOnCardVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCardVisits(Boolean sortOnCardVisits) {
    this.sortOnCardVisits = sortOnCardVisits;
  }


  public ChartRequest sortOnBookings(Boolean sortOnBookings) {
    
    this.sortOnBookings = sortOnBookings;
    return this;
  }

   /**
   * Sort on bookings
   * @return sortOnBookings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on bookings")
  @JsonProperty(JSON_PROPERTY_SORT_ON_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnBookings() {
    return sortOnBookings;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnBookings(Boolean sortOnBookings) {
    this.sortOnBookings = sortOnBookings;
  }


  public ChartRequest sortOnCancellations(Boolean sortOnCancellations) {
    
    this.sortOnCancellations = sortOnCancellations;
    return this;
  }

   /**
   * Sort on cancellations
   * @return sortOnCancellations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancellations")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancellations() {
    return sortOnCancellations;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancellations(Boolean sortOnCancellations) {
    this.sortOnCancellations = sortOnCancellations;
  }


  public ChartRequest sortOnRoomNights(Boolean sortOnRoomNights) {
    
    this.sortOnRoomNights = sortOnRoomNights;
    return this;
  }

   /**
   * Sort on room nights
   * @return sortOnRoomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on room nights")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRoomNights() {
    return sortOnRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRoomNights(Boolean sortOnRoomNights) {
    this.sortOnRoomNights = sortOnRoomNights;
  }


  public ChartRequest sortOnMeetingRooms(Boolean sortOnMeetingRooms) {
    
    this.sortOnMeetingRooms = sortOnMeetingRooms;
    return this;
  }

   /**
   * Sort on meeting rooms
   * @return sortOnMeetingRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on meeting rooms")
  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMeetingRooms() {
    return sortOnMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMeetingRooms(Boolean sortOnMeetingRooms) {
    this.sortOnMeetingRooms = sortOnMeetingRooms;
  }


  public ChartRequest sortOnMeetingRoomsRevenue(Boolean sortOnMeetingRoomsRevenue) {
    
    this.sortOnMeetingRoomsRevenue = sortOnMeetingRoomsRevenue;
    return this;
  }

   /**
   * Sort on meeting rooms revenue
   * @return sortOnMeetingRoomsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on meeting rooms revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMeetingRoomsRevenue() {
    return sortOnMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMeetingRoomsRevenue(Boolean sortOnMeetingRoomsRevenue) {
    this.sortOnMeetingRoomsRevenue = sortOnMeetingRoomsRevenue;
  }


  public ChartRequest sortOnRestaurants(Boolean sortOnRestaurants) {
    
    this.sortOnRestaurants = sortOnRestaurants;
    return this;
  }

   /**
   * Sort on restaurants
   * @return sortOnRestaurants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on restaurants")
  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRestaurants() {
    return sortOnRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRestaurants(Boolean sortOnRestaurants) {
    this.sortOnRestaurants = sortOnRestaurants;
  }


  public ChartRequest sortOnRestaurantsRevenue(Boolean sortOnRestaurantsRevenue) {
    
    this.sortOnRestaurantsRevenue = sortOnRestaurantsRevenue;
    return this;
  }

   /**
   * Sort on restaurants revenue
   * @return sortOnRestaurantsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on restaurants revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRestaurantsRevenue() {
    return sortOnRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRestaurantsRevenue(Boolean sortOnRestaurantsRevenue) {
    this.sortOnRestaurantsRevenue = sortOnRestaurantsRevenue;
  }


  public ChartRequest sortOnSpas(Boolean sortOnSpas) {
    
    this.sortOnSpas = sortOnSpas;
    return this;
  }

   /**
   * Sort on spas
   * @return sortOnSpas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on spas")
  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnSpas() {
    return sortOnSpas;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnSpas(Boolean sortOnSpas) {
    this.sortOnSpas = sortOnSpas;
  }


  public ChartRequest sortOnSpasRevenue(Boolean sortOnSpasRevenue) {
    
    this.sortOnSpasRevenue = sortOnSpasRevenue;
    return this;
  }

   /**
   * Sort on spas revenue
   * @return sortOnSpasRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on spas revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnSpasRevenue() {
    return sortOnSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnSpasRevenue(Boolean sortOnSpasRevenue) {
    this.sortOnSpasRevenue = sortOnSpasRevenue;
  }


  public ChartRequest sortOnActivities(Boolean sortOnActivities) {
    
    this.sortOnActivities = sortOnActivities;
    return this;
  }

   /**
   * Sort on activities
   * @return sortOnActivities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on activities")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnActivities() {
    return sortOnActivities;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnActivities(Boolean sortOnActivities) {
    this.sortOnActivities = sortOnActivities;
  }


  public ChartRequest sortOnActivitiesRevenue(Boolean sortOnActivitiesRevenue) {
    
    this.sortOnActivitiesRevenue = sortOnActivitiesRevenue;
    return this;
  }

   /**
   * Sort on activities revenue
   * @return sortOnActivitiesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on activities revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnActivitiesRevenue() {
    return sortOnActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnActivitiesRevenue(Boolean sortOnActivitiesRevenue) {
    this.sortOnActivitiesRevenue = sortOnActivitiesRevenue;
  }


  public ChartRequest sortOnAttractions(Boolean sortOnAttractions) {
    
    this.sortOnAttractions = sortOnAttractions;
    return this;
  }

   /**
   * Sort on attractions
   * @return sortOnAttractions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on attractions")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAttractions() {
    return sortOnAttractions;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAttractions(Boolean sortOnAttractions) {
    this.sortOnAttractions = sortOnAttractions;
  }


  public ChartRequest sortOnAttractionsRevenue(Boolean sortOnAttractionsRevenue) {
    
    this.sortOnAttractionsRevenue = sortOnAttractionsRevenue;
    return this;
  }

   /**
   * Sort on attractions revenue
   * @return sortOnAttractionsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on attractions revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAttractionsRevenue() {
    return sortOnAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAttractionsRevenue(Boolean sortOnAttractionsRevenue) {
    this.sortOnAttractionsRevenue = sortOnAttractionsRevenue;
  }


  public ChartRequest sortOnPlaces(Boolean sortOnPlaces) {
    
    this.sortOnPlaces = sortOnPlaces;
    return this;
  }

   /**
   * Sort on places
   * @return sortOnPlaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on places")
  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPlaces() {
    return sortOnPlaces;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPlaces(Boolean sortOnPlaces) {
    this.sortOnPlaces = sortOnPlaces;
  }


  public ChartRequest sortOnPlacesRevenue(Boolean sortOnPlacesRevenue) {
    
    this.sortOnPlacesRevenue = sortOnPlacesRevenue;
    return this;
  }

   /**
   * Sort on places revenue
   * @return sortOnPlacesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on places revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPlacesRevenue() {
    return sortOnPlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPlacesRevenue(Boolean sortOnPlacesRevenue) {
    this.sortOnPlacesRevenue = sortOnPlacesRevenue;
  }


  public ChartRequest sortOnRoomTypeAncillaries(Boolean sortOnRoomTypeAncillaries) {
    
    this.sortOnRoomTypeAncillaries = sortOnRoomTypeAncillaries;
    return this;
  }

   /**
   * Sort on room type ancillaries
   * @return sortOnRoomTypeAncillaries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on room type ancillaries")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRoomTypeAncillaries() {
    return sortOnRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRoomTypeAncillaries(Boolean sortOnRoomTypeAncillaries) {
    this.sortOnRoomTypeAncillaries = sortOnRoomTypeAncillaries;
  }


  public ChartRequest sortOnRoomTypeAncillariesRevenue(Boolean sortOnRoomTypeAncillariesRevenue) {
    
    this.sortOnRoomTypeAncillariesRevenue = sortOnRoomTypeAncillariesRevenue;
    return this;
  }

   /**
   * Sort on room type ancillaries revenue
   * @return sortOnRoomTypeAncillariesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on room type ancillaries revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRoomTypeAncillariesRevenue() {
    return sortOnRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRoomTypeAncillariesRevenue(Boolean sortOnRoomTypeAncillariesRevenue) {
    this.sortOnRoomTypeAncillariesRevenue = sortOnRoomTypeAncillariesRevenue;
  }


  public ChartRequest sortOnAddOns(Boolean sortOnAddOns) {
    
    this.sortOnAddOns = sortOnAddOns;
    return this;
  }

   /**
   * Sort on add-ons
   * @return sortOnAddOns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on add-ons")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAddOns() {
    return sortOnAddOns;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAddOns(Boolean sortOnAddOns) {
    this.sortOnAddOns = sortOnAddOns;
  }


  public ChartRequest sortOnAddonsRevenue(Boolean sortOnAddonsRevenue) {
    
    this.sortOnAddonsRevenue = sortOnAddonsRevenue;
    return this;
  }

   /**
   * Sort on add-on revenue
   * @return sortOnAddonsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on add-on revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAddonsRevenue() {
    return sortOnAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAddonsRevenue(Boolean sortOnAddonsRevenue) {
    this.sortOnAddonsRevenue = sortOnAddonsRevenue;
  }


  public ChartRequest sortOnTotalRoomRevenue(Boolean sortOnTotalRoomRevenue) {
    
    this.sortOnTotalRoomRevenue = sortOnTotalRoomRevenue;
    return this;
  }

   /**
   * Sort on total room revenue
   * @return sortOnTotalRoomRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on total room revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalRoomRevenue() {
    return sortOnTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalRoomRevenue(Boolean sortOnTotalRoomRevenue) {
    this.sortOnTotalRoomRevenue = sortOnTotalRoomRevenue;
  }


  public ChartRequest sortOnTotalAncillariesRevenue(Boolean sortOnTotalAncillariesRevenue) {
    
    this.sortOnTotalAncillariesRevenue = sortOnTotalAncillariesRevenue;
    return this;
  }

   /**
   * Sort on aggregate ancillaries revenue
   * @return sortOnTotalAncillariesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on aggregate ancillaries revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalAncillariesRevenue() {
    return sortOnTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalAncillariesRevenue(Boolean sortOnTotalAncillariesRevenue) {
    this.sortOnTotalAncillariesRevenue = sortOnTotalAncillariesRevenue;
  }


  public ChartRequest sortOnTotalNetRevenue(Boolean sortOnTotalNetRevenue) {
    
    this.sortOnTotalNetRevenue = sortOnTotalNetRevenue;
    return this;
  }

   /**
   * Sort on total net revenue
   * @return sortOnTotalNetRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on total net revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalNetRevenue() {
    return sortOnTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalNetRevenue(Boolean sortOnTotalNetRevenue) {
    this.sortOnTotalNetRevenue = sortOnTotalNetRevenue;
  }


  public ChartRequest sortOnCancelledRoomNights(Boolean sortOnCancelledRoomNights) {
    
    this.sortOnCancelledRoomNights = sortOnCancelledRoomNights;
    return this;
  }

   /**
   * Sort on cancelled room nights
   * @return sortOnCancelledRoomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled room nights")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRoomNights() {
    return sortOnCancelledRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRoomNights(Boolean sortOnCancelledRoomNights) {
    this.sortOnCancelledRoomNights = sortOnCancelledRoomNights;
  }


  public ChartRequest sortOnCancelledMeetingRooms(Boolean sortOnCancelledMeetingRooms) {
    
    this.sortOnCancelledMeetingRooms = sortOnCancelledMeetingRooms;
    return this;
  }

   /**
   * Sort on cancelled meeting rooms
   * @return sortOnCancelledMeetingRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled meeting rooms")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledMeetingRooms() {
    return sortOnCancelledMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledMeetingRooms(Boolean sortOnCancelledMeetingRooms) {
    this.sortOnCancelledMeetingRooms = sortOnCancelledMeetingRooms;
  }


  public ChartRequest sortOnCancelledMeetingRoomsRevenue(Boolean sortOnCancelledMeetingRoomsRevenue) {
    
    this.sortOnCancelledMeetingRoomsRevenue = sortOnCancelledMeetingRoomsRevenue;
    return this;
  }

   /**
   * Sort on cancelled meeting rooms revenue
   * @return sortOnCancelledMeetingRoomsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled meeting rooms revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledMeetingRoomsRevenue() {
    return sortOnCancelledMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledMeetingRoomsRevenue(Boolean sortOnCancelledMeetingRoomsRevenue) {
    this.sortOnCancelledMeetingRoomsRevenue = sortOnCancelledMeetingRoomsRevenue;
  }


  public ChartRequest sortOnCancelledRestaurants(Boolean sortOnCancelledRestaurants) {
    
    this.sortOnCancelledRestaurants = sortOnCancelledRestaurants;
    return this;
  }

   /**
   * Sort on cancelled restaurants
   * @return sortOnCancelledRestaurants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled restaurants")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRestaurants() {
    return sortOnCancelledRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRestaurants(Boolean sortOnCancelledRestaurants) {
    this.sortOnCancelledRestaurants = sortOnCancelledRestaurants;
  }


  public ChartRequest sortOnCancelledRestaurantsRevenue(Boolean sortOnCancelledRestaurantsRevenue) {
    
    this.sortOnCancelledRestaurantsRevenue = sortOnCancelledRestaurantsRevenue;
    return this;
  }

   /**
   * Sort on cancelled restaurants revenue
   * @return sortOnCancelledRestaurantsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled restaurants revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRestaurantsRevenue() {
    return sortOnCancelledRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRestaurantsRevenue(Boolean sortOnCancelledRestaurantsRevenue) {
    this.sortOnCancelledRestaurantsRevenue = sortOnCancelledRestaurantsRevenue;
  }


  public ChartRequest sortOnCancelledSpas(Boolean sortOnCancelledSpas) {
    
    this.sortOnCancelledSpas = sortOnCancelledSpas;
    return this;
  }

   /**
   * Sort on cancelled spas
   * @return sortOnCancelledSpas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled spas")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledSpas() {
    return sortOnCancelledSpas;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledSpas(Boolean sortOnCancelledSpas) {
    this.sortOnCancelledSpas = sortOnCancelledSpas;
  }


  public ChartRequest sortOnCancelledSpasRevenue(Boolean sortOnCancelledSpasRevenue) {
    
    this.sortOnCancelledSpasRevenue = sortOnCancelledSpasRevenue;
    return this;
  }

   /**
   * Sort on cancelled spas revenue
   * @return sortOnCancelledSpasRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled spas revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledSpasRevenue() {
    return sortOnCancelledSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledSpasRevenue(Boolean sortOnCancelledSpasRevenue) {
    this.sortOnCancelledSpasRevenue = sortOnCancelledSpasRevenue;
  }


  public ChartRequest sortOnCancelledActivities(Boolean sortOnCancelledActivities) {
    
    this.sortOnCancelledActivities = sortOnCancelledActivities;
    return this;
  }

   /**
   * Sort on cancelled activities
   * @return sortOnCancelledActivities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled activities")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledActivities() {
    return sortOnCancelledActivities;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledActivities(Boolean sortOnCancelledActivities) {
    this.sortOnCancelledActivities = sortOnCancelledActivities;
  }


  public ChartRequest sortOnCancelledActivitiesRevenue(Boolean sortOnCancelledActivitiesRevenue) {
    
    this.sortOnCancelledActivitiesRevenue = sortOnCancelledActivitiesRevenue;
    return this;
  }

   /**
   * Sort on cancelled activities revenue
   * @return sortOnCancelledActivitiesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled activities revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledActivitiesRevenue() {
    return sortOnCancelledActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledActivitiesRevenue(Boolean sortOnCancelledActivitiesRevenue) {
    this.sortOnCancelledActivitiesRevenue = sortOnCancelledActivitiesRevenue;
  }


  public ChartRequest sortOnCancelledAttractions(Boolean sortOnCancelledAttractions) {
    
    this.sortOnCancelledAttractions = sortOnCancelledAttractions;
    return this;
  }

   /**
   * Sort on cancelled attractions
   * @return sortOnCancelledAttractions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled attractions")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAttractions() {
    return sortOnCancelledAttractions;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAttractions(Boolean sortOnCancelledAttractions) {
    this.sortOnCancelledAttractions = sortOnCancelledAttractions;
  }


  public ChartRequest sortOnCancelledAttractionsRevenue(Boolean sortOnCancelledAttractionsRevenue) {
    
    this.sortOnCancelledAttractionsRevenue = sortOnCancelledAttractionsRevenue;
    return this;
  }

   /**
   * Sort on cancelled attractions revenue
   * @return sortOnCancelledAttractionsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled attractions revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAttractionsRevenue() {
    return sortOnCancelledAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAttractionsRevenue(Boolean sortOnCancelledAttractionsRevenue) {
    this.sortOnCancelledAttractionsRevenue = sortOnCancelledAttractionsRevenue;
  }


  public ChartRequest sortOnCancelledPlaces(Boolean sortOnCancelledPlaces) {
    
    this.sortOnCancelledPlaces = sortOnCancelledPlaces;
    return this;
  }

   /**
   * Sort on cancelled places
   * @return sortOnCancelledPlaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled places")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledPlaces() {
    return sortOnCancelledPlaces;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledPlaces(Boolean sortOnCancelledPlaces) {
    this.sortOnCancelledPlaces = sortOnCancelledPlaces;
  }


  public ChartRequest sortOnCancelledPlacesRevenue(Boolean sortOnCancelledPlacesRevenue) {
    
    this.sortOnCancelledPlacesRevenue = sortOnCancelledPlacesRevenue;
    return this;
  }

   /**
   * Sort on cancelled places revenue
   * @return sortOnCancelledPlacesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled places revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledPlacesRevenue() {
    return sortOnCancelledPlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledPlacesRevenue(Boolean sortOnCancelledPlacesRevenue) {
    this.sortOnCancelledPlacesRevenue = sortOnCancelledPlacesRevenue;
  }


  public ChartRequest sortOnCancelledTotalRoomRevenue(Boolean sortOnCancelledTotalRoomRevenue) {
    
    this.sortOnCancelledTotalRoomRevenue = sortOnCancelledTotalRoomRevenue;
    return this;
  }

   /**
   * Sort on cancelled total room revenue
   * @return sortOnCancelledTotalRoomRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled total room revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalRoomRevenue() {
    return sortOnCancelledTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalRoomRevenue(Boolean sortOnCancelledTotalRoomRevenue) {
    this.sortOnCancelledTotalRoomRevenue = sortOnCancelledTotalRoomRevenue;
  }


  public ChartRequest sortOnCancelledTotalAncillariesRevenue(Boolean sortOnCancelledTotalAncillariesRevenue) {
    
    this.sortOnCancelledTotalAncillariesRevenue = sortOnCancelledTotalAncillariesRevenue;
    return this;
  }

   /**
   * Sort on cancelled aggregate total ancillaries revenue
   * @return sortOnCancelledTotalAncillariesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled aggregate total ancillaries revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalAncillariesRevenue() {
    return sortOnCancelledTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalAncillariesRevenue(Boolean sortOnCancelledTotalAncillariesRevenue) {
    this.sortOnCancelledTotalAncillariesRevenue = sortOnCancelledTotalAncillariesRevenue;
  }


  public ChartRequest sortOnCancelledRoomTypeAncillaries(Boolean sortOnCancelledRoomTypeAncillaries) {
    
    this.sortOnCancelledRoomTypeAncillaries = sortOnCancelledRoomTypeAncillaries;
    return this;
  }

   /**
   * Sort on cancelled room type ancillaries
   * @return sortOnCancelledRoomTypeAncillaries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled room type ancillaries")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRoomTypeAncillaries() {
    return sortOnCancelledRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRoomTypeAncillaries(Boolean sortOnCancelledRoomTypeAncillaries) {
    this.sortOnCancelledRoomTypeAncillaries = sortOnCancelledRoomTypeAncillaries;
  }


  public ChartRequest sortOnCancelledRoomTypeAncillariesRevenue(Boolean sortOnCancelledRoomTypeAncillariesRevenue) {
    
    this.sortOnCancelledRoomTypeAncillariesRevenue = sortOnCancelledRoomTypeAncillariesRevenue;
    return this;
  }

   /**
   * Sort on cancelled room type ancillaries revenue
   * @return sortOnCancelledRoomTypeAncillariesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled room type ancillaries revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRoomTypeAncillariesRevenue() {
    return sortOnCancelledRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRoomTypeAncillariesRevenue(Boolean sortOnCancelledRoomTypeAncillariesRevenue) {
    this.sortOnCancelledRoomTypeAncillariesRevenue = sortOnCancelledRoomTypeAncillariesRevenue;
  }


  public ChartRequest sortOnCancelledAddOns(Boolean sortOnCancelledAddOns) {
    
    this.sortOnCancelledAddOns = sortOnCancelledAddOns;
    return this;
  }

   /**
   * Sort on cancelled add-ons
   * @return sortOnCancelledAddOns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled add-ons")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAddOns() {
    return sortOnCancelledAddOns;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAddOns(Boolean sortOnCancelledAddOns) {
    this.sortOnCancelledAddOns = sortOnCancelledAddOns;
  }


  public ChartRequest sortOnCancelledAddonsRevenue(Boolean sortOnCancelledAddonsRevenue) {
    
    this.sortOnCancelledAddonsRevenue = sortOnCancelledAddonsRevenue;
    return this;
  }

   /**
   * Sort on cancelled add-o revenue
   * @return sortOnCancelledAddonsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled add-o revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAddonsRevenue() {
    return sortOnCancelledAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAddonsRevenue(Boolean sortOnCancelledAddonsRevenue) {
    this.sortOnCancelledAddonsRevenue = sortOnCancelledAddonsRevenue;
  }


  public ChartRequest sortOnCancelledTotalNetRevenue(Boolean sortOnCancelledTotalNetRevenue) {
    
    this.sortOnCancelledTotalNetRevenue = sortOnCancelledTotalNetRevenue;
    return this;
  }

   /**
   * Sort on cancelled total net revenue
   * @return sortOnCancelledTotalNetRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Sort on cancelled total net revenue")
  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalNetRevenue() {
    return sortOnCancelledTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalNetRevenue(Boolean sortOnCancelledTotalNetRevenue) {
    this.sortOnCancelledTotalNetRevenue = sortOnCancelledTotalNetRevenue;
  }


  public ChartRequest includePageVisits(Boolean includePageVisits) {
    
    this.includePageVisits = includePageVisits;
    return this;
  }

   /**
   * Include page visits
   * @return includePageVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include page visits")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePageVisits() {
    return includePageVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePageVisits(Boolean includePageVisits) {
    this.includePageVisits = includePageVisits;
  }


  public ChartRequest includeMapMarkerVisits(Boolean includeMapMarkerVisits) {
    
    this.includeMapMarkerVisits = includeMapMarkerVisits;
    return this;
  }

   /**
   * Include map marker visits
   * @return includeMapMarkerVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include map marker visits")
  @JsonProperty(JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMapMarkerVisits() {
    return includeMapMarkerVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMapMarkerVisits(Boolean includeMapMarkerVisits) {
    this.includeMapMarkerVisits = includeMapMarkerVisits;
  }


  public ChartRequest includeCardVisits(Boolean includeCardVisits) {
    
    this.includeCardVisits = includeCardVisits;
    return this;
  }

   /**
   * Include card visits
   * @return includeCardVisits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include card visits")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCardVisits() {
    return includeCardVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCardVisits(Boolean includeCardVisits) {
    this.includeCardVisits = includeCardVisits;
  }


  public ChartRequest includeBookings(Boolean includeBookings) {
    
    this.includeBookings = includeBookings;
    return this;
  }

   /**
   * Include bookings
   * @return includeBookings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include bookings")
  @JsonProperty(JSON_PROPERTY_INCLUDE_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeBookings() {
    return includeBookings;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeBookings(Boolean includeBookings) {
    this.includeBookings = includeBookings;
  }


  public ChartRequest includeCancellations(Boolean includeCancellations) {
    
    this.includeCancellations = includeCancellations;
    return this;
  }

   /**
   * Include cancellations
   * @return includeCancellations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancellations")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancellations() {
    return includeCancellations;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancellations(Boolean includeCancellations) {
    this.includeCancellations = includeCancellations;
  }


  public ChartRequest includeRoomNights(Boolean includeRoomNights) {
    
    this.includeRoomNights = includeRoomNights;
    return this;
  }

   /**
   * Include room nights
   * @return includeRoomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include room nights")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRoomNights() {
    return includeRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRoomNights(Boolean includeRoomNights) {
    this.includeRoomNights = includeRoomNights;
  }


  public ChartRequest includeMeetingRooms(Boolean includeMeetingRooms) {
    
    this.includeMeetingRooms = includeMeetingRooms;
    return this;
  }

   /**
   * Include meeting rooms
   * @return includeMeetingRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include meeting rooms")
  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMeetingRooms() {
    return includeMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMeetingRooms(Boolean includeMeetingRooms) {
    this.includeMeetingRooms = includeMeetingRooms;
  }


  public ChartRequest includeMeetingRoomsRevenue(Boolean includeMeetingRoomsRevenue) {
    
    this.includeMeetingRoomsRevenue = includeMeetingRoomsRevenue;
    return this;
  }

   /**
   * Include meeting rooms revenue
   * @return includeMeetingRoomsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include meeting rooms revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMeetingRoomsRevenue() {
    return includeMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMeetingRoomsRevenue(Boolean includeMeetingRoomsRevenue) {
    this.includeMeetingRoomsRevenue = includeMeetingRoomsRevenue;
  }


  public ChartRequest includeRestaurants(Boolean includeRestaurants) {
    
    this.includeRestaurants = includeRestaurants;
    return this;
  }

   /**
   * Include restaurants
   * @return includeRestaurants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include restaurants")
  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRestaurants() {
    return includeRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRestaurants(Boolean includeRestaurants) {
    this.includeRestaurants = includeRestaurants;
  }


  public ChartRequest includeRestaurantsRevenue(Boolean includeRestaurantsRevenue) {
    
    this.includeRestaurantsRevenue = includeRestaurantsRevenue;
    return this;
  }

   /**
   * Include restaurants revenue
   * @return includeRestaurantsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include restaurants revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRestaurantsRevenue() {
    return includeRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRestaurantsRevenue(Boolean includeRestaurantsRevenue) {
    this.includeRestaurantsRevenue = includeRestaurantsRevenue;
  }


  public ChartRequest includeSpas(Boolean includeSpas) {
    
    this.includeSpas = includeSpas;
    return this;
  }

   /**
   * Include spas
   * @return includeSpas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include spas")
  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeSpas() {
    return includeSpas;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeSpas(Boolean includeSpas) {
    this.includeSpas = includeSpas;
  }


  public ChartRequest includeSpasRevenue(Boolean includeSpasRevenue) {
    
    this.includeSpasRevenue = includeSpasRevenue;
    return this;
  }

   /**
   * Include spas revenue
   * @return includeSpasRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include spas revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeSpasRevenue() {
    return includeSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeSpasRevenue(Boolean includeSpasRevenue) {
    this.includeSpasRevenue = includeSpasRevenue;
  }


  public ChartRequest includeActivities(Boolean includeActivities) {
    
    this.includeActivities = includeActivities;
    return this;
  }

   /**
   * Include activities
   * @return includeActivities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include activities")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeActivities() {
    return includeActivities;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeActivities(Boolean includeActivities) {
    this.includeActivities = includeActivities;
  }


  public ChartRequest includeActivitiesRevenue(Boolean includeActivitiesRevenue) {
    
    this.includeActivitiesRevenue = includeActivitiesRevenue;
    return this;
  }

   /**
   * Include activities revenue
   * @return includeActivitiesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include activities revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeActivitiesRevenue() {
    return includeActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeActivitiesRevenue(Boolean includeActivitiesRevenue) {
    this.includeActivitiesRevenue = includeActivitiesRevenue;
  }


  public ChartRequest includeAttractions(Boolean includeAttractions) {
    
    this.includeAttractions = includeAttractions;
    return this;
  }

   /**
   * Include attractions
   * @return includeAttractions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include attractions")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAttractions() {
    return includeAttractions;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAttractions(Boolean includeAttractions) {
    this.includeAttractions = includeAttractions;
  }


  public ChartRequest includeAttractionsRevenue(Boolean includeAttractionsRevenue) {
    
    this.includeAttractionsRevenue = includeAttractionsRevenue;
    return this;
  }

   /**
   * Include attractions revenue
   * @return includeAttractionsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include attractions revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAttractionsRevenue() {
    return includeAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAttractionsRevenue(Boolean includeAttractionsRevenue) {
    this.includeAttractionsRevenue = includeAttractionsRevenue;
  }


  public ChartRequest includePlaces(Boolean includePlaces) {
    
    this.includePlaces = includePlaces;
    return this;
  }

   /**
   * Include places
   * @return includePlaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include places")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePlaces() {
    return includePlaces;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePlaces(Boolean includePlaces) {
    this.includePlaces = includePlaces;
  }


  public ChartRequest includePlacesRevenue(Boolean includePlacesRevenue) {
    
    this.includePlacesRevenue = includePlacesRevenue;
    return this;
  }

   /**
   * Include places revenue
   * @return includePlacesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include places revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePlacesRevenue() {
    return includePlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePlacesRevenue(Boolean includePlacesRevenue) {
    this.includePlacesRevenue = includePlacesRevenue;
  }


  public ChartRequest includeRoomTypeAncillaries(Boolean includeRoomTypeAncillaries) {
    
    this.includeRoomTypeAncillaries = includeRoomTypeAncillaries;
    return this;
  }

   /**
   * Include room type ancillaries
   * @return includeRoomTypeAncillaries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include room type ancillaries")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRoomTypeAncillaries() {
    return includeRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRoomTypeAncillaries(Boolean includeRoomTypeAncillaries) {
    this.includeRoomTypeAncillaries = includeRoomTypeAncillaries;
  }


  public ChartRequest includeRoomTypeAncillariesRevenue(Boolean includeRoomTypeAncillariesRevenue) {
    
    this.includeRoomTypeAncillariesRevenue = includeRoomTypeAncillariesRevenue;
    return this;
  }

   /**
   * Include packages revenue
   * @return includeRoomTypeAncillariesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include packages revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRoomTypeAncillariesRevenue() {
    return includeRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRoomTypeAncillariesRevenue(Boolean includeRoomTypeAncillariesRevenue) {
    this.includeRoomTypeAncillariesRevenue = includeRoomTypeAncillariesRevenue;
  }


  public ChartRequest includeAddOns(Boolean includeAddOns) {
    
    this.includeAddOns = includeAddOns;
    return this;
  }

   /**
   * Include add-ons
   * @return includeAddOns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include add-ons")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAddOns() {
    return includeAddOns;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAddOns(Boolean includeAddOns) {
    this.includeAddOns = includeAddOns;
  }


  public ChartRequest includeAddOnsRevenue(Boolean includeAddOnsRevenue) {
    
    this.includeAddOnsRevenue = includeAddOnsRevenue;
    return this;
  }

   /**
   * Include add-ons revenue
   * @return includeAddOnsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include add-ons revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAddOnsRevenue() {
    return includeAddOnsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAddOnsRevenue(Boolean includeAddOnsRevenue) {
    this.includeAddOnsRevenue = includeAddOnsRevenue;
  }


  public ChartRequest includeTotalRoomRevenue(Boolean includeTotalRoomRevenue) {
    
    this.includeTotalRoomRevenue = includeTotalRoomRevenue;
    return this;
  }

   /**
   * Include total room revenue
   * @return includeTotalRoomRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include total room revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalRoomRevenue() {
    return includeTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalRoomRevenue(Boolean includeTotalRoomRevenue) {
    this.includeTotalRoomRevenue = includeTotalRoomRevenue;
  }


  public ChartRequest includeAverageRoomRate(Boolean includeAverageRoomRate) {
    
    this.includeAverageRoomRate = includeAverageRoomRate;
    return this;
  }

   /**
   * Include average room rate
   * @return includeAverageRoomRate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include average room rate")
  @JsonProperty(JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAverageRoomRate() {
    return includeAverageRoomRate;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAverageRoomRate(Boolean includeAverageRoomRate) {
    this.includeAverageRoomRate = includeAverageRoomRate;
  }


  public ChartRequest includeTotalAncillariesRevenue(Boolean includeTotalAncillariesRevenue) {
    
    this.includeTotalAncillariesRevenue = includeTotalAncillariesRevenue;
    return this;
  }

   /**
   * Include combined packages and add-os revenue
   * @return includeTotalAncillariesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include combined packages and add-os revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalAncillariesRevenue() {
    return includeTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalAncillariesRevenue(Boolean includeTotalAncillariesRevenue) {
    this.includeTotalAncillariesRevenue = includeTotalAncillariesRevenue;
  }


  public ChartRequest includeTotalNetRevenue(Boolean includeTotalNetRevenue) {
    
    this.includeTotalNetRevenue = includeTotalNetRevenue;
    return this;
  }

   /**
   * Include total net revenue
   * @return includeTotalNetRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include total net revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalNetRevenue() {
    return includeTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalNetRevenue(Boolean includeTotalNetRevenue) {
    this.includeTotalNetRevenue = includeTotalNetRevenue;
  }


  public ChartRequest includeCancelledRoomNights(Boolean includeCancelledRoomNights) {
    
    this.includeCancelledRoomNights = includeCancelledRoomNights;
    return this;
  }

   /**
   * Include cancelled room nights
   * @return includeCancelledRoomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled room nights")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRoomNights() {
    return includeCancelledRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRoomNights(Boolean includeCancelledRoomNights) {
    this.includeCancelledRoomNights = includeCancelledRoomNights;
  }


  public ChartRequest includeCancelledMeetingRooms(Boolean includeCancelledMeetingRooms) {
    
    this.includeCancelledMeetingRooms = includeCancelledMeetingRooms;
    return this;
  }

   /**
   * Include cancelled meeting rooms
   * @return includeCancelledMeetingRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled meeting rooms")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledMeetingRooms() {
    return includeCancelledMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledMeetingRooms(Boolean includeCancelledMeetingRooms) {
    this.includeCancelledMeetingRooms = includeCancelledMeetingRooms;
  }


  public ChartRequest includeCancelledMeetingRoomsRevenue(Boolean includeCancelledMeetingRoomsRevenue) {
    
    this.includeCancelledMeetingRoomsRevenue = includeCancelledMeetingRoomsRevenue;
    return this;
  }

   /**
   * Include cancelled meeting rooms revenue
   * @return includeCancelledMeetingRoomsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled meeting rooms revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledMeetingRoomsRevenue() {
    return includeCancelledMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledMeetingRoomsRevenue(Boolean includeCancelledMeetingRoomsRevenue) {
    this.includeCancelledMeetingRoomsRevenue = includeCancelledMeetingRoomsRevenue;
  }


  public ChartRequest includeCancelledRestaurants(Boolean includeCancelledRestaurants) {
    
    this.includeCancelledRestaurants = includeCancelledRestaurants;
    return this;
  }

   /**
   * Include cancelled restaurants
   * @return includeCancelledRestaurants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled restaurants")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRestaurants() {
    return includeCancelledRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRestaurants(Boolean includeCancelledRestaurants) {
    this.includeCancelledRestaurants = includeCancelledRestaurants;
  }


  public ChartRequest includeCancelledRestaurantsRevenue(Boolean includeCancelledRestaurantsRevenue) {
    
    this.includeCancelledRestaurantsRevenue = includeCancelledRestaurantsRevenue;
    return this;
  }

   /**
   * Include cancelled restaurants revenue
   * @return includeCancelledRestaurantsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled restaurants revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRestaurantsRevenue() {
    return includeCancelledRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRestaurantsRevenue(Boolean includeCancelledRestaurantsRevenue) {
    this.includeCancelledRestaurantsRevenue = includeCancelledRestaurantsRevenue;
  }


  public ChartRequest includeCancelledSpas(Boolean includeCancelledSpas) {
    
    this.includeCancelledSpas = includeCancelledSpas;
    return this;
  }

   /**
   * Include cancelled spas
   * @return includeCancelledSpas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled spas")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledSpas() {
    return includeCancelledSpas;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledSpas(Boolean includeCancelledSpas) {
    this.includeCancelledSpas = includeCancelledSpas;
  }


  public ChartRequest includeCancelledSpasRevenue(Boolean includeCancelledSpasRevenue) {
    
    this.includeCancelledSpasRevenue = includeCancelledSpasRevenue;
    return this;
  }

   /**
   * Include cancelled spas revenue
   * @return includeCancelledSpasRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled spas revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledSpasRevenue() {
    return includeCancelledSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledSpasRevenue(Boolean includeCancelledSpasRevenue) {
    this.includeCancelledSpasRevenue = includeCancelledSpasRevenue;
  }


  public ChartRequest includeCancelledActivities(Boolean includeCancelledActivities) {
    
    this.includeCancelledActivities = includeCancelledActivities;
    return this;
  }

   /**
   * Include cancelled activities
   * @return includeCancelledActivities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled activities")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledActivities() {
    return includeCancelledActivities;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledActivities(Boolean includeCancelledActivities) {
    this.includeCancelledActivities = includeCancelledActivities;
  }


  public ChartRequest includeCancelledActivitiesRevenue(Boolean includeCancelledActivitiesRevenue) {
    
    this.includeCancelledActivitiesRevenue = includeCancelledActivitiesRevenue;
    return this;
  }

   /**
   * Include cancelled activities revenue
   * @return includeCancelledActivitiesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled activities revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledActivitiesRevenue() {
    return includeCancelledActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledActivitiesRevenue(Boolean includeCancelledActivitiesRevenue) {
    this.includeCancelledActivitiesRevenue = includeCancelledActivitiesRevenue;
  }


  public ChartRequest includeCancelledAttractions(Boolean includeCancelledAttractions) {
    
    this.includeCancelledAttractions = includeCancelledAttractions;
    return this;
  }

   /**
   * Include cancelled attractions
   * @return includeCancelledAttractions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled attractions")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAttractions() {
    return includeCancelledAttractions;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAttractions(Boolean includeCancelledAttractions) {
    this.includeCancelledAttractions = includeCancelledAttractions;
  }


  public ChartRequest includeCancelledAttractionsRevenue(Boolean includeCancelledAttractionsRevenue) {
    
    this.includeCancelledAttractionsRevenue = includeCancelledAttractionsRevenue;
    return this;
  }

   /**
   * Include cancelled attractions revenue
   * @return includeCancelledAttractionsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled attractions revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAttractionsRevenue() {
    return includeCancelledAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAttractionsRevenue(Boolean includeCancelledAttractionsRevenue) {
    this.includeCancelledAttractionsRevenue = includeCancelledAttractionsRevenue;
  }


  public ChartRequest includeCancelledPlaces(Boolean includeCancelledPlaces) {
    
    this.includeCancelledPlaces = includeCancelledPlaces;
    return this;
  }

   /**
   * Include cancelled places
   * @return includeCancelledPlaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled places")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledPlaces() {
    return includeCancelledPlaces;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledPlaces(Boolean includeCancelledPlaces) {
    this.includeCancelledPlaces = includeCancelledPlaces;
  }


  public ChartRequest includeCancelledPlacesRevenue(Boolean includeCancelledPlacesRevenue) {
    
    this.includeCancelledPlacesRevenue = includeCancelledPlacesRevenue;
    return this;
  }

   /**
   * Include cancelled places revenue
   * @return includeCancelledPlacesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled places revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledPlacesRevenue() {
    return includeCancelledPlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledPlacesRevenue(Boolean includeCancelledPlacesRevenue) {
    this.includeCancelledPlacesRevenue = includeCancelledPlacesRevenue;
  }


  public ChartRequest includeCancelledRoomTypeAncillaries(Boolean includeCancelledRoomTypeAncillaries) {
    
    this.includeCancelledRoomTypeAncillaries = includeCancelledRoomTypeAncillaries;
    return this;
  }

   /**
   * Include cancelled packages
   * @return includeCancelledRoomTypeAncillaries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled packages")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRoomTypeAncillaries() {
    return includeCancelledRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRoomTypeAncillaries(Boolean includeCancelledRoomTypeAncillaries) {
    this.includeCancelledRoomTypeAncillaries = includeCancelledRoomTypeAncillaries;
  }


  public ChartRequest includeCancelledRoomTypeAncillariesRevenue(Boolean includeCancelledRoomTypeAncillariesRevenue) {
    
    this.includeCancelledRoomTypeAncillariesRevenue = includeCancelledRoomTypeAncillariesRevenue;
    return this;
  }

   /**
   * Include cancelled packages revenue
   * @return includeCancelledRoomTypeAncillariesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled packages revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRoomTypeAncillariesRevenue() {
    return includeCancelledRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRoomTypeAncillariesRevenue(Boolean includeCancelledRoomTypeAncillariesRevenue) {
    this.includeCancelledRoomTypeAncillariesRevenue = includeCancelledRoomTypeAncillariesRevenue;
  }


  public ChartRequest includeCancelledAddOns(Boolean includeCancelledAddOns) {
    
    this.includeCancelledAddOns = includeCancelledAddOns;
    return this;
  }

   /**
   * Include cancelled add-ons
   * @return includeCancelledAddOns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled add-ons")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAddOns() {
    return includeCancelledAddOns;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAddOns(Boolean includeCancelledAddOns) {
    this.includeCancelledAddOns = includeCancelledAddOns;
  }


  public ChartRequest includeCancelledAddOnsRevenue(Boolean includeCancelledAddOnsRevenue) {
    
    this.includeCancelledAddOnsRevenue = includeCancelledAddOnsRevenue;
    return this;
  }

   /**
   * Include cancelled add-ons revenue
   * @return includeCancelledAddOnsRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled add-ons revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAddOnsRevenue() {
    return includeCancelledAddOnsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAddOnsRevenue(Boolean includeCancelledAddOnsRevenue) {
    this.includeCancelledAddOnsRevenue = includeCancelledAddOnsRevenue;
  }


  public ChartRequest includeCancelledTotalRoomRevenue(Boolean includeCancelledTotalRoomRevenue) {
    
    this.includeCancelledTotalRoomRevenue = includeCancelledTotalRoomRevenue;
    return this;
  }

   /**
   * Include cancelled total room revenue
   * @return includeCancelledTotalRoomRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled total room revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalRoomRevenue() {
    return includeCancelledTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalRoomRevenue(Boolean includeCancelledTotalRoomRevenue) {
    this.includeCancelledTotalRoomRevenue = includeCancelledTotalRoomRevenue;
  }


  public ChartRequest includeCancelledTotalAncillariesRevenue(Boolean includeCancelledTotalAncillariesRevenue) {
    
    this.includeCancelledTotalAncillariesRevenue = includeCancelledTotalAncillariesRevenue;
    return this;
  }

   /**
   * Include combined cancelled package and add-on revenue
   * @return includeCancelledTotalAncillariesRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include combined cancelled package and add-on revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalAncillariesRevenue() {
    return includeCancelledTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalAncillariesRevenue(Boolean includeCancelledTotalAncillariesRevenue) {
    this.includeCancelledTotalAncillariesRevenue = includeCancelledTotalAncillariesRevenue;
  }


  public ChartRequest includeCancelledTotalNetRevenue(Boolean includeCancelledTotalNetRevenue) {
    
    this.includeCancelledTotalNetRevenue = includeCancelledTotalNetRevenue;
    return this;
  }

   /**
   * Include cancelled total net revenue
   * @return includeCancelledTotalNetRevenue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Include cancelled total net revenue")
  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalNetRevenue() {
    return includeCancelledTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalNetRevenue(Boolean includeCancelledTotalNetRevenue) {
    this.includeCancelledTotalNetRevenue = includeCancelledTotalNetRevenue;
  }


  public ChartRequest groupOnChannelSubType(Boolean groupOnChannelSubType) {
    
    this.groupOnChannelSubType = groupOnChannelSubType;
    return this;
  }

   /**
   * Group on  channel sub type
   * @return groupOnChannelSubType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on  channel sub type")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnChannelSubType() {
    return groupOnChannelSubType;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnChannelSubType(Boolean groupOnChannelSubType) {
    this.groupOnChannelSubType = groupOnChannelSubType;
  }


  public ChartRequest groupOnOwnerIdentifier(Boolean groupOnOwnerIdentifier) {
    
    this.groupOnOwnerIdentifier = groupOnOwnerIdentifier;
    return this;
  }

   /**
   * Group on owner identifier
   * @return groupOnOwnerIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on owner identifier")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnOwnerIdentifier() {
    return groupOnOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnOwnerIdentifier(Boolean groupOnOwnerIdentifier) {
    this.groupOnOwnerIdentifier = groupOnOwnerIdentifier;
  }


  public ChartRequest groupOnEngineIdentifier(Boolean groupOnEngineIdentifier) {
    
    this.groupOnEngineIdentifier = groupOnEngineIdentifier;
    return this;
  }

   /**
   * Group on application identifier
   * @return groupOnEngineIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on application identifier")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineIdentifier() {
    return groupOnEngineIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineIdentifier(Boolean groupOnEngineIdentifier) {
    this.groupOnEngineIdentifier = groupOnEngineIdentifier;
  }


  public ChartRequest groupOnEngineCountryGeoNameId(Boolean groupOnEngineCountryGeoNameId) {
    
    this.groupOnEngineCountryGeoNameId = groupOnEngineCountryGeoNameId;
    return this;
  }

   /**
   * Group on application country geoNameId
   * @return groupOnEngineCountryGeoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on application country geoNameId")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineCountryGeoNameId() {
    return groupOnEngineCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineCountryGeoNameId(Boolean groupOnEngineCountryGeoNameId) {
    this.groupOnEngineCountryGeoNameId = groupOnEngineCountryGeoNameId;
  }


  public ChartRequest groupOnEngineCityGeoNameId(Boolean groupOnEngineCityGeoNameId) {
    
    this.groupOnEngineCityGeoNameId = groupOnEngineCityGeoNameId;
    return this;
  }

   /**
   * Group on application city geoNameId
   * @return groupOnEngineCityGeoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on application city geoNameId")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineCityGeoNameId() {
    return groupOnEngineCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineCityGeoNameId(Boolean groupOnEngineCityGeoNameId) {
    this.groupOnEngineCityGeoNameId = groupOnEngineCityGeoNameId;
  }


  public ChartRequest groupOnEngineContinentCode(Boolean groupOnEngineContinentCode) {
    
    this.groupOnEngineContinentCode = groupOnEngineContinentCode;
    return this;
  }

   /**
   * Group on application continent code
   * @return groupOnEngineContinentCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on application continent code")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineContinentCode() {
    return groupOnEngineContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineContinentCode(Boolean groupOnEngineContinentCode) {
    this.groupOnEngineContinentCode = groupOnEngineContinentCode;
  }


  public ChartRequest groupOnEngineConfigurationIdentifier(Boolean groupOnEngineConfigurationIdentifier) {
    
    this.groupOnEngineConfigurationIdentifier = groupOnEngineConfigurationIdentifier;
    return this;
  }

   /**
   * Group on customization identifier
   * @return groupOnEngineConfigurationIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on customization identifier")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineConfigurationIdentifier() {
    return groupOnEngineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineConfigurationIdentifier(Boolean groupOnEngineConfigurationIdentifier) {
    this.groupOnEngineConfigurationIdentifier = groupOnEngineConfigurationIdentifier;
  }


  public ChartRequest groupOnCountryGeoNameId(Boolean groupOnCountryGeoNameId) {
    
    this.groupOnCountryGeoNameId = groupOnCountryGeoNameId;
    return this;
  }

   /**
   * Group on country geoNameId
   * @return groupOnCountryGeoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on country geoNameId")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnCountryGeoNameId() {
    return groupOnCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnCountryGeoNameId(Boolean groupOnCountryGeoNameId) {
    this.groupOnCountryGeoNameId = groupOnCountryGeoNameId;
  }


  public ChartRequest groupOnCityGeoNameId(Boolean groupOnCityGeoNameId) {
    
    this.groupOnCityGeoNameId = groupOnCityGeoNameId;
    return this;
  }

   /**
   * Group on city geoNameId
   * @return groupOnCityGeoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on city geoNameId")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnCityGeoNameId() {
    return groupOnCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnCityGeoNameId(Boolean groupOnCityGeoNameId) {
    this.groupOnCityGeoNameId = groupOnCityGeoNameId;
  }


  public ChartRequest groupOnContinentCode(Boolean groupOnContinentCode) {
    
    this.groupOnContinentCode = groupOnContinentCode;
    return this;
  }

   /**
   * Group on continent code
   * @return groupOnContinentCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on continent code")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnContinentCode() {
    return groupOnContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnContinentCode(Boolean groupOnContinentCode) {
    this.groupOnContinentCode = groupOnContinentCode;
  }


  public ChartRequest groupOnHotelIdentifier(Boolean groupOnHotelIdentifier) {
    
    this.groupOnHotelIdentifier = groupOnHotelIdentifier;
    return this;
  }

   /**
   * Group on hotel identifier
   * @return groupOnHotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on hotel identifier")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnHotelIdentifier() {
    return groupOnHotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnHotelIdentifier(Boolean groupOnHotelIdentifier) {
    this.groupOnHotelIdentifier = groupOnHotelIdentifier;
  }


  public ChartRequest groupOnUserIdentifier(Boolean groupOnUserIdentifier) {
    
    this.groupOnUserIdentifier = groupOnUserIdentifier;
    return this;
  }

   /**
   * Group on user identifier
   * @return groupOnUserIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Group on user identifier")
  @JsonProperty(JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnUserIdentifier() {
    return groupOnUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnUserIdentifier(Boolean groupOnUserIdentifier) {
    this.groupOnUserIdentifier = groupOnUserIdentifier;
  }


  public ChartRequest currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code
   * @return currencyCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "EUR", value = "Currency code")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChartRequest chartRequest = (ChartRequest) o;
    return Objects.equals(this.series, chartRequest.series) &&
        Objects.equals(this.timeSeriesUnits, chartRequest.timeSeriesUnits) &&
        Objects.equals(this.startDate, chartRequest.startDate) &&
        Objects.equals(this.endDate, chartRequest.endDate) &&
        Objects.equals(this.filterOnHotelIdentifier, chartRequest.filterOnHotelIdentifier) &&
        Objects.equals(this.filterOnChannelSubType, chartRequest.filterOnChannelSubType) &&
        Objects.equals(this.filterOnOwnerIdentifier, chartRequest.filterOnOwnerIdentifier) &&
        Objects.equals(this.filterOnEngineCountryGeoNameId, chartRequest.filterOnEngineCountryGeoNameId) &&
        Objects.equals(this.filterOnEngineCityGeoNameId, chartRequest.filterOnEngineCityGeoNameId) &&
        Objects.equals(this.filterOnEngineContinentCode, chartRequest.filterOnEngineContinentCode) &&
        Objects.equals(this.filterOnEngineConfigurationIdentifier, chartRequest.filterOnEngineConfigurationIdentifier) &&
        Objects.equals(this.filterOnCountryGeoNameId, chartRequest.filterOnCountryGeoNameId) &&
        Objects.equals(this.filterOnCityGeoNameId, chartRequest.filterOnCityGeoNameId) &&
        Objects.equals(this.filterOnContinentCode, chartRequest.filterOnContinentCode) &&
        Objects.equals(this.filterOnUserIdentifier, chartRequest.filterOnUserIdentifier) &&
        Objects.equals(this.sortOnPageVisits, chartRequest.sortOnPageVisits) &&
        Objects.equals(this.sortOnMapMarkerVisits, chartRequest.sortOnMapMarkerVisits) &&
        Objects.equals(this.sortOnCardVisits, chartRequest.sortOnCardVisits) &&
        Objects.equals(this.sortOnBookings, chartRequest.sortOnBookings) &&
        Objects.equals(this.sortOnCancellations, chartRequest.sortOnCancellations) &&
        Objects.equals(this.sortOnRoomNights, chartRequest.sortOnRoomNights) &&
        Objects.equals(this.sortOnMeetingRooms, chartRequest.sortOnMeetingRooms) &&
        Objects.equals(this.sortOnMeetingRoomsRevenue, chartRequest.sortOnMeetingRoomsRevenue) &&
        Objects.equals(this.sortOnRestaurants, chartRequest.sortOnRestaurants) &&
        Objects.equals(this.sortOnRestaurantsRevenue, chartRequest.sortOnRestaurantsRevenue) &&
        Objects.equals(this.sortOnSpas, chartRequest.sortOnSpas) &&
        Objects.equals(this.sortOnSpasRevenue, chartRequest.sortOnSpasRevenue) &&
        Objects.equals(this.sortOnActivities, chartRequest.sortOnActivities) &&
        Objects.equals(this.sortOnActivitiesRevenue, chartRequest.sortOnActivitiesRevenue) &&
        Objects.equals(this.sortOnAttractions, chartRequest.sortOnAttractions) &&
        Objects.equals(this.sortOnAttractionsRevenue, chartRequest.sortOnAttractionsRevenue) &&
        Objects.equals(this.sortOnPlaces, chartRequest.sortOnPlaces) &&
        Objects.equals(this.sortOnPlacesRevenue, chartRequest.sortOnPlacesRevenue) &&
        Objects.equals(this.sortOnRoomTypeAncillaries, chartRequest.sortOnRoomTypeAncillaries) &&
        Objects.equals(this.sortOnRoomTypeAncillariesRevenue, chartRequest.sortOnRoomTypeAncillariesRevenue) &&
        Objects.equals(this.sortOnAddOns, chartRequest.sortOnAddOns) &&
        Objects.equals(this.sortOnAddonsRevenue, chartRequest.sortOnAddonsRevenue) &&
        Objects.equals(this.sortOnTotalRoomRevenue, chartRequest.sortOnTotalRoomRevenue) &&
        Objects.equals(this.sortOnTotalAncillariesRevenue, chartRequest.sortOnTotalAncillariesRevenue) &&
        Objects.equals(this.sortOnTotalNetRevenue, chartRequest.sortOnTotalNetRevenue) &&
        Objects.equals(this.sortOnCancelledRoomNights, chartRequest.sortOnCancelledRoomNights) &&
        Objects.equals(this.sortOnCancelledMeetingRooms, chartRequest.sortOnCancelledMeetingRooms) &&
        Objects.equals(this.sortOnCancelledMeetingRoomsRevenue, chartRequest.sortOnCancelledMeetingRoomsRevenue) &&
        Objects.equals(this.sortOnCancelledRestaurants, chartRequest.sortOnCancelledRestaurants) &&
        Objects.equals(this.sortOnCancelledRestaurantsRevenue, chartRequest.sortOnCancelledRestaurantsRevenue) &&
        Objects.equals(this.sortOnCancelledSpas, chartRequest.sortOnCancelledSpas) &&
        Objects.equals(this.sortOnCancelledSpasRevenue, chartRequest.sortOnCancelledSpasRevenue) &&
        Objects.equals(this.sortOnCancelledActivities, chartRequest.sortOnCancelledActivities) &&
        Objects.equals(this.sortOnCancelledActivitiesRevenue, chartRequest.sortOnCancelledActivitiesRevenue) &&
        Objects.equals(this.sortOnCancelledAttractions, chartRequest.sortOnCancelledAttractions) &&
        Objects.equals(this.sortOnCancelledAttractionsRevenue, chartRequest.sortOnCancelledAttractionsRevenue) &&
        Objects.equals(this.sortOnCancelledPlaces, chartRequest.sortOnCancelledPlaces) &&
        Objects.equals(this.sortOnCancelledPlacesRevenue, chartRequest.sortOnCancelledPlacesRevenue) &&
        Objects.equals(this.sortOnCancelledTotalRoomRevenue, chartRequest.sortOnCancelledTotalRoomRevenue) &&
        Objects.equals(this.sortOnCancelledTotalAncillariesRevenue, chartRequest.sortOnCancelledTotalAncillariesRevenue) &&
        Objects.equals(this.sortOnCancelledRoomTypeAncillaries, chartRequest.sortOnCancelledRoomTypeAncillaries) &&
        Objects.equals(this.sortOnCancelledRoomTypeAncillariesRevenue, chartRequest.sortOnCancelledRoomTypeAncillariesRevenue) &&
        Objects.equals(this.sortOnCancelledAddOns, chartRequest.sortOnCancelledAddOns) &&
        Objects.equals(this.sortOnCancelledAddonsRevenue, chartRequest.sortOnCancelledAddonsRevenue) &&
        Objects.equals(this.sortOnCancelledTotalNetRevenue, chartRequest.sortOnCancelledTotalNetRevenue) &&
        Objects.equals(this.includePageVisits, chartRequest.includePageVisits) &&
        Objects.equals(this.includeMapMarkerVisits, chartRequest.includeMapMarkerVisits) &&
        Objects.equals(this.includeCardVisits, chartRequest.includeCardVisits) &&
        Objects.equals(this.includeBookings, chartRequest.includeBookings) &&
        Objects.equals(this.includeCancellations, chartRequest.includeCancellations) &&
        Objects.equals(this.includeRoomNights, chartRequest.includeRoomNights) &&
        Objects.equals(this.includeMeetingRooms, chartRequest.includeMeetingRooms) &&
        Objects.equals(this.includeMeetingRoomsRevenue, chartRequest.includeMeetingRoomsRevenue) &&
        Objects.equals(this.includeRestaurants, chartRequest.includeRestaurants) &&
        Objects.equals(this.includeRestaurantsRevenue, chartRequest.includeRestaurantsRevenue) &&
        Objects.equals(this.includeSpas, chartRequest.includeSpas) &&
        Objects.equals(this.includeSpasRevenue, chartRequest.includeSpasRevenue) &&
        Objects.equals(this.includeActivities, chartRequest.includeActivities) &&
        Objects.equals(this.includeActivitiesRevenue, chartRequest.includeActivitiesRevenue) &&
        Objects.equals(this.includeAttractions, chartRequest.includeAttractions) &&
        Objects.equals(this.includeAttractionsRevenue, chartRequest.includeAttractionsRevenue) &&
        Objects.equals(this.includePlaces, chartRequest.includePlaces) &&
        Objects.equals(this.includePlacesRevenue, chartRequest.includePlacesRevenue) &&
        Objects.equals(this.includeRoomTypeAncillaries, chartRequest.includeRoomTypeAncillaries) &&
        Objects.equals(this.includeRoomTypeAncillariesRevenue, chartRequest.includeRoomTypeAncillariesRevenue) &&
        Objects.equals(this.includeAddOns, chartRequest.includeAddOns) &&
        Objects.equals(this.includeAddOnsRevenue, chartRequest.includeAddOnsRevenue) &&
        Objects.equals(this.includeTotalRoomRevenue, chartRequest.includeTotalRoomRevenue) &&
        Objects.equals(this.includeAverageRoomRate, chartRequest.includeAverageRoomRate) &&
        Objects.equals(this.includeTotalAncillariesRevenue, chartRequest.includeTotalAncillariesRevenue) &&
        Objects.equals(this.includeTotalNetRevenue, chartRequest.includeTotalNetRevenue) &&
        Objects.equals(this.includeCancelledRoomNights, chartRequest.includeCancelledRoomNights) &&
        Objects.equals(this.includeCancelledMeetingRooms, chartRequest.includeCancelledMeetingRooms) &&
        Objects.equals(this.includeCancelledMeetingRoomsRevenue, chartRequest.includeCancelledMeetingRoomsRevenue) &&
        Objects.equals(this.includeCancelledRestaurants, chartRequest.includeCancelledRestaurants) &&
        Objects.equals(this.includeCancelledRestaurantsRevenue, chartRequest.includeCancelledRestaurantsRevenue) &&
        Objects.equals(this.includeCancelledSpas, chartRequest.includeCancelledSpas) &&
        Objects.equals(this.includeCancelledSpasRevenue, chartRequest.includeCancelledSpasRevenue) &&
        Objects.equals(this.includeCancelledActivities, chartRequest.includeCancelledActivities) &&
        Objects.equals(this.includeCancelledActivitiesRevenue, chartRequest.includeCancelledActivitiesRevenue) &&
        Objects.equals(this.includeCancelledAttractions, chartRequest.includeCancelledAttractions) &&
        Objects.equals(this.includeCancelledAttractionsRevenue, chartRequest.includeCancelledAttractionsRevenue) &&
        Objects.equals(this.includeCancelledPlaces, chartRequest.includeCancelledPlaces) &&
        Objects.equals(this.includeCancelledPlacesRevenue, chartRequest.includeCancelledPlacesRevenue) &&
        Objects.equals(this.includeCancelledRoomTypeAncillaries, chartRequest.includeCancelledRoomTypeAncillaries) &&
        Objects.equals(this.includeCancelledRoomTypeAncillariesRevenue, chartRequest.includeCancelledRoomTypeAncillariesRevenue) &&
        Objects.equals(this.includeCancelledAddOns, chartRequest.includeCancelledAddOns) &&
        Objects.equals(this.includeCancelledAddOnsRevenue, chartRequest.includeCancelledAddOnsRevenue) &&
        Objects.equals(this.includeCancelledTotalRoomRevenue, chartRequest.includeCancelledTotalRoomRevenue) &&
        Objects.equals(this.includeCancelledTotalAncillariesRevenue, chartRequest.includeCancelledTotalAncillariesRevenue) &&
        Objects.equals(this.includeCancelledTotalNetRevenue, chartRequest.includeCancelledTotalNetRevenue) &&
        Objects.equals(this.groupOnChannelSubType, chartRequest.groupOnChannelSubType) &&
        Objects.equals(this.groupOnOwnerIdentifier, chartRequest.groupOnOwnerIdentifier) &&
        Objects.equals(this.groupOnEngineIdentifier, chartRequest.groupOnEngineIdentifier) &&
        Objects.equals(this.groupOnEngineCountryGeoNameId, chartRequest.groupOnEngineCountryGeoNameId) &&
        Objects.equals(this.groupOnEngineCityGeoNameId, chartRequest.groupOnEngineCityGeoNameId) &&
        Objects.equals(this.groupOnEngineContinentCode, chartRequest.groupOnEngineContinentCode) &&
        Objects.equals(this.groupOnEngineConfigurationIdentifier, chartRequest.groupOnEngineConfigurationIdentifier) &&
        Objects.equals(this.groupOnCountryGeoNameId, chartRequest.groupOnCountryGeoNameId) &&
        Objects.equals(this.groupOnCityGeoNameId, chartRequest.groupOnCityGeoNameId) &&
        Objects.equals(this.groupOnContinentCode, chartRequest.groupOnContinentCode) &&
        Objects.equals(this.groupOnHotelIdentifier, chartRequest.groupOnHotelIdentifier) &&
        Objects.equals(this.groupOnUserIdentifier, chartRequest.groupOnUserIdentifier) &&
        Objects.equals(this.currencyCode, chartRequest.currencyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(series, timeSeriesUnits, startDate, endDate, filterOnHotelIdentifier, filterOnChannelSubType, filterOnOwnerIdentifier, filterOnEngineCountryGeoNameId, filterOnEngineCityGeoNameId, filterOnEngineContinentCode, filterOnEngineConfigurationIdentifier, filterOnCountryGeoNameId, filterOnCityGeoNameId, filterOnContinentCode, filterOnUserIdentifier, sortOnPageVisits, sortOnMapMarkerVisits, sortOnCardVisits, sortOnBookings, sortOnCancellations, sortOnRoomNights, sortOnMeetingRooms, sortOnMeetingRoomsRevenue, sortOnRestaurants, sortOnRestaurantsRevenue, sortOnSpas, sortOnSpasRevenue, sortOnActivities, sortOnActivitiesRevenue, sortOnAttractions, sortOnAttractionsRevenue, sortOnPlaces, sortOnPlacesRevenue, sortOnRoomTypeAncillaries, sortOnRoomTypeAncillariesRevenue, sortOnAddOns, sortOnAddonsRevenue, sortOnTotalRoomRevenue, sortOnTotalAncillariesRevenue, sortOnTotalNetRevenue, sortOnCancelledRoomNights, sortOnCancelledMeetingRooms, sortOnCancelledMeetingRoomsRevenue, sortOnCancelledRestaurants, sortOnCancelledRestaurantsRevenue, sortOnCancelledSpas, sortOnCancelledSpasRevenue, sortOnCancelledActivities, sortOnCancelledActivitiesRevenue, sortOnCancelledAttractions, sortOnCancelledAttractionsRevenue, sortOnCancelledPlaces, sortOnCancelledPlacesRevenue, sortOnCancelledTotalRoomRevenue, sortOnCancelledTotalAncillariesRevenue, sortOnCancelledRoomTypeAncillaries, sortOnCancelledRoomTypeAncillariesRevenue, sortOnCancelledAddOns, sortOnCancelledAddonsRevenue, sortOnCancelledTotalNetRevenue, includePageVisits, includeMapMarkerVisits, includeCardVisits, includeBookings, includeCancellations, includeRoomNights, includeMeetingRooms, includeMeetingRoomsRevenue, includeRestaurants, includeRestaurantsRevenue, includeSpas, includeSpasRevenue, includeActivities, includeActivitiesRevenue, includeAttractions, includeAttractionsRevenue, includePlaces, includePlacesRevenue, includeRoomTypeAncillaries, includeRoomTypeAncillariesRevenue, includeAddOns, includeAddOnsRevenue, includeTotalRoomRevenue, includeAverageRoomRate, includeTotalAncillariesRevenue, includeTotalNetRevenue, includeCancelledRoomNights, includeCancelledMeetingRooms, includeCancelledMeetingRoomsRevenue, includeCancelledRestaurants, includeCancelledRestaurantsRevenue, includeCancelledSpas, includeCancelledSpasRevenue, includeCancelledActivities, includeCancelledActivitiesRevenue, includeCancelledAttractions, includeCancelledAttractionsRevenue, includeCancelledPlaces, includeCancelledPlacesRevenue, includeCancelledRoomTypeAncillaries, includeCancelledRoomTypeAncillariesRevenue, includeCancelledAddOns, includeCancelledAddOnsRevenue, includeCancelledTotalRoomRevenue, includeCancelledTotalAncillariesRevenue, includeCancelledTotalNetRevenue, groupOnChannelSubType, groupOnOwnerIdentifier, groupOnEngineIdentifier, groupOnEngineCountryGeoNameId, groupOnEngineCityGeoNameId, groupOnEngineContinentCode, groupOnEngineConfigurationIdentifier, groupOnCountryGeoNameId, groupOnCityGeoNameId, groupOnContinentCode, groupOnHotelIdentifier, groupOnUserIdentifier, currencyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChartRequest {\n");
    sb.append("    series: ").append(toIndentedString(series)).append("\n");
    sb.append("    timeSeriesUnits: ").append(toIndentedString(timeSeriesUnits)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    filterOnHotelIdentifier: ").append(toIndentedString(filterOnHotelIdentifier)).append("\n");
    sb.append("    filterOnChannelSubType: ").append(toIndentedString(filterOnChannelSubType)).append("\n");
    sb.append("    filterOnOwnerIdentifier: ").append(toIndentedString(filterOnOwnerIdentifier)).append("\n");
    sb.append("    filterOnEngineCountryGeoNameId: ").append(toIndentedString(filterOnEngineCountryGeoNameId)).append("\n");
    sb.append("    filterOnEngineCityGeoNameId: ").append(toIndentedString(filterOnEngineCityGeoNameId)).append("\n");
    sb.append("    filterOnEngineContinentCode: ").append(toIndentedString(filterOnEngineContinentCode)).append("\n");
    sb.append("    filterOnEngineConfigurationIdentifier: ").append(toIndentedString(filterOnEngineConfigurationIdentifier)).append("\n");
    sb.append("    filterOnCountryGeoNameId: ").append(toIndentedString(filterOnCountryGeoNameId)).append("\n");
    sb.append("    filterOnCityGeoNameId: ").append(toIndentedString(filterOnCityGeoNameId)).append("\n");
    sb.append("    filterOnContinentCode: ").append(toIndentedString(filterOnContinentCode)).append("\n");
    sb.append("    filterOnUserIdentifier: ").append(toIndentedString(filterOnUserIdentifier)).append("\n");
    sb.append("    sortOnPageVisits: ").append(toIndentedString(sortOnPageVisits)).append("\n");
    sb.append("    sortOnMapMarkerVisits: ").append(toIndentedString(sortOnMapMarkerVisits)).append("\n");
    sb.append("    sortOnCardVisits: ").append(toIndentedString(sortOnCardVisits)).append("\n");
    sb.append("    sortOnBookings: ").append(toIndentedString(sortOnBookings)).append("\n");
    sb.append("    sortOnCancellations: ").append(toIndentedString(sortOnCancellations)).append("\n");
    sb.append("    sortOnRoomNights: ").append(toIndentedString(sortOnRoomNights)).append("\n");
    sb.append("    sortOnMeetingRooms: ").append(toIndentedString(sortOnMeetingRooms)).append("\n");
    sb.append("    sortOnMeetingRoomsRevenue: ").append(toIndentedString(sortOnMeetingRoomsRevenue)).append("\n");
    sb.append("    sortOnRestaurants: ").append(toIndentedString(sortOnRestaurants)).append("\n");
    sb.append("    sortOnRestaurantsRevenue: ").append(toIndentedString(sortOnRestaurantsRevenue)).append("\n");
    sb.append("    sortOnSpas: ").append(toIndentedString(sortOnSpas)).append("\n");
    sb.append("    sortOnSpasRevenue: ").append(toIndentedString(sortOnSpasRevenue)).append("\n");
    sb.append("    sortOnActivities: ").append(toIndentedString(sortOnActivities)).append("\n");
    sb.append("    sortOnActivitiesRevenue: ").append(toIndentedString(sortOnActivitiesRevenue)).append("\n");
    sb.append("    sortOnAttractions: ").append(toIndentedString(sortOnAttractions)).append("\n");
    sb.append("    sortOnAttractionsRevenue: ").append(toIndentedString(sortOnAttractionsRevenue)).append("\n");
    sb.append("    sortOnPlaces: ").append(toIndentedString(sortOnPlaces)).append("\n");
    sb.append("    sortOnPlacesRevenue: ").append(toIndentedString(sortOnPlacesRevenue)).append("\n");
    sb.append("    sortOnRoomTypeAncillaries: ").append(toIndentedString(sortOnRoomTypeAncillaries)).append("\n");
    sb.append("    sortOnRoomTypeAncillariesRevenue: ").append(toIndentedString(sortOnRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    sortOnAddOns: ").append(toIndentedString(sortOnAddOns)).append("\n");
    sb.append("    sortOnAddonsRevenue: ").append(toIndentedString(sortOnAddonsRevenue)).append("\n");
    sb.append("    sortOnTotalRoomRevenue: ").append(toIndentedString(sortOnTotalRoomRevenue)).append("\n");
    sb.append("    sortOnTotalAncillariesRevenue: ").append(toIndentedString(sortOnTotalAncillariesRevenue)).append("\n");
    sb.append("    sortOnTotalNetRevenue: ").append(toIndentedString(sortOnTotalNetRevenue)).append("\n");
    sb.append("    sortOnCancelledRoomNights: ").append(toIndentedString(sortOnCancelledRoomNights)).append("\n");
    sb.append("    sortOnCancelledMeetingRooms: ").append(toIndentedString(sortOnCancelledMeetingRooms)).append("\n");
    sb.append("    sortOnCancelledMeetingRoomsRevenue: ").append(toIndentedString(sortOnCancelledMeetingRoomsRevenue)).append("\n");
    sb.append("    sortOnCancelledRestaurants: ").append(toIndentedString(sortOnCancelledRestaurants)).append("\n");
    sb.append("    sortOnCancelledRestaurantsRevenue: ").append(toIndentedString(sortOnCancelledRestaurantsRevenue)).append("\n");
    sb.append("    sortOnCancelledSpas: ").append(toIndentedString(sortOnCancelledSpas)).append("\n");
    sb.append("    sortOnCancelledSpasRevenue: ").append(toIndentedString(sortOnCancelledSpasRevenue)).append("\n");
    sb.append("    sortOnCancelledActivities: ").append(toIndentedString(sortOnCancelledActivities)).append("\n");
    sb.append("    sortOnCancelledActivitiesRevenue: ").append(toIndentedString(sortOnCancelledActivitiesRevenue)).append("\n");
    sb.append("    sortOnCancelledAttractions: ").append(toIndentedString(sortOnCancelledAttractions)).append("\n");
    sb.append("    sortOnCancelledAttractionsRevenue: ").append(toIndentedString(sortOnCancelledAttractionsRevenue)).append("\n");
    sb.append("    sortOnCancelledPlaces: ").append(toIndentedString(sortOnCancelledPlaces)).append("\n");
    sb.append("    sortOnCancelledPlacesRevenue: ").append(toIndentedString(sortOnCancelledPlacesRevenue)).append("\n");
    sb.append("    sortOnCancelledTotalRoomRevenue: ").append(toIndentedString(sortOnCancelledTotalRoomRevenue)).append("\n");
    sb.append("    sortOnCancelledTotalAncillariesRevenue: ").append(toIndentedString(sortOnCancelledTotalAncillariesRevenue)).append("\n");
    sb.append("    sortOnCancelledRoomTypeAncillaries: ").append(toIndentedString(sortOnCancelledRoomTypeAncillaries)).append("\n");
    sb.append("    sortOnCancelledRoomTypeAncillariesRevenue: ").append(toIndentedString(sortOnCancelledRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    sortOnCancelledAddOns: ").append(toIndentedString(sortOnCancelledAddOns)).append("\n");
    sb.append("    sortOnCancelledAddonsRevenue: ").append(toIndentedString(sortOnCancelledAddonsRevenue)).append("\n");
    sb.append("    sortOnCancelledTotalNetRevenue: ").append(toIndentedString(sortOnCancelledTotalNetRevenue)).append("\n");
    sb.append("    includePageVisits: ").append(toIndentedString(includePageVisits)).append("\n");
    sb.append("    includeMapMarkerVisits: ").append(toIndentedString(includeMapMarkerVisits)).append("\n");
    sb.append("    includeCardVisits: ").append(toIndentedString(includeCardVisits)).append("\n");
    sb.append("    includeBookings: ").append(toIndentedString(includeBookings)).append("\n");
    sb.append("    includeCancellations: ").append(toIndentedString(includeCancellations)).append("\n");
    sb.append("    includeRoomNights: ").append(toIndentedString(includeRoomNights)).append("\n");
    sb.append("    includeMeetingRooms: ").append(toIndentedString(includeMeetingRooms)).append("\n");
    sb.append("    includeMeetingRoomsRevenue: ").append(toIndentedString(includeMeetingRoomsRevenue)).append("\n");
    sb.append("    includeRestaurants: ").append(toIndentedString(includeRestaurants)).append("\n");
    sb.append("    includeRestaurantsRevenue: ").append(toIndentedString(includeRestaurantsRevenue)).append("\n");
    sb.append("    includeSpas: ").append(toIndentedString(includeSpas)).append("\n");
    sb.append("    includeSpasRevenue: ").append(toIndentedString(includeSpasRevenue)).append("\n");
    sb.append("    includeActivities: ").append(toIndentedString(includeActivities)).append("\n");
    sb.append("    includeActivitiesRevenue: ").append(toIndentedString(includeActivitiesRevenue)).append("\n");
    sb.append("    includeAttractions: ").append(toIndentedString(includeAttractions)).append("\n");
    sb.append("    includeAttractionsRevenue: ").append(toIndentedString(includeAttractionsRevenue)).append("\n");
    sb.append("    includePlaces: ").append(toIndentedString(includePlaces)).append("\n");
    sb.append("    includePlacesRevenue: ").append(toIndentedString(includePlacesRevenue)).append("\n");
    sb.append("    includeRoomTypeAncillaries: ").append(toIndentedString(includeRoomTypeAncillaries)).append("\n");
    sb.append("    includeRoomTypeAncillariesRevenue: ").append(toIndentedString(includeRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    includeAddOns: ").append(toIndentedString(includeAddOns)).append("\n");
    sb.append("    includeAddOnsRevenue: ").append(toIndentedString(includeAddOnsRevenue)).append("\n");
    sb.append("    includeTotalRoomRevenue: ").append(toIndentedString(includeTotalRoomRevenue)).append("\n");
    sb.append("    includeAverageRoomRate: ").append(toIndentedString(includeAverageRoomRate)).append("\n");
    sb.append("    includeTotalAncillariesRevenue: ").append(toIndentedString(includeTotalAncillariesRevenue)).append("\n");
    sb.append("    includeTotalNetRevenue: ").append(toIndentedString(includeTotalNetRevenue)).append("\n");
    sb.append("    includeCancelledRoomNights: ").append(toIndentedString(includeCancelledRoomNights)).append("\n");
    sb.append("    includeCancelledMeetingRooms: ").append(toIndentedString(includeCancelledMeetingRooms)).append("\n");
    sb.append("    includeCancelledMeetingRoomsRevenue: ").append(toIndentedString(includeCancelledMeetingRoomsRevenue)).append("\n");
    sb.append("    includeCancelledRestaurants: ").append(toIndentedString(includeCancelledRestaurants)).append("\n");
    sb.append("    includeCancelledRestaurantsRevenue: ").append(toIndentedString(includeCancelledRestaurantsRevenue)).append("\n");
    sb.append("    includeCancelledSpas: ").append(toIndentedString(includeCancelledSpas)).append("\n");
    sb.append("    includeCancelledSpasRevenue: ").append(toIndentedString(includeCancelledSpasRevenue)).append("\n");
    sb.append("    includeCancelledActivities: ").append(toIndentedString(includeCancelledActivities)).append("\n");
    sb.append("    includeCancelledActivitiesRevenue: ").append(toIndentedString(includeCancelledActivitiesRevenue)).append("\n");
    sb.append("    includeCancelledAttractions: ").append(toIndentedString(includeCancelledAttractions)).append("\n");
    sb.append("    includeCancelledAttractionsRevenue: ").append(toIndentedString(includeCancelledAttractionsRevenue)).append("\n");
    sb.append("    includeCancelledPlaces: ").append(toIndentedString(includeCancelledPlaces)).append("\n");
    sb.append("    includeCancelledPlacesRevenue: ").append(toIndentedString(includeCancelledPlacesRevenue)).append("\n");
    sb.append("    includeCancelledRoomTypeAncillaries: ").append(toIndentedString(includeCancelledRoomTypeAncillaries)).append("\n");
    sb.append("    includeCancelledRoomTypeAncillariesRevenue: ").append(toIndentedString(includeCancelledRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    includeCancelledAddOns: ").append(toIndentedString(includeCancelledAddOns)).append("\n");
    sb.append("    includeCancelledAddOnsRevenue: ").append(toIndentedString(includeCancelledAddOnsRevenue)).append("\n");
    sb.append("    includeCancelledTotalRoomRevenue: ").append(toIndentedString(includeCancelledTotalRoomRevenue)).append("\n");
    sb.append("    includeCancelledTotalAncillariesRevenue: ").append(toIndentedString(includeCancelledTotalAncillariesRevenue)).append("\n");
    sb.append("    includeCancelledTotalNetRevenue: ").append(toIndentedString(includeCancelledTotalNetRevenue)).append("\n");
    sb.append("    groupOnChannelSubType: ").append(toIndentedString(groupOnChannelSubType)).append("\n");
    sb.append("    groupOnOwnerIdentifier: ").append(toIndentedString(groupOnOwnerIdentifier)).append("\n");
    sb.append("    groupOnEngineIdentifier: ").append(toIndentedString(groupOnEngineIdentifier)).append("\n");
    sb.append("    groupOnEngineCountryGeoNameId: ").append(toIndentedString(groupOnEngineCountryGeoNameId)).append("\n");
    sb.append("    groupOnEngineCityGeoNameId: ").append(toIndentedString(groupOnEngineCityGeoNameId)).append("\n");
    sb.append("    groupOnEngineContinentCode: ").append(toIndentedString(groupOnEngineContinentCode)).append("\n");
    sb.append("    groupOnEngineConfigurationIdentifier: ").append(toIndentedString(groupOnEngineConfigurationIdentifier)).append("\n");
    sb.append("    groupOnCountryGeoNameId: ").append(toIndentedString(groupOnCountryGeoNameId)).append("\n");
    sb.append("    groupOnCityGeoNameId: ").append(toIndentedString(groupOnCityGeoNameId)).append("\n");
    sb.append("    groupOnContinentCode: ").append(toIndentedString(groupOnContinentCode)).append("\n");
    sb.append("    groupOnHotelIdentifier: ").append(toIndentedString(groupOnHotelIdentifier)).append("\n");
    sb.append("    groupOnUserIdentifier: ").append(toIndentedString(groupOnUserIdentifier)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

