package travel.wink.sdk.analytics.api;

import travel.wink.sdk.analytics.invoker.ApiClient;

import travel.wink.sdk.analytics.model.BookingLeaderboardEntryConsumer;
import travel.wink.sdk.analytics.model.GenericErrorMessage;
import travel.wink.sdk.analytics.model.LeaderboardOwnerRequestConsumer;
import travel.wink.sdk.analytics.model.LeaderboardRequestConsumer;
import travel.wink.sdk.analytics.model.PageBookingLeaderboardEntryConsumer;
import travel.wink.sdk.analytics.model.ShowChartRequest400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-12T17:36:15.307125182+07:00[Asia/Bangkok]")
public class LeaderboardApi {
    private ApiClient apiClient;

    public LeaderboardApi() {
        this(new ApiClient());
    }

    @Autowired
    public LeaderboardApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Location Leaderboard
     * Show leaderboard based on location type such as continent.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardRequestConsumer The leaderboardRequestConsumer parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingLeaderboardEntryConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLeaderboardRequestCreation(LeaderboardRequestConsumer leaderboardRequestConsumer, String winkVersion) throws WebClientResponseException {
        Object postBody = leaderboardRequestConsumer;
        // verify the required parameter 'leaderboardRequestConsumer' is set
        if (leaderboardRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'leaderboardRequestConsumer' when calling showLeaderboard", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingLeaderboardEntryConsumer> localVarReturnType = new ParameterizedTypeReference<PageBookingLeaderboardEntryConsumer>() {};
        return apiClient.invokeAPI("/api/analytics/leaderboard/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Location Leaderboard
     * Show leaderboard based on location type such as continent.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardRequestConsumer The leaderboardRequestConsumer parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingLeaderboardEntryConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingLeaderboardEntryConsumer> showLeaderboard(LeaderboardRequestConsumer leaderboardRequestConsumer, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingLeaderboardEntryConsumer> localVarReturnType = new ParameterizedTypeReference<PageBookingLeaderboardEntryConsumer>() {};
        return showLeaderboardRequestCreation(leaderboardRequestConsumer, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Location Leaderboard
     * Show leaderboard based on location type such as continent.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardRequestConsumer The leaderboardRequestConsumer parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageBookingLeaderboardEntryConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageBookingLeaderboardEntryConsumer>> showLeaderboardWithHttpInfo(LeaderboardRequestConsumer leaderboardRequestConsumer, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingLeaderboardEntryConsumer> localVarReturnType = new ParameterizedTypeReference<PageBookingLeaderboardEntryConsumer>() {};
        return showLeaderboardRequestCreation(leaderboardRequestConsumer, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Location Leaderboard
     * Show leaderboard based on location type such as continent.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardRequestConsumer The leaderboardRequestConsumer parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLeaderboardWithResponseSpec(LeaderboardRequestConsumer leaderboardRequestConsumer, String winkVersion) throws WebClientResponseException {
        return showLeaderboardRequestCreation(leaderboardRequestConsumer, winkVersion);
    }
    /**
     * Show Affiliate Leaderboard 
     * Show leaderboard for a specific affiliate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardOwnerRequestConsumer The leaderboardOwnerRequestConsumer parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingLeaderboardEntryConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLeaderboardByOwnerRequestCreation(LeaderboardOwnerRequestConsumer leaderboardOwnerRequestConsumer, String winkVersion) throws WebClientResponseException {
        Object postBody = leaderboardOwnerRequestConsumer;
        // verify the required parameter 'leaderboardOwnerRequestConsumer' is set
        if (leaderboardOwnerRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'leaderboardOwnerRequestConsumer' when calling showLeaderboardByOwner", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingLeaderboardEntryConsumer> localVarReturnType = new ParameterizedTypeReference<BookingLeaderboardEntryConsumer>() {};
        return apiClient.invokeAPI("/api/analytics/leaderboard", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Affiliate Leaderboard 
     * Show leaderboard for a specific affiliate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardOwnerRequestConsumer The leaderboardOwnerRequestConsumer parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingLeaderboardEntryConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingLeaderboardEntryConsumer> showLeaderboardByOwner(LeaderboardOwnerRequestConsumer leaderboardOwnerRequestConsumer, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingLeaderboardEntryConsumer> localVarReturnType = new ParameterizedTypeReference<BookingLeaderboardEntryConsumer>() {};
        return showLeaderboardByOwnerRequestCreation(leaderboardOwnerRequestConsumer, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Affiliate Leaderboard 
     * Show leaderboard for a specific affiliate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardOwnerRequestConsumer The leaderboardOwnerRequestConsumer parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingLeaderboardEntryConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingLeaderboardEntryConsumer>> showLeaderboardByOwnerWithHttpInfo(LeaderboardOwnerRequestConsumer leaderboardOwnerRequestConsumer, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingLeaderboardEntryConsumer> localVarReturnType = new ParameterizedTypeReference<BookingLeaderboardEntryConsumer>() {};
        return showLeaderboardByOwnerRequestCreation(leaderboardOwnerRequestConsumer, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Affiliate Leaderboard 
     * Show leaderboard for a specific affiliate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param leaderboardOwnerRequestConsumer The leaderboardOwnerRequestConsumer parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLeaderboardByOwnerWithResponseSpec(LeaderboardOwnerRequestConsumer leaderboardOwnerRequestConsumer, String winkVersion) throws WebClientResponseException {
        return showLeaderboardByOwnerRequestCreation(leaderboardOwnerRequestConsumer, winkVersion);
    }
}
