/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.analytics.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.analytics.invoker.ApiClient;
import travel.wink.sdk.analytics.model.ChartRequestView;
import travel.wink.sdk.analytics.model.ChartRequestViewConsumer;
import travel.wink.sdk.analytics.model.LineChartConsumer;
import travel.wink.sdk.analytics.model.RemoveEntryResponse;
import travel.wink.sdk.analytics.model.UpsertChartRequestWrapper;

public class AnalyticsApi {
    private ApiClient apiClient;

    public AnalyticsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnalyticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createChartRequestRequestCreation(UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        UpsertChartRequestWrapper postBody = upsertChartRequestWrapper;
        if (upsertChartRequestWrapper == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestWrapper' when calling createChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>(){};
        return this.apiClient.invokeAPI("/api/analytics/chart", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ChartRequestView> createChartRequest(UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>(){};
        return this.createChartRequestRequestCreation(upsertChartRequestWrapper, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ChartRequestView>> createChartRequestWithHttpInfo(UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>(){};
        return this.createChartRequestRequestCreation(upsertChartRequestWrapper, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createChartRequestWithResponseSpec(UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        return this.createChartRequestRequestCreation(upsertChartRequestWrapper, winkVersion);
    }

    private WebClient.ResponseSpec removeChartRequestRequestCreation(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling removeChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("chartIdentifier", chartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeChartRequest(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeChartRequestRequestCreation(chartIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeChartRequestWithHttpInfo(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeChartRequestRequestCreation(chartIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeChartRequestWithResponseSpec(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeChartRequestRequestCreation(chartIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showAnalyticsRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<LineChartConsumer> localVarReturnType = new ParameterizedTypeReference<LineChartConsumer>(){};
        return this.apiClient.invokeAPI("/api/analytics/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<LineChartConsumer> showAnalytics(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartConsumer> localVarReturnType = new ParameterizedTypeReference<LineChartConsumer>(){};
        return this.showAnalyticsRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<LineChartConsumer>>> showAnalyticsWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartConsumer> localVarReturnType = new ParameterizedTypeReference<LineChartConsumer>(){};
        return this.showAnalyticsRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAnalyticsWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showAnalyticsRequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec showChartRequestRequestCreation(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling showChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("chartIdentifier", chartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>(){};
        return this.apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ChartRequestView> showChartRequest(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>(){};
        return this.showChartRequestRequestCreation(chartIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ChartRequestView>> showChartRequestWithHttpInfo(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>(){};
        return this.showChartRequestRequestCreation(chartIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showChartRequestWithResponseSpec(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showChartRequestRequestCreation(chartIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showChartRequestsRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartRequestViewConsumer> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewConsumer>(){};
        return this.apiClient.invokeAPI("/api/analytics/chart/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ChartRequestViewConsumer> showChartRequests(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewConsumer> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewConsumer>(){};
        return this.showChartRequestsRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ChartRequestViewConsumer>>> showChartRequestsWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewConsumer> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewConsumer>(){};
        return this.showChartRequestsRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showChartRequestsWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showChartRequestsRequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec updateChartRequestRequestCreation(String chartIdentifier, UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        UpsertChartRequestWrapper postBody = upsertChartRequestWrapper;
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertChartRequestWrapper == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestWrapper' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("chartIdentifier", chartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>(){};
        return this.apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ChartRequestView> updateChartRequest(String chartIdentifier, UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>(){};
        return this.updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapper, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ChartRequestView>> updateChartRequestWithHttpInfo(String chartIdentifier, UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>(){};
        return this.updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapper, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateChartRequestWithResponseSpec(String chartIdentifier, UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        return this.updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapper, winkVersion);
    }
}

