/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.10.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The selected axis range. If set, the axis selection is enabled. The range is index-based, starting from zero. Categories with indexes in the range (&#x60;select.from&#x60;, &#x60;select.to&#x60;) will be selected. That is, the last category in the range will not be included in the selection. If the categories are dates, the range has to be also specified with date values. Selection is only supported if the axis is horizontal.
 */
@JsonPropertyOrder({
  CategoryAxisSelectConsumer.JSON_PROPERTY_FROM,
  CategoryAxisSelectConsumer.JSON_PROPERTY_MAX,
  CategoryAxisSelectConsumer.JSON_PROPERTY_MIN,
  CategoryAxisSelectConsumer.JSON_PROPERTY_MOUSEWHEEL,
  CategoryAxisSelectConsumer.JSON_PROPERTY_TO
})
@JsonTypeName("CategoryAxisSelect_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-09-09T12:27:31.958855002+07:00[Asia/Bangkok]")
public class CategoryAxisSelectConsumer {
  public static final String JSON_PROPERTY_FROM = "from";
  private Object from;

  public static final String JSON_PROPERTY_MAX = "max";
  private Object max;

  public static final String JSON_PROPERTY_MIN = "min";
  private Object min;

  public static final String JSON_PROPERTY_MOUSEWHEEL = "mousewheel";
  private Object mousewheel;

  public static final String JSON_PROPERTY_TO = "to";
  private Object to;

  public CategoryAxisSelectConsumer() {
  }

  public CategoryAxisSelectConsumer from(Object from) {
    
    this.from = from;
    return this;
  }

   /**
   * Get from
   * @return from
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getFrom() {
    return from;
  }


  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(Object from) {
    this.from = from;
  }


  public CategoryAxisSelectConsumer max(Object max) {
    
    this.max = max;
    return this;
  }

   /**
   * Get max
   * @return max
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMax() {
    return max;
  }


  @JsonProperty(JSON_PROPERTY_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMax(Object max) {
    this.max = max;
  }


  public CategoryAxisSelectConsumer min(Object min) {
    
    this.min = min;
    return this;
  }

   /**
   * Get min
   * @return min
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMin() {
    return min;
  }


  @JsonProperty(JSON_PROPERTY_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMin(Object min) {
    this.min = min;
  }


  public CategoryAxisSelectConsumer mousewheel(Object mousewheel) {
    
    this.mousewheel = mousewheel;
    return this;
  }

   /**
   * Get mousewheel
   * @return mousewheel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MOUSEWHEEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMousewheel() {
    return mousewheel;
  }


  @JsonProperty(JSON_PROPERTY_MOUSEWHEEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMousewheel(Object mousewheel) {
    this.mousewheel = mousewheel;
  }


  public CategoryAxisSelectConsumer to(Object to) {
    
    this.to = to;
    return this;
  }

   /**
   * Get to
   * @return to
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTo() {
    return to;
  }


  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTo(Object to) {
    this.to = to;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CategoryAxisSelectConsumer categoryAxisSelectConsumer = (CategoryAxisSelectConsumer) o;
    return Objects.equals(this.from, categoryAxisSelectConsumer.from) &&
        Objects.equals(this.max, categoryAxisSelectConsumer.max) &&
        Objects.equals(this.min, categoryAxisSelectConsumer.min) &&
        Objects.equals(this.mousewheel, categoryAxisSelectConsumer.mousewheel) &&
        Objects.equals(this.to, categoryAxisSelectConsumer.to);
  }

  @Override
  public int hashCode() {
    return Objects.hash(from, max, min, mousewheel, to);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CategoryAxisSelectConsumer {\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    max: ").append(toIndentedString(max)).append("\n");
    sb.append("    min: ").append(toIndentedString(min)).append("\n");
    sb.append("    mousewheel: ").append(toIndentedString(mousewheel)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

