package travel.wink.sdk.analytics.api;

import travel.wink.sdk.analytics.invoker.ApiClient;

import travel.wink.sdk.analytics.model.ChartRequestView;
import travel.wink.sdk.analytics.model.ChartRequestViewNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.GenericErrorMessage;
import travel.wink.sdk.analytics.model.LineChartNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.RemoveEntryResponse;
import travel.wink.sdk.analytics.model.ShowChartRequest400Response;
import travel.wink.sdk.analytics.model.UpsertChartRequestWrapper;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T10:43:55.545651496+07:00[Asia/Bangkok]")
public class AnalyticsApi {
    private ApiClient apiClient;

    public AnalyticsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnalyticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param upsertChartRequestWrapper The upsertChartRequestWrapper parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createChartRequestRequestCreation(UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertChartRequestWrapper;
        // verify the required parameter 'upsertChartRequestWrapper' is set
        if (upsertChartRequestWrapper == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestWrapper' when calling createChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return apiClient.invokeAPI("/api/analytics/chart", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param upsertChartRequestWrapper The upsertChartRequestWrapper parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartRequestView> createChartRequest(UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return createChartRequestRequestCreation(upsertChartRequestWrapper, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param upsertChartRequestWrapper The upsertChartRequestWrapper parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ChartRequestView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ChartRequestView>> createChartRequestWithHttpInfo(UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return createChartRequestRequestCreation(upsertChartRequestWrapper, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Chart
     * Creates a new chart request.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param upsertChartRequestWrapper The upsertChartRequestWrapper parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createChartRequestWithResponseSpec(UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        return createChartRequestRequestCreation(upsertChartRequestWrapper, winkVersion);
    }
    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeChartRequestRequestCreation(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling removeChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeChartRequest(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeChartRequestRequestCreation(chartIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> removeChartRequestWithHttpInfo(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeChartRequestRequestCreation(chartIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Remove Chart
     * Remove chart request for specific identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeChartRequestWithResponseSpec(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        return removeChartRequestRequestCreation(chartIdentifier, winkVersion);
    }
    /**
     * Show Analytics
     * Show analytics the authenticated entity has previously created
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;LineChartNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnalyticsRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Analytics
     * Show analytics the authenticated entity has previously created
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;LineChartNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<LineChartNonAuthenticatedEntity> showAnalytics(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>() {};
        return showAnalyticsRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Analytics
     * Show analytics the authenticated entity has previously created
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;LineChartNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<LineChartNonAuthenticatedEntity>>> showAnalyticsWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LineChartNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<LineChartNonAuthenticatedEntity>() {};
        return showAnalyticsRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Analytics
     * Show analytics the authenticated entity has previously created
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAnalyticsWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showAnalyticsRequestCreation(winkVersion);
    }
    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChartRequestRequestCreation(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling showChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartRequestView> showChartRequest(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return showChartRequestRequestCreation(chartIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ChartRequestView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ChartRequestView>> showChartRequestWithHttpInfo(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return showChartRequestRequestCreation(chartIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Chart
     * Displays a single chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showChartRequestWithResponseSpec(String chartIdentifier, String winkVersion) throws WebClientResponseException {
        return showChartRequestRequestCreation(chartIdentifier, winkVersion);
    }
    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;ChartRequestViewNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChartRequestsRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartRequestViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/analytics/chart/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;ChartRequestViewNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ChartRequestViewNonAuthenticatedEntity> showChartRequests(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewNonAuthenticatedEntity>() {};
        return showChartRequestsRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;ChartRequestViewNonAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ChartRequestViewNonAuthenticatedEntity>>> showChartRequestsWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ChartRequestViewNonAuthenticatedEntity>() {};
        return showChartRequestsRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Charts
     * Displays all charts for caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showChartRequestsWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showChartRequestsRequestCreation(winkVersion);
    }
    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestWrapper The upsertChartRequestWrapper parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateChartRequestRequestCreation(String chartIdentifier, UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertChartRequestWrapper;
        // verify the required parameter 'chartIdentifier' is set
        if (chartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'chartIdentifier' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertChartRequestWrapper' is set
        if (upsertChartRequestWrapper == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertChartRequestWrapper' when calling updateChartRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("chartIdentifier", chartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return apiClient.invokeAPI("/api/analytics/chart/{chartIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestWrapper The upsertChartRequestWrapper parameter
     * @param winkVersion The winkVersion parameter
     * @return ChartRequestView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ChartRequestView> updateChartRequest(String chartIdentifier, UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapper, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestWrapper The upsertChartRequestWrapper parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ChartRequestView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ChartRequestView>> updateChartRequestWithHttpInfo(String chartIdentifier, UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChartRequestView> localVarReturnType = new ParameterizedTypeReference<ChartRequestView>() {};
        return updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapper, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Chart
     * Updates an existing chart request by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param chartIdentifier Chart identifier
     * @param upsertChartRequestWrapper The upsertChartRequestWrapper parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateChartRequestWithResponseSpec(String chartIdentifier, UpsertChartRequestWrapper upsertChartRequestWrapper, String winkVersion) throws WebClientResponseException {
        return updateChartRequestRequestCreation(chartIdentifier, upsertChartRequestWrapper, winkVersion);
    }
}
