/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.42.12
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BorderNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  BorderNonAuthenticatedEntity.JSON_PROPERTY_COLOR,
  BorderNonAuthenticatedEntity.JSON_PROPERTY_DASH_TYPE,
  BorderNonAuthenticatedEntity.JSON_PROPERTY_WIDTH
})
@JsonTypeName("Border_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T10:43:55.545651496+07:00[Asia/Bangkok]")
public class BorderNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_COLOR = "color";
  private String color;

  /**
   * Gets or Sets dashType
   */
  public enum DashTypeEnum {
    DASH("dash"),
    
    DASHDOT("dashDot"),
    
    DOT("dot"),
    
    LONGDASH("longDash"),
    
    LONGDASHDOT("longDashDot"),
    
    LONGDASHDOTDOT("longDashDotDot"),
    
    SOLID("solid");

    private String value;

    DashTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DashTypeEnum fromValue(String value) {
      for (DashTypeEnum b : DashTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DASH_TYPE = "dashType";
  private DashTypeEnum dashType;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private BigDecimal width;

  public BorderNonAuthenticatedEntity() {
  }

  public BorderNonAuthenticatedEntity color(String color) {
    
    this.color = color;
    return this;
  }

   /**
   * Get color
   * @return color
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public BorderNonAuthenticatedEntity dashType(DashTypeEnum dashType) {
    
    this.dashType = dashType;
    return this;
  }

   /**
   * Get dashType
   * @return dashType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DASH_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DashTypeEnum getDashType() {
    return dashType;
  }


  @JsonProperty(JSON_PROPERTY_DASH_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDashType(DashTypeEnum dashType) {
    this.dashType = dashType;
  }


  public BorderNonAuthenticatedEntity width(BigDecimal width) {
    
    this.width = width;
    return this;
  }

   /**
   * Get width
   * @return width
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(BigDecimal width) {
    this.width = width;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BorderNonAuthenticatedEntity borderNonAuthenticatedEntity = (BorderNonAuthenticatedEntity) o;
    return Objects.equals(this.color, borderNonAuthenticatedEntity.color) &&
        Objects.equals(this.dashType, borderNonAuthenticatedEntity.dashType) &&
        Objects.equals(this.width, borderNonAuthenticatedEntity.width);
  }

  @Override
  public int hashCode() {
    return Objects.hash(color, dashType, width);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BorderNonAuthenticatedEntity {\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    dashType: ").append(toIndentedString(dashType)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

