/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.56.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.analytics.model.BorderNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.PaddingNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CategoryAxisCrosshairTooltipNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  CategoryAxisCrosshairTooltipNonAuthenticatedEntity.JSON_PROPERTY_BACKGROUND,
  CategoryAxisCrosshairTooltipNonAuthenticatedEntity.JSON_PROPERTY_BORDER,
  CategoryAxisCrosshairTooltipNonAuthenticatedEntity.JSON_PROPERTY_COLOR,
  CategoryAxisCrosshairTooltipNonAuthenticatedEntity.JSON_PROPERTY_FONT,
  CategoryAxisCrosshairTooltipNonAuthenticatedEntity.JSON_PROPERTY_FORMAT,
  CategoryAxisCrosshairTooltipNonAuthenticatedEntity.JSON_PROPERTY_PADDING,
  CategoryAxisCrosshairTooltipNonAuthenticatedEntity.JSON_PROPERTY_VISIBLE
})
@JsonTypeName("CategoryAxisCrosshairTooltip_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-25T09:03:04.418164276+07:00[Asia/Bangkok]")
public class CategoryAxisCrosshairTooltipNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_BACKGROUND = "background";
  private String background;

  public static final String JSON_PROPERTY_BORDER = "border";
  private BorderNonAuthenticatedEntity border;

  public static final String JSON_PROPERTY_COLOR = "color";
  private String color;

  public static final String JSON_PROPERTY_FONT = "font";
  private String font;

  public static final String JSON_PROPERTY_FORMAT = "format";
  private String format;

  public static final String JSON_PROPERTY_PADDING = "padding";
  private PaddingNonAuthenticatedEntity padding;

  public static final String JSON_PROPERTY_VISIBLE = "visible";
  private Boolean visible;

  public CategoryAxisCrosshairTooltipNonAuthenticatedEntity() {
  }

  public CategoryAxisCrosshairTooltipNonAuthenticatedEntity background(String background) {
    
    this.background = background;
    return this;
  }

   /**
   * Get background
   * @return background
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBackground() {
    return background;
  }


  @JsonProperty(JSON_PROPERTY_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBackground(String background) {
    this.background = background;
  }


  public CategoryAxisCrosshairTooltipNonAuthenticatedEntity border(BorderNonAuthenticatedEntity border) {
    
    this.border = border;
    return this;
  }

   /**
   * Get border
   * @return border
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BorderNonAuthenticatedEntity getBorder() {
    return border;
  }


  @JsonProperty(JSON_PROPERTY_BORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBorder(BorderNonAuthenticatedEntity border) {
    this.border = border;
  }


  public CategoryAxisCrosshairTooltipNonAuthenticatedEntity color(String color) {
    
    this.color = color;
    return this;
  }

   /**
   * Get color
   * @return color
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public CategoryAxisCrosshairTooltipNonAuthenticatedEntity font(String font) {
    
    this.font = font;
    return this;
  }

   /**
   * Get font
   * @return font
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FONT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFont() {
    return font;
  }


  @JsonProperty(JSON_PROPERTY_FONT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFont(String font) {
    this.font = font;
  }


  public CategoryAxisCrosshairTooltipNonAuthenticatedEntity format(String format) {
    
    this.format = format;
    return this;
  }

   /**
   * Get format
   * @return format
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFormat() {
    return format;
  }


  @JsonProperty(JSON_PROPERTY_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormat(String format) {
    this.format = format;
  }


  public CategoryAxisCrosshairTooltipNonAuthenticatedEntity padding(PaddingNonAuthenticatedEntity padding) {
    
    this.padding = padding;
    return this;
  }

   /**
   * Get padding
   * @return padding
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PADDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaddingNonAuthenticatedEntity getPadding() {
    return padding;
  }


  @JsonProperty(JSON_PROPERTY_PADDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPadding(PaddingNonAuthenticatedEntity padding) {
    this.padding = padding;
  }


  public CategoryAxisCrosshairTooltipNonAuthenticatedEntity visible(Boolean visible) {
    
    this.visible = visible;
    return this;
  }

   /**
   * Get visible
   * @return visible
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getVisible() {
    return visible;
  }


  @JsonProperty(JSON_PROPERTY_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisible(Boolean visible) {
    this.visible = visible;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CategoryAxisCrosshairTooltipNonAuthenticatedEntity categoryAxisCrosshairTooltipNonAuthenticatedEntity = (CategoryAxisCrosshairTooltipNonAuthenticatedEntity) o;
    return Objects.equals(this.background, categoryAxisCrosshairTooltipNonAuthenticatedEntity.background) &&
        Objects.equals(this.border, categoryAxisCrosshairTooltipNonAuthenticatedEntity.border) &&
        Objects.equals(this.color, categoryAxisCrosshairTooltipNonAuthenticatedEntity.color) &&
        Objects.equals(this.font, categoryAxisCrosshairTooltipNonAuthenticatedEntity.font) &&
        Objects.equals(this.format, categoryAxisCrosshairTooltipNonAuthenticatedEntity.format) &&
        Objects.equals(this.padding, categoryAxisCrosshairTooltipNonAuthenticatedEntity.padding) &&
        Objects.equals(this.visible, categoryAxisCrosshairTooltipNonAuthenticatedEntity.visible);
  }

  @Override
  public int hashCode() {
    return Objects.hash(background, border, color, font, format, padding, visible);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CategoryAxisCrosshairTooltipNonAuthenticatedEntity {\n");
    sb.append("    background: ").append(toIndentedString(background)).append("\n");
    sb.append("    border: ").append(toIndentedString(border)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    font: ").append(toIndentedString(font)).append("\n");
    sb.append("    format: ").append(toIndentedString(format)).append("\n");
    sb.append("    padding: ").append(toIndentedString(padding)).append("\n");
    sb.append("    visible: ").append(toIndentedString(visible)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

