/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.56.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.analytics.model.SortObjectNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PageableObjectNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  PageableObjectNonAuthenticatedEntity.JSON_PROPERTY_OFFSET,
  PageableObjectNonAuthenticatedEntity.JSON_PROPERTY_SORT,
  PageableObjectNonAuthenticatedEntity.JSON_PROPERTY_PAGE_NUMBER,
  PageableObjectNonAuthenticatedEntity.JSON_PROPERTY_PAGE_SIZE,
  PageableObjectNonAuthenticatedEntity.JSON_PROPERTY_UNPAGED,
  PageableObjectNonAuthenticatedEntity.JSON_PROPERTY_PAGED
})
@JsonTypeName("PageableObject_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-25T09:03:04.418164276+07:00[Asia/Bangkok]")
public class PageableObjectNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_OFFSET = "offset";
  private Long offset;

  public static final String JSON_PROPERTY_SORT = "sort";
  private SortObjectNonAuthenticatedEntity sort;

  public static final String JSON_PROPERTY_PAGE_NUMBER = "pageNumber";
  private Integer pageNumber;

  public static final String JSON_PROPERTY_PAGE_SIZE = "pageSize";
  private Integer pageSize;

  public static final String JSON_PROPERTY_UNPAGED = "unpaged";
  private Boolean unpaged;

  public static final String JSON_PROPERTY_PAGED = "paged";
  private Boolean paged;

  public PageableObjectNonAuthenticatedEntity() {
  }

  public PageableObjectNonAuthenticatedEntity offset(Long offset) {
    
    this.offset = offset;
    return this;
  }

   /**
   * Get offset
   * @return offset
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getOffset() {
    return offset;
  }


  @JsonProperty(JSON_PROPERTY_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOffset(Long offset) {
    this.offset = offset;
  }


  public PageableObjectNonAuthenticatedEntity sort(SortObjectNonAuthenticatedEntity sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Get sort
   * @return sort
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SortObjectNonAuthenticatedEntity getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(SortObjectNonAuthenticatedEntity sort) {
    this.sort = sort;
  }


  public PageableObjectNonAuthenticatedEntity pageNumber(Integer pageNumber) {
    
    this.pageNumber = pageNumber;
    return this;
  }

   /**
   * Get pageNumber
   * @return pageNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAGE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPageNumber() {
    return pageNumber;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageNumber(Integer pageNumber) {
    this.pageNumber = pageNumber;
  }


  public PageableObjectNonAuthenticatedEntity pageSize(Integer pageSize) {
    
    this.pageSize = pageSize;
    return this;
  }

   /**
   * Get pageSize
   * @return pageSize
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPageSize() {
    return pageSize;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  public PageableObjectNonAuthenticatedEntity unpaged(Boolean unpaged) {
    
    this.unpaged = unpaged;
    return this;
  }

   /**
   * Get unpaged
   * @return unpaged
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_UNPAGED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUnpaged() {
    return unpaged;
  }


  @JsonProperty(JSON_PROPERTY_UNPAGED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnpaged(Boolean unpaged) {
    this.unpaged = unpaged;
  }


  public PageableObjectNonAuthenticatedEntity paged(Boolean paged) {
    
    this.paged = paged;
    return this;
  }

   /**
   * Get paged
   * @return paged
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAGED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPaged() {
    return paged;
  }


  @JsonProperty(JSON_PROPERTY_PAGED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaged(Boolean paged) {
    this.paged = paged;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PageableObjectNonAuthenticatedEntity pageableObjectNonAuthenticatedEntity = (PageableObjectNonAuthenticatedEntity) o;
    return Objects.equals(this.offset, pageableObjectNonAuthenticatedEntity.offset) &&
        Objects.equals(this.sort, pageableObjectNonAuthenticatedEntity.sort) &&
        Objects.equals(this.pageNumber, pageableObjectNonAuthenticatedEntity.pageNumber) &&
        Objects.equals(this.pageSize, pageableObjectNonAuthenticatedEntity.pageSize) &&
        Objects.equals(this.unpaged, pageableObjectNonAuthenticatedEntity.unpaged) &&
        Objects.equals(this.paged, pageableObjectNonAuthenticatedEntity.paged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(offset, sort, pageNumber, pageSize, unpaged, paged);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PageableObjectNonAuthenticatedEntity {\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    pageNumber: ").append(toIndentedString(pageNumber)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    unpaged: ").append(toIndentedString(unpaged)).append("\n");
    sb.append("    paged: ").append(toIndentedString(paged)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

