/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.58.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The time-interval steps when &#x60;baseUnit&#x60; is set either to &#x60;fit&#x60; or &#x60;auto&#x60;. The axis will try to divide the active period into the smallest possible units that yield &#x60;maxDateGroups&#x60; or less discrete intervals.
 */
@JsonPropertyOrder({
  AutoBaseUnitStepsNonAuthenticatedEntity.JSON_PROPERTY_MILLISECONDS,
  AutoBaseUnitStepsNonAuthenticatedEntity.JSON_PROPERTY_SECONDS,
  AutoBaseUnitStepsNonAuthenticatedEntity.JSON_PROPERTY_MINUTES,
  AutoBaseUnitStepsNonAuthenticatedEntity.JSON_PROPERTY_HOURS,
  AutoBaseUnitStepsNonAuthenticatedEntity.JSON_PROPERTY_DAYS,
  AutoBaseUnitStepsNonAuthenticatedEntity.JSON_PROPERTY_WEEKS,
  AutoBaseUnitStepsNonAuthenticatedEntity.JSON_PROPERTY_MONTHS,
  AutoBaseUnitStepsNonAuthenticatedEntity.JSON_PROPERTY_YEARS
})
@JsonTypeName("AutoBaseUnitSteps_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-28T20:17:34.304312895+07:00[Asia/Bangkok]")
public class AutoBaseUnitStepsNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_MILLISECONDS = "milliseconds";
  private BigDecimal milliseconds;

  public static final String JSON_PROPERTY_SECONDS = "seconds";
  private BigDecimal seconds;

  public static final String JSON_PROPERTY_MINUTES = "minutes";
  private BigDecimal minutes;

  public static final String JSON_PROPERTY_HOURS = "hours";
  private BigDecimal hours;

  public static final String JSON_PROPERTY_DAYS = "days";
  private BigDecimal days;

  public static final String JSON_PROPERTY_WEEKS = "weeks";
  private BigDecimal weeks;

  public static final String JSON_PROPERTY_MONTHS = "months";
  private BigDecimal months;

  public static final String JSON_PROPERTY_YEARS = "years";
  private BigDecimal years;

  public AutoBaseUnitStepsNonAuthenticatedEntity() {
  }

  public AutoBaseUnitStepsNonAuthenticatedEntity milliseconds(BigDecimal milliseconds) {
    
    this.milliseconds = milliseconds;
    return this;
  }

   /**
   * Get milliseconds
   * @return milliseconds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MILLISECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMilliseconds() {
    return milliseconds;
  }


  @JsonProperty(JSON_PROPERTY_MILLISECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMilliseconds(BigDecimal milliseconds) {
    this.milliseconds = milliseconds;
  }


  public AutoBaseUnitStepsNonAuthenticatedEntity seconds(BigDecimal seconds) {
    
    this.seconds = seconds;
    return this;
  }

   /**
   * Get seconds
   * @return seconds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSeconds() {
    return seconds;
  }


  @JsonProperty(JSON_PROPERTY_SECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeconds(BigDecimal seconds) {
    this.seconds = seconds;
  }


  public AutoBaseUnitStepsNonAuthenticatedEntity minutes(BigDecimal minutes) {
    
    this.minutes = minutes;
    return this;
  }

   /**
   * Get minutes
   * @return minutes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MINUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMinutes() {
    return minutes;
  }


  @JsonProperty(JSON_PROPERTY_MINUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinutes(BigDecimal minutes) {
    this.minutes = minutes;
  }


  public AutoBaseUnitStepsNonAuthenticatedEntity hours(BigDecimal hours) {
    
    this.hours = hours;
    return this;
  }

   /**
   * Get hours
   * @return hours
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getHours() {
    return hours;
  }


  @JsonProperty(JSON_PROPERTY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHours(BigDecimal hours) {
    this.hours = hours;
  }


  public AutoBaseUnitStepsNonAuthenticatedEntity days(BigDecimal days) {
    
    this.days = days;
    return this;
  }

   /**
   * Get days
   * @return days
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDays() {
    return days;
  }


  @JsonProperty(JSON_PROPERTY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDays(BigDecimal days) {
    this.days = days;
  }


  public AutoBaseUnitStepsNonAuthenticatedEntity weeks(BigDecimal weeks) {
    
    this.weeks = weeks;
    return this;
  }

   /**
   * Get weeks
   * @return weeks
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_WEEKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getWeeks() {
    return weeks;
  }


  @JsonProperty(JSON_PROPERTY_WEEKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWeeks(BigDecimal weeks) {
    this.weeks = weeks;
  }


  public AutoBaseUnitStepsNonAuthenticatedEntity months(BigDecimal months) {
    
    this.months = months;
    return this;
  }

   /**
   * Get months
   * @return months
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMonths() {
    return months;
  }


  @JsonProperty(JSON_PROPERTY_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMonths(BigDecimal months) {
    this.months = months;
  }


  public AutoBaseUnitStepsNonAuthenticatedEntity years(BigDecimal years) {
    
    this.years = years;
    return this;
  }

   /**
   * Get years
   * @return years
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_YEARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getYears() {
    return years;
  }


  @JsonProperty(JSON_PROPERTY_YEARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setYears(BigDecimal years) {
    this.years = years;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AutoBaseUnitStepsNonAuthenticatedEntity autoBaseUnitStepsNonAuthenticatedEntity = (AutoBaseUnitStepsNonAuthenticatedEntity) o;
    return Objects.equals(this.milliseconds, autoBaseUnitStepsNonAuthenticatedEntity.milliseconds) &&
        Objects.equals(this.seconds, autoBaseUnitStepsNonAuthenticatedEntity.seconds) &&
        Objects.equals(this.minutes, autoBaseUnitStepsNonAuthenticatedEntity.minutes) &&
        Objects.equals(this.hours, autoBaseUnitStepsNonAuthenticatedEntity.hours) &&
        Objects.equals(this.days, autoBaseUnitStepsNonAuthenticatedEntity.days) &&
        Objects.equals(this.weeks, autoBaseUnitStepsNonAuthenticatedEntity.weeks) &&
        Objects.equals(this.months, autoBaseUnitStepsNonAuthenticatedEntity.months) &&
        Objects.equals(this.years, autoBaseUnitStepsNonAuthenticatedEntity.years);
  }

  @Override
  public int hashCode() {
    return Objects.hash(milliseconds, seconds, minutes, hours, days, weeks, months, years);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AutoBaseUnitStepsNonAuthenticatedEntity {\n");
    sb.append("    milliseconds: ").append(toIndentedString(milliseconds)).append("\n");
    sb.append("    seconds: ").append(toIndentedString(seconds)).append("\n");
    sb.append("    minutes: ").append(toIndentedString(minutes)).append("\n");
    sb.append("    hours: ").append(toIndentedString(hours)).append("\n");
    sb.append("    days: ").append(toIndentedString(days)).append("\n");
    sb.append("    weeks: ").append(toIndentedString(weeks)).append("\n");
    sb.append("    months: ").append(toIndentedString(months)).append("\n");
    sb.append("    years: ").append(toIndentedString(years)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

