/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.58.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import travel.wink.sdk.analytics.model.KeyValuePairAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Chart properties allow you to choose how to visualize available data points. Choose how you want to:   - filter your data  - sort your data  - group your data  - include data in your data sets  - display currency amounts
 */
@JsonPropertyOrder({
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SERIES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_TIME_SERIES_UNITS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_START_DATE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_END_DATE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_CONTINENT_CODE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_PAGE_VISITS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CARD_VISITS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_BOOKINGS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLATIONS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ROOM_NIGHTS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_MEETING_ROOMS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_RESTAURANTS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_SPAS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_SPAS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ACTIVITIES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ATTRACTIONS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_PLACES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_PLACES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ADD_ONS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_ADDONS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_SPAS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_PLACES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_PAGE_VISITS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CARD_VISITS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_BOOKINGS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLATIONS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ROOM_NIGHTS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_MEETING_ROOMS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_RESTAURANTS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_SPAS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_SPAS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ACTIVITIES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ATTRACTIONS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_PLACES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_PLACES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ADD_ONS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_SPAS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_PLACES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_CONTINENT_CODE,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER,
  ChartRequestAuthenticatedEntity.JSON_PROPERTY_CURRENCY_CODE
})
@JsonTypeName("ChartRequest_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-28T20:17:34.304312895+07:00[Asia/Bangkok]")
public class ChartRequestAuthenticatedEntity {
  /**
   * The time series to visualize
   */
  public enum SeriesEnum {
    HOUR("HOUR"),
    
    DAY("DAY"),
    
    MONTH("MONTH"),
    
    YEAR("YEAR");

    private String value;

    SeriesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SeriesEnum fromValue(String value) {
      for (SeriesEnum b : SeriesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SERIES = "series";
  private SeriesEnum series;

  public static final String JSON_PROPERTY_TIME_SERIES_UNITS = "timeSeriesUnits";
  private Long timeSeriesUnits;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private java.time.LocalDateTime startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private java.time.LocalDateTime endDate;

  public static final String JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER = "filterOnHotelIdentifier";
  private KeyValuePairAuthenticatedEntity filterOnHotelIdentifier;

  /**
   * Filter on channel sub type. What channel sub-type helped make the booking.
   */
  public enum FilterOnChannelSubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM"),
    
    GOOGLE_HOTEL_API("GOOGLE_HOTEL_API"),
    
    MANAGEMENT_COMPANY("MANAGEMENT_COMPANY"),
    
    CHAIN("CHAIN"),
    
    BRAND("BRAND"),
    
    EVENT_ORGANIZER("EVENT_ORGANIZER");

    private String value;

    FilterOnChannelSubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FilterOnChannelSubTypeEnum fromValue(String value) {
      for (FilterOnChannelSubTypeEnum b : FilterOnChannelSubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE = "filterOnChannelSubType";
  private FilterOnChannelSubTypeEnum filterOnChannelSubType;

  public static final String JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER = "filterOnOwnerIdentifier";
  private KeyValuePairAuthenticatedEntity filterOnOwnerIdentifier;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID = "filterOnEngineCountryGeoNameId";
  private KeyValuePairAuthenticatedEntity filterOnEngineCountryGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID = "filterOnEngineCityGeoNameId";
  private KeyValuePairAuthenticatedEntity filterOnEngineCityGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE = "filterOnEngineContinentCode";
  private KeyValuePairAuthenticatedEntity filterOnEngineContinentCode;

  public static final String JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER = "filterOnEngineConfigurationIdentifier";
  private KeyValuePairAuthenticatedEntity filterOnEngineConfigurationIdentifier;

  public static final String JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID = "filterOnCountryGeoNameId";
  private KeyValuePairAuthenticatedEntity filterOnCountryGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID = "filterOnCityGeoNameId";
  private KeyValuePairAuthenticatedEntity filterOnCityGeoNameId;

  public static final String JSON_PROPERTY_FILTER_ON_CONTINENT_CODE = "filterOnContinentCode";
  private KeyValuePairAuthenticatedEntity filterOnContinentCode;

  public static final String JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER = "filterOnUserIdentifier";
  private KeyValuePairAuthenticatedEntity filterOnUserIdentifier;

  public static final String JSON_PROPERTY_SORT_ON_PAGE_VISITS = "sortOnPageVisits";
  private Boolean sortOnPageVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS = "sortOnMapMarkerVisits";
  private Boolean sortOnMapMarkerVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_CARD_VISITS = "sortOnCardVisits";
  private Boolean sortOnCardVisits = false;

  public static final String JSON_PROPERTY_SORT_ON_BOOKINGS = "sortOnBookings";
  private Boolean sortOnBookings = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLATIONS = "sortOnCancellations";
  private Boolean sortOnCancellations = false;

  public static final String JSON_PROPERTY_SORT_ON_ROOM_NIGHTS = "sortOnRoomNights";
  private Boolean sortOnRoomNights = false;

  public static final String JSON_PROPERTY_SORT_ON_MEETING_ROOMS = "sortOnMeetingRooms";
  private Boolean sortOnMeetingRooms = false;

  public static final String JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE = "sortOnMeetingRoomsRevenue";
  private Boolean sortOnMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_RESTAURANTS = "sortOnRestaurants";
  private Boolean sortOnRestaurants = false;

  public static final String JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE = "sortOnRestaurantsRevenue";
  private Boolean sortOnRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_SPAS = "sortOnSpas";
  private Boolean sortOnSpas = false;

  public static final String JSON_PROPERTY_SORT_ON_SPAS_REVENUE = "sortOnSpasRevenue";
  private Boolean sortOnSpasRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ACTIVITIES = "sortOnActivities";
  private Boolean sortOnActivities = false;

  public static final String JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE = "sortOnActivitiesRevenue";
  private Boolean sortOnActivitiesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ATTRACTIONS = "sortOnAttractions";
  private Boolean sortOnAttractions = false;

  public static final String JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE = "sortOnAttractionsRevenue";
  private Boolean sortOnAttractionsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_PLACES = "sortOnPlaces";
  private Boolean sortOnPlaces = false;

  public static final String JSON_PROPERTY_SORT_ON_PLACES_REVENUE = "sortOnPlacesRevenue";
  private Boolean sortOnPlacesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES = "sortOnRoomTypeAncillaries";
  private Boolean sortOnRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE = "sortOnRoomTypeAncillariesRevenue";
  private Boolean sortOnRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_ADD_ONS = "sortOnAddOns";
  private Boolean sortOnAddOns = false;

  public static final String JSON_PROPERTY_SORT_ON_ADDONS_REVENUE = "sortOnAddonsRevenue";
  private Boolean sortOnAddonsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE = "sortOnTotalRoomRevenue";
  private Boolean sortOnTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE = "sortOnTotalAncillariesRevenue";
  private Boolean sortOnTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE = "sortOnTotalNetRevenue";
  private Boolean sortOnTotalNetRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS = "sortOnCancelledRoomNights";
  private Boolean sortOnCancelledRoomNights = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS = "sortOnCancelledMeetingRooms";
  private Boolean sortOnCancelledMeetingRooms = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE = "sortOnCancelledMeetingRoomsRevenue";
  private Boolean sortOnCancelledMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS = "sortOnCancelledRestaurants";
  private Boolean sortOnCancelledRestaurants = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE = "sortOnCancelledRestaurantsRevenue";
  private Boolean sortOnCancelledRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_SPAS = "sortOnCancelledSpas";
  private Boolean sortOnCancelledSpas = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE = "sortOnCancelledSpasRevenue";
  private Boolean sortOnCancelledSpasRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES = "sortOnCancelledActivities";
  private Boolean sortOnCancelledActivities = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE = "sortOnCancelledActivitiesRevenue";
  private Boolean sortOnCancelledActivitiesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS = "sortOnCancelledAttractions";
  private Boolean sortOnCancelledAttractions = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE = "sortOnCancelledAttractionsRevenue";
  private Boolean sortOnCancelledAttractionsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PLACES = "sortOnCancelledPlaces";
  private Boolean sortOnCancelledPlaces = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE = "sortOnCancelledPlacesRevenue";
  private Boolean sortOnCancelledPlacesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE = "sortOnCancelledTotalRoomRevenue";
  private Boolean sortOnCancelledTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE = "sortOnCancelledTotalAncillariesRevenue";
  private Boolean sortOnCancelledTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES = "sortOnCancelledRoomTypeAncillaries";
  private Boolean sortOnCancelledRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE = "sortOnCancelledRoomTypeAncillariesRevenue";
  private Boolean sortOnCancelledRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS = "sortOnCancelledAddOns";
  private Boolean sortOnCancelledAddOns = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE = "sortOnCancelledAddonsRevenue";
  private Boolean sortOnCancelledAddonsRevenue = false;

  public static final String JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE = "sortOnCancelledTotalNetRevenue";
  private Boolean sortOnCancelledTotalNetRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_PAGE_VISITS = "includePageVisits";
  private Boolean includePageVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS = "includeMapMarkerVisits";
  private Boolean includeMapMarkerVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_CARD_VISITS = "includeCardVisits";
  private Boolean includeCardVisits = false;

  public static final String JSON_PROPERTY_INCLUDE_BOOKINGS = "includeBookings";
  private Boolean includeBookings = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLATIONS = "includeCancellations";
  private Boolean includeCancellations = false;

  public static final String JSON_PROPERTY_INCLUDE_ROOM_NIGHTS = "includeRoomNights";
  private Boolean includeRoomNights = false;

  public static final String JSON_PROPERTY_INCLUDE_MEETING_ROOMS = "includeMeetingRooms";
  private Boolean includeMeetingRooms = false;

  public static final String JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE = "includeMeetingRoomsRevenue";
  private Boolean includeMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_RESTAURANTS = "includeRestaurants";
  private Boolean includeRestaurants = false;

  public static final String JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE = "includeRestaurantsRevenue";
  private Boolean includeRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_SPAS = "includeSpas";
  private Boolean includeSpas = false;

  public static final String JSON_PROPERTY_INCLUDE_SPAS_REVENUE = "includeSpasRevenue";
  private Boolean includeSpasRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ACTIVITIES = "includeActivities";
  private Boolean includeActivities = false;

  public static final String JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE = "includeActivitiesRevenue";
  private Boolean includeActivitiesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ATTRACTIONS = "includeAttractions";
  private Boolean includeAttractions = false;

  public static final String JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE = "includeAttractionsRevenue";
  private Boolean includeAttractionsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_PLACES = "includePlaces";
  private Boolean includePlaces = false;

  public static final String JSON_PROPERTY_INCLUDE_PLACES_REVENUE = "includePlacesRevenue";
  private Boolean includePlacesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES = "includeRoomTypeAncillaries";
  private Boolean includeRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE = "includeRoomTypeAncillariesRevenue";
  private Boolean includeRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_ADD_ONS = "includeAddOns";
  private Boolean includeAddOns = false;

  public static final String JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE = "includeAddOnsRevenue";
  private Boolean includeAddOnsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE = "includeTotalRoomRevenue";
  private Boolean includeTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE = "includeAverageRoomRate";
  private Boolean includeAverageRoomRate = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE = "includeTotalAncillariesRevenue";
  private Boolean includeTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE = "includeTotalNetRevenue";
  private Boolean includeTotalNetRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS = "includeCancelledRoomNights";
  private Boolean includeCancelledRoomNights = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS = "includeCancelledMeetingRooms";
  private Boolean includeCancelledMeetingRooms = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE = "includeCancelledMeetingRoomsRevenue";
  private Boolean includeCancelledMeetingRoomsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS = "includeCancelledRestaurants";
  private Boolean includeCancelledRestaurants = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE = "includeCancelledRestaurantsRevenue";
  private Boolean includeCancelledRestaurantsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_SPAS = "includeCancelledSpas";
  private Boolean includeCancelledSpas = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE = "includeCancelledSpasRevenue";
  private Boolean includeCancelledSpasRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES = "includeCancelledActivities";
  private Boolean includeCancelledActivities = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE = "includeCancelledActivitiesRevenue";
  private Boolean includeCancelledActivitiesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS = "includeCancelledAttractions";
  private Boolean includeCancelledAttractions = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE = "includeCancelledAttractionsRevenue";
  private Boolean includeCancelledAttractionsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PLACES = "includeCancelledPlaces";
  private Boolean includeCancelledPlaces = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE = "includeCancelledPlacesRevenue";
  private Boolean includeCancelledPlacesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES = "includeCancelledRoomTypeAncillaries";
  private Boolean includeCancelledRoomTypeAncillaries = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE = "includeCancelledRoomTypeAncillariesRevenue";
  private Boolean includeCancelledRoomTypeAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS = "includeCancelledAddOns";
  private Boolean includeCancelledAddOns = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE = "includeCancelledAddOnsRevenue";
  private Boolean includeCancelledAddOnsRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE = "includeCancelledTotalRoomRevenue";
  private Boolean includeCancelledTotalRoomRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE = "includeCancelledTotalAncillariesRevenue";
  private Boolean includeCancelledTotalAncillariesRevenue = false;

  public static final String JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE = "includeCancelledTotalNetRevenue";
  private Boolean includeCancelledTotalNetRevenue = false;

  public static final String JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE = "groupOnChannelSubType";
  private Boolean groupOnChannelSubType = false;

  public static final String JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER = "groupOnOwnerIdentifier";
  private Boolean groupOnOwnerIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER = "groupOnEngineIdentifier";
  private Boolean groupOnEngineIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID = "groupOnEngineCountryGeoNameId";
  private Boolean groupOnEngineCountryGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID = "groupOnEngineCityGeoNameId";
  private Boolean groupOnEngineCityGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE = "groupOnEngineContinentCode";
  private Boolean groupOnEngineContinentCode = false;

  public static final String JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER = "groupOnEngineConfigurationIdentifier";
  private Boolean groupOnEngineConfigurationIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID = "groupOnCountryGeoNameId";
  private Boolean groupOnCountryGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID = "groupOnCityGeoNameId";
  private Boolean groupOnCityGeoNameId = false;

  public static final String JSON_PROPERTY_GROUP_ON_CONTINENT_CODE = "groupOnContinentCode";
  private Boolean groupOnContinentCode = false;

  public static final String JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER = "groupOnHotelIdentifier";
  private Boolean groupOnHotelIdentifier = false;

  public static final String JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER = "groupOnUserIdentifier";
  private Boolean groupOnUserIdentifier = false;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode = "USD";

  public ChartRequestAuthenticatedEntity() {
  }

  public ChartRequestAuthenticatedEntity series(SeriesEnum series) {
    
    this.series = series;
    return this;
  }

   /**
   * The time series to visualize
   * @return series
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SeriesEnum getSeries() {
    return series;
  }


  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSeries(SeriesEnum series) {
    this.series = series;
  }


  public ChartRequestAuthenticatedEntity timeSeriesUnits(Long timeSeriesUnits) {
    
    this.timeSeriesUnits = timeSeriesUnits;
    return this;
  }

   /**
   * How many units of the time series type to visualize. Only required if start / end date not populated.
   * @return timeSeriesUnits
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIME_SERIES_UNITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimeSeriesUnits() {
    return timeSeriesUnits;
  }


  @JsonProperty(JSON_PROPERTY_TIME_SERIES_UNITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeSeriesUnits(Long timeSeriesUnits) {
    this.timeSeriesUnits = timeSeriesUnits;
  }


  public ChartRequestAuthenticatedEntity startDate(java.time.LocalDateTime startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Fixed date to start visualizations on
   * @return startDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(java.time.LocalDateTime startDate) {
    this.startDate = startDate;
  }


  public ChartRequestAuthenticatedEntity endDate(java.time.LocalDateTime endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Fixed date to end visualizations on
   * @return endDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(java.time.LocalDateTime endDate) {
    this.endDate = endDate;
  }


  public ChartRequestAuthenticatedEntity filterOnHotelIdentifier(KeyValuePairAuthenticatedEntity filterOnHotelIdentifier) {
    
    this.filterOnHotelIdentifier = filterOnHotelIdentifier;
    return this;
  }

   /**
   * Get filterOnHotelIdentifier
   * @return filterOnHotelIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnHotelIdentifier() {
    return filterOnHotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnHotelIdentifier(KeyValuePairAuthenticatedEntity filterOnHotelIdentifier) {
    this.filterOnHotelIdentifier = filterOnHotelIdentifier;
  }


  public ChartRequestAuthenticatedEntity filterOnChannelSubType(FilterOnChannelSubTypeEnum filterOnChannelSubType) {
    
    this.filterOnChannelSubType = filterOnChannelSubType;
    return this;
  }

   /**
   * Filter on channel sub type. What channel sub-type helped make the booking.
   * @return filterOnChannelSubType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FilterOnChannelSubTypeEnum getFilterOnChannelSubType() {
    return filterOnChannelSubType;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnChannelSubType(FilterOnChannelSubTypeEnum filterOnChannelSubType) {
    this.filterOnChannelSubType = filterOnChannelSubType;
  }


  public ChartRequestAuthenticatedEntity filterOnOwnerIdentifier(KeyValuePairAuthenticatedEntity filterOnOwnerIdentifier) {
    
    this.filterOnOwnerIdentifier = filterOnOwnerIdentifier;
    return this;
  }

   /**
   * Get filterOnOwnerIdentifier
   * @return filterOnOwnerIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnOwnerIdentifier() {
    return filterOnOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnOwnerIdentifier(KeyValuePairAuthenticatedEntity filterOnOwnerIdentifier) {
    this.filterOnOwnerIdentifier = filterOnOwnerIdentifier;
  }


  public ChartRequestAuthenticatedEntity filterOnEngineCountryGeoNameId(KeyValuePairAuthenticatedEntity filterOnEngineCountryGeoNameId) {
    
    this.filterOnEngineCountryGeoNameId = filterOnEngineCountryGeoNameId;
    return this;
  }

   /**
   * Get filterOnEngineCountryGeoNameId
   * @return filterOnEngineCountryGeoNameId
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnEngineCountryGeoNameId() {
    return filterOnEngineCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineCountryGeoNameId(KeyValuePairAuthenticatedEntity filterOnEngineCountryGeoNameId) {
    this.filterOnEngineCountryGeoNameId = filterOnEngineCountryGeoNameId;
  }


  public ChartRequestAuthenticatedEntity filterOnEngineCityGeoNameId(KeyValuePairAuthenticatedEntity filterOnEngineCityGeoNameId) {
    
    this.filterOnEngineCityGeoNameId = filterOnEngineCityGeoNameId;
    return this;
  }

   /**
   * Get filterOnEngineCityGeoNameId
   * @return filterOnEngineCityGeoNameId
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnEngineCityGeoNameId() {
    return filterOnEngineCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineCityGeoNameId(KeyValuePairAuthenticatedEntity filterOnEngineCityGeoNameId) {
    this.filterOnEngineCityGeoNameId = filterOnEngineCityGeoNameId;
  }


  public ChartRequestAuthenticatedEntity filterOnEngineContinentCode(KeyValuePairAuthenticatedEntity filterOnEngineContinentCode) {
    
    this.filterOnEngineContinentCode = filterOnEngineContinentCode;
    return this;
  }

   /**
   * Get filterOnEngineContinentCode
   * @return filterOnEngineContinentCode
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnEngineContinentCode() {
    return filterOnEngineContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineContinentCode(KeyValuePairAuthenticatedEntity filterOnEngineContinentCode) {
    this.filterOnEngineContinentCode = filterOnEngineContinentCode;
  }


  public ChartRequestAuthenticatedEntity filterOnEngineConfigurationIdentifier(KeyValuePairAuthenticatedEntity filterOnEngineConfigurationIdentifier) {
    
    this.filterOnEngineConfigurationIdentifier = filterOnEngineConfigurationIdentifier;
    return this;
  }

   /**
   * Get filterOnEngineConfigurationIdentifier
   * @return filterOnEngineConfigurationIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnEngineConfigurationIdentifier() {
    return filterOnEngineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnEngineConfigurationIdentifier(KeyValuePairAuthenticatedEntity filterOnEngineConfigurationIdentifier) {
    this.filterOnEngineConfigurationIdentifier = filterOnEngineConfigurationIdentifier;
  }


  public ChartRequestAuthenticatedEntity filterOnCountryGeoNameId(KeyValuePairAuthenticatedEntity filterOnCountryGeoNameId) {
    
    this.filterOnCountryGeoNameId = filterOnCountryGeoNameId;
    return this;
  }

   /**
   * Get filterOnCountryGeoNameId
   * @return filterOnCountryGeoNameId
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnCountryGeoNameId() {
    return filterOnCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnCountryGeoNameId(KeyValuePairAuthenticatedEntity filterOnCountryGeoNameId) {
    this.filterOnCountryGeoNameId = filterOnCountryGeoNameId;
  }


  public ChartRequestAuthenticatedEntity filterOnCityGeoNameId(KeyValuePairAuthenticatedEntity filterOnCityGeoNameId) {
    
    this.filterOnCityGeoNameId = filterOnCityGeoNameId;
    return this;
  }

   /**
   * Get filterOnCityGeoNameId
   * @return filterOnCityGeoNameId
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnCityGeoNameId() {
    return filterOnCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnCityGeoNameId(KeyValuePairAuthenticatedEntity filterOnCityGeoNameId) {
    this.filterOnCityGeoNameId = filterOnCityGeoNameId;
  }


  public ChartRequestAuthenticatedEntity filterOnContinentCode(KeyValuePairAuthenticatedEntity filterOnContinentCode) {
    
    this.filterOnContinentCode = filterOnContinentCode;
    return this;
  }

   /**
   * Get filterOnContinentCode
   * @return filterOnContinentCode
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnContinentCode() {
    return filterOnContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnContinentCode(KeyValuePairAuthenticatedEntity filterOnContinentCode) {
    this.filterOnContinentCode = filterOnContinentCode;
  }


  public ChartRequestAuthenticatedEntity filterOnUserIdentifier(KeyValuePairAuthenticatedEntity filterOnUserIdentifier) {
    
    this.filterOnUserIdentifier = filterOnUserIdentifier;
    return this;
  }

   /**
   * Get filterOnUserIdentifier
   * @return filterOnUserIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAuthenticatedEntity getFilterOnUserIdentifier() {
    return filterOnUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FILTER_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilterOnUserIdentifier(KeyValuePairAuthenticatedEntity filterOnUserIdentifier) {
    this.filterOnUserIdentifier = filterOnUserIdentifier;
  }


  public ChartRequestAuthenticatedEntity sortOnPageVisits(Boolean sortOnPageVisits) {
    
    this.sortOnPageVisits = sortOnPageVisits;
    return this;
  }

   /**
   * Sort on page visits
   * @return sortOnPageVisits
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPageVisits() {
    return sortOnPageVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPageVisits(Boolean sortOnPageVisits) {
    this.sortOnPageVisits = sortOnPageVisits;
  }


  public ChartRequestAuthenticatedEntity sortOnMapMarkerVisits(Boolean sortOnMapMarkerVisits) {
    
    this.sortOnMapMarkerVisits = sortOnMapMarkerVisits;
    return this;
  }

   /**
   * Sort on map marker visits
   * @return sortOnMapMarkerVisits
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMapMarkerVisits() {
    return sortOnMapMarkerVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMapMarkerVisits(Boolean sortOnMapMarkerVisits) {
    this.sortOnMapMarkerVisits = sortOnMapMarkerVisits;
  }


  public ChartRequestAuthenticatedEntity sortOnCardVisits(Boolean sortOnCardVisits) {
    
    this.sortOnCardVisits = sortOnCardVisits;
    return this;
  }

   /**
   * Sort on card visits
   * @return sortOnCardVisits
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCardVisits() {
    return sortOnCardVisits;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCardVisits(Boolean sortOnCardVisits) {
    this.sortOnCardVisits = sortOnCardVisits;
  }


  public ChartRequestAuthenticatedEntity sortOnBookings(Boolean sortOnBookings) {
    
    this.sortOnBookings = sortOnBookings;
    return this;
  }

   /**
   * Sort on bookings
   * @return sortOnBookings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnBookings() {
    return sortOnBookings;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnBookings(Boolean sortOnBookings) {
    this.sortOnBookings = sortOnBookings;
  }


  public ChartRequestAuthenticatedEntity sortOnCancellations(Boolean sortOnCancellations) {
    
    this.sortOnCancellations = sortOnCancellations;
    return this;
  }

   /**
   * Sort on cancellations
   * @return sortOnCancellations
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancellations() {
    return sortOnCancellations;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancellations(Boolean sortOnCancellations) {
    this.sortOnCancellations = sortOnCancellations;
  }


  public ChartRequestAuthenticatedEntity sortOnRoomNights(Boolean sortOnRoomNights) {
    
    this.sortOnRoomNights = sortOnRoomNights;
    return this;
  }

   /**
   * Sort on room nights
   * @return sortOnRoomNights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRoomNights() {
    return sortOnRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRoomNights(Boolean sortOnRoomNights) {
    this.sortOnRoomNights = sortOnRoomNights;
  }


  public ChartRequestAuthenticatedEntity sortOnMeetingRooms(Boolean sortOnMeetingRooms) {
    
    this.sortOnMeetingRooms = sortOnMeetingRooms;
    return this;
  }

   /**
   * Sort on meeting rooms
   * @return sortOnMeetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMeetingRooms() {
    return sortOnMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMeetingRooms(Boolean sortOnMeetingRooms) {
    this.sortOnMeetingRooms = sortOnMeetingRooms;
  }


  public ChartRequestAuthenticatedEntity sortOnMeetingRoomsRevenue(Boolean sortOnMeetingRoomsRevenue) {
    
    this.sortOnMeetingRoomsRevenue = sortOnMeetingRoomsRevenue;
    return this;
  }

   /**
   * Sort on meeting rooms revenue
   * @return sortOnMeetingRoomsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnMeetingRoomsRevenue() {
    return sortOnMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnMeetingRoomsRevenue(Boolean sortOnMeetingRoomsRevenue) {
    this.sortOnMeetingRoomsRevenue = sortOnMeetingRoomsRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnRestaurants(Boolean sortOnRestaurants) {
    
    this.sortOnRestaurants = sortOnRestaurants;
    return this;
  }

   /**
   * Sort on restaurants
   * @return sortOnRestaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRestaurants() {
    return sortOnRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRestaurants(Boolean sortOnRestaurants) {
    this.sortOnRestaurants = sortOnRestaurants;
  }


  public ChartRequestAuthenticatedEntity sortOnRestaurantsRevenue(Boolean sortOnRestaurantsRevenue) {
    
    this.sortOnRestaurantsRevenue = sortOnRestaurantsRevenue;
    return this;
  }

   /**
   * Sort on restaurants revenue
   * @return sortOnRestaurantsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRestaurantsRevenue() {
    return sortOnRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRestaurantsRevenue(Boolean sortOnRestaurantsRevenue) {
    this.sortOnRestaurantsRevenue = sortOnRestaurantsRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnSpas(Boolean sortOnSpas) {
    
    this.sortOnSpas = sortOnSpas;
    return this;
  }

   /**
   * Sort on spas
   * @return sortOnSpas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnSpas() {
    return sortOnSpas;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnSpas(Boolean sortOnSpas) {
    this.sortOnSpas = sortOnSpas;
  }


  public ChartRequestAuthenticatedEntity sortOnSpasRevenue(Boolean sortOnSpasRevenue) {
    
    this.sortOnSpasRevenue = sortOnSpasRevenue;
    return this;
  }

   /**
   * Sort on spas revenue
   * @return sortOnSpasRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnSpasRevenue() {
    return sortOnSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnSpasRevenue(Boolean sortOnSpasRevenue) {
    this.sortOnSpasRevenue = sortOnSpasRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnActivities(Boolean sortOnActivities) {
    
    this.sortOnActivities = sortOnActivities;
    return this;
  }

   /**
   * Sort on activities
   * @return sortOnActivities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnActivities() {
    return sortOnActivities;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnActivities(Boolean sortOnActivities) {
    this.sortOnActivities = sortOnActivities;
  }


  public ChartRequestAuthenticatedEntity sortOnActivitiesRevenue(Boolean sortOnActivitiesRevenue) {
    
    this.sortOnActivitiesRevenue = sortOnActivitiesRevenue;
    return this;
  }

   /**
   * Sort on activities revenue
   * @return sortOnActivitiesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnActivitiesRevenue() {
    return sortOnActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnActivitiesRevenue(Boolean sortOnActivitiesRevenue) {
    this.sortOnActivitiesRevenue = sortOnActivitiesRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnAttractions(Boolean sortOnAttractions) {
    
    this.sortOnAttractions = sortOnAttractions;
    return this;
  }

   /**
   * Sort on attractions
   * @return sortOnAttractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAttractions() {
    return sortOnAttractions;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAttractions(Boolean sortOnAttractions) {
    this.sortOnAttractions = sortOnAttractions;
  }


  public ChartRequestAuthenticatedEntity sortOnAttractionsRevenue(Boolean sortOnAttractionsRevenue) {
    
    this.sortOnAttractionsRevenue = sortOnAttractionsRevenue;
    return this;
  }

   /**
   * Sort on attractions revenue
   * @return sortOnAttractionsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAttractionsRevenue() {
    return sortOnAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAttractionsRevenue(Boolean sortOnAttractionsRevenue) {
    this.sortOnAttractionsRevenue = sortOnAttractionsRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnPlaces(Boolean sortOnPlaces) {
    
    this.sortOnPlaces = sortOnPlaces;
    return this;
  }

   /**
   * Sort on places
   * @return sortOnPlaces
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPlaces() {
    return sortOnPlaces;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPlaces(Boolean sortOnPlaces) {
    this.sortOnPlaces = sortOnPlaces;
  }


  public ChartRequestAuthenticatedEntity sortOnPlacesRevenue(Boolean sortOnPlacesRevenue) {
    
    this.sortOnPlacesRevenue = sortOnPlacesRevenue;
    return this;
  }

   /**
   * Sort on places revenue
   * @return sortOnPlacesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnPlacesRevenue() {
    return sortOnPlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnPlacesRevenue(Boolean sortOnPlacesRevenue) {
    this.sortOnPlacesRevenue = sortOnPlacesRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnRoomTypeAncillaries(Boolean sortOnRoomTypeAncillaries) {
    
    this.sortOnRoomTypeAncillaries = sortOnRoomTypeAncillaries;
    return this;
  }

   /**
   * Sort on room type ancillaries
   * @return sortOnRoomTypeAncillaries
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRoomTypeAncillaries() {
    return sortOnRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRoomTypeAncillaries(Boolean sortOnRoomTypeAncillaries) {
    this.sortOnRoomTypeAncillaries = sortOnRoomTypeAncillaries;
  }


  public ChartRequestAuthenticatedEntity sortOnRoomTypeAncillariesRevenue(Boolean sortOnRoomTypeAncillariesRevenue) {
    
    this.sortOnRoomTypeAncillariesRevenue = sortOnRoomTypeAncillariesRevenue;
    return this;
  }

   /**
   * Sort on room type ancillaries revenue
   * @return sortOnRoomTypeAncillariesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnRoomTypeAncillariesRevenue() {
    return sortOnRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnRoomTypeAncillariesRevenue(Boolean sortOnRoomTypeAncillariesRevenue) {
    this.sortOnRoomTypeAncillariesRevenue = sortOnRoomTypeAncillariesRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnAddOns(Boolean sortOnAddOns) {
    
    this.sortOnAddOns = sortOnAddOns;
    return this;
  }

   /**
   * Sort on add-ons
   * @return sortOnAddOns
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAddOns() {
    return sortOnAddOns;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAddOns(Boolean sortOnAddOns) {
    this.sortOnAddOns = sortOnAddOns;
  }


  public ChartRequestAuthenticatedEntity sortOnAddonsRevenue(Boolean sortOnAddonsRevenue) {
    
    this.sortOnAddonsRevenue = sortOnAddonsRevenue;
    return this;
  }

   /**
   * Sort on add-on revenue
   * @return sortOnAddonsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnAddonsRevenue() {
    return sortOnAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnAddonsRevenue(Boolean sortOnAddonsRevenue) {
    this.sortOnAddonsRevenue = sortOnAddonsRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnTotalRoomRevenue(Boolean sortOnTotalRoomRevenue) {
    
    this.sortOnTotalRoomRevenue = sortOnTotalRoomRevenue;
    return this;
  }

   /**
   * Sort on total room revenue
   * @return sortOnTotalRoomRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalRoomRevenue() {
    return sortOnTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalRoomRevenue(Boolean sortOnTotalRoomRevenue) {
    this.sortOnTotalRoomRevenue = sortOnTotalRoomRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnTotalAncillariesRevenue(Boolean sortOnTotalAncillariesRevenue) {
    
    this.sortOnTotalAncillariesRevenue = sortOnTotalAncillariesRevenue;
    return this;
  }

   /**
   * Sort on aggregate ancillaries revenue
   * @return sortOnTotalAncillariesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalAncillariesRevenue() {
    return sortOnTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalAncillariesRevenue(Boolean sortOnTotalAncillariesRevenue) {
    this.sortOnTotalAncillariesRevenue = sortOnTotalAncillariesRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnTotalNetRevenue(Boolean sortOnTotalNetRevenue) {
    
    this.sortOnTotalNetRevenue = sortOnTotalNetRevenue;
    return this;
  }

   /**
   * Sort on total net revenue
   * @return sortOnTotalNetRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnTotalNetRevenue() {
    return sortOnTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnTotalNetRevenue(Boolean sortOnTotalNetRevenue) {
    this.sortOnTotalNetRevenue = sortOnTotalNetRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledRoomNights(Boolean sortOnCancelledRoomNights) {
    
    this.sortOnCancelledRoomNights = sortOnCancelledRoomNights;
    return this;
  }

   /**
   * Sort on cancelled room nights
   * @return sortOnCancelledRoomNights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRoomNights() {
    return sortOnCancelledRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRoomNights(Boolean sortOnCancelledRoomNights) {
    this.sortOnCancelledRoomNights = sortOnCancelledRoomNights;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledMeetingRooms(Boolean sortOnCancelledMeetingRooms) {
    
    this.sortOnCancelledMeetingRooms = sortOnCancelledMeetingRooms;
    return this;
  }

   /**
   * Sort on cancelled meeting rooms
   * @return sortOnCancelledMeetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledMeetingRooms() {
    return sortOnCancelledMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledMeetingRooms(Boolean sortOnCancelledMeetingRooms) {
    this.sortOnCancelledMeetingRooms = sortOnCancelledMeetingRooms;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledMeetingRoomsRevenue(Boolean sortOnCancelledMeetingRoomsRevenue) {
    
    this.sortOnCancelledMeetingRoomsRevenue = sortOnCancelledMeetingRoomsRevenue;
    return this;
  }

   /**
   * Sort on cancelled meeting rooms revenue
   * @return sortOnCancelledMeetingRoomsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledMeetingRoomsRevenue() {
    return sortOnCancelledMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledMeetingRoomsRevenue(Boolean sortOnCancelledMeetingRoomsRevenue) {
    this.sortOnCancelledMeetingRoomsRevenue = sortOnCancelledMeetingRoomsRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledRestaurants(Boolean sortOnCancelledRestaurants) {
    
    this.sortOnCancelledRestaurants = sortOnCancelledRestaurants;
    return this;
  }

   /**
   * Sort on cancelled restaurants
   * @return sortOnCancelledRestaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRestaurants() {
    return sortOnCancelledRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRestaurants(Boolean sortOnCancelledRestaurants) {
    this.sortOnCancelledRestaurants = sortOnCancelledRestaurants;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledRestaurantsRevenue(Boolean sortOnCancelledRestaurantsRevenue) {
    
    this.sortOnCancelledRestaurantsRevenue = sortOnCancelledRestaurantsRevenue;
    return this;
  }

   /**
   * Sort on cancelled restaurants revenue
   * @return sortOnCancelledRestaurantsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRestaurantsRevenue() {
    return sortOnCancelledRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRestaurantsRevenue(Boolean sortOnCancelledRestaurantsRevenue) {
    this.sortOnCancelledRestaurantsRevenue = sortOnCancelledRestaurantsRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledSpas(Boolean sortOnCancelledSpas) {
    
    this.sortOnCancelledSpas = sortOnCancelledSpas;
    return this;
  }

   /**
   * Sort on cancelled spas
   * @return sortOnCancelledSpas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledSpas() {
    return sortOnCancelledSpas;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledSpas(Boolean sortOnCancelledSpas) {
    this.sortOnCancelledSpas = sortOnCancelledSpas;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledSpasRevenue(Boolean sortOnCancelledSpasRevenue) {
    
    this.sortOnCancelledSpasRevenue = sortOnCancelledSpasRevenue;
    return this;
  }

   /**
   * Sort on cancelled spas revenue
   * @return sortOnCancelledSpasRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledSpasRevenue() {
    return sortOnCancelledSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledSpasRevenue(Boolean sortOnCancelledSpasRevenue) {
    this.sortOnCancelledSpasRevenue = sortOnCancelledSpasRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledActivities(Boolean sortOnCancelledActivities) {
    
    this.sortOnCancelledActivities = sortOnCancelledActivities;
    return this;
  }

   /**
   * Sort on cancelled activities
   * @return sortOnCancelledActivities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledActivities() {
    return sortOnCancelledActivities;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledActivities(Boolean sortOnCancelledActivities) {
    this.sortOnCancelledActivities = sortOnCancelledActivities;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledActivitiesRevenue(Boolean sortOnCancelledActivitiesRevenue) {
    
    this.sortOnCancelledActivitiesRevenue = sortOnCancelledActivitiesRevenue;
    return this;
  }

   /**
   * Sort on cancelled activities revenue
   * @return sortOnCancelledActivitiesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledActivitiesRevenue() {
    return sortOnCancelledActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledActivitiesRevenue(Boolean sortOnCancelledActivitiesRevenue) {
    this.sortOnCancelledActivitiesRevenue = sortOnCancelledActivitiesRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledAttractions(Boolean sortOnCancelledAttractions) {
    
    this.sortOnCancelledAttractions = sortOnCancelledAttractions;
    return this;
  }

   /**
   * Sort on cancelled attractions
   * @return sortOnCancelledAttractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAttractions() {
    return sortOnCancelledAttractions;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAttractions(Boolean sortOnCancelledAttractions) {
    this.sortOnCancelledAttractions = sortOnCancelledAttractions;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledAttractionsRevenue(Boolean sortOnCancelledAttractionsRevenue) {
    
    this.sortOnCancelledAttractionsRevenue = sortOnCancelledAttractionsRevenue;
    return this;
  }

   /**
   * Sort on cancelled attractions revenue
   * @return sortOnCancelledAttractionsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAttractionsRevenue() {
    return sortOnCancelledAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAttractionsRevenue(Boolean sortOnCancelledAttractionsRevenue) {
    this.sortOnCancelledAttractionsRevenue = sortOnCancelledAttractionsRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledPlaces(Boolean sortOnCancelledPlaces) {
    
    this.sortOnCancelledPlaces = sortOnCancelledPlaces;
    return this;
  }

   /**
   * Sort on cancelled places
   * @return sortOnCancelledPlaces
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledPlaces() {
    return sortOnCancelledPlaces;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledPlaces(Boolean sortOnCancelledPlaces) {
    this.sortOnCancelledPlaces = sortOnCancelledPlaces;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledPlacesRevenue(Boolean sortOnCancelledPlacesRevenue) {
    
    this.sortOnCancelledPlacesRevenue = sortOnCancelledPlacesRevenue;
    return this;
  }

   /**
   * Sort on cancelled places revenue
   * @return sortOnCancelledPlacesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledPlacesRevenue() {
    return sortOnCancelledPlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledPlacesRevenue(Boolean sortOnCancelledPlacesRevenue) {
    this.sortOnCancelledPlacesRevenue = sortOnCancelledPlacesRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledTotalRoomRevenue(Boolean sortOnCancelledTotalRoomRevenue) {
    
    this.sortOnCancelledTotalRoomRevenue = sortOnCancelledTotalRoomRevenue;
    return this;
  }

   /**
   * Sort on cancelled total room revenue
   * @return sortOnCancelledTotalRoomRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalRoomRevenue() {
    return sortOnCancelledTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalRoomRevenue(Boolean sortOnCancelledTotalRoomRevenue) {
    this.sortOnCancelledTotalRoomRevenue = sortOnCancelledTotalRoomRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledTotalAncillariesRevenue(Boolean sortOnCancelledTotalAncillariesRevenue) {
    
    this.sortOnCancelledTotalAncillariesRevenue = sortOnCancelledTotalAncillariesRevenue;
    return this;
  }

   /**
   * Sort on cancelled aggregate total ancillaries revenue
   * @return sortOnCancelledTotalAncillariesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalAncillariesRevenue() {
    return sortOnCancelledTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalAncillariesRevenue(Boolean sortOnCancelledTotalAncillariesRevenue) {
    this.sortOnCancelledTotalAncillariesRevenue = sortOnCancelledTotalAncillariesRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledRoomTypeAncillaries(Boolean sortOnCancelledRoomTypeAncillaries) {
    
    this.sortOnCancelledRoomTypeAncillaries = sortOnCancelledRoomTypeAncillaries;
    return this;
  }

   /**
   * Sort on cancelled room type ancillaries
   * @return sortOnCancelledRoomTypeAncillaries
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRoomTypeAncillaries() {
    return sortOnCancelledRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRoomTypeAncillaries(Boolean sortOnCancelledRoomTypeAncillaries) {
    this.sortOnCancelledRoomTypeAncillaries = sortOnCancelledRoomTypeAncillaries;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledRoomTypeAncillariesRevenue(Boolean sortOnCancelledRoomTypeAncillariesRevenue) {
    
    this.sortOnCancelledRoomTypeAncillariesRevenue = sortOnCancelledRoomTypeAncillariesRevenue;
    return this;
  }

   /**
   * Sort on cancelled room type ancillaries revenue
   * @return sortOnCancelledRoomTypeAncillariesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledRoomTypeAncillariesRevenue() {
    return sortOnCancelledRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledRoomTypeAncillariesRevenue(Boolean sortOnCancelledRoomTypeAncillariesRevenue) {
    this.sortOnCancelledRoomTypeAncillariesRevenue = sortOnCancelledRoomTypeAncillariesRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledAddOns(Boolean sortOnCancelledAddOns) {
    
    this.sortOnCancelledAddOns = sortOnCancelledAddOns;
    return this;
  }

   /**
   * Sort on cancelled add-ons
   * @return sortOnCancelledAddOns
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAddOns() {
    return sortOnCancelledAddOns;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAddOns(Boolean sortOnCancelledAddOns) {
    this.sortOnCancelledAddOns = sortOnCancelledAddOns;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledAddonsRevenue(Boolean sortOnCancelledAddonsRevenue) {
    
    this.sortOnCancelledAddonsRevenue = sortOnCancelledAddonsRevenue;
    return this;
  }

   /**
   * Sort on cancelled add-o revenue
   * @return sortOnCancelledAddonsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledAddonsRevenue() {
    return sortOnCancelledAddonsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_ADDONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledAddonsRevenue(Boolean sortOnCancelledAddonsRevenue) {
    this.sortOnCancelledAddonsRevenue = sortOnCancelledAddonsRevenue;
  }


  public ChartRequestAuthenticatedEntity sortOnCancelledTotalNetRevenue(Boolean sortOnCancelledTotalNetRevenue) {
    
    this.sortOnCancelledTotalNetRevenue = sortOnCancelledTotalNetRevenue;
    return this;
  }

   /**
   * Sort on cancelled total net revenue
   * @return sortOnCancelledTotalNetRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSortOnCancelledTotalNetRevenue() {
    return sortOnCancelledTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_SORT_ON_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortOnCancelledTotalNetRevenue(Boolean sortOnCancelledTotalNetRevenue) {
    this.sortOnCancelledTotalNetRevenue = sortOnCancelledTotalNetRevenue;
  }


  public ChartRequestAuthenticatedEntity includePageVisits(Boolean includePageVisits) {
    
    this.includePageVisits = includePageVisits;
    return this;
  }

   /**
   * Include page visits
   * @return includePageVisits
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePageVisits() {
    return includePageVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PAGE_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePageVisits(Boolean includePageVisits) {
    this.includePageVisits = includePageVisits;
  }


  public ChartRequestAuthenticatedEntity includeMapMarkerVisits(Boolean includeMapMarkerVisits) {
    
    this.includeMapMarkerVisits = includeMapMarkerVisits;
    return this;
  }

   /**
   * Include map marker visits
   * @return includeMapMarkerVisits
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMapMarkerVisits() {
    return includeMapMarkerVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MAP_MARKER_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMapMarkerVisits(Boolean includeMapMarkerVisits) {
    this.includeMapMarkerVisits = includeMapMarkerVisits;
  }


  public ChartRequestAuthenticatedEntity includeCardVisits(Boolean includeCardVisits) {
    
    this.includeCardVisits = includeCardVisits;
    return this;
  }

   /**
   * Include card visits
   * @return includeCardVisits
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCardVisits() {
    return includeCardVisits;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CARD_VISITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCardVisits(Boolean includeCardVisits) {
    this.includeCardVisits = includeCardVisits;
  }


  public ChartRequestAuthenticatedEntity includeBookings(Boolean includeBookings) {
    
    this.includeBookings = includeBookings;
    return this;
  }

   /**
   * Include bookings
   * @return includeBookings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeBookings() {
    return includeBookings;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeBookings(Boolean includeBookings) {
    this.includeBookings = includeBookings;
  }


  public ChartRequestAuthenticatedEntity includeCancellations(Boolean includeCancellations) {
    
    this.includeCancellations = includeCancellations;
    return this;
  }

   /**
   * Include cancellations
   * @return includeCancellations
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancellations() {
    return includeCancellations;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancellations(Boolean includeCancellations) {
    this.includeCancellations = includeCancellations;
  }


  public ChartRequestAuthenticatedEntity includeRoomNights(Boolean includeRoomNights) {
    
    this.includeRoomNights = includeRoomNights;
    return this;
  }

   /**
   * Include room nights
   * @return includeRoomNights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRoomNights() {
    return includeRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRoomNights(Boolean includeRoomNights) {
    this.includeRoomNights = includeRoomNights;
  }


  public ChartRequestAuthenticatedEntity includeMeetingRooms(Boolean includeMeetingRooms) {
    
    this.includeMeetingRooms = includeMeetingRooms;
    return this;
  }

   /**
   * Include meeting rooms
   * @return includeMeetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMeetingRooms() {
    return includeMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMeetingRooms(Boolean includeMeetingRooms) {
    this.includeMeetingRooms = includeMeetingRooms;
  }


  public ChartRequestAuthenticatedEntity includeMeetingRoomsRevenue(Boolean includeMeetingRoomsRevenue) {
    
    this.includeMeetingRoomsRevenue = includeMeetingRoomsRevenue;
    return this;
  }

   /**
   * Include meeting rooms revenue
   * @return includeMeetingRoomsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeMeetingRoomsRevenue() {
    return includeMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMeetingRoomsRevenue(Boolean includeMeetingRoomsRevenue) {
    this.includeMeetingRoomsRevenue = includeMeetingRoomsRevenue;
  }


  public ChartRequestAuthenticatedEntity includeRestaurants(Boolean includeRestaurants) {
    
    this.includeRestaurants = includeRestaurants;
    return this;
  }

   /**
   * Include restaurants
   * @return includeRestaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRestaurants() {
    return includeRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRestaurants(Boolean includeRestaurants) {
    this.includeRestaurants = includeRestaurants;
  }


  public ChartRequestAuthenticatedEntity includeRestaurantsRevenue(Boolean includeRestaurantsRevenue) {
    
    this.includeRestaurantsRevenue = includeRestaurantsRevenue;
    return this;
  }

   /**
   * Include restaurants revenue
   * @return includeRestaurantsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRestaurantsRevenue() {
    return includeRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRestaurantsRevenue(Boolean includeRestaurantsRevenue) {
    this.includeRestaurantsRevenue = includeRestaurantsRevenue;
  }


  public ChartRequestAuthenticatedEntity includeSpas(Boolean includeSpas) {
    
    this.includeSpas = includeSpas;
    return this;
  }

   /**
   * Include spas
   * @return includeSpas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeSpas() {
    return includeSpas;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeSpas(Boolean includeSpas) {
    this.includeSpas = includeSpas;
  }


  public ChartRequestAuthenticatedEntity includeSpasRevenue(Boolean includeSpasRevenue) {
    
    this.includeSpasRevenue = includeSpasRevenue;
    return this;
  }

   /**
   * Include spas revenue
   * @return includeSpasRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeSpasRevenue() {
    return includeSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeSpasRevenue(Boolean includeSpasRevenue) {
    this.includeSpasRevenue = includeSpasRevenue;
  }


  public ChartRequestAuthenticatedEntity includeActivities(Boolean includeActivities) {
    
    this.includeActivities = includeActivities;
    return this;
  }

   /**
   * Include activities
   * @return includeActivities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeActivities() {
    return includeActivities;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeActivities(Boolean includeActivities) {
    this.includeActivities = includeActivities;
  }


  public ChartRequestAuthenticatedEntity includeActivitiesRevenue(Boolean includeActivitiesRevenue) {
    
    this.includeActivitiesRevenue = includeActivitiesRevenue;
    return this;
  }

   /**
   * Include activities revenue
   * @return includeActivitiesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeActivitiesRevenue() {
    return includeActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeActivitiesRevenue(Boolean includeActivitiesRevenue) {
    this.includeActivitiesRevenue = includeActivitiesRevenue;
  }


  public ChartRequestAuthenticatedEntity includeAttractions(Boolean includeAttractions) {
    
    this.includeAttractions = includeAttractions;
    return this;
  }

   /**
   * Include attractions
   * @return includeAttractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAttractions() {
    return includeAttractions;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAttractions(Boolean includeAttractions) {
    this.includeAttractions = includeAttractions;
  }


  public ChartRequestAuthenticatedEntity includeAttractionsRevenue(Boolean includeAttractionsRevenue) {
    
    this.includeAttractionsRevenue = includeAttractionsRevenue;
    return this;
  }

   /**
   * Include attractions revenue
   * @return includeAttractionsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAttractionsRevenue() {
    return includeAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAttractionsRevenue(Boolean includeAttractionsRevenue) {
    this.includeAttractionsRevenue = includeAttractionsRevenue;
  }


  public ChartRequestAuthenticatedEntity includePlaces(Boolean includePlaces) {
    
    this.includePlaces = includePlaces;
    return this;
  }

   /**
   * Include places
   * @return includePlaces
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePlaces() {
    return includePlaces;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePlaces(Boolean includePlaces) {
    this.includePlaces = includePlaces;
  }


  public ChartRequestAuthenticatedEntity includePlacesRevenue(Boolean includePlacesRevenue) {
    
    this.includePlacesRevenue = includePlacesRevenue;
    return this;
  }

   /**
   * Include places revenue
   * @return includePlacesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludePlacesRevenue() {
    return includePlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludePlacesRevenue(Boolean includePlacesRevenue) {
    this.includePlacesRevenue = includePlacesRevenue;
  }


  public ChartRequestAuthenticatedEntity includeRoomTypeAncillaries(Boolean includeRoomTypeAncillaries) {
    
    this.includeRoomTypeAncillaries = includeRoomTypeAncillaries;
    return this;
  }

   /**
   * Include room type ancillaries
   * @return includeRoomTypeAncillaries
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRoomTypeAncillaries() {
    return includeRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRoomTypeAncillaries(Boolean includeRoomTypeAncillaries) {
    this.includeRoomTypeAncillaries = includeRoomTypeAncillaries;
  }


  public ChartRequestAuthenticatedEntity includeRoomTypeAncillariesRevenue(Boolean includeRoomTypeAncillariesRevenue) {
    
    this.includeRoomTypeAncillariesRevenue = includeRoomTypeAncillariesRevenue;
    return this;
  }

   /**
   * Include packages revenue
   * @return includeRoomTypeAncillariesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeRoomTypeAncillariesRevenue() {
    return includeRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeRoomTypeAncillariesRevenue(Boolean includeRoomTypeAncillariesRevenue) {
    this.includeRoomTypeAncillariesRevenue = includeRoomTypeAncillariesRevenue;
  }


  public ChartRequestAuthenticatedEntity includeAddOns(Boolean includeAddOns) {
    
    this.includeAddOns = includeAddOns;
    return this;
  }

   /**
   * Include add-ons
   * @return includeAddOns
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAddOns() {
    return includeAddOns;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAddOns(Boolean includeAddOns) {
    this.includeAddOns = includeAddOns;
  }


  public ChartRequestAuthenticatedEntity includeAddOnsRevenue(Boolean includeAddOnsRevenue) {
    
    this.includeAddOnsRevenue = includeAddOnsRevenue;
    return this;
  }

   /**
   * Include add-ons revenue
   * @return includeAddOnsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAddOnsRevenue() {
    return includeAddOnsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAddOnsRevenue(Boolean includeAddOnsRevenue) {
    this.includeAddOnsRevenue = includeAddOnsRevenue;
  }


  public ChartRequestAuthenticatedEntity includeTotalRoomRevenue(Boolean includeTotalRoomRevenue) {
    
    this.includeTotalRoomRevenue = includeTotalRoomRevenue;
    return this;
  }

   /**
   * Include total room revenue
   * @return includeTotalRoomRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalRoomRevenue() {
    return includeTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalRoomRevenue(Boolean includeTotalRoomRevenue) {
    this.includeTotalRoomRevenue = includeTotalRoomRevenue;
  }


  public ChartRequestAuthenticatedEntity includeAverageRoomRate(Boolean includeAverageRoomRate) {
    
    this.includeAverageRoomRate = includeAverageRoomRate;
    return this;
  }

   /**
   * Include average room rate
   * @return includeAverageRoomRate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeAverageRoomRate() {
    return includeAverageRoomRate;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_AVERAGE_ROOM_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeAverageRoomRate(Boolean includeAverageRoomRate) {
    this.includeAverageRoomRate = includeAverageRoomRate;
  }


  public ChartRequestAuthenticatedEntity includeTotalAncillariesRevenue(Boolean includeTotalAncillariesRevenue) {
    
    this.includeTotalAncillariesRevenue = includeTotalAncillariesRevenue;
    return this;
  }

   /**
   * Include combined packages and add-os revenue
   * @return includeTotalAncillariesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalAncillariesRevenue() {
    return includeTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalAncillariesRevenue(Boolean includeTotalAncillariesRevenue) {
    this.includeTotalAncillariesRevenue = includeTotalAncillariesRevenue;
  }


  public ChartRequestAuthenticatedEntity includeTotalNetRevenue(Boolean includeTotalNetRevenue) {
    
    this.includeTotalNetRevenue = includeTotalNetRevenue;
    return this;
  }

   /**
   * Include total net revenue
   * @return includeTotalNetRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeTotalNetRevenue() {
    return includeTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeTotalNetRevenue(Boolean includeTotalNetRevenue) {
    this.includeTotalNetRevenue = includeTotalNetRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledRoomNights(Boolean includeCancelledRoomNights) {
    
    this.includeCancelledRoomNights = includeCancelledRoomNights;
    return this;
  }

   /**
   * Include cancelled room nights
   * @return includeCancelledRoomNights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRoomNights() {
    return includeCancelledRoomNights;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRoomNights(Boolean includeCancelledRoomNights) {
    this.includeCancelledRoomNights = includeCancelledRoomNights;
  }


  public ChartRequestAuthenticatedEntity includeCancelledMeetingRooms(Boolean includeCancelledMeetingRooms) {
    
    this.includeCancelledMeetingRooms = includeCancelledMeetingRooms;
    return this;
  }

   /**
   * Include cancelled meeting rooms
   * @return includeCancelledMeetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledMeetingRooms() {
    return includeCancelledMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledMeetingRooms(Boolean includeCancelledMeetingRooms) {
    this.includeCancelledMeetingRooms = includeCancelledMeetingRooms;
  }


  public ChartRequestAuthenticatedEntity includeCancelledMeetingRoomsRevenue(Boolean includeCancelledMeetingRoomsRevenue) {
    
    this.includeCancelledMeetingRoomsRevenue = includeCancelledMeetingRoomsRevenue;
    return this;
  }

   /**
   * Include cancelled meeting rooms revenue
   * @return includeCancelledMeetingRoomsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledMeetingRoomsRevenue() {
    return includeCancelledMeetingRoomsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_MEETING_ROOMS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledMeetingRoomsRevenue(Boolean includeCancelledMeetingRoomsRevenue) {
    this.includeCancelledMeetingRoomsRevenue = includeCancelledMeetingRoomsRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledRestaurants(Boolean includeCancelledRestaurants) {
    
    this.includeCancelledRestaurants = includeCancelledRestaurants;
    return this;
  }

   /**
   * Include cancelled restaurants
   * @return includeCancelledRestaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRestaurants() {
    return includeCancelledRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRestaurants(Boolean includeCancelledRestaurants) {
    this.includeCancelledRestaurants = includeCancelledRestaurants;
  }


  public ChartRequestAuthenticatedEntity includeCancelledRestaurantsRevenue(Boolean includeCancelledRestaurantsRevenue) {
    
    this.includeCancelledRestaurantsRevenue = includeCancelledRestaurantsRevenue;
    return this;
  }

   /**
   * Include cancelled restaurants revenue
   * @return includeCancelledRestaurantsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRestaurantsRevenue() {
    return includeCancelledRestaurantsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_RESTAURANTS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRestaurantsRevenue(Boolean includeCancelledRestaurantsRevenue) {
    this.includeCancelledRestaurantsRevenue = includeCancelledRestaurantsRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledSpas(Boolean includeCancelledSpas) {
    
    this.includeCancelledSpas = includeCancelledSpas;
    return this;
  }

   /**
   * Include cancelled spas
   * @return includeCancelledSpas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledSpas() {
    return includeCancelledSpas;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledSpas(Boolean includeCancelledSpas) {
    this.includeCancelledSpas = includeCancelledSpas;
  }


  public ChartRequestAuthenticatedEntity includeCancelledSpasRevenue(Boolean includeCancelledSpasRevenue) {
    
    this.includeCancelledSpasRevenue = includeCancelledSpasRevenue;
    return this;
  }

   /**
   * Include cancelled spas revenue
   * @return includeCancelledSpasRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledSpasRevenue() {
    return includeCancelledSpasRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_SPAS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledSpasRevenue(Boolean includeCancelledSpasRevenue) {
    this.includeCancelledSpasRevenue = includeCancelledSpasRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledActivities(Boolean includeCancelledActivities) {
    
    this.includeCancelledActivities = includeCancelledActivities;
    return this;
  }

   /**
   * Include cancelled activities
   * @return includeCancelledActivities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledActivities() {
    return includeCancelledActivities;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledActivities(Boolean includeCancelledActivities) {
    this.includeCancelledActivities = includeCancelledActivities;
  }


  public ChartRequestAuthenticatedEntity includeCancelledActivitiesRevenue(Boolean includeCancelledActivitiesRevenue) {
    
    this.includeCancelledActivitiesRevenue = includeCancelledActivitiesRevenue;
    return this;
  }

   /**
   * Include cancelled activities revenue
   * @return includeCancelledActivitiesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledActivitiesRevenue() {
    return includeCancelledActivitiesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ACTIVITIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledActivitiesRevenue(Boolean includeCancelledActivitiesRevenue) {
    this.includeCancelledActivitiesRevenue = includeCancelledActivitiesRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledAttractions(Boolean includeCancelledAttractions) {
    
    this.includeCancelledAttractions = includeCancelledAttractions;
    return this;
  }

   /**
   * Include cancelled attractions
   * @return includeCancelledAttractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAttractions() {
    return includeCancelledAttractions;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAttractions(Boolean includeCancelledAttractions) {
    this.includeCancelledAttractions = includeCancelledAttractions;
  }


  public ChartRequestAuthenticatedEntity includeCancelledAttractionsRevenue(Boolean includeCancelledAttractionsRevenue) {
    
    this.includeCancelledAttractionsRevenue = includeCancelledAttractionsRevenue;
    return this;
  }

   /**
   * Include cancelled attractions revenue
   * @return includeCancelledAttractionsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAttractionsRevenue() {
    return includeCancelledAttractionsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ATTRACTIONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAttractionsRevenue(Boolean includeCancelledAttractionsRevenue) {
    this.includeCancelledAttractionsRevenue = includeCancelledAttractionsRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledPlaces(Boolean includeCancelledPlaces) {
    
    this.includeCancelledPlaces = includeCancelledPlaces;
    return this;
  }

   /**
   * Include cancelled places
   * @return includeCancelledPlaces
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledPlaces() {
    return includeCancelledPlaces;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledPlaces(Boolean includeCancelledPlaces) {
    this.includeCancelledPlaces = includeCancelledPlaces;
  }


  public ChartRequestAuthenticatedEntity includeCancelledPlacesRevenue(Boolean includeCancelledPlacesRevenue) {
    
    this.includeCancelledPlacesRevenue = includeCancelledPlacesRevenue;
    return this;
  }

   /**
   * Include cancelled places revenue
   * @return includeCancelledPlacesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledPlacesRevenue() {
    return includeCancelledPlacesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_PLACES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledPlacesRevenue(Boolean includeCancelledPlacesRevenue) {
    this.includeCancelledPlacesRevenue = includeCancelledPlacesRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledRoomTypeAncillaries(Boolean includeCancelledRoomTypeAncillaries) {
    
    this.includeCancelledRoomTypeAncillaries = includeCancelledRoomTypeAncillaries;
    return this;
  }

   /**
   * Include cancelled packages
   * @return includeCancelledRoomTypeAncillaries
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRoomTypeAncillaries() {
    return includeCancelledRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRoomTypeAncillaries(Boolean includeCancelledRoomTypeAncillaries) {
    this.includeCancelledRoomTypeAncillaries = includeCancelledRoomTypeAncillaries;
  }


  public ChartRequestAuthenticatedEntity includeCancelledRoomTypeAncillariesRevenue(Boolean includeCancelledRoomTypeAncillariesRevenue) {
    
    this.includeCancelledRoomTypeAncillariesRevenue = includeCancelledRoomTypeAncillariesRevenue;
    return this;
  }

   /**
   * Include cancelled packages revenue
   * @return includeCancelledRoomTypeAncillariesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledRoomTypeAncillariesRevenue() {
    return includeCancelledRoomTypeAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ROOM_TYPE_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledRoomTypeAncillariesRevenue(Boolean includeCancelledRoomTypeAncillariesRevenue) {
    this.includeCancelledRoomTypeAncillariesRevenue = includeCancelledRoomTypeAncillariesRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledAddOns(Boolean includeCancelledAddOns) {
    
    this.includeCancelledAddOns = includeCancelledAddOns;
    return this;
  }

   /**
   * Include cancelled add-ons
   * @return includeCancelledAddOns
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAddOns() {
    return includeCancelledAddOns;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAddOns(Boolean includeCancelledAddOns) {
    this.includeCancelledAddOns = includeCancelledAddOns;
  }


  public ChartRequestAuthenticatedEntity includeCancelledAddOnsRevenue(Boolean includeCancelledAddOnsRevenue) {
    
    this.includeCancelledAddOnsRevenue = includeCancelledAddOnsRevenue;
    return this;
  }

   /**
   * Include cancelled add-ons revenue
   * @return includeCancelledAddOnsRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledAddOnsRevenue() {
    return includeCancelledAddOnsRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_ADD_ONS_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledAddOnsRevenue(Boolean includeCancelledAddOnsRevenue) {
    this.includeCancelledAddOnsRevenue = includeCancelledAddOnsRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledTotalRoomRevenue(Boolean includeCancelledTotalRoomRevenue) {
    
    this.includeCancelledTotalRoomRevenue = includeCancelledTotalRoomRevenue;
    return this;
  }

   /**
   * Include cancelled total room revenue
   * @return includeCancelledTotalRoomRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalRoomRevenue() {
    return includeCancelledTotalRoomRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ROOM_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalRoomRevenue(Boolean includeCancelledTotalRoomRevenue) {
    this.includeCancelledTotalRoomRevenue = includeCancelledTotalRoomRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledTotalAncillariesRevenue(Boolean includeCancelledTotalAncillariesRevenue) {
    
    this.includeCancelledTotalAncillariesRevenue = includeCancelledTotalAncillariesRevenue;
    return this;
  }

   /**
   * Include combined cancelled package and add-on revenue
   * @return includeCancelledTotalAncillariesRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalAncillariesRevenue() {
    return includeCancelledTotalAncillariesRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_ANCILLARIES_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalAncillariesRevenue(Boolean includeCancelledTotalAncillariesRevenue) {
    this.includeCancelledTotalAncillariesRevenue = includeCancelledTotalAncillariesRevenue;
  }


  public ChartRequestAuthenticatedEntity includeCancelledTotalNetRevenue(Boolean includeCancelledTotalNetRevenue) {
    
    this.includeCancelledTotalNetRevenue = includeCancelledTotalNetRevenue;
    return this;
  }

   /**
   * Include cancelled total net revenue
   * @return includeCancelledTotalNetRevenue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludeCancelledTotalNetRevenue() {
    return includeCancelledTotalNetRevenue;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_CANCELLED_TOTAL_NET_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeCancelledTotalNetRevenue(Boolean includeCancelledTotalNetRevenue) {
    this.includeCancelledTotalNetRevenue = includeCancelledTotalNetRevenue;
  }


  public ChartRequestAuthenticatedEntity groupOnChannelSubType(Boolean groupOnChannelSubType) {
    
    this.groupOnChannelSubType = groupOnChannelSubType;
    return this;
  }

   /**
   * Group on  channel sub type
   * @return groupOnChannelSubType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnChannelSubType() {
    return groupOnChannelSubType;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CHANNEL_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnChannelSubType(Boolean groupOnChannelSubType) {
    this.groupOnChannelSubType = groupOnChannelSubType;
  }


  public ChartRequestAuthenticatedEntity groupOnOwnerIdentifier(Boolean groupOnOwnerIdentifier) {
    
    this.groupOnOwnerIdentifier = groupOnOwnerIdentifier;
    return this;
  }

   /**
   * Group on owner identifier
   * @return groupOnOwnerIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnOwnerIdentifier() {
    return groupOnOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnOwnerIdentifier(Boolean groupOnOwnerIdentifier) {
    this.groupOnOwnerIdentifier = groupOnOwnerIdentifier;
  }


  public ChartRequestAuthenticatedEntity groupOnEngineIdentifier(Boolean groupOnEngineIdentifier) {
    
    this.groupOnEngineIdentifier = groupOnEngineIdentifier;
    return this;
  }

   /**
   * Group on application identifier
   * @return groupOnEngineIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineIdentifier() {
    return groupOnEngineIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineIdentifier(Boolean groupOnEngineIdentifier) {
    this.groupOnEngineIdentifier = groupOnEngineIdentifier;
  }


  public ChartRequestAuthenticatedEntity groupOnEngineCountryGeoNameId(Boolean groupOnEngineCountryGeoNameId) {
    
    this.groupOnEngineCountryGeoNameId = groupOnEngineCountryGeoNameId;
    return this;
  }

   /**
   * Group on application country geoNameId
   * @return groupOnEngineCountryGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineCountryGeoNameId() {
    return groupOnEngineCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineCountryGeoNameId(Boolean groupOnEngineCountryGeoNameId) {
    this.groupOnEngineCountryGeoNameId = groupOnEngineCountryGeoNameId;
  }


  public ChartRequestAuthenticatedEntity groupOnEngineCityGeoNameId(Boolean groupOnEngineCityGeoNameId) {
    
    this.groupOnEngineCityGeoNameId = groupOnEngineCityGeoNameId;
    return this;
  }

   /**
   * Group on application city geoNameId
   * @return groupOnEngineCityGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineCityGeoNameId() {
    return groupOnEngineCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineCityGeoNameId(Boolean groupOnEngineCityGeoNameId) {
    this.groupOnEngineCityGeoNameId = groupOnEngineCityGeoNameId;
  }


  public ChartRequestAuthenticatedEntity groupOnEngineContinentCode(Boolean groupOnEngineContinentCode) {
    
    this.groupOnEngineContinentCode = groupOnEngineContinentCode;
    return this;
  }

   /**
   * Group on application continent code
   * @return groupOnEngineContinentCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineContinentCode() {
    return groupOnEngineContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineContinentCode(Boolean groupOnEngineContinentCode) {
    this.groupOnEngineContinentCode = groupOnEngineContinentCode;
  }


  public ChartRequestAuthenticatedEntity groupOnEngineConfigurationIdentifier(Boolean groupOnEngineConfigurationIdentifier) {
    
    this.groupOnEngineConfigurationIdentifier = groupOnEngineConfigurationIdentifier;
    return this;
  }

   /**
   * Group on customization identifier
   * @return groupOnEngineConfigurationIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnEngineConfigurationIdentifier() {
    return groupOnEngineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnEngineConfigurationIdentifier(Boolean groupOnEngineConfigurationIdentifier) {
    this.groupOnEngineConfigurationIdentifier = groupOnEngineConfigurationIdentifier;
  }


  public ChartRequestAuthenticatedEntity groupOnCountryGeoNameId(Boolean groupOnCountryGeoNameId) {
    
    this.groupOnCountryGeoNameId = groupOnCountryGeoNameId;
    return this;
  }

   /**
   * Group on country geoNameId
   * @return groupOnCountryGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnCountryGeoNameId() {
    return groupOnCountryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnCountryGeoNameId(Boolean groupOnCountryGeoNameId) {
    this.groupOnCountryGeoNameId = groupOnCountryGeoNameId;
  }


  public ChartRequestAuthenticatedEntity groupOnCityGeoNameId(Boolean groupOnCityGeoNameId) {
    
    this.groupOnCityGeoNameId = groupOnCityGeoNameId;
    return this;
  }

   /**
   * Group on city geoNameId
   * @return groupOnCityGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnCityGeoNameId() {
    return groupOnCityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnCityGeoNameId(Boolean groupOnCityGeoNameId) {
    this.groupOnCityGeoNameId = groupOnCityGeoNameId;
  }


  public ChartRequestAuthenticatedEntity groupOnContinentCode(Boolean groupOnContinentCode) {
    
    this.groupOnContinentCode = groupOnContinentCode;
    return this;
  }

   /**
   * Group on continent code
   * @return groupOnContinentCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnContinentCode() {
    return groupOnContinentCode;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnContinentCode(Boolean groupOnContinentCode) {
    this.groupOnContinentCode = groupOnContinentCode;
  }


  public ChartRequestAuthenticatedEntity groupOnHotelIdentifier(Boolean groupOnHotelIdentifier) {
    
    this.groupOnHotelIdentifier = groupOnHotelIdentifier;
    return this;
  }

   /**
   * Group on hotel identifier
   * @return groupOnHotelIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnHotelIdentifier() {
    return groupOnHotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnHotelIdentifier(Boolean groupOnHotelIdentifier) {
    this.groupOnHotelIdentifier = groupOnHotelIdentifier;
  }


  public ChartRequestAuthenticatedEntity groupOnUserIdentifier(Boolean groupOnUserIdentifier) {
    
    this.groupOnUserIdentifier = groupOnUserIdentifier;
    return this;
  }

   /**
   * Group on user identifier
   * @return groupOnUserIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getGroupOnUserIdentifier() {
    return groupOnUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ON_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupOnUserIdentifier(Boolean groupOnUserIdentifier) {
    this.groupOnUserIdentifier = groupOnUserIdentifier;
  }


  public ChartRequestAuthenticatedEntity currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code
   * @return currencyCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChartRequestAuthenticatedEntity chartRequestAuthenticatedEntity = (ChartRequestAuthenticatedEntity) o;
    return Objects.equals(this.series, chartRequestAuthenticatedEntity.series) &&
        Objects.equals(this.timeSeriesUnits, chartRequestAuthenticatedEntity.timeSeriesUnits) &&
        Objects.equals(this.startDate, chartRequestAuthenticatedEntity.startDate) &&
        Objects.equals(this.endDate, chartRequestAuthenticatedEntity.endDate) &&
        Objects.equals(this.filterOnHotelIdentifier, chartRequestAuthenticatedEntity.filterOnHotelIdentifier) &&
        Objects.equals(this.filterOnChannelSubType, chartRequestAuthenticatedEntity.filterOnChannelSubType) &&
        Objects.equals(this.filterOnOwnerIdentifier, chartRequestAuthenticatedEntity.filterOnOwnerIdentifier) &&
        Objects.equals(this.filterOnEngineCountryGeoNameId, chartRequestAuthenticatedEntity.filterOnEngineCountryGeoNameId) &&
        Objects.equals(this.filterOnEngineCityGeoNameId, chartRequestAuthenticatedEntity.filterOnEngineCityGeoNameId) &&
        Objects.equals(this.filterOnEngineContinentCode, chartRequestAuthenticatedEntity.filterOnEngineContinentCode) &&
        Objects.equals(this.filterOnEngineConfigurationIdentifier, chartRequestAuthenticatedEntity.filterOnEngineConfigurationIdentifier) &&
        Objects.equals(this.filterOnCountryGeoNameId, chartRequestAuthenticatedEntity.filterOnCountryGeoNameId) &&
        Objects.equals(this.filterOnCityGeoNameId, chartRequestAuthenticatedEntity.filterOnCityGeoNameId) &&
        Objects.equals(this.filterOnContinentCode, chartRequestAuthenticatedEntity.filterOnContinentCode) &&
        Objects.equals(this.filterOnUserIdentifier, chartRequestAuthenticatedEntity.filterOnUserIdentifier) &&
        Objects.equals(this.sortOnPageVisits, chartRequestAuthenticatedEntity.sortOnPageVisits) &&
        Objects.equals(this.sortOnMapMarkerVisits, chartRequestAuthenticatedEntity.sortOnMapMarkerVisits) &&
        Objects.equals(this.sortOnCardVisits, chartRequestAuthenticatedEntity.sortOnCardVisits) &&
        Objects.equals(this.sortOnBookings, chartRequestAuthenticatedEntity.sortOnBookings) &&
        Objects.equals(this.sortOnCancellations, chartRequestAuthenticatedEntity.sortOnCancellations) &&
        Objects.equals(this.sortOnRoomNights, chartRequestAuthenticatedEntity.sortOnRoomNights) &&
        Objects.equals(this.sortOnMeetingRooms, chartRequestAuthenticatedEntity.sortOnMeetingRooms) &&
        Objects.equals(this.sortOnMeetingRoomsRevenue, chartRequestAuthenticatedEntity.sortOnMeetingRoomsRevenue) &&
        Objects.equals(this.sortOnRestaurants, chartRequestAuthenticatedEntity.sortOnRestaurants) &&
        Objects.equals(this.sortOnRestaurantsRevenue, chartRequestAuthenticatedEntity.sortOnRestaurantsRevenue) &&
        Objects.equals(this.sortOnSpas, chartRequestAuthenticatedEntity.sortOnSpas) &&
        Objects.equals(this.sortOnSpasRevenue, chartRequestAuthenticatedEntity.sortOnSpasRevenue) &&
        Objects.equals(this.sortOnActivities, chartRequestAuthenticatedEntity.sortOnActivities) &&
        Objects.equals(this.sortOnActivitiesRevenue, chartRequestAuthenticatedEntity.sortOnActivitiesRevenue) &&
        Objects.equals(this.sortOnAttractions, chartRequestAuthenticatedEntity.sortOnAttractions) &&
        Objects.equals(this.sortOnAttractionsRevenue, chartRequestAuthenticatedEntity.sortOnAttractionsRevenue) &&
        Objects.equals(this.sortOnPlaces, chartRequestAuthenticatedEntity.sortOnPlaces) &&
        Objects.equals(this.sortOnPlacesRevenue, chartRequestAuthenticatedEntity.sortOnPlacesRevenue) &&
        Objects.equals(this.sortOnRoomTypeAncillaries, chartRequestAuthenticatedEntity.sortOnRoomTypeAncillaries) &&
        Objects.equals(this.sortOnRoomTypeAncillariesRevenue, chartRequestAuthenticatedEntity.sortOnRoomTypeAncillariesRevenue) &&
        Objects.equals(this.sortOnAddOns, chartRequestAuthenticatedEntity.sortOnAddOns) &&
        Objects.equals(this.sortOnAddonsRevenue, chartRequestAuthenticatedEntity.sortOnAddonsRevenue) &&
        Objects.equals(this.sortOnTotalRoomRevenue, chartRequestAuthenticatedEntity.sortOnTotalRoomRevenue) &&
        Objects.equals(this.sortOnTotalAncillariesRevenue, chartRequestAuthenticatedEntity.sortOnTotalAncillariesRevenue) &&
        Objects.equals(this.sortOnTotalNetRevenue, chartRequestAuthenticatedEntity.sortOnTotalNetRevenue) &&
        Objects.equals(this.sortOnCancelledRoomNights, chartRequestAuthenticatedEntity.sortOnCancelledRoomNights) &&
        Objects.equals(this.sortOnCancelledMeetingRooms, chartRequestAuthenticatedEntity.sortOnCancelledMeetingRooms) &&
        Objects.equals(this.sortOnCancelledMeetingRoomsRevenue, chartRequestAuthenticatedEntity.sortOnCancelledMeetingRoomsRevenue) &&
        Objects.equals(this.sortOnCancelledRestaurants, chartRequestAuthenticatedEntity.sortOnCancelledRestaurants) &&
        Objects.equals(this.sortOnCancelledRestaurantsRevenue, chartRequestAuthenticatedEntity.sortOnCancelledRestaurantsRevenue) &&
        Objects.equals(this.sortOnCancelledSpas, chartRequestAuthenticatedEntity.sortOnCancelledSpas) &&
        Objects.equals(this.sortOnCancelledSpasRevenue, chartRequestAuthenticatedEntity.sortOnCancelledSpasRevenue) &&
        Objects.equals(this.sortOnCancelledActivities, chartRequestAuthenticatedEntity.sortOnCancelledActivities) &&
        Objects.equals(this.sortOnCancelledActivitiesRevenue, chartRequestAuthenticatedEntity.sortOnCancelledActivitiesRevenue) &&
        Objects.equals(this.sortOnCancelledAttractions, chartRequestAuthenticatedEntity.sortOnCancelledAttractions) &&
        Objects.equals(this.sortOnCancelledAttractionsRevenue, chartRequestAuthenticatedEntity.sortOnCancelledAttractionsRevenue) &&
        Objects.equals(this.sortOnCancelledPlaces, chartRequestAuthenticatedEntity.sortOnCancelledPlaces) &&
        Objects.equals(this.sortOnCancelledPlacesRevenue, chartRequestAuthenticatedEntity.sortOnCancelledPlacesRevenue) &&
        Objects.equals(this.sortOnCancelledTotalRoomRevenue, chartRequestAuthenticatedEntity.sortOnCancelledTotalRoomRevenue) &&
        Objects.equals(this.sortOnCancelledTotalAncillariesRevenue, chartRequestAuthenticatedEntity.sortOnCancelledTotalAncillariesRevenue) &&
        Objects.equals(this.sortOnCancelledRoomTypeAncillaries, chartRequestAuthenticatedEntity.sortOnCancelledRoomTypeAncillaries) &&
        Objects.equals(this.sortOnCancelledRoomTypeAncillariesRevenue, chartRequestAuthenticatedEntity.sortOnCancelledRoomTypeAncillariesRevenue) &&
        Objects.equals(this.sortOnCancelledAddOns, chartRequestAuthenticatedEntity.sortOnCancelledAddOns) &&
        Objects.equals(this.sortOnCancelledAddonsRevenue, chartRequestAuthenticatedEntity.sortOnCancelledAddonsRevenue) &&
        Objects.equals(this.sortOnCancelledTotalNetRevenue, chartRequestAuthenticatedEntity.sortOnCancelledTotalNetRevenue) &&
        Objects.equals(this.includePageVisits, chartRequestAuthenticatedEntity.includePageVisits) &&
        Objects.equals(this.includeMapMarkerVisits, chartRequestAuthenticatedEntity.includeMapMarkerVisits) &&
        Objects.equals(this.includeCardVisits, chartRequestAuthenticatedEntity.includeCardVisits) &&
        Objects.equals(this.includeBookings, chartRequestAuthenticatedEntity.includeBookings) &&
        Objects.equals(this.includeCancellations, chartRequestAuthenticatedEntity.includeCancellations) &&
        Objects.equals(this.includeRoomNights, chartRequestAuthenticatedEntity.includeRoomNights) &&
        Objects.equals(this.includeMeetingRooms, chartRequestAuthenticatedEntity.includeMeetingRooms) &&
        Objects.equals(this.includeMeetingRoomsRevenue, chartRequestAuthenticatedEntity.includeMeetingRoomsRevenue) &&
        Objects.equals(this.includeRestaurants, chartRequestAuthenticatedEntity.includeRestaurants) &&
        Objects.equals(this.includeRestaurantsRevenue, chartRequestAuthenticatedEntity.includeRestaurantsRevenue) &&
        Objects.equals(this.includeSpas, chartRequestAuthenticatedEntity.includeSpas) &&
        Objects.equals(this.includeSpasRevenue, chartRequestAuthenticatedEntity.includeSpasRevenue) &&
        Objects.equals(this.includeActivities, chartRequestAuthenticatedEntity.includeActivities) &&
        Objects.equals(this.includeActivitiesRevenue, chartRequestAuthenticatedEntity.includeActivitiesRevenue) &&
        Objects.equals(this.includeAttractions, chartRequestAuthenticatedEntity.includeAttractions) &&
        Objects.equals(this.includeAttractionsRevenue, chartRequestAuthenticatedEntity.includeAttractionsRevenue) &&
        Objects.equals(this.includePlaces, chartRequestAuthenticatedEntity.includePlaces) &&
        Objects.equals(this.includePlacesRevenue, chartRequestAuthenticatedEntity.includePlacesRevenue) &&
        Objects.equals(this.includeRoomTypeAncillaries, chartRequestAuthenticatedEntity.includeRoomTypeAncillaries) &&
        Objects.equals(this.includeRoomTypeAncillariesRevenue, chartRequestAuthenticatedEntity.includeRoomTypeAncillariesRevenue) &&
        Objects.equals(this.includeAddOns, chartRequestAuthenticatedEntity.includeAddOns) &&
        Objects.equals(this.includeAddOnsRevenue, chartRequestAuthenticatedEntity.includeAddOnsRevenue) &&
        Objects.equals(this.includeTotalRoomRevenue, chartRequestAuthenticatedEntity.includeTotalRoomRevenue) &&
        Objects.equals(this.includeAverageRoomRate, chartRequestAuthenticatedEntity.includeAverageRoomRate) &&
        Objects.equals(this.includeTotalAncillariesRevenue, chartRequestAuthenticatedEntity.includeTotalAncillariesRevenue) &&
        Objects.equals(this.includeTotalNetRevenue, chartRequestAuthenticatedEntity.includeTotalNetRevenue) &&
        Objects.equals(this.includeCancelledRoomNights, chartRequestAuthenticatedEntity.includeCancelledRoomNights) &&
        Objects.equals(this.includeCancelledMeetingRooms, chartRequestAuthenticatedEntity.includeCancelledMeetingRooms) &&
        Objects.equals(this.includeCancelledMeetingRoomsRevenue, chartRequestAuthenticatedEntity.includeCancelledMeetingRoomsRevenue) &&
        Objects.equals(this.includeCancelledRestaurants, chartRequestAuthenticatedEntity.includeCancelledRestaurants) &&
        Objects.equals(this.includeCancelledRestaurantsRevenue, chartRequestAuthenticatedEntity.includeCancelledRestaurantsRevenue) &&
        Objects.equals(this.includeCancelledSpas, chartRequestAuthenticatedEntity.includeCancelledSpas) &&
        Objects.equals(this.includeCancelledSpasRevenue, chartRequestAuthenticatedEntity.includeCancelledSpasRevenue) &&
        Objects.equals(this.includeCancelledActivities, chartRequestAuthenticatedEntity.includeCancelledActivities) &&
        Objects.equals(this.includeCancelledActivitiesRevenue, chartRequestAuthenticatedEntity.includeCancelledActivitiesRevenue) &&
        Objects.equals(this.includeCancelledAttractions, chartRequestAuthenticatedEntity.includeCancelledAttractions) &&
        Objects.equals(this.includeCancelledAttractionsRevenue, chartRequestAuthenticatedEntity.includeCancelledAttractionsRevenue) &&
        Objects.equals(this.includeCancelledPlaces, chartRequestAuthenticatedEntity.includeCancelledPlaces) &&
        Objects.equals(this.includeCancelledPlacesRevenue, chartRequestAuthenticatedEntity.includeCancelledPlacesRevenue) &&
        Objects.equals(this.includeCancelledRoomTypeAncillaries, chartRequestAuthenticatedEntity.includeCancelledRoomTypeAncillaries) &&
        Objects.equals(this.includeCancelledRoomTypeAncillariesRevenue, chartRequestAuthenticatedEntity.includeCancelledRoomTypeAncillariesRevenue) &&
        Objects.equals(this.includeCancelledAddOns, chartRequestAuthenticatedEntity.includeCancelledAddOns) &&
        Objects.equals(this.includeCancelledAddOnsRevenue, chartRequestAuthenticatedEntity.includeCancelledAddOnsRevenue) &&
        Objects.equals(this.includeCancelledTotalRoomRevenue, chartRequestAuthenticatedEntity.includeCancelledTotalRoomRevenue) &&
        Objects.equals(this.includeCancelledTotalAncillariesRevenue, chartRequestAuthenticatedEntity.includeCancelledTotalAncillariesRevenue) &&
        Objects.equals(this.includeCancelledTotalNetRevenue, chartRequestAuthenticatedEntity.includeCancelledTotalNetRevenue) &&
        Objects.equals(this.groupOnChannelSubType, chartRequestAuthenticatedEntity.groupOnChannelSubType) &&
        Objects.equals(this.groupOnOwnerIdentifier, chartRequestAuthenticatedEntity.groupOnOwnerIdentifier) &&
        Objects.equals(this.groupOnEngineIdentifier, chartRequestAuthenticatedEntity.groupOnEngineIdentifier) &&
        Objects.equals(this.groupOnEngineCountryGeoNameId, chartRequestAuthenticatedEntity.groupOnEngineCountryGeoNameId) &&
        Objects.equals(this.groupOnEngineCityGeoNameId, chartRequestAuthenticatedEntity.groupOnEngineCityGeoNameId) &&
        Objects.equals(this.groupOnEngineContinentCode, chartRequestAuthenticatedEntity.groupOnEngineContinentCode) &&
        Objects.equals(this.groupOnEngineConfigurationIdentifier, chartRequestAuthenticatedEntity.groupOnEngineConfigurationIdentifier) &&
        Objects.equals(this.groupOnCountryGeoNameId, chartRequestAuthenticatedEntity.groupOnCountryGeoNameId) &&
        Objects.equals(this.groupOnCityGeoNameId, chartRequestAuthenticatedEntity.groupOnCityGeoNameId) &&
        Objects.equals(this.groupOnContinentCode, chartRequestAuthenticatedEntity.groupOnContinentCode) &&
        Objects.equals(this.groupOnHotelIdentifier, chartRequestAuthenticatedEntity.groupOnHotelIdentifier) &&
        Objects.equals(this.groupOnUserIdentifier, chartRequestAuthenticatedEntity.groupOnUserIdentifier) &&
        Objects.equals(this.currencyCode, chartRequestAuthenticatedEntity.currencyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(series, timeSeriesUnits, startDate, endDate, filterOnHotelIdentifier, filterOnChannelSubType, filterOnOwnerIdentifier, filterOnEngineCountryGeoNameId, filterOnEngineCityGeoNameId, filterOnEngineContinentCode, filterOnEngineConfigurationIdentifier, filterOnCountryGeoNameId, filterOnCityGeoNameId, filterOnContinentCode, filterOnUserIdentifier, sortOnPageVisits, sortOnMapMarkerVisits, sortOnCardVisits, sortOnBookings, sortOnCancellations, sortOnRoomNights, sortOnMeetingRooms, sortOnMeetingRoomsRevenue, sortOnRestaurants, sortOnRestaurantsRevenue, sortOnSpas, sortOnSpasRevenue, sortOnActivities, sortOnActivitiesRevenue, sortOnAttractions, sortOnAttractionsRevenue, sortOnPlaces, sortOnPlacesRevenue, sortOnRoomTypeAncillaries, sortOnRoomTypeAncillariesRevenue, sortOnAddOns, sortOnAddonsRevenue, sortOnTotalRoomRevenue, sortOnTotalAncillariesRevenue, sortOnTotalNetRevenue, sortOnCancelledRoomNights, sortOnCancelledMeetingRooms, sortOnCancelledMeetingRoomsRevenue, sortOnCancelledRestaurants, sortOnCancelledRestaurantsRevenue, sortOnCancelledSpas, sortOnCancelledSpasRevenue, sortOnCancelledActivities, sortOnCancelledActivitiesRevenue, sortOnCancelledAttractions, sortOnCancelledAttractionsRevenue, sortOnCancelledPlaces, sortOnCancelledPlacesRevenue, sortOnCancelledTotalRoomRevenue, sortOnCancelledTotalAncillariesRevenue, sortOnCancelledRoomTypeAncillaries, sortOnCancelledRoomTypeAncillariesRevenue, sortOnCancelledAddOns, sortOnCancelledAddonsRevenue, sortOnCancelledTotalNetRevenue, includePageVisits, includeMapMarkerVisits, includeCardVisits, includeBookings, includeCancellations, includeRoomNights, includeMeetingRooms, includeMeetingRoomsRevenue, includeRestaurants, includeRestaurantsRevenue, includeSpas, includeSpasRevenue, includeActivities, includeActivitiesRevenue, includeAttractions, includeAttractionsRevenue, includePlaces, includePlacesRevenue, includeRoomTypeAncillaries, includeRoomTypeAncillariesRevenue, includeAddOns, includeAddOnsRevenue, includeTotalRoomRevenue, includeAverageRoomRate, includeTotalAncillariesRevenue, includeTotalNetRevenue, includeCancelledRoomNights, includeCancelledMeetingRooms, includeCancelledMeetingRoomsRevenue, includeCancelledRestaurants, includeCancelledRestaurantsRevenue, includeCancelledSpas, includeCancelledSpasRevenue, includeCancelledActivities, includeCancelledActivitiesRevenue, includeCancelledAttractions, includeCancelledAttractionsRevenue, includeCancelledPlaces, includeCancelledPlacesRevenue, includeCancelledRoomTypeAncillaries, includeCancelledRoomTypeAncillariesRevenue, includeCancelledAddOns, includeCancelledAddOnsRevenue, includeCancelledTotalRoomRevenue, includeCancelledTotalAncillariesRevenue, includeCancelledTotalNetRevenue, groupOnChannelSubType, groupOnOwnerIdentifier, groupOnEngineIdentifier, groupOnEngineCountryGeoNameId, groupOnEngineCityGeoNameId, groupOnEngineContinentCode, groupOnEngineConfigurationIdentifier, groupOnCountryGeoNameId, groupOnCityGeoNameId, groupOnContinentCode, groupOnHotelIdentifier, groupOnUserIdentifier, currencyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChartRequestAuthenticatedEntity {\n");
    sb.append("    series: ").append(toIndentedString(series)).append("\n");
    sb.append("    timeSeriesUnits: ").append(toIndentedString(timeSeriesUnits)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    filterOnHotelIdentifier: ").append(toIndentedString(filterOnHotelIdentifier)).append("\n");
    sb.append("    filterOnChannelSubType: ").append(toIndentedString(filterOnChannelSubType)).append("\n");
    sb.append("    filterOnOwnerIdentifier: ").append(toIndentedString(filterOnOwnerIdentifier)).append("\n");
    sb.append("    filterOnEngineCountryGeoNameId: ").append(toIndentedString(filterOnEngineCountryGeoNameId)).append("\n");
    sb.append("    filterOnEngineCityGeoNameId: ").append(toIndentedString(filterOnEngineCityGeoNameId)).append("\n");
    sb.append("    filterOnEngineContinentCode: ").append(toIndentedString(filterOnEngineContinentCode)).append("\n");
    sb.append("    filterOnEngineConfigurationIdentifier: ").append(toIndentedString(filterOnEngineConfigurationIdentifier)).append("\n");
    sb.append("    filterOnCountryGeoNameId: ").append(toIndentedString(filterOnCountryGeoNameId)).append("\n");
    sb.append("    filterOnCityGeoNameId: ").append(toIndentedString(filterOnCityGeoNameId)).append("\n");
    sb.append("    filterOnContinentCode: ").append(toIndentedString(filterOnContinentCode)).append("\n");
    sb.append("    filterOnUserIdentifier: ").append(toIndentedString(filterOnUserIdentifier)).append("\n");
    sb.append("    sortOnPageVisits: ").append(toIndentedString(sortOnPageVisits)).append("\n");
    sb.append("    sortOnMapMarkerVisits: ").append(toIndentedString(sortOnMapMarkerVisits)).append("\n");
    sb.append("    sortOnCardVisits: ").append(toIndentedString(sortOnCardVisits)).append("\n");
    sb.append("    sortOnBookings: ").append(toIndentedString(sortOnBookings)).append("\n");
    sb.append("    sortOnCancellations: ").append(toIndentedString(sortOnCancellations)).append("\n");
    sb.append("    sortOnRoomNights: ").append(toIndentedString(sortOnRoomNights)).append("\n");
    sb.append("    sortOnMeetingRooms: ").append(toIndentedString(sortOnMeetingRooms)).append("\n");
    sb.append("    sortOnMeetingRoomsRevenue: ").append(toIndentedString(sortOnMeetingRoomsRevenue)).append("\n");
    sb.append("    sortOnRestaurants: ").append(toIndentedString(sortOnRestaurants)).append("\n");
    sb.append("    sortOnRestaurantsRevenue: ").append(toIndentedString(sortOnRestaurantsRevenue)).append("\n");
    sb.append("    sortOnSpas: ").append(toIndentedString(sortOnSpas)).append("\n");
    sb.append("    sortOnSpasRevenue: ").append(toIndentedString(sortOnSpasRevenue)).append("\n");
    sb.append("    sortOnActivities: ").append(toIndentedString(sortOnActivities)).append("\n");
    sb.append("    sortOnActivitiesRevenue: ").append(toIndentedString(sortOnActivitiesRevenue)).append("\n");
    sb.append("    sortOnAttractions: ").append(toIndentedString(sortOnAttractions)).append("\n");
    sb.append("    sortOnAttractionsRevenue: ").append(toIndentedString(sortOnAttractionsRevenue)).append("\n");
    sb.append("    sortOnPlaces: ").append(toIndentedString(sortOnPlaces)).append("\n");
    sb.append("    sortOnPlacesRevenue: ").append(toIndentedString(sortOnPlacesRevenue)).append("\n");
    sb.append("    sortOnRoomTypeAncillaries: ").append(toIndentedString(sortOnRoomTypeAncillaries)).append("\n");
    sb.append("    sortOnRoomTypeAncillariesRevenue: ").append(toIndentedString(sortOnRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    sortOnAddOns: ").append(toIndentedString(sortOnAddOns)).append("\n");
    sb.append("    sortOnAddonsRevenue: ").append(toIndentedString(sortOnAddonsRevenue)).append("\n");
    sb.append("    sortOnTotalRoomRevenue: ").append(toIndentedString(sortOnTotalRoomRevenue)).append("\n");
    sb.append("    sortOnTotalAncillariesRevenue: ").append(toIndentedString(sortOnTotalAncillariesRevenue)).append("\n");
    sb.append("    sortOnTotalNetRevenue: ").append(toIndentedString(sortOnTotalNetRevenue)).append("\n");
    sb.append("    sortOnCancelledRoomNights: ").append(toIndentedString(sortOnCancelledRoomNights)).append("\n");
    sb.append("    sortOnCancelledMeetingRooms: ").append(toIndentedString(sortOnCancelledMeetingRooms)).append("\n");
    sb.append("    sortOnCancelledMeetingRoomsRevenue: ").append(toIndentedString(sortOnCancelledMeetingRoomsRevenue)).append("\n");
    sb.append("    sortOnCancelledRestaurants: ").append(toIndentedString(sortOnCancelledRestaurants)).append("\n");
    sb.append("    sortOnCancelledRestaurantsRevenue: ").append(toIndentedString(sortOnCancelledRestaurantsRevenue)).append("\n");
    sb.append("    sortOnCancelledSpas: ").append(toIndentedString(sortOnCancelledSpas)).append("\n");
    sb.append("    sortOnCancelledSpasRevenue: ").append(toIndentedString(sortOnCancelledSpasRevenue)).append("\n");
    sb.append("    sortOnCancelledActivities: ").append(toIndentedString(sortOnCancelledActivities)).append("\n");
    sb.append("    sortOnCancelledActivitiesRevenue: ").append(toIndentedString(sortOnCancelledActivitiesRevenue)).append("\n");
    sb.append("    sortOnCancelledAttractions: ").append(toIndentedString(sortOnCancelledAttractions)).append("\n");
    sb.append("    sortOnCancelledAttractionsRevenue: ").append(toIndentedString(sortOnCancelledAttractionsRevenue)).append("\n");
    sb.append("    sortOnCancelledPlaces: ").append(toIndentedString(sortOnCancelledPlaces)).append("\n");
    sb.append("    sortOnCancelledPlacesRevenue: ").append(toIndentedString(sortOnCancelledPlacesRevenue)).append("\n");
    sb.append("    sortOnCancelledTotalRoomRevenue: ").append(toIndentedString(sortOnCancelledTotalRoomRevenue)).append("\n");
    sb.append("    sortOnCancelledTotalAncillariesRevenue: ").append(toIndentedString(sortOnCancelledTotalAncillariesRevenue)).append("\n");
    sb.append("    sortOnCancelledRoomTypeAncillaries: ").append(toIndentedString(sortOnCancelledRoomTypeAncillaries)).append("\n");
    sb.append("    sortOnCancelledRoomTypeAncillariesRevenue: ").append(toIndentedString(sortOnCancelledRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    sortOnCancelledAddOns: ").append(toIndentedString(sortOnCancelledAddOns)).append("\n");
    sb.append("    sortOnCancelledAddonsRevenue: ").append(toIndentedString(sortOnCancelledAddonsRevenue)).append("\n");
    sb.append("    sortOnCancelledTotalNetRevenue: ").append(toIndentedString(sortOnCancelledTotalNetRevenue)).append("\n");
    sb.append("    includePageVisits: ").append(toIndentedString(includePageVisits)).append("\n");
    sb.append("    includeMapMarkerVisits: ").append(toIndentedString(includeMapMarkerVisits)).append("\n");
    sb.append("    includeCardVisits: ").append(toIndentedString(includeCardVisits)).append("\n");
    sb.append("    includeBookings: ").append(toIndentedString(includeBookings)).append("\n");
    sb.append("    includeCancellations: ").append(toIndentedString(includeCancellations)).append("\n");
    sb.append("    includeRoomNights: ").append(toIndentedString(includeRoomNights)).append("\n");
    sb.append("    includeMeetingRooms: ").append(toIndentedString(includeMeetingRooms)).append("\n");
    sb.append("    includeMeetingRoomsRevenue: ").append(toIndentedString(includeMeetingRoomsRevenue)).append("\n");
    sb.append("    includeRestaurants: ").append(toIndentedString(includeRestaurants)).append("\n");
    sb.append("    includeRestaurantsRevenue: ").append(toIndentedString(includeRestaurantsRevenue)).append("\n");
    sb.append("    includeSpas: ").append(toIndentedString(includeSpas)).append("\n");
    sb.append("    includeSpasRevenue: ").append(toIndentedString(includeSpasRevenue)).append("\n");
    sb.append("    includeActivities: ").append(toIndentedString(includeActivities)).append("\n");
    sb.append("    includeActivitiesRevenue: ").append(toIndentedString(includeActivitiesRevenue)).append("\n");
    sb.append("    includeAttractions: ").append(toIndentedString(includeAttractions)).append("\n");
    sb.append("    includeAttractionsRevenue: ").append(toIndentedString(includeAttractionsRevenue)).append("\n");
    sb.append("    includePlaces: ").append(toIndentedString(includePlaces)).append("\n");
    sb.append("    includePlacesRevenue: ").append(toIndentedString(includePlacesRevenue)).append("\n");
    sb.append("    includeRoomTypeAncillaries: ").append(toIndentedString(includeRoomTypeAncillaries)).append("\n");
    sb.append("    includeRoomTypeAncillariesRevenue: ").append(toIndentedString(includeRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    includeAddOns: ").append(toIndentedString(includeAddOns)).append("\n");
    sb.append("    includeAddOnsRevenue: ").append(toIndentedString(includeAddOnsRevenue)).append("\n");
    sb.append("    includeTotalRoomRevenue: ").append(toIndentedString(includeTotalRoomRevenue)).append("\n");
    sb.append("    includeAverageRoomRate: ").append(toIndentedString(includeAverageRoomRate)).append("\n");
    sb.append("    includeTotalAncillariesRevenue: ").append(toIndentedString(includeTotalAncillariesRevenue)).append("\n");
    sb.append("    includeTotalNetRevenue: ").append(toIndentedString(includeTotalNetRevenue)).append("\n");
    sb.append("    includeCancelledRoomNights: ").append(toIndentedString(includeCancelledRoomNights)).append("\n");
    sb.append("    includeCancelledMeetingRooms: ").append(toIndentedString(includeCancelledMeetingRooms)).append("\n");
    sb.append("    includeCancelledMeetingRoomsRevenue: ").append(toIndentedString(includeCancelledMeetingRoomsRevenue)).append("\n");
    sb.append("    includeCancelledRestaurants: ").append(toIndentedString(includeCancelledRestaurants)).append("\n");
    sb.append("    includeCancelledRestaurantsRevenue: ").append(toIndentedString(includeCancelledRestaurantsRevenue)).append("\n");
    sb.append("    includeCancelledSpas: ").append(toIndentedString(includeCancelledSpas)).append("\n");
    sb.append("    includeCancelledSpasRevenue: ").append(toIndentedString(includeCancelledSpasRevenue)).append("\n");
    sb.append("    includeCancelledActivities: ").append(toIndentedString(includeCancelledActivities)).append("\n");
    sb.append("    includeCancelledActivitiesRevenue: ").append(toIndentedString(includeCancelledActivitiesRevenue)).append("\n");
    sb.append("    includeCancelledAttractions: ").append(toIndentedString(includeCancelledAttractions)).append("\n");
    sb.append("    includeCancelledAttractionsRevenue: ").append(toIndentedString(includeCancelledAttractionsRevenue)).append("\n");
    sb.append("    includeCancelledPlaces: ").append(toIndentedString(includeCancelledPlaces)).append("\n");
    sb.append("    includeCancelledPlacesRevenue: ").append(toIndentedString(includeCancelledPlacesRevenue)).append("\n");
    sb.append("    includeCancelledRoomTypeAncillaries: ").append(toIndentedString(includeCancelledRoomTypeAncillaries)).append("\n");
    sb.append("    includeCancelledRoomTypeAncillariesRevenue: ").append(toIndentedString(includeCancelledRoomTypeAncillariesRevenue)).append("\n");
    sb.append("    includeCancelledAddOns: ").append(toIndentedString(includeCancelledAddOns)).append("\n");
    sb.append("    includeCancelledAddOnsRevenue: ").append(toIndentedString(includeCancelledAddOnsRevenue)).append("\n");
    sb.append("    includeCancelledTotalRoomRevenue: ").append(toIndentedString(includeCancelledTotalRoomRevenue)).append("\n");
    sb.append("    includeCancelledTotalAncillariesRevenue: ").append(toIndentedString(includeCancelledTotalAncillariesRevenue)).append("\n");
    sb.append("    includeCancelledTotalNetRevenue: ").append(toIndentedString(includeCancelledTotalNetRevenue)).append("\n");
    sb.append("    groupOnChannelSubType: ").append(toIndentedString(groupOnChannelSubType)).append("\n");
    sb.append("    groupOnOwnerIdentifier: ").append(toIndentedString(groupOnOwnerIdentifier)).append("\n");
    sb.append("    groupOnEngineIdentifier: ").append(toIndentedString(groupOnEngineIdentifier)).append("\n");
    sb.append("    groupOnEngineCountryGeoNameId: ").append(toIndentedString(groupOnEngineCountryGeoNameId)).append("\n");
    sb.append("    groupOnEngineCityGeoNameId: ").append(toIndentedString(groupOnEngineCityGeoNameId)).append("\n");
    sb.append("    groupOnEngineContinentCode: ").append(toIndentedString(groupOnEngineContinentCode)).append("\n");
    sb.append("    groupOnEngineConfigurationIdentifier: ").append(toIndentedString(groupOnEngineConfigurationIdentifier)).append("\n");
    sb.append("    groupOnCountryGeoNameId: ").append(toIndentedString(groupOnCountryGeoNameId)).append("\n");
    sb.append("    groupOnCityGeoNameId: ").append(toIndentedString(groupOnCityGeoNameId)).append("\n");
    sb.append("    groupOnContinentCode: ").append(toIndentedString(groupOnContinentCode)).append("\n");
    sb.append("    groupOnHotelIdentifier: ").append(toIndentedString(groupOnHotelIdentifier)).append("\n");
    sb.append("    groupOnUserIdentifier: ").append(toIndentedString(groupOnUserIdentifier)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

