/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.61.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.analytics.model.ChartCategoryAxisNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.ChartLegendNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.ChartSeriesDefaultsNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.ChartSeriesNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.ChartTitleNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.ChartTooltipNonAuthenticatedEntity;
import travel.wink.sdk.analytics.model.ChartValueAxisNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * LineChartNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  LineChartNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  LineChartNonAuthenticatedEntity.JSON_PROPERTY_TITLE,
  LineChartNonAuthenticatedEntity.JSON_PROPERTY_LEGEND,
  LineChartNonAuthenticatedEntity.JSON_PROPERTY_SERIES_DEFAULTS,
  LineChartNonAuthenticatedEntity.JSON_PROPERTY_SERIES,
  LineChartNonAuthenticatedEntity.JSON_PROPERTY_VALUE_AXIS,
  LineChartNonAuthenticatedEntity.JSON_PROPERTY_CATEGORY_AXIS,
  LineChartNonAuthenticatedEntity.JSON_PROPERTY_TOOLTIP,
  LineChartNonAuthenticatedEntity.JSON_PROPERTY_RENDER_AS,
  LineChartNonAuthenticatedEntity.JSON_PROPERTY_TRANSITIONS
})
@JsonTypeName("LineChart_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T22:28:27.330111255+07:00[Asia/Bangkok]")
public class LineChartNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_TITLE = "title";
  private ChartTitleNonAuthenticatedEntity title;

  public static final String JSON_PROPERTY_LEGEND = "legend";
  private ChartLegendNonAuthenticatedEntity legend;

  public static final String JSON_PROPERTY_SERIES_DEFAULTS = "seriesDefaults";
  private ChartSeriesDefaultsNonAuthenticatedEntity seriesDefaults;

  public static final String JSON_PROPERTY_SERIES = "series";
  private List<ChartSeriesNonAuthenticatedEntity> series;

  public static final String JSON_PROPERTY_VALUE_AXIS = "valueAxis";
  private ChartValueAxisNonAuthenticatedEntity valueAxis;

  public static final String JSON_PROPERTY_CATEGORY_AXIS = "categoryAxis";
  private ChartCategoryAxisNonAuthenticatedEntity categoryAxis;

  public static final String JSON_PROPERTY_TOOLTIP = "tooltip";
  private ChartTooltipNonAuthenticatedEntity tooltip;

  public static final String JSON_PROPERTY_RENDER_AS = "renderAs";
  private String renderAs;

  public static final String JSON_PROPERTY_TRANSITIONS = "transitions";
  private Boolean transitions;

  public LineChartNonAuthenticatedEntity() {
  }

  public LineChartNonAuthenticatedEntity identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique line chart identifier
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public LineChartNonAuthenticatedEntity title(ChartTitleNonAuthenticatedEntity title) {
    
    this.title = title;
    return this;
  }

   /**
   * Get title
   * @return title
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartTitleNonAuthenticatedEntity getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(ChartTitleNonAuthenticatedEntity title) {
    this.title = title;
  }


  public LineChartNonAuthenticatedEntity legend(ChartLegendNonAuthenticatedEntity legend) {
    
    this.legend = legend;
    return this;
  }

   /**
   * Get legend
   * @return legend
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LEGEND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartLegendNonAuthenticatedEntity getLegend() {
    return legend;
  }


  @JsonProperty(JSON_PROPERTY_LEGEND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegend(ChartLegendNonAuthenticatedEntity legend) {
    this.legend = legend;
  }


  public LineChartNonAuthenticatedEntity seriesDefaults(ChartSeriesDefaultsNonAuthenticatedEntity seriesDefaults) {
    
    this.seriesDefaults = seriesDefaults;
    return this;
  }

   /**
   * Get seriesDefaults
   * @return seriesDefaults
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SERIES_DEFAULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartSeriesDefaultsNonAuthenticatedEntity getSeriesDefaults() {
    return seriesDefaults;
  }


  @JsonProperty(JSON_PROPERTY_SERIES_DEFAULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeriesDefaults(ChartSeriesDefaultsNonAuthenticatedEntity seriesDefaults) {
    this.seriesDefaults = seriesDefaults;
  }


  public LineChartNonAuthenticatedEntity series(List<ChartSeriesNonAuthenticatedEntity> series) {
    
    this.series = series;
    return this;
  }

  public LineChartNonAuthenticatedEntity addSeriesItem(ChartSeriesNonAuthenticatedEntity seriesItem) {
    if (this.series == null) {
      this.series = new ArrayList<>();
    }
    this.series.add(seriesItem);
    return this;
  }

   /**
   * The configuration of the chart series. The series type is determined by the value of the type field. If a type value is missing, the chart renders the type that is specified in &#x60;seriesDefaults&#x60;. Some options accept functions as arguments. These arguments are evaluated for each point which is supplied as a parameter. If no value is returned, the chart uses the &#x60;theme&#x60; or &#x60;seriesDefaults&#x60; values.
   * @return series
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ChartSeriesNonAuthenticatedEntity> getSeries() {
    return series;
  }


  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeries(List<ChartSeriesNonAuthenticatedEntity> series) {
    this.series = series;
  }


  public LineChartNonAuthenticatedEntity valueAxis(ChartValueAxisNonAuthenticatedEntity valueAxis) {
    
    this.valueAxis = valueAxis;
    return this;
  }

   /**
   * Get valueAxis
   * @return valueAxis
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VALUE_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartValueAxisNonAuthenticatedEntity getValueAxis() {
    return valueAxis;
  }


  @JsonProperty(JSON_PROPERTY_VALUE_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValueAxis(ChartValueAxisNonAuthenticatedEntity valueAxis) {
    this.valueAxis = valueAxis;
  }


  public LineChartNonAuthenticatedEntity categoryAxis(ChartCategoryAxisNonAuthenticatedEntity categoryAxis) {
    
    this.categoryAxis = categoryAxis;
    return this;
  }

   /**
   * Get categoryAxis
   * @return categoryAxis
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CATEGORY_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartCategoryAxisNonAuthenticatedEntity getCategoryAxis() {
    return categoryAxis;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryAxis(ChartCategoryAxisNonAuthenticatedEntity categoryAxis) {
    this.categoryAxis = categoryAxis;
  }


  public LineChartNonAuthenticatedEntity tooltip(ChartTooltipNonAuthenticatedEntity tooltip) {
    
    this.tooltip = tooltip;
    return this;
  }

   /**
   * Get tooltip
   * @return tooltip
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOOLTIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartTooltipNonAuthenticatedEntity getTooltip() {
    return tooltip;
  }


  @JsonProperty(JSON_PROPERTY_TOOLTIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTooltip(ChartTooltipNonAuthenticatedEntity tooltip) {
    this.tooltip = tooltip;
  }


  public LineChartNonAuthenticatedEntity renderAs(String renderAs) {
    
    this.renderAs = renderAs;
    return this;
  }

   /**
   * Sets the preferred rendering engine. If not supported by the browser, the Chart switches to the first available mode.  The supported values are:  - svg (If available, renders the component as an inline .svg file.)- canvas (If available, renders the component as a canvas element.)
   * @return renderAs
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RENDER_AS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRenderAs() {
    return renderAs;
  }


  @JsonProperty(JSON_PROPERTY_RENDER_AS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRenderAs(String renderAs) {
    this.renderAs = renderAs;
  }


  public LineChartNonAuthenticatedEntity transitions(Boolean transitions) {
    
    this.transitions = transitions;
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, the Chart plays animations when it displays the series. By default, animations are enabled.
   * @return transitions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTransitions() {
    return transitions;
  }


  @JsonProperty(JSON_PROPERTY_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransitions(Boolean transitions) {
    this.transitions = transitions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LineChartNonAuthenticatedEntity lineChartNonAuthenticatedEntity = (LineChartNonAuthenticatedEntity) o;
    return Objects.equals(this.identifier, lineChartNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.title, lineChartNonAuthenticatedEntity.title) &&
        Objects.equals(this.legend, lineChartNonAuthenticatedEntity.legend) &&
        Objects.equals(this.seriesDefaults, lineChartNonAuthenticatedEntity.seriesDefaults) &&
        Objects.equals(this.series, lineChartNonAuthenticatedEntity.series) &&
        Objects.equals(this.valueAxis, lineChartNonAuthenticatedEntity.valueAxis) &&
        Objects.equals(this.categoryAxis, lineChartNonAuthenticatedEntity.categoryAxis) &&
        Objects.equals(this.tooltip, lineChartNonAuthenticatedEntity.tooltip) &&
        Objects.equals(this.renderAs, lineChartNonAuthenticatedEntity.renderAs) &&
        Objects.equals(this.transitions, lineChartNonAuthenticatedEntity.transitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, title, legend, seriesDefaults, series, valueAxis, categoryAxis, tooltip, renderAs, transitions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LineChartNonAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    legend: ").append(toIndentedString(legend)).append("\n");
    sb.append("    seriesDefaults: ").append(toIndentedString(seriesDefaults)).append("\n");
    sb.append("    series: ").append(toIndentedString(series)).append("\n");
    sb.append("    valueAxis: ").append(toIndentedString(valueAxis)).append("\n");
    sb.append("    categoryAxis: ").append(toIndentedString(categoryAxis)).append("\n");
    sb.append("    tooltip: ").append(toIndentedString(tooltip)).append("\n");
    sb.append("    renderAs: ").append(toIndentedString(renderAs)).append("\n");
    sb.append("    transitions: ").append(toIndentedString(transitions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

