/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Analytics API Welcome to the Affiliate API - A programmer-friendly way to get insight into platform-level activities and bookings.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.8.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.analytics.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BookingLeaderboardEntryConsumer
 */
@JsonPropertyOrder({
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_OWNER_IDENTIFIER,
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_OWNER_NAME,
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_CONTINENT,
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_COUNTRY,
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_COUNTRY_GEO_NAME_ID,
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_CITY,
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_CITY_GEO_NAME_ID,
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_BOOKINGS,
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_TOTAL_PRICE_AMOUNT,
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT,
  BookingLeaderboardEntryConsumer.JSON_PROPERTY_CURRENCY_CODE
})
@JsonTypeName("BookingLeaderboardEntry_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-22T15:43:05.359341978+07:00[Asia/Bangkok]")
public class BookingLeaderboardEntryConsumer {
  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private String ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_CONTINENT = "continent";
  private String continent;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_COUNTRY_GEO_NAME_ID = "countryGeoNameId";
  private String countryGeoNameId;

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_CITY_GEO_NAME_ID = "cityGeoNameId";
  private String cityGeoNameId;

  public static final String JSON_PROPERTY_BOOKINGS = "bookings";
  private Long bookings;

  public static final String JSON_PROPERTY_TOTAL_PRICE_AMOUNT = "totalPriceAmount";
  private BigDecimal totalPriceAmount;

  public static final String JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT = "averageBookingAmount";
  private BigDecimal averageBookingAmount;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public BookingLeaderboardEntryConsumer() {
  }

  public BookingLeaderboardEntryConsumer ownerIdentifier(String ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Get ownerIdentifier
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(String ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public BookingLeaderboardEntryConsumer ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Get ownerName
   * @return ownerName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public BookingLeaderboardEntryConsumer continent(String continent) {
    
    this.continent = continent;
    return this;
  }

   /**
   * Get continent
   * @return continent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinent() {
    return continent;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinent(String continent) {
    this.continent = continent;
  }


  public BookingLeaderboardEntryConsumer country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }


  public BookingLeaderboardEntryConsumer countryGeoNameId(String countryGeoNameId) {
    
    this.countryGeoNameId = countryGeoNameId;
    return this;
  }

   /**
   * Get countryGeoNameId
   * @return countryGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryGeoNameId() {
    return countryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryGeoNameId(String countryGeoNameId) {
    this.countryGeoNameId = countryGeoNameId;
  }


  public BookingLeaderboardEntryConsumer city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(String city) {
    this.city = city;
  }


  public BookingLeaderboardEntryConsumer cityGeoNameId(String cityGeoNameId) {
    
    this.cityGeoNameId = cityGeoNameId;
    return this;
  }

   /**
   * Get cityGeoNameId
   * @return cityGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityGeoNameId() {
    return cityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityGeoNameId(String cityGeoNameId) {
    this.cityGeoNameId = cityGeoNameId;
  }


  public BookingLeaderboardEntryConsumer bookings(Long bookings) {
    
    this.bookings = bookings;
    return this;
  }

   /**
   * Get bookings
   * @return bookings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBookings() {
    return bookings;
  }


  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookings(Long bookings) {
    this.bookings = bookings;
  }


  public BookingLeaderboardEntryConsumer totalPriceAmount(BigDecimal totalPriceAmount) {
    
    this.totalPriceAmount = totalPriceAmount;
    return this;
  }

   /**
   * Get totalPriceAmount
   * @return totalPriceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getTotalPriceAmount() {
    return totalPriceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalPriceAmount(BigDecimal totalPriceAmount) {
    this.totalPriceAmount = totalPriceAmount;
  }


  public BookingLeaderboardEntryConsumer averageBookingAmount(BigDecimal averageBookingAmount) {
    
    this.averageBookingAmount = averageBookingAmount;
    return this;
  }

   /**
   * Get averageBookingAmount
   * @return averageBookingAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getAverageBookingAmount() {
    return averageBookingAmount;
  }


  @JsonProperty(JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAverageBookingAmount(BigDecimal averageBookingAmount) {
    this.averageBookingAmount = averageBookingAmount;
  }


  public BookingLeaderboardEntryConsumer currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Get currencyCode
   * @return currencyCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingLeaderboardEntryConsumer bookingLeaderboardEntryConsumer = (BookingLeaderboardEntryConsumer) o;
    return Objects.equals(this.ownerIdentifier, bookingLeaderboardEntryConsumer.ownerIdentifier) &&
        Objects.equals(this.ownerName, bookingLeaderboardEntryConsumer.ownerName) &&
        Objects.equals(this.continent, bookingLeaderboardEntryConsumer.continent) &&
        Objects.equals(this.country, bookingLeaderboardEntryConsumer.country) &&
        Objects.equals(this.countryGeoNameId, bookingLeaderboardEntryConsumer.countryGeoNameId) &&
        Objects.equals(this.city, bookingLeaderboardEntryConsumer.city) &&
        Objects.equals(this.cityGeoNameId, bookingLeaderboardEntryConsumer.cityGeoNameId) &&
        Objects.equals(this.bookings, bookingLeaderboardEntryConsumer.bookings) &&
        Objects.equals(this.totalPriceAmount, bookingLeaderboardEntryConsumer.totalPriceAmount) &&
        Objects.equals(this.averageBookingAmount, bookingLeaderboardEntryConsumer.averageBookingAmount) &&
        Objects.equals(this.currencyCode, bookingLeaderboardEntryConsumer.currencyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ownerIdentifier, ownerName, continent, country, countryGeoNameId, city, cityGeoNameId, bookings, totalPriceAmount, averageBookingAmount, currencyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingLeaderboardEntryConsumer {\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    continent: ").append(toIndentedString(continent)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    countryGeoNameId: ").append(toIndentedString(countryGeoNameId)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    cityGeoNameId: ").append(toIndentedString(cityGeoNameId)).append("\n");
    sb.append("    bookings: ").append(toIndentedString(bookings)).append("\n");
    sb.append("    totalPriceAmount: ").append(toIndentedString(totalPriceAmount)).append("\n");
    sb.append("    averageBookingAmount: ").append(toIndentedString(averageBookingAmount)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

