/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.analytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonPropertyOrder(value={"page", "size", "currencyCode", "type", "groupingIdentifier"})
@JsonTypeName(value="LeaderboardRequest_Consumer")
public class LeaderboardRequestConsumer {
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 0;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size = 100;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode = "USD";
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.GLOBAL;
    public static final String JSON_PROPERTY_GROUPING_IDENTIFIER = "groupingIdentifier";
    private String groupingIdentifier;

    public LeaderboardRequestConsumer page(Integer page) {
        this.page = page;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public LeaderboardRequestConsumer size(Integer size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @Max(value=100L)
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Max(value=100L) Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(Integer size) {
        this.size = size;
    }

    public LeaderboardRequestConsumer currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public LeaderboardRequestConsumer type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public LeaderboardRequestConsumer groupingIdentifier(String groupingIdentifier) {
        this.groupingIdentifier = groupingIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="groupingIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupingIdentifier() {
        return this.groupingIdentifier;
    }

    @JsonProperty(value="groupingIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupingIdentifier(String groupingIdentifier) {
        this.groupingIdentifier = groupingIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaderboardRequestConsumer leaderboardRequestConsumer = (LeaderboardRequestConsumer)o;
        return Objects.equals(this.page, leaderboardRequestConsumer.page) && Objects.equals(this.size, leaderboardRequestConsumer.size) && Objects.equals(this.currencyCode, leaderboardRequestConsumer.currencyCode) && Objects.equals((Object)this.type, (Object)leaderboardRequestConsumer.type) && Objects.equals(this.groupingIdentifier, leaderboardRequestConsumer.groupingIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.page, this.size, this.currencyCode, this.type, this.groupingIdentifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LeaderboardRequestConsumer {\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    groupingIdentifier: ").append(this.toIndentedString(this.groupingIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        GLOBAL("GLOBAL"),
        CONTINENT("CONTINENT"),
        COUNTRY("COUNTRY"),
        CITY("CITY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

