/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.client.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.booking.client.invoker.ApiClient;
import travel.wink.sdk.booking.client.model.EngineClientNonAuthenticatedEntity;

public class ConfigurationApi {
    private ApiClient apiClient;

    public ConfigurationApi() {
        this(new ApiClient());
    }

    @Autowired
    public ConfigurationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showEngineConfigurationRequestCreation(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showEngineConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/configuration/{identifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineClientNonAuthenticatedEntity> showEngineConfiguration(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showEngineConfigurationRequestCreation(identifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineClientNonAuthenticatedEntity>> showEngineConfigurationWithHttpInfo(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showEngineConfigurationRequestCreation(identifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showEngineConfigurationWithResponseSpec(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showEngineConfigurationRequestCreation(identifier, winkVersion, accept);
    }

    @Deprecated
    private WebClient.ResponseSpec showEngineConfigurationWithClientHeaderRequestCreation(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (clientId == null) {
            throw new WebClientResponseException("Missing the required parameter 'clientId' when calling showEngineConfigurationWithClientHeader", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (clientId != null) {
            headerParams.add("clientId", this.apiClient.parameterToString(clientId));
        }
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/configuration/client", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineClientNonAuthenticatedEntity> showEngineConfigurationWithClientHeader(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showEngineConfigurationWithClientHeaderRequestCreation(clientId, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineClientNonAuthenticatedEntity>> showEngineConfigurationWithClientHeaderWithHttpInfo(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showEngineConfigurationWithClientHeaderRequestCreation(clientId, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showEngineConfigurationWithClientHeaderWithResponseSpec(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        return this.showEngineConfigurationWithClientHeaderRequestCreation(clientId, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPrimaryEngineConfigurationRequestCreation(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (clientId == null) {
            throw new WebClientResponseException("Missing the required parameter 'clientId' when calling showPrimaryEngineConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("clientId", clientId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/configuration/client/{clientId}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineClientNonAuthenticatedEntity> showPrimaryEngineConfiguration(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showPrimaryEngineConfigurationRequestCreation(clientId, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineClientNonAuthenticatedEntity>> showPrimaryEngineConfigurationWithHttpInfo(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showPrimaryEngineConfigurationRequestCreation(clientId, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPrimaryEngineConfigurationWithResponseSpec(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPrimaryEngineConfigurationRequestCreation(clientId, winkVersion, accept);
    }
}

