/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.client.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.booking.client.invoker.ApiClient;
import travel.wink.sdk.booking.client.model.EngineClientNonAuthenticatedEntity;

public class ConfigurationApi {
    private ApiClient apiClient;

    public ConfigurationApi() {
        this(new ApiClient());
    }

    @Autowired
    public ConfigurationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showCustomizationByClientIdRequestCreation(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (clientId == null) {
            throw new WebClientResponseException("Missing the required parameter 'clientId' when calling showCustomizationByClientId", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("clientId", clientId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/configuration/client/{clientId}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineClientNonAuthenticatedEntity> showCustomizationByClientId(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showCustomizationByClientIdRequestCreation(clientId, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineClientNonAuthenticatedEntity>> showCustomizationByClientIdWithHttpInfo(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showCustomizationByClientIdRequestCreation(clientId, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCustomizationByClientIdWithResponseSpec(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        return this.showCustomizationByClientIdRequestCreation(clientId, winkVersion, accept);
    }

    @Deprecated
    private WebClient.ResponseSpec showCustomizationByClientIdHeaderRequestCreation(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (clientId == null) {
            throw new WebClientResponseException("Missing the required parameter 'clientId' when calling showCustomizationByClientIdHeader", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (clientId != null) {
            headerParams.add("clientId", this.apiClient.parameterToString(clientId));
        }
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/configuration/client", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineClientNonAuthenticatedEntity> showCustomizationByClientIdHeader(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showCustomizationByClientIdHeaderRequestCreation(clientId, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineClientNonAuthenticatedEntity>> showCustomizationByClientIdHeaderWithHttpInfo(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showCustomizationByClientIdHeaderRequestCreation(clientId, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCustomizationByClientIdHeaderWithResponseSpec(String clientId, String winkVersion, String accept) throws WebClientResponseException {
        return this.showCustomizationByClientIdHeaderRequestCreation(clientId, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCustomizationByIdRequestCreation(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showCustomizationById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/configuration/{identifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineClientNonAuthenticatedEntity> showCustomizationById(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showCustomizationByIdRequestCreation(identifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineClientNonAuthenticatedEntity>> showCustomizationByIdWithHttpInfo(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showCustomizationByIdRequestCreation(identifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCustomizationByIdWithResponseSpec(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showCustomizationByIdRequestCreation(identifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCustomizationByUrlNameRequestCreation(String urlName, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling showCustomizationByUrlName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("urlName", urlName);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/configuration/url-name/{urlName}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineClientNonAuthenticatedEntity> showCustomizationByUrlName(String urlName, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showCustomizationByUrlNameRequestCreation(urlName, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineClientNonAuthenticatedEntity>> showCustomizationByUrlNameWithHttpInfo(String urlName, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineClientNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<EngineClientNonAuthenticatedEntity>(this){};
        return this.showCustomizationByUrlNameRequestCreation(urlName, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCustomizationByUrlNameWithResponseSpec(String urlName, String winkVersion, String accept) throws WebClientResponseException {
        return this.showCustomizationByUrlNameRequestCreation(urlName, winkVersion, accept);
    }
}

