/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive platform-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.booking.engine.model.AncillaryRequest;
import travel.wink.booking.engine.model.BookingUserRequest;
import travel.wink.booking.engine.model.RoomConfiguration;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of room configuration booking requests. Each entry is a separately booked room.
 */
@ApiModel(description = "List of room configuration booking requests. Each entry is a separately booked room.")
@JsonPropertyOrder({
  AgentBookingRequest.JSON_PROPERTY_HOTEL_IDENTIFIER,
  AgentBookingRequest.JSON_PROPERTY_START_DATE,
  AgentBookingRequest.JSON_PROPERTY_END_DATE,
  AgentBookingRequest.JSON_PROPERTY_ROOM_CONFIGURATION,
  AgentBookingRequest.JSON_PROPERTY_PROMOTIONAL_CODES,
  AgentBookingRequest.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  AgentBookingRequest.JSON_PROPERTY_BED_TYPE,
  AgentBookingRequest.JSON_PROPERTY_PACKAGE_OFFERS,
  AgentBookingRequest.JSON_PROPERTY_ADD_ON_OFFERS,
  AgentBookingRequest.JSON_PROPERTY_ANCILLARIES,
  AgentBookingRequest.JSON_PROPERTY_SPECIAL_REQUESTS,
  AgentBookingRequest.JSON_PROPERTY_USER,
  AgentBookingRequest.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  AgentBookingRequest.JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-24T12:59:12.895942+07:00[Asia/Bangkok]")
public class AgentBookingRequest {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATION = "roomConfiguration";
  private RoomConfiguration roomConfiguration;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes = null;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private String roomRateIdentifier;

  public static final String JSON_PROPERTY_BED_TYPE = "bedType";
  private String bedType;

  public static final String JSON_PROPERTY_PACKAGE_OFFERS = "packageOffers";
  private List<String> packageOffers = null;

  public static final String JSON_PROPERTY_ADD_ON_OFFERS = "addOnOffers";
  private List<String> addOnOffers = null;

  public static final String JSON_PROPERTY_ANCILLARIES = "ancillaries";
  private List<AncillaryRequest> ancillaries = null;

  public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
  private String specialRequests;

  public static final String JSON_PROPERTY_USER = "user";
  private BookingUserRequest user;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
  private String externalTransactionIdentifier;

  public AgentBookingRequest() { 
  }

  public AgentBookingRequest hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "hotel-1", required = true, value = "Unique hotel record identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public AgentBookingRequest startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Date when guest arrives on the premises.
   * @return startDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "Sun Jan 31 07:00:00 ICT 2021", required = true, value = "Date when guest arrives on the premises.")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public AgentBookingRequest endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Date when guest departs the premises.
   * @return endDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "Sun Feb 07 07:00:00 ICT 2021", required = true, value = "Date when guest departs the premises.")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public AgentBookingRequest roomConfiguration(RoomConfiguration roomConfiguration) {
    
    this.roomConfiguration = roomConfiguration;
    return this;
  }

   /**
   * Get roomConfiguration
   * @return roomConfiguration
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomConfiguration getRoomConfiguration() {
    return roomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomConfiguration(RoomConfiguration roomConfiguration) {
    this.roomConfiguration = roomConfiguration;
  }


  public AgentBookingRequest promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public AgentBookingRequest addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * List of promotional codes the user entered to to activate a promotion.
   * @return promotionalCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"promo-1\",\"promo-2\"]", value = "List of promotional codes the user entered to to activate a promotion.")
  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public AgentBookingRequest roomRateIdentifier(String roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * The unique master rate that made the guest room / rate plan available for sale.
   * @return roomRateIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "master-rate-1", required = true, value = "The unique master rate that made the guest room / rate plan available for sale.")
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(String roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public AgentBookingRequest bedType(String bedType) {
    
    this.bedType = bedType;
    return this;
  }

   /**
   * Guest can optionally request a specific bed type if the room type is set up with multiple bed type choices. Example: 9 is a &#x60;Single&#x60;. Taken from the &#x60;BED&#x60; OTA specification.
   * @return bedType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "9", value = "Guest can optionally request a specific bed type if the room type is set up with multiple bed type choices. Example: 9 is a `Single`. Taken from the `BED` OTA specification.")
  @JsonProperty(JSON_PROPERTY_BED_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBedType() {
    return bedType;
  }


  @JsonProperty(JSON_PROPERTY_BED_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBedType(String bedType) {
    this.bedType = bedType;
  }


  public AgentBookingRequest packageOffers(List<String> packageOffers) {
    
    this.packageOffers = packageOffers;
    return this;
  }

  public AgentBookingRequest addPackageOffersItem(String packageOffersItem) {
    if (this.packageOffers == null) {
      this.packageOffers = new ArrayList<>();
    }
    this.packageOffers.add(packageOffersItem);
    return this;
  }

   /**
   * Unique package identifiers guest wants added to her booking. Note: these add-ons must be available as part of the room type to be able to add them to a booking.
   * @return packageOffers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"package-1\"]", value = "Unique package identifiers guest wants added to her booking. Note: these add-ons must be available as part of the room type to be able to add them to a booking.")
  @JsonProperty(JSON_PROPERTY_PACKAGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPackageOffers() {
    return packageOffers;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageOffers(List<String> packageOffers) {
    this.packageOffers = packageOffers;
  }


  public AgentBookingRequest addOnOffers(List<String> addOnOffers) {
    
    this.addOnOffers = addOnOffers;
    return this;
  }

  public AgentBookingRequest addAddOnOffersItem(String addOnOffersItem) {
    if (this.addOnOffers == null) {
      this.addOnOffers = new ArrayList<>();
    }
    this.addOnOffers.add(addOnOffersItem);
    return this;
  }

   /**
   * Unique add-on identifiers guest wants added to her booking. Note: these add-ons must be available as part of the room type to be able to add them to a booking.
   * @return addOnOffers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"add-on-1\"]", value = "Unique add-on identifiers guest wants added to her booking. Note: these add-ons must be available as part of the room type to be able to add them to a booking.")
  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAddOnOffers() {
    return addOnOffers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnOffers(List<String> addOnOffers) {
    this.addOnOffers = addOnOffers;
  }


  public AgentBookingRequest ancillaries(List<AncillaryRequest> ancillaries) {
    
    this.ancillaries = ancillaries;
    return this;
  }

  public AgentBookingRequest addAncillariesItem(AncillaryRequest ancillariesItem) {
    if (this.ancillaries == null) {
      this.ancillaries = new ArrayList<>();
    }
    this.ancillaries.add(ancillariesItem);
    return this;
  }

   /**
   * Extra reservations of spas, meeting rooms etc that should accompany the room type booking.
   * @return ancillaries
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Extra reservations of spas, meeting rooms etc that should accompany the room type booking.")
  @JsonProperty(JSON_PROPERTY_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AncillaryRequest> getAncillaries() {
    return ancillaries;
  }


  @JsonProperty(JSON_PROPERTY_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncillaries(List<AncillaryRequest> ancillaries) {
    this.ancillaries = ancillaries;
  }


  public AgentBookingRequest specialRequests(String specialRequests) {
    
    this.specialRequests = specialRequests;
    return this;
  }

   /**
   * A guest can send a special request to the hotel in free-text here.
   * @return specialRequests
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Can I please have rose petals on my pillows when I arrive?", value = "A guest can send a special request to the hotel in free-text here.")
  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSpecialRequests() {
    return specialRequests;
  }


  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpecialRequests(String specialRequests) {
    this.specialRequests = specialRequests;
  }


  public AgentBookingRequest user(BookingUserRequest user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserRequest getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(BookingUserRequest user) {
    this.user = user;
  }


  public AgentBookingRequest externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "external-booking-code-1", value = "External booking code generated by the affiliate")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public AgentBookingRequest externalTransactionIdentifier(String externalTransactionIdentifier) {
    
    this.externalTransactionIdentifier = externalTransactionIdentifier;
    return this;
  }

   /**
   * External transaction identifier populated when agent responsible for acquiring
   * @return externalTransactionIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "external-transaction-1", value = "External transaction identifier populated when agent responsible for acquiring")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalTransactionIdentifier() {
    return externalTransactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
    this.externalTransactionIdentifier = externalTransactionIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AgentBookingRequest agentBookingRequest = (AgentBookingRequest) o;
    return Objects.equals(this.hotelIdentifier, agentBookingRequest.hotelIdentifier) &&
        Objects.equals(this.startDate, agentBookingRequest.startDate) &&
        Objects.equals(this.endDate, agentBookingRequest.endDate) &&
        Objects.equals(this.roomConfiguration, agentBookingRequest.roomConfiguration) &&
        Objects.equals(this.promotionalCodes, agentBookingRequest.promotionalCodes) &&
        Objects.equals(this.roomRateIdentifier, agentBookingRequest.roomRateIdentifier) &&
        Objects.equals(this.bedType, agentBookingRequest.bedType) &&
        Objects.equals(this.packageOffers, agentBookingRequest.packageOffers) &&
        Objects.equals(this.addOnOffers, agentBookingRequest.addOnOffers) &&
        Objects.equals(this.ancillaries, agentBookingRequest.ancillaries) &&
        Objects.equals(this.specialRequests, agentBookingRequest.specialRequests) &&
        Objects.equals(this.user, agentBookingRequest.user) &&
        Objects.equals(this.externalSupplierBookingCode, agentBookingRequest.externalSupplierBookingCode) &&
        Objects.equals(this.externalTransactionIdentifier, agentBookingRequest.externalTransactionIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, startDate, endDate, roomConfiguration, promotionalCodes, roomRateIdentifier, bedType, packageOffers, addOnOffers, ancillaries, specialRequests, user, externalSupplierBookingCode, externalTransactionIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AgentBookingRequest {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomConfiguration: ").append(toIndentedString(roomConfiguration)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    bedType: ").append(toIndentedString(bedType)).append("\n");
    sb.append("    packageOffers: ").append(toIndentedString(packageOffers)).append("\n");
    sb.append("    addOnOffers: ").append(toIndentedString(addOnOffers)).append("\n");
    sb.append("    ancillaries: ").append(toIndentedString(ancillaries)).append("\n");
    sb.append("    specialRequests: ").append(toIndentedString(specialRequests)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    externalTransactionIdentifier: ").append(toIndentedString(externalTransactionIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

