/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.booking.engine.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.booking.engine.invoker.ApiClient;
import travel.wink.booking.engine.model.BookingConfirmations;
import travel.wink.booking.engine.model.BookingView;
import travel.wink.booking.engine.model.CancellationDetail;
import travel.wink.booking.engine.model.CreateAgentBookingRequest;
import travel.wink.booking.engine.model.CreateMerchantBookingRequest;
import travel.wink.booking.engine.model.PageBookingView;
import travel.wink.booking.engine.model.State;

public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec cancelBookingRequestCreation(String bookingIdentifier, CancellationDetail cancellationDetail) throws WebClientResponseException {
        CancellationDetail postBody = cancellationDetail;
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationDetail == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetail' when calling cancelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.apiClient.invokeAPI("/api/booking/{bookingIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingView> cancelBooking(String bookingIdentifier, CancellationDetail cancellationDetail) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.cancelBookingRequestCreation(bookingIdentifier, cancellationDetail).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingView>> cancelBookingWithHttpInfo(String bookingIdentifier, CancellationDetail cancellationDetail) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.cancelBookingRequestCreation(bookingIdentifier, cancellationDetail).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec cancelGroupBookingRequestCreation(String groupIdentifier, CancellationDetail cancellationDetail) throws WebClientResponseException {
        CancellationDetail postBody = cancellationDetail;
        if (groupIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'groupIdentifier' when calling cancelGroupBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationDetail == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetail' when calling cancelGroupBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("groupIdentifier", groupIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.apiClient.invokeAPI("/api/booking/group/{groupIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingView> cancelGroupBooking(String groupIdentifier, CancellationDetail cancellationDetail) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.cancelGroupBookingRequestCreation(groupIdentifier, cancellationDetail).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingView>>> cancelGroupBookingWithHttpInfo(String groupIdentifier, CancellationDetail cancellationDetail) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.cancelGroupBookingRequestCreation(groupIdentifier, cancellationDetail).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createAgentBookingRequestCreation(CreateAgentBookingRequest createAgentBookingRequest) throws WebClientResponseException {
        CreateAgentBookingRequest postBody = createAgentBookingRequest;
        if (createAgentBookingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAgentBookingRequest' when calling createAgentBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>(){};
        return this.apiClient.invokeAPI("/api/booking/agent", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingConfirmations> createAgentBooking(CreateAgentBookingRequest createAgentBookingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>(){};
        return this.createAgentBookingRequestCreation(createAgentBookingRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingConfirmations>> createAgentBookingWithHttpInfo(CreateAgentBookingRequest createAgentBookingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>(){};
        return this.createAgentBookingRequestCreation(createAgentBookingRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createMerchantBookingRequestCreation(CreateMerchantBookingRequest createMerchantBookingRequest) throws WebClientResponseException {
        CreateMerchantBookingRequest postBody = createMerchantBookingRequest;
        if (createMerchantBookingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createMerchantBookingRequest' when calling createMerchantBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>(){};
        return this.apiClient.invokeAPI("/api/booking/merchant", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingConfirmations> createMerchantBooking(CreateMerchantBookingRequest createMerchantBookingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>(){};
        return this.createMerchantBookingRequestCreation(createMerchantBookingRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingConfirmations>> createMerchantBookingWithHttpInfo(CreateMerchantBookingRequest createMerchantBookingRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>(){};
        return this.createMerchantBookingRequestCreation(createMerchantBookingRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showBookingRequestCreation(String bookingIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.apiClient.invokeAPI("/api/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingView> showBooking(String bookingIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.showBookingRequestCreation(bookingIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingView>> showBookingWithHttpInfo(String bookingIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.showBookingRequestCreation(bookingIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showBookingGridRequestCreation(State state) throws WebClientResponseException {
        State postBody = state;
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling showBookingGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>(){};
        return this.apiClient.invokeAPI("/api/booking/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingView> showBookingGrid(State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>(){};
        return this.showBookingGridRequestCreation(state).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingView>> showBookingGridWithHttpInfo(State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>(){};
        return this.showBookingGridRequestCreation(state).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showBookingsRequestCreation(Integer page, Integer size, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>(){};
        return this.apiClient.invokeAPI("/api/booking/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingView> showBookings(Integer page, Integer size, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>(){};
        return this.showBookingsRequestCreation(page, size, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingView>> showBookingsWithHttpInfo(Integer page, Integer size, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>(){};
        return this.showBookingsRequestCreation(page, size, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showBookingsByReviewStateRequestCreation(String state, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.apiClient.invokeAPI("/api/booking/review/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingView> showBookingsByReviewState(String state, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.showBookingsByReviewStateRequestCreation(state, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingView>>> showBookingsByReviewStateWithHttpInfo(String state, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.showBookingsByReviewStateRequestCreation(state, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showBookingsByStateRequestCreation(String state, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.apiClient.invokeAPI("/api/booking/state", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingView> showBookingsByState(String state, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.showBookingsByStateRequestCreation(state, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingView>>> showBookingsByStateWithHttpInfo(String state, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.showBookingsByStateRequestCreation(state, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showGroupedBookingsRequestCreation(String groupIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (groupIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'groupIdentifier' when calling showGroupedBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("groupIdentifier", groupIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.apiClient.invokeAPI("/api/booking/group/{groupIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingView> showGroupedBookings(String groupIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.showGroupedBookingsRequestCreation(groupIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingView>>> showGroupedBookingsWithHttpInfo(String groupIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>(){};
        return this.showGroupedBookingsRequestCreation(groupIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }
}

