/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.booking.engine.model.UserSession;

@JsonPropertyOrder(value={"identifier", "engineConfigurationIdentifier", "userSession", "page", "size"})
public class AggregateSellerInventoryListRequest {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
    private String engineConfigurationIdentifier;
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSession userSession;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size;

    public AggregateSellerInventoryListRequest identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public AggregateSellerInventoryListRequest engineConfigurationIdentifier(String engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The configuration identifier that was used during this call.")
    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEngineConfigurationIdentifier() {
        return this.engineConfigurationIdentifier;
    }

    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEngineConfigurationIdentifier(String engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    }

    public AggregateSellerInventoryListRequest userSession(UserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    public AggregateSellerInventoryListRequest page(Integer page) {
        this.page = page;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(required=true, value="Which to page to paginate to")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public AggregateSellerInventoryListRequest size(Integer size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @Max(value=12L)
    @ApiModelProperty(required=true, value="How many results to return per page")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) @Max(value=12L) Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest = (AggregateSellerInventoryListRequest)o;
        return Objects.equals(this.identifier, aggregateSellerInventoryListRequest.identifier) && Objects.equals(this.engineConfigurationIdentifier, aggregateSellerInventoryListRequest.engineConfigurationIdentifier) && Objects.equals(this.userSession, aggregateSellerInventoryListRequest.userSession) && Objects.equals(this.page, aggregateSellerInventoryListRequest.page) && Objects.equals(this.size, aggregateSellerInventoryListRequest.size);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.engineConfigurationIdentifier, this.userSession, this.page, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregateSellerInventoryListRequest {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    engineConfigurationIdentifier: ").append(this.toIndentedString(this.engineConfigurationIdentifier)).append("\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

