/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@ApiModel(description="User object contains details of the person that made the booking.")
@JsonPropertyOrder(value={"firstName", "lastName", "email", "telephone"})
public class BookingUserRequest {
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_TELEPHONE = "telephone";
    private String telephone;

    public BookingUserRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="John", required=true, value="First name")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public BookingUserRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Smith", required=true, value="Last name")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public BookingUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="john.smith@email.com", required=true, value="Email")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public BookingUserRequest telephone(String telephone) {
        this.telephone = telephone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0123456789", value="Telephone")
    @JsonProperty(value="telephone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephone() {
        return this.telephone;
    }

    @JsonProperty(value="telephone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingUserRequest bookingUserRequest = (BookingUserRequest)o;
        return Objects.equals(this.firstName, bookingUserRequest.firstName) && Objects.equals(this.lastName, bookingUserRequest.lastName) && Objects.equals(this.email, bookingUserRequest.email) && Objects.equals(this.telephone, bookingUserRequest.telephone);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.email, this.telephone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingUserRequest {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    telephone: ").append(this.toIndentedString(this.telephone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

