/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="List of all travel inventory entries that are due a commission to the affiliate.")
@JsonPropertyOrder(value={"name", "identifier", "type", "commissionPercent"})
public class CommissionableEntry {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_COMMISSION_PERCENT = "commissionPercent";
    private Float commissionPercent;

    public CommissionableEntry name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public CommissionableEntry identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public CommissionableEntry type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CommissionableEntry commissionPercent(Float commissionPercent) {
        this.commissionPercent = commissionPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getCommissionPercent() {
        return this.commissionPercent;
    }

    @JsonProperty(value="commissionPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionPercent(Float commissionPercent) {
        this.commissionPercent = commissionPercent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommissionableEntry commissionableEntry = (CommissionableEntry)o;
        return Objects.equals(this.name, commissionableEntry.name) && Objects.equals(this.identifier, commissionableEntry.identifier) && Objects.equals((Object)this.type, (Object)commissionableEntry.type) && Objects.equals(this.commissionPercent, commissionableEntry.commissionPercent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.identifier, this.type, this.commissionPercent});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommissionableEntry {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    commissionPercent: ").append(this.toIndentedString(this.commissionPercent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        GUEST_ROOM("GUEST_ROOM"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE"),
        ACTIVITY("ACTIVITY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

