/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.booking.engine.model.UserSession;

@JsonPropertyOrder(value={"hotelIdentifier", "urlName", "showHotel", "showMetadata", "showVideos", "showImages", "showRoomTypes", "showPackageOffers", "showAddOnOffers", "showRestaurants", "showMeetingRooms", "showSpas", "showAttractions", "showActivities", "showPlaces", "showRecognition", "showAggregateGreenIndexScores", "showAnnouncements", "showReviews", "userSession"})
public class HotelInventoryRequest {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_URL_NAME = "urlName";
    private String urlName;
    public static final String JSON_PROPERTY_SHOW_HOTEL = "showHotel";
    private Boolean showHotel = true;
    public static final String JSON_PROPERTY_SHOW_METADATA = "showMetadata";
    private Boolean showMetadata = true;
    public static final String JSON_PROPERTY_SHOW_VIDEOS = "showVideos";
    private Boolean showVideos = false;
    public static final String JSON_PROPERTY_SHOW_IMAGES = "showImages";
    private Boolean showImages = false;
    public static final String JSON_PROPERTY_SHOW_ROOM_TYPES = "showRoomTypes";
    private Boolean showRoomTypes = true;
    public static final String JSON_PROPERTY_SHOW_PACKAGE_OFFERS = "showPackageOffers";
    private Boolean showPackageOffers = false;
    public static final String JSON_PROPERTY_SHOW_ADD_ON_OFFERS = "showAddOnOffers";
    private Boolean showAddOnOffers = false;
    public static final String JSON_PROPERTY_SHOW_RESTAURANTS = "showRestaurants";
    private Boolean showRestaurants = false;
    public static final String JSON_PROPERTY_SHOW_MEETING_ROOMS = "showMeetingRooms";
    private Boolean showMeetingRooms = false;
    public static final String JSON_PROPERTY_SHOW_SPAS = "showSpas";
    private Boolean showSpas = false;
    public static final String JSON_PROPERTY_SHOW_ATTRACTIONS = "showAttractions";
    private Boolean showAttractions = false;
    public static final String JSON_PROPERTY_SHOW_ACTIVITIES = "showActivities";
    private Boolean showActivities = false;
    public static final String JSON_PROPERTY_SHOW_PLACES = "showPlaces";
    private Boolean showPlaces = false;
    public static final String JSON_PROPERTY_SHOW_RECOGNITION = "showRecognition";
    private Boolean showRecognition = false;
    public static final String JSON_PROPERTY_SHOW_AGGREGATE_GREEN_INDEX_SCORES = "showAggregateGreenIndexScores";
    private Boolean showAggregateGreenIndexScores = false;
    public static final String JSON_PROPERTY_SHOW_ANNOUNCEMENTS = "showAnnouncements";
    private Boolean showAnnouncements = false;
    public static final String JSON_PROPERTY_SHOW_REVIEWS = "showReviews";
    private Boolean showReviews = false;
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSession userSession;

    public HotelInventoryRequest hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="hotel-1", value="Unique property identifier to retrieve inventory for. Either the hotelIdentifier or urlName property is required.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public HotelInventoryRequest urlName(String urlName) {
        this.urlName = urlName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="the-most-fantastic-hotel", value="Unique url-friendly record identifier of property. Either the hotelIdentifier or urlName property is required.")
    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrlName() {
        return this.urlName;
    }

    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrlName(String urlName) {
        this.urlName = urlName;
    }

    public HotelInventoryRequest showHotel(Boolean showHotel) {
        this.showHotel = showHotel;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return basic property data. If you are loading up property for the first time, this data would be good to include. But there is no need to load that a second time if you are only going for availability data. This field populates `hotel` data in response.")
    @JsonProperty(value="showHotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowHotel() {
        return this.showHotel;
    }

    @JsonProperty(value="showHotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowHotel(Boolean showHotel) {
        this.showHotel = showHotel;
    }

    public HotelInventoryRequest showMetadata(Boolean showMetadata) {
        this.showMetadata = showMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property meta data. This field populates `metadata` data in response.")
    @JsonProperty(value="showMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowMetadata() {
        return this.showMetadata;
    }

    @JsonProperty(value="showMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowMetadata(Boolean showMetadata) {
        this.showMetadata = showMetadata;
    }

    public HotelInventoryRequest showVideos(Boolean showVideos) {
        this.showVideos = showVideos;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property video data. This field populates `videos` data in response.")
    @JsonProperty(value="showVideos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowVideos() {
        return this.showVideos;
    }

    @JsonProperty(value="showVideos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowVideos(Boolean showVideos) {
        this.showVideos = showVideos;
    }

    public HotelInventoryRequest showImages(Boolean showImages) {
        this.showImages = showImages;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property image data. This field populates `images` data in response.")
    @JsonProperty(value="showImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowImages() {
        return this.showImages;
    }

    @JsonProperty(value="showImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowImages(Boolean showImages) {
        this.showImages = showImages;
    }

    public HotelInventoryRequest showRoomTypes(Boolean showRoomTypes) {
        this.showRoomTypes = showRoomTypes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property room type data. This field populates `roomType`, `cheapesRoomTypes` and `available` data in response.")
    @JsonProperty(value="showRoomTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowRoomTypes() {
        return this.showRoomTypes;
    }

    @JsonProperty(value="showRoomTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowRoomTypes(Boolean showRoomTypes) {
        this.showRoomTypes = showRoomTypes;
    }

    public HotelInventoryRequest showPackageOffers(Boolean showPackageOffers) {
        this.showPackageOffers = showPackageOffers;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property package offer data. This field populates `roomTypes.priceConfigurations.packageOffers` data in response.")
    @JsonProperty(value="showPackageOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowPackageOffers() {
        return this.showPackageOffers;
    }

    @JsonProperty(value="showPackageOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowPackageOffers(Boolean showPackageOffers) {
        this.showPackageOffers = showPackageOffers;
    }

    public HotelInventoryRequest showAddOnOffers(Boolean showAddOnOffers) {
        this.showAddOnOffers = showAddOnOffers;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property add-on data. This field populates `roomTypes.priceConfigurations.addOnOffers` data in response.")
    @JsonProperty(value="showAddOnOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowAddOnOffers() {
        return this.showAddOnOffers;
    }

    @JsonProperty(value="showAddOnOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowAddOnOffers(Boolean showAddOnOffers) {
        this.showAddOnOffers = showAddOnOffers;
    }

    public HotelInventoryRequest showRestaurants(Boolean showRestaurants) {
        this.showRestaurants = showRestaurants;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property restaurant data. This field populates `restaurants` data in response.")
    @JsonProperty(value="showRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowRestaurants() {
        return this.showRestaurants;
    }

    @JsonProperty(value="showRestaurants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowRestaurants(Boolean showRestaurants) {
        this.showRestaurants = showRestaurants;
    }

    public HotelInventoryRequest showMeetingRooms(Boolean showMeetingRooms) {
        this.showMeetingRooms = showMeetingRooms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property meeting room data. This field populates `meetingRooms` data in response.")
    @JsonProperty(value="showMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowMeetingRooms() {
        return this.showMeetingRooms;
    }

    @JsonProperty(value="showMeetingRooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowMeetingRooms(Boolean showMeetingRooms) {
        this.showMeetingRooms = showMeetingRooms;
    }

    public HotelInventoryRequest showSpas(Boolean showSpas) {
        this.showSpas = showSpas;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property spa data. This field populates `spas` data in response.")
    @JsonProperty(value="showSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowSpas() {
        return this.showSpas;
    }

    @JsonProperty(value="showSpas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowSpas(Boolean showSpas) {
        this.showSpas = showSpas;
    }

    public HotelInventoryRequest showAttractions(Boolean showAttractions) {
        this.showAttractions = showAttractions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property attraction data. This field populates `attractions` data in response.")
    @JsonProperty(value="showAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowAttractions() {
        return this.showAttractions;
    }

    @JsonProperty(value="showAttractions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowAttractions(Boolean showAttractions) {
        this.showAttractions = showAttractions;
    }

    public HotelInventoryRequest showActivities(Boolean showActivities) {
        this.showActivities = showActivities;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property activity data. This field populates `activities` data in response.")
    @JsonProperty(value="showActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowActivities() {
        return this.showActivities;
    }

    @JsonProperty(value="showActivities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowActivities(Boolean showActivities) {
        this.showActivities = showActivities;
    }

    public HotelInventoryRequest showPlaces(Boolean showPlaces) {
        this.showPlaces = showPlaces;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property place data. This field populates `places` data in response.")
    @JsonProperty(value="showPlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowPlaces() {
        return this.showPlaces;
    }

    @JsonProperty(value="showPlaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowPlaces(Boolean showPlaces) {
        this.showPlaces = showPlaces;
    }

    public HotelInventoryRequest showRecognition(Boolean showRecognition) {
        this.showRecognition = showRecognition;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property recognition data. This field populates `recognitions` data in response.")
    @JsonProperty(value="showRecognition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowRecognition() {
        return this.showRecognition;
    }

    @JsonProperty(value="showRecognition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowRecognition(Boolean showRecognition) {
        this.showRecognition = showRecognition;
    }

    public HotelInventoryRequest showAggregateGreenIndexScores(Boolean showAggregateGreenIndexScores) {
        this.showAggregateGreenIndexScores = showAggregateGreenIndexScores;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property green index score data. This field populates `greenIndexScores` data in response. Note: You only need to return hotel data to get the overall aggregate Green Index score and not detailed category scores.")
    @JsonProperty(value="showAggregateGreenIndexScores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowAggregateGreenIndexScores() {
        return this.showAggregateGreenIndexScores;
    }

    @JsonProperty(value="showAggregateGreenIndexScores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowAggregateGreenIndexScores(Boolean showAggregateGreenIndexScores) {
        this.showAggregateGreenIndexScores = showAggregateGreenIndexScores;
    }

    public HotelInventoryRequest showAnnouncements(Boolean showAnnouncements) {
        this.showAnnouncements = showAnnouncements;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property announcement data. Announcements are messages the property wishes to convey to travelers for certain dates. This field populates `announcements` data in response.")
    @JsonProperty(value="showAnnouncements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowAnnouncements() {
        return this.showAnnouncements;
    }

    @JsonProperty(value="showAnnouncements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowAnnouncements(Boolean showAnnouncements) {
        this.showAnnouncements = showAnnouncements;
    }

    public HotelInventoryRequest showReviews(Boolean showReviews) {
        this.showReviews = showReviews;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate whether to return property review data. Note: You only need to return hotel data to get the overall aggregate review score and not the entire list of reviews. This field populates `reviews` data in response.")
    @JsonProperty(value="showReviews")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowReviews() {
        return this.showReviews;
    }

    @JsonProperty(value="showReviews")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowReviews(Boolean showReviews) {
        this.showReviews = showReviews;
    }

    public HotelInventoryRequest userSession(UserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotelInventoryRequest hotelInventoryRequest = (HotelInventoryRequest)o;
        return Objects.equals(this.hotelIdentifier, hotelInventoryRequest.hotelIdentifier) && Objects.equals(this.urlName, hotelInventoryRequest.urlName) && Objects.equals(this.showHotel, hotelInventoryRequest.showHotel) && Objects.equals(this.showMetadata, hotelInventoryRequest.showMetadata) && Objects.equals(this.showVideos, hotelInventoryRequest.showVideos) && Objects.equals(this.showImages, hotelInventoryRequest.showImages) && Objects.equals(this.showRoomTypes, hotelInventoryRequest.showRoomTypes) && Objects.equals(this.showPackageOffers, hotelInventoryRequest.showPackageOffers) && Objects.equals(this.showAddOnOffers, hotelInventoryRequest.showAddOnOffers) && Objects.equals(this.showRestaurants, hotelInventoryRequest.showRestaurants) && Objects.equals(this.showMeetingRooms, hotelInventoryRequest.showMeetingRooms) && Objects.equals(this.showSpas, hotelInventoryRequest.showSpas) && Objects.equals(this.showAttractions, hotelInventoryRequest.showAttractions) && Objects.equals(this.showActivities, hotelInventoryRequest.showActivities) && Objects.equals(this.showPlaces, hotelInventoryRequest.showPlaces) && Objects.equals(this.showRecognition, hotelInventoryRequest.showRecognition) && Objects.equals(this.showAggregateGreenIndexScores, hotelInventoryRequest.showAggregateGreenIndexScores) && Objects.equals(this.showAnnouncements, hotelInventoryRequest.showAnnouncements) && Objects.equals(this.showReviews, hotelInventoryRequest.showReviews) && Objects.equals(this.userSession, hotelInventoryRequest.userSession);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.urlName, this.showHotel, this.showMetadata, this.showVideos, this.showImages, this.showRoomTypes, this.showPackageOffers, this.showAddOnOffers, this.showRestaurants, this.showMeetingRooms, this.showSpas, this.showAttractions, this.showActivities, this.showPlaces, this.showRecognition, this.showAggregateGreenIndexScores, this.showAnnouncements, this.showReviews, this.userSession);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HotelInventoryRequest {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    urlName: ").append(this.toIndentedString(this.urlName)).append("\n");
        sb.append("    showHotel: ").append(this.toIndentedString(this.showHotel)).append("\n");
        sb.append("    showMetadata: ").append(this.toIndentedString(this.showMetadata)).append("\n");
        sb.append("    showVideos: ").append(this.toIndentedString(this.showVideos)).append("\n");
        sb.append("    showImages: ").append(this.toIndentedString(this.showImages)).append("\n");
        sb.append("    showRoomTypes: ").append(this.toIndentedString(this.showRoomTypes)).append("\n");
        sb.append("    showPackageOffers: ").append(this.toIndentedString(this.showPackageOffers)).append("\n");
        sb.append("    showAddOnOffers: ").append(this.toIndentedString(this.showAddOnOffers)).append("\n");
        sb.append("    showRestaurants: ").append(this.toIndentedString(this.showRestaurants)).append("\n");
        sb.append("    showMeetingRooms: ").append(this.toIndentedString(this.showMeetingRooms)).append("\n");
        sb.append("    showSpas: ").append(this.toIndentedString(this.showSpas)).append("\n");
        sb.append("    showAttractions: ").append(this.toIndentedString(this.showAttractions)).append("\n");
        sb.append("    showActivities: ").append(this.toIndentedString(this.showActivities)).append("\n");
        sb.append("    showPlaces: ").append(this.toIndentedString(this.showPlaces)).append("\n");
        sb.append("    showRecognition: ").append(this.toIndentedString(this.showRecognition)).append("\n");
        sb.append("    showAggregateGreenIndexScores: ").append(this.toIndentedString(this.showAggregateGreenIndexScores)).append("\n");
        sb.append("    showAnnouncements: ").append(this.toIndentedString(this.showAnnouncements)).append("\n");
        sb.append("    showReviews: ").append(this.toIndentedString(this.showReviews)).append("\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

