/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.booking.engine.model.GuestRoom;
import travel.wink.booking.engine.model.HotelOnMap;
import travel.wink.booking.engine.model.Quote;
import travel.wink.booking.engine.model.RoomTypeBestPrice;
import travel.wink.booking.engine.model.RoomTypeWithBestPrice;

@JsonPropertyOrder(value={"hotel", "price", "roomTypeList", "priceList", "potentialChannelDiscountPercent", "distance", "sourceToUserCurrencyQuote", "sourceToInternalCurrencyQuote", "available"})
public class HotelWithBestPrice {
    public static final String JSON_PROPERTY_HOTEL = "hotel";
    private HotelOnMap hotel;
    public static final String JSON_PROPERTY_PRICE = "price";
    private RoomTypeWithBestPrice price;
    public static final String JSON_PROPERTY_ROOM_TYPE_LIST = "roomTypeList";
    private List<GuestRoom> roomTypeList = null;
    public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
    private List<RoomTypeBestPrice> priceList = null;
    public static final String JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT = "potentialChannelDiscountPercent";
    private Float potentialChannelDiscountPercent;
    public static final String JSON_PROPERTY_DISTANCE = "distance";
    private Double distance;
    public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
    private Quote sourceToUserCurrencyQuote;
    public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
    private Quote sourceToInternalCurrencyQuote;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;

    public HotelWithBestPrice hotel(HotelOnMap hotel) {
        this.hotel = hotel;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HotelOnMap getHotel() {
        return this.hotel;
    }

    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotel(HotelOnMap hotel) {
        this.hotel = hotel;
    }

    public HotelWithBestPrice price(RoomTypeWithBestPrice price) {
        this.price = price;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomTypeWithBestPrice getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrice(RoomTypeWithBestPrice price) {
        this.price = price;
    }

    public HotelWithBestPrice roomTypeList(List<GuestRoom> roomTypeList) {
        this.roomTypeList = roomTypeList;
        return this;
    }

    public HotelWithBestPrice addRoomTypeListItem(GuestRoom roomTypeListItem) {
        if (this.roomTypeList == null) {
            this.roomTypeList = new ArrayList<GuestRoom>();
        }
        this.roomTypeList.add(roomTypeListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique property room types")
    @JsonProperty(value="roomTypeList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<GuestRoom> getRoomTypeList() {
        return this.roomTypeList;
    }

    @JsonProperty(value="roomTypeList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomTypeList(List<GuestRoom> roomTypeList) {
        this.roomTypeList = roomTypeList;
    }

    public HotelWithBestPrice priceList(List<RoomTypeBestPrice> priceList) {
        this.priceList = priceList;
        return this;
    }

    public HotelWithBestPrice addPriceListItem(RoomTypeBestPrice priceListItem) {
        if (this.priceList == null) {
            this.priceList = new ArrayList<RoomTypeBestPrice>();
        }
        this.priceList.add(priceListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Best-priced room types")
    @JsonProperty(value="priceList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RoomTypeBestPrice> getPriceList() {
        return this.priceList;
    }

    @JsonProperty(value="priceList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriceList(List<RoomTypeBestPrice> priceList) {
        this.priceList = priceList;
    }

    public HotelWithBestPrice potentialChannelDiscountPercent(Float potentialChannelDiscountPercent) {
        this.potentialChannelDiscountPercent = potentialChannelDiscountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The potential discount the user is entitled to if user is a member / authenticated.")
    @JsonProperty(value="potentialChannelDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPotentialChannelDiscountPercent() {
        return this.potentialChannelDiscountPercent;
    }

    @JsonProperty(value="potentialChannelDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPotentialChannelDiscountPercent(Float potentialChannelDiscountPercent) {
        this.potentialChannelDiscountPercent = potentialChannelDiscountPercent;
    }

    public HotelWithBestPrice distance(Double distance) {
        this.distance = distance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If property is within certain geo data result set, distance will be included here to signify the distance the property is from a specific geo-location.")
    @JsonProperty(value="distance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDistance() {
        return this.distance;
    }

    @JsonProperty(value="distance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public HotelWithBestPrice sourceToUserCurrencyQuote(Quote sourceToUserCurrencyQuote) {
        this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceToUserCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Quote getSourceToUserCurrencyQuote() {
        return this.sourceToUserCurrencyQuote;
    }

    @JsonProperty(value="sourceToUserCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceToUserCurrencyQuote(Quote sourceToUserCurrencyQuote) {
        this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    }

    public HotelWithBestPrice sourceToInternalCurrencyQuote(Quote sourceToInternalCurrencyQuote) {
        this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceToInternalCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Quote getSourceToInternalCurrencyQuote() {
        return this.sourceToInternalCurrencyQuote;
    }

    @JsonProperty(value="sourceToInternalCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceToInternalCurrencyQuote(Quote sourceToInternalCurrencyQuote) {
        this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    }

    public HotelWithBestPrice available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Flag to indicate whether this inventory is available or not. This data point is identifier to the available flag on the `price` child data point.")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotelWithBestPrice hotelWithBestPrice = (HotelWithBestPrice)o;
        return Objects.equals(this.hotel, hotelWithBestPrice.hotel) && Objects.equals(this.price, hotelWithBestPrice.price) && Objects.equals(this.roomTypeList, hotelWithBestPrice.roomTypeList) && Objects.equals(this.priceList, hotelWithBestPrice.priceList) && Objects.equals(this.potentialChannelDiscountPercent, hotelWithBestPrice.potentialChannelDiscountPercent) && Objects.equals(this.distance, hotelWithBestPrice.distance) && Objects.equals(this.sourceToUserCurrencyQuote, hotelWithBestPrice.sourceToUserCurrencyQuote) && Objects.equals(this.sourceToInternalCurrencyQuote, hotelWithBestPrice.sourceToInternalCurrencyQuote) && Objects.equals(this.available, hotelWithBestPrice.available);
    }

    public int hashCode() {
        return Objects.hash(this.hotel, this.price, this.roomTypeList, this.priceList, this.potentialChannelDiscountPercent, this.distance, this.sourceToUserCurrencyQuote, this.sourceToInternalCurrencyQuote, this.available);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HotelWithBestPrice {\n");
        sb.append("    hotel: ").append(this.toIndentedString(this.hotel)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    roomTypeList: ").append(this.toIndentedString(this.roomTypeList)).append("\n");
        sb.append("    priceList: ").append(this.toIndentedString(this.priceList)).append("\n");
        sb.append("    potentialChannelDiscountPercent: ").append(this.toIndentedString(this.potentialChannelDiscountPercent)).append("\n");
        sb.append("    distance: ").append(this.toIndentedString(this.distance)).append("\n");
        sb.append("    sourceToUserCurrencyQuote: ").append(this.toIndentedString(this.sourceToUserCurrencyQuote)).append("\n");
        sb.append("    sourceToInternalCurrencyQuote: ").append(this.toIndentedString(this.sourceToInternalCurrencyQuote)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

