/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.booking.engine.model.ActivityWithBestPrice;
import travel.wink.booking.engine.model.AddOnWithBestPrice;
import travel.wink.booking.engine.model.AttractionWithBestPrice;
import travel.wink.booking.engine.model.HotelWithBestPrice;
import travel.wink.booking.engine.model.MeetingRoomWithBestPrice;
import travel.wink.booking.engine.model.PackageWithBestPrice;
import travel.wink.booking.engine.model.PlaceWithBestPrice;
import travel.wink.booking.engine.model.RestaurantWithBestPrice;
import travel.wink.booking.engine.model.SpaWithBestPrice;

@JsonPropertyOrder(value={"sort", "type", "identifier", "supplierIdentifier", "activity", "attraction", "place", "roomType", "meetingRoom", "restaurant", "spa", "bundle", "upgrade", "available"})
public class InventoryGridItem {
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private String supplierIdentifier;
    public static final String JSON_PROPERTY_ACTIVITY = "activity";
    private ActivityWithBestPrice activity;
    public static final String JSON_PROPERTY_ATTRACTION = "attraction";
    private AttractionWithBestPrice attraction;
    public static final String JSON_PROPERTY_PLACE = "place";
    private PlaceWithBestPrice place;
    public static final String JSON_PROPERTY_ROOM_TYPE = "roomType";
    private HotelWithBestPrice roomType;
    public static final String JSON_PROPERTY_MEETING_ROOM = "meetingRoom";
    private MeetingRoomWithBestPrice meetingRoom;
    public static final String JSON_PROPERTY_RESTAURANT = "restaurant";
    private RestaurantWithBestPrice restaurant;
    public static final String JSON_PROPERTY_SPA = "spa";
    private SpaWithBestPrice spa;
    public static final String JSON_PROPERTY_BUNDLE = "bundle";
    private PackageWithBestPrice bundle;
    public static final String JSON_PROPERTY_UPGRADE = "upgrade";
    private AddOnWithBestPrice upgrade;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;

    public InventoryGridItem sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Sort property indicates how this grid item fits in with the rest of the items in the list.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public InventoryGridItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="HOTEL", value="The type of inventory this item represents.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public InventoryGridItem identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique inventory identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public InventoryGridItem supplierIdentifier(String supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="hotel-1", value="Supplier identifier referencing inventory owner")
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierIdentifier(String supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public InventoryGridItem activity(ActivityWithBestPrice activity) {
        this.activity = activity;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="activity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ActivityWithBestPrice getActivity() {
        return this.activity;
    }

    @JsonProperty(value="activity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivity(ActivityWithBestPrice activity) {
        this.activity = activity;
    }

    public InventoryGridItem attraction(AttractionWithBestPrice attraction) {
        this.attraction = attraction;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="attraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AttractionWithBestPrice getAttraction() {
        return this.attraction;
    }

    @JsonProperty(value="attraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttraction(AttractionWithBestPrice attraction) {
        this.attraction = attraction;
    }

    public InventoryGridItem place(PlaceWithBestPrice place) {
        this.place = place;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="place")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlaceWithBestPrice getPlace() {
        return this.place;
    }

    @JsonProperty(value="place")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlace(PlaceWithBestPrice place) {
        this.place = place;
    }

    public InventoryGridItem roomType(HotelWithBestPrice roomType) {
        this.roomType = roomType;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="roomType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HotelWithBestPrice getRoomType() {
        return this.roomType;
    }

    @JsonProperty(value="roomType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomType(HotelWithBestPrice roomType) {
        this.roomType = roomType;
    }

    public InventoryGridItem meetingRoom(MeetingRoomWithBestPrice meetingRoom) {
        this.meetingRoom = meetingRoom;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="meetingRoom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MeetingRoomWithBestPrice getMeetingRoom() {
        return this.meetingRoom;
    }

    @JsonProperty(value="meetingRoom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeetingRoom(MeetingRoomWithBestPrice meetingRoom) {
        this.meetingRoom = meetingRoom;
    }

    public InventoryGridItem restaurant(RestaurantWithBestPrice restaurant) {
        this.restaurant = restaurant;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="restaurant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RestaurantWithBestPrice getRestaurant() {
        return this.restaurant;
    }

    @JsonProperty(value="restaurant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestaurant(RestaurantWithBestPrice restaurant) {
        this.restaurant = restaurant;
    }

    public InventoryGridItem spa(SpaWithBestPrice spa) {
        this.spa = spa;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="spa")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SpaWithBestPrice getSpa() {
        return this.spa;
    }

    @JsonProperty(value="spa")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpa(SpaWithBestPrice spa) {
        this.spa = spa;
    }

    public InventoryGridItem bundle(PackageWithBestPrice bundle) {
        this.bundle = bundle;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="bundle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PackageWithBestPrice getBundle() {
        return this.bundle;
    }

    @JsonProperty(value="bundle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBundle(PackageWithBestPrice bundle) {
        this.bundle = bundle;
    }

    public InventoryGridItem upgrade(AddOnWithBestPrice upgrade) {
        this.upgrade = upgrade;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="upgrade")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AddOnWithBestPrice getUpgrade() {
        return this.upgrade;
    }

    @JsonProperty(value="upgrade")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpgrade(AddOnWithBestPrice upgrade) {
        this.upgrade = upgrade;
    }

    public InventoryGridItem available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this inventory is available")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryGridItem inventoryGridItem = (InventoryGridItem)o;
        return Objects.equals(this.sort, inventoryGridItem.sort) && Objects.equals((Object)this.type, (Object)inventoryGridItem.type) && Objects.equals(this.identifier, inventoryGridItem.identifier) && Objects.equals(this.supplierIdentifier, inventoryGridItem.supplierIdentifier) && Objects.equals(this.activity, inventoryGridItem.activity) && Objects.equals(this.attraction, inventoryGridItem.attraction) && Objects.equals(this.place, inventoryGridItem.place) && Objects.equals(this.roomType, inventoryGridItem.roomType) && Objects.equals(this.meetingRoom, inventoryGridItem.meetingRoom) && Objects.equals(this.restaurant, inventoryGridItem.restaurant) && Objects.equals(this.spa, inventoryGridItem.spa) && Objects.equals(this.bundle, inventoryGridItem.bundle) && Objects.equals(this.upgrade, inventoryGridItem.upgrade) && Objects.equals(this.available, inventoryGridItem.available);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sort, this.type, this.identifier, this.supplierIdentifier, this.activity, this.attraction, this.place, this.roomType, this.meetingRoom, this.restaurant, this.spa, this.bundle, this.upgrade, this.available});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryGridItem {\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    activity: ").append(this.toIndentedString(this.activity)).append("\n");
        sb.append("    attraction: ").append(this.toIndentedString(this.attraction)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    roomType: ").append(this.toIndentedString(this.roomType)).append("\n");
        sb.append("    meetingRoom: ").append(this.toIndentedString(this.meetingRoom)).append("\n");
        sb.append("    restaurant: ").append(this.toIndentedString(this.restaurant)).append("\n");
        sb.append("    spa: ").append(this.toIndentedString(this.spa)).append("\n");
        sb.append("    bundle: ").append(this.toIndentedString(this.bundle)).append("\n");
        sb.append("    upgrade: ").append(this.toIndentedString(this.upgrade)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        HOTEL("HOTEL"),
        GUEST_ROOM("GUEST_ROOM"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        ATTRACTION("ATTRACTION"),
        ACTIVITY("ACTIVITY"),
        PLACE("PLACE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

