/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Exchange rate quote between the property's source currency and the platform's currency that was used to populate price.")
@JsonPropertyOrder(value={"source", "target", "exchangeRate", "timestamp"})
public class Quote {
    public static final String JSON_PROPERTY_SOURCE = "source";
    private String source;
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_EXCHANGE_RATE = "exchangeRate";
    private Double exchangeRate;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;

    public Quote source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Source")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(String source) {
        this.source = source;
    }

    public Quote target(String target) {
        this.target = target;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Target")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTarget(String target) {
        this.target = target;
    }

    public Quote exchangeRate(Double exchangeRate) {
        this.exchangeRate = exchangeRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Exchange rate")
    @JsonProperty(value="exchangeRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="exchangeRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExchangeRate(Double exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public Quote timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quote quote = (Quote)o;
        return Objects.equals(this.source, quote.source) && Objects.equals(this.target, quote.target) && Objects.equals(this.exchangeRate, quote.exchangeRate) && Objects.equals(this.timestamp, quote.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target, this.exchangeRate, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Quote {\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    exchangeRate: ").append(this.toIndentedString(this.exchangeRate)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

