/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.booking.engine.model.RoomTypeWithPriceConfiguration;

@ApiModel(description="Best-priced room at property")
@JsonPropertyOrder(value={"roomTypeWithPriceConfiguration", "perkValue", "available", "sort"})
public class RoomTypeWithBestPrice {
    public static final String JSON_PROPERTY_ROOM_TYPE_WITH_PRICE_CONFIGURATION = "roomTypeWithPriceConfiguration";
    private RoomTypeWithPriceConfiguration roomTypeWithPriceConfiguration;
    public static final String JSON_PROPERTY_PERK_VALUE = "perkValue";
    private Integer perkValue;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;

    public RoomTypeWithBestPrice roomTypeWithPriceConfiguration(RoomTypeWithPriceConfiguration roomTypeWithPriceConfiguration) {
        this.roomTypeWithPriceConfiguration = roomTypeWithPriceConfiguration;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="roomTypeWithPriceConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomTypeWithPriceConfiguration getRoomTypeWithPriceConfiguration() {
        return this.roomTypeWithPriceConfiguration;
    }

    @JsonProperty(value="roomTypeWithPriceConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomTypeWithPriceConfiguration(RoomTypeWithPriceConfiguration roomTypeWithPriceConfiguration) {
        this.roomTypeWithPriceConfiguration = roomTypeWithPriceConfiguration;
    }

    public RoomTypeWithBestPrice perkValue(Integer perkValue) {
        this.perkValue = perkValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sum of all perks the master rate had made available.")
    @JsonProperty(value="perkValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPerkValue() {
        return this.perkValue;
    }

    @JsonProperty(value="perkValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkValue(Integer perkValue) {
        this.perkValue = perkValue;
    }

    public RoomTypeWithBestPrice available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this room type is available with this configuration")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public RoomTypeWithBestPrice sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When this room type is displayed in conjunction with many others, this sort property will often times be populated to indicate how the room types should be sorted and displayed.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomTypeWithBestPrice roomTypeWithBestPrice = (RoomTypeWithBestPrice)o;
        return Objects.equals(this.roomTypeWithPriceConfiguration, roomTypeWithBestPrice.roomTypeWithPriceConfiguration) && Objects.equals(this.perkValue, roomTypeWithBestPrice.perkValue) && Objects.equals(this.available, roomTypeWithBestPrice.available) && Objects.equals(this.sort, roomTypeWithBestPrice.sort);
    }

    public int hashCode() {
        return Objects.hash(this.roomTypeWithPriceConfiguration, this.perkValue, this.available, this.sort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomTypeWithBestPrice {\n");
        sb.append("    roomTypeWithPriceConfiguration: ").append(this.toIndentedString(this.roomTypeWithPriceConfiguration)).append("\n");
        sb.append("    perkValue: ").append(this.toIndentedString(this.perkValue)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

