/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive platform-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.booking.engine.model.UserSession;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * MapRequest
 */
@JsonPropertyOrder({
  MapRequest.JSON_PROPERTY_USER_SESSION,
  MapRequest.JSON_PROPERTY_HOTEL_IDENTIFIERS,
  MapRequest.JSON_PROPERTY_PAGE,
  MapRequest.JSON_PROPERTY_SIZE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:28:43.464694+07:00[Asia/Bangkok]")
public class MapRequest {
  public static final String JSON_PROPERTY_USER_SESSION = "userSession";
  private UserSession userSession;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIERS = "hotelIdentifiers";
  private List<String> hotelIdentifiers = null;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page;

  public static final String JSON_PROPERTY_SIZE = "size";
  private Integer size;

  public MapRequest() { 
  }

  public MapRequest userSession(UserSession userSession) {
    
    this.userSession = userSession;
    return this;
  }

   /**
   * Get userSession
   * @return userSession
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UserSession getUserSession() {
    return userSession;
  }


  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSession(UserSession userSession) {
    this.userSession = userSession;
  }


  public MapRequest hotelIdentifiers(List<String> hotelIdentifiers) {
    
    this.hotelIdentifiers = hotelIdentifiers;
    return this;
  }

  public MapRequest addHotelIdentifiersItem(String hotelIdentifiersItem) {
    if (this.hotelIdentifiers == null) {
      this.hotelIdentifiers = new ArrayList<>();
    }
    this.hotelIdentifiers.add(hotelIdentifiersItem);
    return this;
  }

   /**
   * Optionally exclude property identifiers.
   * @return hotelIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"hotel-1\"]", value = "Optionally exclude property identifiers.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHotelIdentifiers() {
    return hotelIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifiers(List<String> hotelIdentifiers) {
    this.hotelIdentifiers = hotelIdentifiers;
  }


  public MapRequest page(Integer page) {
    
    this.page = page;
    return this;
  }

   /**
   * The page to paginate to. Note: Page uses a 0-based index.
   * minimum: 0
   * @return page
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "0", required = true, value = "The page to paginate to. Note: Page uses a 0-based index.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public MapRequest size(Integer size) {
    
    this.size = size;
    return this;
  }

   /**
   * The result size to return.
   * minimum: 1
   * maximum: 50
   * @return size
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1) @Max(50)  @ApiModelProperty(example = "10", required = true, value = "The result size to return.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSize(Integer size) {
    this.size = size;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MapRequest mapRequest = (MapRequest) o;
    return Objects.equals(this.userSession, mapRequest.userSession) &&
        Objects.equals(this.hotelIdentifiers, mapRequest.hotelIdentifiers) &&
        Objects.equals(this.page, mapRequest.page) &&
        Objects.equals(this.size, mapRequest.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userSession, hotelIdentifiers, page, size);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MapRequest {\n");
    sb.append("    userSession: ").append(toIndentedString(userSession)).append("\n");
    sb.append("    hotelIdentifiers: ").append(toIndentedString(hotelIdentifiers)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

